<?php
/**
 * Dashboard widget for scan analytics.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

class GoValid_Admin_Dashboard {

	/**
	 * Register hooks.
	 */
	public function register(): void {
		add_action( 'wp_dashboard_setup', array( $this, 'add_widget' ) );
	}

	/**
	 * Add the dashboard widget.
	 */
	public function add_widget(): void {
		if ( ! current_user_can( 'edit_posts' ) || ! GoValid_QR::is_connected() ) {
			return;
		}

		wp_add_dashboard_widget(
			'govalid_qr_dashboard',
			__( 'GoValid QR — Scan Analytics', 'govalid-qr' ),
			array( $this, 'render_widget' )
		);
	}

	/**
	 * Render the widget.
	 */
	public function render_widget(): void {
		include GOVALID_QR_PLUGIN_DIR . 'admin/partials/dashboard-widget.php';
	}
}
