<?php
/**
 * Plugin Name:       GoValid QR
 * Plugin URI:        https://my.govalid.org/qr_codes/thirdparty/wp-plugin/
 * Description:       Generate, embed, and track QR codes from your GoValid account directly in WordPress.
 * Version:           3.6.0
 * Requires at least: 5.8
 * Requires PHP:      7.4
 * Author:            GoValid
 * Author URI:        https://govalid.org
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       govalid-qr
 * Domain Path:       /languages
 */

defined( 'ABSPATH' ) || exit;

define( 'GOVALID_QR_VERSION', '3.6.0' );
define( 'GOVALID_QR_PLUGIN_FILE', __FILE__ );
define( 'GOVALID_QR_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'GOVALID_QR_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'GOVALID_QR_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'GOVALID_QR_DEFAULT_BASE_URL', 'https://my.govalid.org' );

/**
 * Autoload plugin classes.
 */
spl_autoload_register( function ( $class ) {
	$prefix = 'GoValid_';
	if ( strpos( $class, $prefix ) !== 0 ) {
		return;
	}

	$class_file = str_replace( '_', '-', strtolower( $class ) );
	$class_file = 'class-' . $class_file . '.php';

	$paths = array(
		GOVALID_QR_PLUGIN_DIR . 'includes/' . $class_file,
		GOVALID_QR_PLUGIN_DIR . 'includes/api/' . $class_file,
		GOVALID_QR_PLUGIN_DIR . 'includes/admin/' . $class_file,
		GOVALID_QR_PLUGIN_DIR . 'includes/rest/' . $class_file,
		GOVALID_QR_PLUGIN_DIR . 'includes/blocks/' . $class_file,
		GOVALID_QR_PLUGIN_DIR . 'includes/shortcodes/' . $class_file,
		GOVALID_QR_PLUGIN_DIR . 'includes/cache/' . $class_file,
	);

	foreach ( $paths as $path ) {
		if ( file_exists( $path ) ) {
			require_once $path;
			return;
		}
	}
} );

/**
 * Plugin activation.
 */
function govalid_qr_activate() {
	require_once GOVALID_QR_PLUGIN_DIR . 'includes/class-govalid-qr-activator.php';
	GoValid_QR_Activator::activate();
}
register_activation_hook( __FILE__, 'govalid_qr_activate' );

/**
 * Plugin deactivation.
 */
function govalid_qr_deactivate() {
	require_once GOVALID_QR_PLUGIN_DIR . 'includes/class-govalid-qr-deactivator.php';
	GoValid_QR_Deactivator::deactivate();
}
register_deactivation_hook( __FILE__, 'govalid_qr_deactivate' );

/**
 * Boot the plugin.
 */
function govalid_qr_init() {
	return GoValid_QR::get_instance();
}
add_action( 'plugins_loaded', 'govalid_qr_init' );
