<?php
/**
 * Humanize Links admin page template.
 *
 * Two-step flow: suggest → choose/edit → check → create.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$govalid_is_connected = GoValid_QR::is_connected();
?>
<div class="wrap govalid-links">
	<!-- Page Header -->
	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div>
			<h1><?php esc_html_e( 'Humanize Links', 'govalid-qr' ); ?></h1>
			<p class="govalid-page-subtitle"><?php esc_html_e( 'Create memorable AI-powered short links for your URLs.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<?php if ( ! $govalid_is_connected ) : ?>
		<div class="govalid-card" style="max-width:1000px; border-left:4px solid #2563eb; background:linear-gradient(135deg, rgba(37,99,235,0.04), #fff 40%);">
			<div style="display:flex; align-items:center; gap:14px;">
				<div style="display:flex; align-items:center; justify-content:center; width:44px; height:44px; border-radius:12px; background:rgba(37,99,235,0.12); flex-shrink:0;">
					<span class="dashicons dashicons-admin-links" style="font-size:22px; width:22px; height:22px; color:#2563eb;"></span>
				</div>
				<div style="flex:1;">
					<h3 style="margin:0 0 4px; font-size:14px; color:var(--gv-gray-800);"><?php esc_html_e( 'Try Humanize Links', 'govalid-qr' ); ?></h3>
					<p style="margin:0; font-size:13px; color:var(--gv-gray-500); line-height:1.5;">
						<?php esc_html_e( 'You can create up to 2 AI-powered humanize links without an account. Connect to GoValid for up to 5 free links.', 'govalid-qr' ); ?>
					</p>
				</div>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr' ) ); ?>" class="button button-primary" style="display:inline-flex; align-items:center; gap:6px; white-space:nowrap;">
					<span class="dashicons dashicons-admin-network" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
					<?php esc_html_e( 'Connect Now', 'govalid-qr' ); ?>
				</a>
			</div>
		</div>
	<?php endif; ?>

		<div class="govalid-generator-layout">
			<!-- Main Content -->
			<div class="govalid-generator-main">

				<!-- Step 1: Enter URL & Get Suggestions -->
				<div class="govalid-card govalid-form" id="govalid-link-form-card">
					<h2><?php esc_html_e( 'Create a Humanize Link', 'govalid-qr' ); ?></h2>

					<div class="govalid-field-group">
						<label class="govalid-field-label" for="govalid-link-url">
							<?php esc_html_e( 'Target URL', 'govalid-qr' ); ?>
							<span class="govalid-required">*</span>
						</label>
						<div class="govalid-input-wrap" style="max-width: 100%;">
							<span class="govalid-input-icon"><span class="dashicons dashicons-admin-links"></span></span>
							<input type="url" id="govalid-link-url" class="govalid-input"
								   placeholder="https://example.com/your-page" required />
						</div>
					</div>

					<div class="govalid-link-field-row" style="display: flex; gap: 14px;">
						<div class="govalid-field-group" style="flex: 1;">
							<label class="govalid-field-label" for="govalid-link-title">
								<?php esc_html_e( 'Title', 'govalid-qr' ); ?>
								<span class="govalid-badge"><?php esc_html_e( 'Optional', 'govalid-qr' ); ?></span>
							</label>
							<div class="govalid-input-wrap" style="max-width: 100%;">
								<input type="text" id="govalid-link-title" class="govalid-input"
									   placeholder="<?php esc_attr_e( 'Help AI generate a better slug', 'govalid-qr' ); ?>" />
							</div>
						</div>

						<div class="govalid-field-group" style="flex: 0 0 160px;">
							<label class="govalid-field-label" for="govalid-link-audience">
								<?php esc_html_e( 'Audience', 'govalid-qr' ); ?>
							</label>
							<select id="govalid-link-audience" class="govalid-select" style="max-width: 100%;">
								<option value="local"><?php esc_html_e( 'Local', 'govalid-qr' ); ?></option>
								<option value="global"><?php esc_html_e( 'Global', 'govalid-qr' ); ?></option>
								<option value="both"><?php esc_html_e( 'Both', 'govalid-qr' ); ?></option>
							</select>
						</div>
					</div>

					<div class="govalid-field-group">
						<label class="govalid-field-label" for="govalid-link-description">
							<?php esc_html_e( 'Description', 'govalid-qr' ); ?>
							<span class="govalid-badge"><?php esc_html_e( 'Optional', 'govalid-qr' ); ?></span>
						</label>
						<div class="govalid-input-wrap" style="max-width: 100%;">
							<input type="text" id="govalid-link-description" class="govalid-input"
								   placeholder="<?php esc_attr_e( 'Extra context for AI slug generation (max 150 chars)', 'govalid-qr' ); ?>"
								   maxlength="150" />
						</div>
					</div>

					<div class="govalid-form-actions">
						<button type="button" id="govalid-suggest-btn" class="govalid-btn govalid-btn-primary">
							<span class="dashicons dashicons-randomize"></span>
							<?php esc_html_e( 'Humanize', 'govalid-qr' ); ?>
						</button>
					</div>
				</div>

				<!-- Step 2: Suggestions + Edit + Check + Create -->
				<div id="govalid-suggestions-card" class="govalid-card govalid-form" style="display: none;">
					<h2><?php esc_html_e( 'Choose Your Link', 'govalid-qr' ); ?></h2>
					<p class="govalid-field-help" style="margin: -8px 0 16px;">
						<?php esc_html_e( 'Click a suggestion, edit the slug if you want, check availability, then create.', 'govalid-qr' ); ?>
					</p>

					<!-- Suggestion Cards -->
					<div id="govalid-suggestion-list" class="govalid-suggestion-list"></div>

					<!-- Editable Slug Area -->
					<div id="govalid-slug-editor" class="govalid-slug-editor" style="display: none;">
						<div class="govalid-field-group">
							<label class="govalid-field-label"><?php esc_html_e( 'Your Link', 'govalid-qr' ); ?></label>
							<div class="govalid-slug-edit-row">
								<span id="govalid-slug-domain-prefix" class="govalid-slug-domain-prefix"></span>
								<input type="text" id="govalid-slug-input" class="govalid-slug-input" />
								<button type="button" id="govalid-check-slug-btn" class="govalid-btn govalid-btn-sm">
									<?php esc_html_e( 'Check', 'govalid-qr' ); ?>
								</button>
							</div>
							<div id="govalid-slug-status" class="govalid-slug-status" style="display: none;"></div>
						</div>

						<div class="govalid-form-actions" style="margin-top: 16px;">
							<button type="button" id="govalid-create-link-btn" class="govalid-btn govalid-btn-primary" disabled>
								<span class="dashicons dashicons-yes-alt"></span>
								<?php esc_html_e( 'Create Link', 'govalid-qr' ); ?>
							</button>
							<button type="button" id="govalid-back-btn" class="govalid-btn" style="background: var(--gv-gray-100); color: var(--gv-gray-600); margin-left: 8px;">
								<span class="dashicons dashicons-arrow-left-alt2"></span>
								<?php esc_html_e( 'Back', 'govalid-qr' ); ?>
							</button>
						</div>
					</div>
				</div>

				<!-- Result Area -->
				<div id="govalid-link-result" class="govalid-card" style="display: none;">
					<h2 id="govalid-link-result-heading"><?php esc_html_e( 'Link QR Code', 'govalid-qr' ); ?></h2>
					<div class="govalid-link-result-main" style="display: flex; align-items: center; gap: 12px; margin-bottom: 14px;">
						<code id="govalid-link-result-url" style="flex: 1; font-size: 15px; padding: 10px 14px; background: var(--gv-gray-50); border: 1px solid var(--gv-gray-200); border-radius: 8px; word-break: break-all;"></code>
						<button type="button" class="govalid-btn govalid-btn-primary govalid-copy-shortcode" id="govalid-copy-link-btn" data-clipboard="">
							<span class="dashicons dashicons-clipboard"></span>
							<?php esc_html_e( 'Copy', 'govalid-qr' ); ?>
						</button>
					</div>

					<!-- Live QR Preview -->
					<div class="govalid-qr-preview-wrap">
						<div id="govalid-link-qr-preview" class="govalid-qr-preview"></div>
						<div class="govalid-qr-actions">
							<button type="button" id="govalid-qr-save-design" class="govalid-btn govalid-btn-sm govalid-btn-primary">
								<span class="dashicons dashicons-saved"></span>
								<?php esc_html_e( 'Save Design', 'govalid-qr' ); ?>
							</button>
							<button type="button" id="govalid-qr-download-png" class="govalid-btn govalid-btn-sm">
								<span class="dashicons dashicons-download"></span>
								<?php esc_html_e( 'PNG', 'govalid-qr' ); ?>
							</button>
							<button type="button" id="govalid-qr-download-svg" class="govalid-btn govalid-btn-sm">
								<span class="dashicons dashicons-download"></span>
								<?php esc_html_e( 'HD', 'govalid-qr' ); ?>
							</button>
						</div>
					</div>

					<!-- Collapsible QR Design Panel -->
					<div class="govalid-qr-design-panel">
						<button type="button" id="govalid-qr-design-toggle" class="govalid-qr-design-toggle">
							<span class="dashicons dashicons-art"></span>
							<?php esc_html_e( 'Customize QR Design', 'govalid-qr' ); ?>
							<span class="dashicons dashicons-arrow-down-alt2 govalid-qr-toggle-icon"></span>
						</button>
						<div id="govalid-qr-design-body" class="govalid-qr-design-body" style="display: none;">

							<!-- Module Shape -->
							<div class="govalid-qr-section">
								<label class="govalid-field-label">
									<span class="dashicons dashicons-screenoptions"></span>
									<?php esc_html_e( 'Module Shape', 'govalid-qr' ); ?>
								</label>
								<div class="govalid-shape-grid" id="govalid-module-shapes">
									<div class="govalid-shape-option active" data-shape="square" title="<?php esc_attr_e( 'Square', 'govalid-qr' ); ?>">
										<svg width="32" height="32" viewBox="0 0 6 6" fill="currentColor"><path d="M5,1h1l0-1L4,0v1H3V0L0,0v0v0v2h1V1h0h1h1v1v0v0l0,0H2v1H1H0h0v3h0v0h2v0H1l0-2h1l0,1h1v1h3v0H5v0V5h1V4H5v1H3 l0-2l1,0v1h1V3h1V2H5V1z M5,3H4V2h1V3z"></path></svg>
										<span><?php esc_html_e( 'Square', 'govalid-qr' ); ?></span>
									</div>
									<div class="govalid-shape-option" data-shape="circle" title="<?php esc_attr_e( 'Circle', 'govalid-qr' ); ?>">
										<svg width="32" height="32" viewBox="0 0 6 6" fill="currentColor"><circle cx="0.5" cy="0.5" r="0.5"/><circle cx="1.5" cy="0.5" r="0.5"/><circle cx="3.5" cy="0.5" r="0.5"/><circle cx="4.5" cy="0.5" r="0.5"/><circle cx="0.5" cy="1.5" r="0.5"/><circle cx="4.5" cy="1.5" r="0.5"/><circle cx="5.5" cy="1.5" r="0.5"/><circle cx="0.5" cy="2.5" r="0.5"/><circle cx="1.5" cy="2.5" r="0.5"/><circle cx="0.5" cy="3.5" r="0.5"/><circle cx="1.5" cy="3.5" r="0.5"/><circle cx="4.5" cy="3.5" r="0.5"/><circle cx="5.5" cy="3.5" r="0.5"/><circle cx="2.5" cy="4.5" r="0.5"/><circle cx="1.5" cy="5.5" r="0.5"/><circle cx="3.5" cy="5.5" r="0.5"/><circle cx="5.5" cy="5.5" r="0.5"/></svg>
										<span><?php esc_html_e( 'Circle', 'govalid-qr' ); ?></span>
									</div>
									<div class="govalid-shape-option" data-shape="star" title="<?php esc_attr_e( 'Star', 'govalid-qr' ); ?>">
										<svg width="32" height="32" viewBox="0 0 6 6" fill="currentColor"><polygon points="0.5,0.8 0.2,1 0.2,0.6 0,0.4 0.3,0.3 0.5,0 0.7,0.3 1,0.4 0.7,0.6 0.8,1"/><polygon points="2.5,0.8 2.2,1 2.2,0.6 2,0.4 2.3,0.3 2.5,0 2.7,0.3 3,0.4 2.7,0.6 2.8,1"/><polygon points="4.5,0.8 4.2,1 4.3,0.6 4,0.4 4.3,0.3 4.5,0 4.7,0.3 5,0.4 4.8,0.6 4.8,1"/><polygon points="5.5,0.8 5.2,1 5.3,0.6 5,0.4 5.3,0.3 5.5,0 5.7,0.3 6,0.4 5.8,0.6 5.8,1"/><polygon points="3.5,1.8 3.2,2 3.2,1.6 3,1.4 3.3,1.3 3.5,1 3.7,1.3 4,1.4 3.7,1.6 3.8,2"/><polygon points="0.5,1.8 0.2,2 0.2,1.6 0,1.4 0.3,1.3 0.5,1 0.7,1.3 1,1.4 0.7,1.6 0.8,2"/><polygon points="2.5,2.8 2.2,3 2.2,2.6 2,2.4 2.3,2.3 2.5,2 2.7,2.3 3,2.4 2.7,2.6 2.8,3"/><polygon points="0.5,3.8 0.2,4 0.2,3.6 0,3.4 0.3,3.3 0.5,3 0.7,3.3 1,3.4 0.7,3.6 0.8,4"/><polygon points="4.5,3.8 4.2,4 4.3,3.6 4,3.4 4.3,3.3 4.5,3 4.7,3.3 5,3.4 4.8,3.6 4.8,4"/><polygon points="5.5,4.8 5.2,5 5.3,4.6 5,4.4 5.3,4.3 5.5,4 5.7,4.3 6,4.4 5.8,4.6 5.8,5"/><polygon points="2.5,5.8 2.2,6 2.2,5.6 2,5.4 2.3,5.3 2.5,5 2.7,5.3 3,5.4 2.8,5.6 2.8,6"/><polygon points="0.5,5.8 0.2,6 0.2,5.6 0,5.4 0.3,5.3 0.5,5 0.7,5.3 1,5.4 0.7,5.6 0.8,6"/></svg>
										<span><?php esc_html_e( 'Star', 'govalid-qr' ); ?></span>
									</div>
									<div class="govalid-shape-option" data-shape="diamond" title="<?php esc_attr_e( 'Diamond', 'govalid-qr' ); ?>">
										<svg width="32" height="32" viewBox="0 0 6 6" fill="currentColor"><rect x="0.1" y="0.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -0.2075 0.4992)" width="0.7" height="0.7"/><rect x="2.1" y="0.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 0.3783 1.9134)" width="0.7" height="0.7"/><rect x="4.1" y="0.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 0.9641 3.3276)" width="0.7" height="0.7"/><rect x="5.1" y="0.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 1.257 4.0347)" width="0.7" height="0.7"/><rect x="4.1" y="1.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 0.257 3.6205)" width="0.7" height="0.7"/><rect x="3.1" y="2.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -0.743 3.2063)" width="0.7" height="0.7"/><rect x="0.1" y="3.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -2.3287 1.3777)" width="0.7" height="0.7"/><rect x="1.1" y="3.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -2.0359 2.0849)" width="0.7" height="0.7"/><rect x="4.1" y="3.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -1.1573 4.2063)" width="0.7" height="0.7"/><rect x="5.1" y="4.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -1.5715 5.2063)" width="0.7" height="0.7"/><rect x="2.1" y="5.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -3.1573 3.3778)" width="0.7" height="0.7"/><rect x="0.1" y="5.1" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -3.7428 1.9634)" width="0.7" height="0.7"/></svg>
										<span><?php esc_html_e( 'Diamond', 'govalid-qr' ); ?></span>
									</div>
									<div class="govalid-shape-option" data-shape="rounded" title="<?php esc_attr_e( 'Rounded', 'govalid-qr' ); ?>">
										<svg width="32" height="32" viewBox="0 0 6 6" fill="currentColor"><path d="M0.5,0C0.2,0,0,0.2,0,0.5s0.2,0.5,0.5,0.5S1,0.8,1,0.5S0.8,0,0.5,0z"/><path d="M1.5,0C1.2,0,1,0.2,1,0.5s0.2,0.5,0.5,0.5S2,0.8,2,0.5S1.8,0,1.5,0z"/><path d="M3.5,0C3.2,0,3,0.2,3,0.5s0.2,0.5,0.5,0.5S4,0.8,4,0.5S3.8,0,3.5,0z"/><path d="M4.5,0C4.2,0,4,0.2,4,0.5s0.2,0.5,0.5,0.5S5,0.8,5,0.5S4.8,0,4.5,0z"/><path d="M0.5,1C0.2,1,0,1.2,0,1.5s0.2,0.5,0.5,0.5S1,1.8,1,1.5S0.8,1,0.5,1z"/><path d="M4.5,1C4.2,1,4,1.2,4,1.5s0.2,0.5,0.5,0.5S5,1.8,5,1.5S4.8,1,4.5,1z"/><path d="M5.5,1C5.2,1,5,1.2,5,1.5s0.2,0.5,0.5,0.5S6,1.8,6,1.5S5.8,1,5.5,1z"/><path d="M0.5,3C0.2,3,0,3.2,0,3.5s0.2,0.5,0.5,0.5S1,3.8,1,3.5S0.8,3,0.5,3z"/><path d="M1.5,3C1.2,3,1,3.2,1,3.5s0.2,0.5,0.5,0.5S2,3.8,2,3.5S1.8,3,1.5,3z"/><path d="M4.5,3C4.2,3,4,3.2,4,3.5s0.2,0.5,0.5,0.5S5,3.8,5,3.5S4.8,3,4.5,3z"/><path d="M5.5,3C5.2,3,5,3.2,5,3.5s0.2,0.5,0.5,0.5S6,3.8,6,3.5S5.8,3,5.5,3z"/><path d="M2.5,4C2.2,4,2,4.2,2,4.5s0.2,0.5,0.5,0.5S3,4.8,3,4.5S2.8,4,2.5,4z"/><path d="M1.5,5C1.2,5,1,5.2,1,5.5s0.2,0.5,0.5,0.5S2,5.8,2,5.5S1.8,5,1.5,5z"/><path d="M3.5,5C3.2,5,3,5.2,3,5.5s0.2,0.5,0.5,0.5S4,5.8,4,5.5S3.8,5,3.5,5z"/><path d="M5.5,5C5.2,5,5,5.2,5,5.5s0.2,0.5,0.5,0.5S6,5.8,6,5.5S5.8,5,5.5,5z"/></svg>
										<span><?php esc_html_e( 'Rounded', 'govalid-qr' ); ?></span>
									</div>
									<div class="govalid-shape-option" data-shape="cross" title="<?php esc_attr_e( 'Cross', 'govalid-qr' ); ?>">
										<svg width="32" height="32" viewBox="0 0 6 6" fill="currentColor"><polygon points="1.7,0 1.3,0 1.3,0.3 1,0.3 0.7,0.3 0.7,0 0.3,0 0.3,0.3 0,0.3 0,0.7 0.3,0.7 0.3,1 0.7,1 0.7,0.7 1,0.7 1.3,0.7 1.3,1 1.7,1 1.7,0.7 2,0.7 2,0.3 1.7,0.3"/><polygon points="4.7,0 4.3,0 4.3,0.3 4,0.3 3.7,0.3 3.7,0 3.3,0 3.3,0.3 3,0.3 3,0.7 3.3,0.7 3.3,1 3.7,1 3.7,0.7 4,0.7 4.3,0.7 4.3,1 4.7,1 4.7,0.7 5,0.7 5,0.3 4.7,0.3"/><polygon points="5.7,1 5.3,1 5.3,1.3 5,1.3 5,1.7 5.3,1.7 5.3,2 5.7,2 5.7,1.7 6,1.7 6,1.3 5.7,1.3"/><polygon points="3.7,2 3.3,2 3.3,2.3 3,2.3 2.7,2.3 2.7,2 2.3,2 2.3,2.3 2,2.3 2,2.7 2.3,2.7 2.3,3 2.7,3 2.7,2.7 3,2.7 3.3,2.7 3.3,3 3.7,3 3.7,2.7 4,2.7 4,2.3 3.7,2.3"/><polygon points="1.7,3 1.3,3 1.3,3.3 1,3.3 0.7,3.3 0.7,3 0.3,3 0.3,3.3 0,3.3 0,3.7 0.3,3.7 0.3,4 0.7,4 0.7,3.7 1,3.7 1.3,3.7 1.3,4 1.7,4 1.7,3.7 2,3.7 2,3.3 1.7,3.3"/><polygon points="5.7,4 5.3,4 5.3,4.3 5,4.3 5,4.7 5.3,4.7 5.3,5 5.7,5 5.7,4.7 6,4.7 6,4.3 5.7,4.3"/><polygon points="3.7,5 3.3,5 3.3,5.3 3,5.3 2.7,5.3 2.7,5 2.3,5 2.3,5.3 2,5.3 2,5.7 2.3,5.7 2.3,6 2.7,6 2.7,5.7 3,5.7 3.3,5.7 3.3,6 3.7,6 3.7,5.7 4,5.7 4,5.3 3.7,5.3"/><polygon points="0.7,5 0.3,5 0.3,5.3 0,5.3 0,5.7 0.3,5.7 0.3,6 0.7,6 0.7,5.7 1,5.7 1,5.3 0.7,5.3"/></svg>
										<span><?php esc_html_e( 'Cross', 'govalid-qr' ); ?></span>
									</div>
									<div class="govalid-shape-option" data-shape="heart" title="<?php esc_attr_e( 'Heart', 'govalid-qr' ); ?>">
										<svg width="32" height="32" viewBox="0 0 6 6" fill="currentColor"><path d="M0.8,0C0.7,0,0.6,0,0.5,0.1C0.4,0,0.4,0,0.3,0C0.1,0,0,0.1,0,0.3c0,0.1,0,0.1,0,0.2l0,0L0.5,1l0.4-0.5C1,0.4,1,0.3,1,0.3C1,0.1,0.9,0,0.8,0z"/><path d="M2.8,0C2.7,0,2.6,0,2.5,0.1C2.4,0,2.4,0,2.3,0C2.1,0,2,0.1,2,0.3c0,0.1,0,0.1,0,0.2l0,0L2.5,1l0.4-0.5C3,0.4,3,0.3,3,0.3C3,0.1,2.9,0,2.8,0z"/><path d="M4.8,0C4.7,0,4.6,0,4.5,0.1C4.4,0,4.4,0,4.3,0C4.1,0,4,0.1,4,0.3c0,0.1,0,0.1,0,0.2l0,0L4.5,1l0.4-0.5C5,0.4,5,0.3,5,0.3C5,0.1,4.9,0,4.8,0z"/><path d="M5,0.5L5.5,1l0.4-0.5C6,0.4,6,0.3,6,0.3C6,0.1,5.9,0,5.8,0C5.7,0,5.6,0,5.5,0.1C5.4,0,5.4,0,5.3,0C5.1,0,5,0.1,5,0.3C5,0.3,5,0.4,5,0.5L5,0.5z"/><path d="M4.8,1C4.7,1,4.6,1,4.5,1.1C4.4,1,4.4,1,4.3,1C4.1,1,4,1.1,4,1.3c0,0.1,0,0.1,0,0.2l0,0L4.5,2l0.4-0.5C5,1.4,5,1.3,5,1.3C5,1.1,4.9,1,4.8,1z"/><path d="M0.8,1C0.7,1,0.6,1,0.5,1.1C0.4,1,0.4,1,0.3,1C0.1,1,0,1.1,0,1.3c0,0.1,0,0.1,0,0.2l0,0L0.5,2l0.4-0.5C1,1.4,1,1.3,1,1.3C1,1.1,0.9,1,0.8,1z"/><path d="M2.8,2C2.7,2,2.6,2,2.5,2.1C2.4,2,2.4,2,2.3,2C2.1,2,2,2.1,2,2.3c0,0.1,0,0.1,0,0.2l0,0L2.5,3l0.4-0.5C3,2.4,3,2.3,3,2.3C3,2.1,2.9,2,2.8,2z"/><path d="M0.8,3C0.7,3,0.6,3,0.5,3.1C0.4,3,0.4,3,0.3,3C0.1,3,0,3.1,0,3.3c0,0.1,0,0.1,0,0.2l0,0L0.5,4l0.4-0.5C1,3.4,1,3.3,1,3.3C1,3.1,0.9,3,0.8,3z"/><path d="M1.8,3C1.7,3,1.6,3,1.5,3.1C1.4,3,1.4,3,1.3,3C1.1,3,1,3.1,1,3.3c0,0.1,0,0.1,0,0.2l0,0L1.5,4l0.4-0.5C2,3.4,2,3.3,2,3.3C2,3.1,1.9,3,1.8,3z"/><path d="M4.8,3C4.7,3,4.6,3,4.5,3.1C4.4,3,4.4,3,4.3,3C4.1,3,4,3.1,4,3.3c0,0.1,0,0.1,0,0.2l0,0L4.5,4l0.4-0.5C5,3.4,5,3.3,5,3.3C5,3.1,4.9,3,4.8,3z"/><path d="M5.8,4C5.7,4,5.6,4,5.5,4.1C5.4,4,5.4,4,5.3,4C5.1,4,5,4.1,5,4.3c0,0.1,0,0.1,0,0.2l0,0L5.5,5l0.4-0.5C6,4.4,6,4.3,6,4.3C6,4.1,5.9,4,5.8,4z"/><path d="M2.8,5C2.7,5,2.6,5,2.5,5.1C2.4,5,2.4,5,2.3,5C2.1,5,2,5.1,2,5.3c0,0.1,0,0.1,0,0.2l0,0L2.5,6l0.4-0.5C3,5.4,3,5.3,3,5.3C3,5.1,2.9,5,2.8,5z"/><path d="M0.8,5C0.7,5,0.6,5,0.5,5.1C0.4,5,0.4,5,0.3,5C0.1,5,0,5.1,0,5.3c0,0.1,0,0.1,0,0.2l0,0L0.5,6l0.4-0.5C1,5.4,1,5.3,1,5.3C1,5.1,0.9,5,0.8,5z"/></svg>
										<span><?php esc_html_e( 'Heart', 'govalid-qr' ); ?></span>
									</div>
								</div>
							</div>

							<!-- Eye Shapes: Outer & Inner -->
							<div class="govalid-qr-section">
								<label class="govalid-field-label">
									<span class="dashicons dashicons-visibility"></span>
									<?php esc_html_e( 'Eye Style', 'govalid-qr' ); ?>
								</label>
								<div class="govalid-qr-eye-row">
									<!-- Outer Eye -->
									<div class="govalid-qr-eye-col">
										<h4><?php esc_html_e( 'Outer Eye', 'govalid-qr' ); ?></h4>
										<div class="govalid-eye-grid" id="govalid-outer-eyes">
											<div class="govalid-eye-option active" data-eye="square" title="<?php esc_attr_e( 'Square', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0,0v14h14V0H0z M12,12H2V2h10V12z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="rounded" title="<?php esc_attr_e( 'Rounded', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M4.5,14h5.1C12,14,14,12,14,9.6V4.5C14,2,12,0,9.5,0H4.4C2,0,0,2,0,4.4v5.1C0,12,2,14,4.5,14z M12,4.8v4.4c0,1.5-1.3,2.8-2.8,2.8H4.8C3.2,12,2,10.8,2,9.2V4.8C2,3.3,3.3,2,4.8,2h4.4C10.8,2,12,3.2,12,4.8z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="circle" title="<?php esc_attr_e( 'Circle', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0,7c0,3.9,3.1,7,7,7s7-3.1,7-7S10.9,0,7,0S0,3.1,0,7z M7,12c-2.8,0-5-2.2-5-5s2.2-5,5-5s5,2.2,5,5S9.8,12,7,12z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="leaf" title="<?php esc_attr_e( 'Leaf', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0,0L0,10Q0,14,4,14L14,14L14,4Q14,0,10,0Z M2,2L10,2Q12,2,12,4L12,12L4,12Q2,12,2,10Z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="drop" title="<?php esc_attr_e( 'Drop', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0,7c0,3.9,3.1,7,7,7h7V7c0-3.9-3.1-7-7-7C3.1,0,0,3.1,0,7z M12,12H7c-2.8,0-5-2.2-5-5s2.2-5,5-5s5,2.2,5,5V12z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="dropin" title="<?php esc_attr_e( 'Drop In', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0,0l0,7c0,3.9,3.1,7,7,7s7-3.1,7-7V0H0z M7,12c-2.8,0-5-2.2-5-5V2h5c2.8,0,5,2.2,5,5S9.8,12,7,12z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="dropeye" title="<?php esc_attr_e( 'Drop Eye', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0,0l0,7c0,3.9,3.1,7,7,7h7V7c0-3.9-3.1-7-7-7H0z M12,12H7c-2.8,0-5-2.2-5-5V2h5c2.8,0,5,2.2,5,5V12z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="flower" title="<?php esc_attr_e( 'Flower', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0,0v9.6C0,12,2,14,4.4,14h5.1C12,14,14,12,14,9.6V4.4C14,2,12,0,9.6,0H0z M9.2,12H4.8C3.3,12,2,10.7,2,9.2V2h7.2C10.7,2,12,3.3,12,4.8v4.4C12,10.7,10.7,12,9.2,12z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="flurry" title="<?php esc_attr_e( 'Flurry', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0.2,0.1L0.1,0.6l0.1,0.5L0.2,1.6L0.1,2.1l0.1,0.5L0,3.1l0,0.5L0,4l0.1,0.5l0,0.5l0.1,0.5L0.1,6l0,0.5l0,0.5l0.2,0.5L0.1,8l0.1,0.5L0,8.9l0.2,0.5L0,9.9l0.2,0.5l-0.1,0.5l0,0.5L0,11.9l0.2,0.5l-0.1,0.5l0.1,0.5l0,0.4L0.6,14l0.5,0l0.5-0.1l0.5,0.1l0.5,0.1L3.1,14l0.5-0.1l0.5-0.1l0.5,0L5,13.9l0.5-0.1l0.5,0l0.5,0L7,13.9L7.5,14L8,14l0.5-0.2L9,13.9L9.4,14l0.5-0.2l0.5,0.2l0.5-0.1l0.5,0l0.5-0.1l0.5,0l0.5,0l0.5,0l0.5,0.1l-0.1-0.5l0.2-0.5l-0.1-0.5l-0.1-0.5l0.2-0.5l-0.2-0.5l0.1-0.5L14,9.9l-0.2-0.5L13.9,9L14,8.5L14,8l-0.2-0.5l0-0.5l0.1-0.5L13.8,6l0-0.5L14,5l0-0.5l-0.1-0.5l0.1-0.5l-0.2-0.5l0.1-0.5l0-0.5l0-0.5l-0.1-0.5L14,0.6l-0.2-0.4l-0.4,0l-0.5,0L12.4,0l-0.5,0.2l-0.5,0l-0.5-0.1l-0.5,0L10,0l-0.5,0L9,0L8.5,0.2L8,0.2L7.5,0.1L7,0.1L6.5,0.2L6,0L5.5,0.2L5.1,0.2L4.6,0.1L4.1,0.1L3.6,0L3.1,0.1L2.6,0L2.1,0.1l-0.5,0l-0.5,0L0.6,0.2L0.2,0.1z M11.9,11.9l-0.5-0.1L10.9,12l-0.5-0.1L10,11.9l-0.5,0.1L9,11.8l-0.5,0l-0.5,0l-0.5,0.1l-0.5,0L6.5,12L6,11.9l-0.5,0l-0.5,0L4.6,12l-0.5-0.2L3.6,12l-0.5-0.1L2.6,12l-0.4-0.1L2,11.4l0.1-0.5l0-0.5l0.1-0.5L2,9.5L2.1,9L2,8.5L2,8l0.2-0.5l0-0.5L2,6.5L2.1,6l0.1-0.5L2.2,5L2.1,4.5L2,4.1l0-0.5l0.2-0.5L2,2.6L2,2l0.5,0l0.5,0.1l0.5,0.1l0.5,0L4.5,2L5,2.1l0.5,0.1L6,2l0.5,0.2L7,2.1l0.5,0L8,2l0.5,0L9,2l0.5,0l0.5,0.1L10.4,2l0.5,0.2L11.4,2L12,2l-0.1,0.6L12,3.1l-0.1,0.5L11.8,4L12,4.5L11.9,5l-0.1,0.5l0,0.5L12,6.5L12,7l-0.1,0.5L12,8l0,0.5l-0.2,0.5l0,0.5l0.1,0.5l-0.1,0.5l0.2,0.5l-0.1,0.5L11.9,11.9z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="sdoz" title="<?php esc_attr_e( 'Sdoz', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0,0l0.9,13c0,0.6,0.5,1,1,1h12V2c0-0.6-0.4-1-1-1L0,0z M12,12H3.8c-0.5,0-1-0.4-1-1L2,2l9,0.7c0.5,0,1,0.5,1,1V12z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="squarecircle" title="<?php esc_attr_e( 'Square Circle', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 14 14" fill="currentColor"><path d="M0,0L14,0L14,14L0,14Z M7,2A5,5,0,1,0,7,12A5,5,0,1,0,7,2Z"/></svg>
											</div>
										</div>
									</div>
									<!-- Inner Eye -->
									<div class="govalid-qr-eye-col">
										<h4><?php esc_html_e( 'Inner Eye', 'govalid-qr' ); ?></h4>
										<div class="govalid-eye-grid" id="govalid-inner-eyes">
											<div class="govalid-eye-option active" data-eye="square" title="<?php esc_attr_e( 'Square', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M0,0L6,0L6,6L0,6Z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="rounded" title="<?php esc_attr_e( 'Rounded', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M1,0Q0,0,0,1L0,5Q0,6,1,6L5,6Q6,6,6,5L6,1Q6,0,5,0Z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="circle" title="<?php esc_attr_e( 'Circle', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M3,0A3,3,0,1,1,3,6A3,3,0,1,1,3,0Z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="drop" title="<?php esc_attr_e( 'Drop', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M6,6H3C1.3,6,0,4.7,0,3v0c0-1.7,1.3-3,3-3h0c1.7,0,3,1.3,3,3V6z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="dropeye" title="<?php esc_attr_e( 'Drop Eye', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M6,6H3C1.3,6,0,4.7,0,3l0-3l3,0c1.7,0,3,1.3,3,3V6z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="dropin" title="<?php esc_attr_e( 'Drop In', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M3,6C1.3,6,0,4.7,0,3l0-3l3,0c1.7,0,3,1.3,3,3C6,4.7,4.7,6,3,6z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="flurry" title="<?php esc_attr_e( 'Flurry', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><polygon points="5.9,5.9 5.6,5.9 5.3,6 5,5.7 4.7,5.8 4.4,5.8 4.1,5.8 3.9,5.7 3.6,5.7 3.3,5.8 3,5.9 2.7,5.8 2.4,5.8 2.1,5.8 1.9,5.7 1.6,5.7 1.3,5.7 1,5.8 0.7,5.8 0.4,5.8 0.1,5.9 0,5.5 0.1,5.3 0,5 0.3,4.7 0.3,4.4 0.2,4.1 0.2,3.8 0.1,3.5 0.3,3.3 0.1,3 0.1,2.7 0.2,2.4 0.1,2.1 0.1,1.8 0.1,1.5 0.2,1.3 0.3,1 0,0.7 0,0.4 0.3,0.2 0.4,0.1 0.7,0.1 1,0.2 1.3,0.1 1.6,0.3 1.9,0.1 2.1,0.1 2.4,0.2 2.7,0.1 3,0.3 3.3,0.2 3.6,0.2 3.8,0.2 4.1,0.1 4.4,0.3 4.7,0.1 5,0.2 5.3,0.1 5.6,0 5.9,0 5.8,0.4 6,0.7 6,1 5.9,1.2 5.7,1.5 5.7,1.8 5.9,2.1 5.7,2.4 5.8,2.7 6,3 5.9,3.3 5.8,3.5 5.8,3.8 5.8,4.1 6,4.4 5.8,4.7 5.7,5 5.7,5.3 5.8,5.5"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="star" title="<?php esc_attr_e( 'Star', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M3.2,0.3l0.6,1.3C4,1.8,4.1,1.9,4.3,1.9l1.4,0.2c0.2,0,0.3,0.3,0.2,0.5l-1,1C4.7,3.7,4.7,3.9,4.7,4.1L5,5.5c0,0.2-0.2,0.4-0.4,0.3L3.3,5.2c-0.2-0.1-0.4-0.1-0.6,0L1.4,5.8C1.2,5.9,1,5.8,1,5.5l0.2-1.4c0-0.2,0-0.4-0.2-0.5l-1-1C-0.1,2.4,0,2.2,0.2,2.1l1.4-0.2c0.2,0,0.4-0.2,0.5-0.3l0.6-1.3C2.9,0.1,3.1,0.1,3.2,0.3z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="diamond" title="<?php esc_attr_e( 'Diamond', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M3,0L6,3L3,6L0,3Z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="heart" title="<?php esc_attr_e( 'Heart', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M1.5,1Q0,1,0,2.5Q0,3.5,3,6Q6,3.5,6,2.5Q6,1,4.5,1Q3,1,3,2Q3,1,1.5,1Z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="leaf" title="<?php esc_attr_e( 'Leaf', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M0,0L0,4Q0,6,2,6L6,6L6,2Q6,0,4,0Z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="sun" title="<?php esc_attr_e( 'Sun', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><path d="M3,0 L3.4,0.7 L4,0.2 L4.1,0.9 L4.9,0.7 L4.8,1.5 L5.6,1.5 L5.2,2.2 L5.9,2.5 L5.3,3 L5.9,3.5 L5.2,3.8 L5.6,4.5 L4.8,4.5 L4.9,5.3 L4.1,5.1 L4,5.8 L3.4,5.3 L3,6 L2.5,5.3 L1.9,5.8 L1.8,5.1 L1,5.3 L1.1,4.5 L0.4,4.5 L0.7,3.8 L0,3.5 L0.6,3 L0,2.5 L0.7,2.2 L0.4,1.5 L1.1,1.5 L1,0.7 L1.8,0.9 L1.9,0.2 L2.5,0.7 Z"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="cross" title="<?php esc_attr_e( 'Cross', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><polygon points="6,1.5 4.5,1.5 4.5,0 1.5,0 1.5,1.5 0,1.5 0,4.5 1.5,4.5 1.5,6 4.5,6 4.5,4.5 6,4.5"/></svg>
											</div>
											<div class="govalid-eye-option" data-eye="sdoz" title="<?php esc_attr_e( 'Sdoz', 'govalid-qr' ); ?>">
												<svg width="24" height="24" viewBox="0 0 6 6" fill="currentColor"><polygon points="6,6 0.5,6 0,0 6,0.5"/></svg>
											</div>
										</div>
									</div>
								</div>
							</div>

							<!-- Colors -->
							<div class="govalid-qr-section">
								<label class="govalid-field-label">
									<span class="dashicons dashicons-admin-appearance"></span>
									<?php esc_html_e( 'Colors', 'govalid-qr' ); ?>
								</label>
								<div class="govalid-color-row">
									<div class="govalid-color-field">
										<label><?php esc_html_e( 'Module', 'govalid-qr' ); ?></label>
										<input type="color" id="govalid-qr-module-color" value="#000000" />
									</div>
									<div class="govalid-color-field">
										<label><?php esc_html_e( 'Outer Eye', 'govalid-qr' ); ?></label>
										<input type="color" id="govalid-qr-outer-color" value="#000000" />
									</div>
									<div class="govalid-color-field">
										<label><?php esc_html_e( 'Inner Eye', 'govalid-qr' ); ?></label>
										<input type="color" id="govalid-qr-inner-color" value="#000000" />
									</div>
								</div>
							</div>

							<!-- Custom Logo -->
							<div class="govalid-qr-section">
								<label class="govalid-field-label">
									<span class="dashicons dashicons-format-image"></span>
									<?php esc_html_e( 'Center Logo', 'govalid-qr' ); ?>
								</label>
								<div class="govalid-qr-logo-field">
									<button type="button" id="govalid-qr-logo-btn" class="govalid-btn govalid-btn-sm">
										<span class="dashicons dashicons-upload"></span>
										<?php esc_html_e( 'Upload Logo', 'govalid-qr' ); ?>
									</button>
									<div id="govalid-qr-logo-preview" class="govalid-qr-logo-preview" style="display: none;">
										<img id="govalid-qr-logo-img" src="" alt="Logo" />
										<button type="button" id="govalid-qr-logo-remove" class="govalid-qr-logo-remove" title="<?php esc_attr_e( 'Remove', 'govalid-qr' ); ?>">
											<span class="dashicons dashicons-no-alt"></span>
										</button>
									</div>
								</div>
							</div>

						</div><!-- /#govalid-qr-design-body -->
					</div><!-- /.govalid-qr-design-panel -->

					<div style="margin-top: 16px; display: flex; gap: 8px;">
						<button type="button" id="govalid-create-another-btn" class="govalid-btn" style="background: var(--gv-gray-100); color: var(--gv-gray-600);">
							<span class="dashicons dashicons-plus-alt2"></span>
							<?php esc_html_e( 'Create Another', 'govalid-qr' ); ?>
						</button>
						<button type="button" id="govalid-back-to-list-btn" class="govalid-btn" style="background: var(--gv-gray-100); color: var(--gv-gray-600); display: none;">
							<span class="dashicons dashicons-arrow-left-alt"></span>
							<?php esc_html_e( 'Back to List', 'govalid-qr' ); ?>
						</button>
					</div>
				</div>

				<!-- Links Table -->
				<div class="govalid-card">
					<h2><?php esc_html_e( 'Your Links', 'govalid-qr' ); ?></h2>
					<div id="govalid-links-list" class="govalid-links-list">
						<p class="govalid-loading"><?php esc_html_e( 'Loading links...', 'govalid-qr' ); ?></p>
					</div>
					<div id="govalid-links-pagination" class="govalid-links-pagination" style="display: none; margin-top: 16px; text-align: center;"></div>
				</div>

			</div>

			<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/promo-sidebar.php'; ?>
		</div>

</div>
