<?php
/**
 * QR Generator page template.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$govalid_is_connected  = GoValid_QR::is_connected();
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only URL parameters.
$govalid_error         = isset( $_GET['error'] ) ? sanitize_text_field( wp_unslash( $_GET['error'] ) ) : '';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_active_tab    = isset( $_GET['tab'] ) ? sanitize_key( wp_unslash( $_GET['tab'] ) ) : 'certificate';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_prefill_url   = isset( $_GET['prefill_url'] ) ? sanitize_url( wp_unslash( $_GET['prefill_url'] ) ) : '';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_prefill_name  = isset( $_GET['prefill_name'] ) ? sanitize_text_field( wp_unslash( $_GET['prefill_name'] ) ) : '';

$govalid_tabs = array(
	'certificate' => array(
		'label' => __( 'Certificate', 'govalid-qr' ),
		'icon'  => 'dashicons-awards',
	),
	'products'    => array(
		'label' => __( 'Products', 'govalid-qr' ),
		'icon'  => 'dashicons-cart',
	),
	'timeline'    => array(
		'label' => __( 'Timeline', 'govalid-qr' ),
		'icon'  => 'dashicons-backup',
	),
	'documents'   => array(
		'label' => __( 'Documents', 'govalid-qr' ),
		'icon'  => 'dashicons-media-document',
	),
);
?>
<div class="wrap govalid-generator">
	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div>
			<h1><?php esc_html_e( 'QR Code Generator', 'govalid-qr' ); ?></h1>
			<p class="govalid-page-subtitle"><?php esc_html_e( 'Create and manage QR codes for your products.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<?php if ( ! $govalid_is_connected ) : ?>
		<div class="govalid-card" style="max-width:1000px; border-left:4px solid #2563eb; background:linear-gradient(135deg, rgba(37,99,235,0.04), #fff 40%);">
			<div style="display:flex; align-items:center; gap:14px;">
				<div style="display:flex; align-items:center; justify-content:center; width:44px; height:44px; border-radius:12px; background:rgba(37,99,235,0.12); flex-shrink:0;">
					<span class="dashicons dashicons-admin-links" style="font-size:22px; width:22px; height:22px; color:#2563eb;"></span>
				</div>
				<div style="flex:1;">
					<h3 style="margin:0 0 4px; font-size:14px; color:var(--gv-gray-800);"><?php esc_html_e( 'Connect to GoValid', 'govalid-qr' ); ?></h3>
					<p style="margin:0; font-size:13px; color:var(--gv-gray-500); line-height:1.5;">
						<?php esc_html_e( 'Connect your free GoValid account to start generating QR codes. Explore the forms below to see what you can create.', 'govalid-qr' ); ?>
					</p>
				</div>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr' ) ); ?>" class="button button-primary" style="display:inline-flex; align-items:center; gap:6px; white-space:nowrap;">
					<span class="dashicons dashicons-admin-network" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
					<?php esc_html_e( 'Connect Now', 'govalid-qr' ); ?>
				</a>
			</div>
		</div>
	<?php endif; ?>

	<?php if ( $govalid_error ) : ?>
		<div class="notice notice-error is-dismissible">
			<p><?php echo esc_html( $govalid_error ); ?></p>
		</div>
	<?php endif; ?>

	<?php if ( $govalid_prefill_url ) : ?>
		<div class="notice notice-info" style="max-width: 720px;">
			<p>
				<strong><?php esc_html_e( 'QR Code for:', 'govalid-qr' ); ?></strong>
				<?php echo esc_html( $govalid_prefill_name ?: $govalid_prefill_url ); ?>
			</p>
			<p style="font-size: 12px; color: #64748b;">
				<?php esc_html_e( 'The form URL has been pre-filled below. Choose a QR type and generate.', 'govalid-qr' ); ?>
			</p>
		</div>
		<script>
			document.addEventListener('DOMContentLoaded', function() {
				// Try to pre-fill QR name and URL fields if they exist.
				var nameField = document.getElementById('govalid-qr-name') || document.querySelector('[name="qr_name"]');
				var urlField  = document.getElementById('govalid-qr-url') || document.querySelector('[name="qr_url"]');
				if (nameField && <?php echo wp_json_encode( $govalid_prefill_name ); ?>) {
					nameField.value = <?php echo wp_json_encode( $govalid_prefill_name ); ?>;
				}
				if (urlField && <?php echo wp_json_encode( $govalid_prefill_url ); ?>) {
					urlField.value = <?php echo wp_json_encode( $govalid_prefill_url ); ?>;
				}
			});
		</script>
	<?php endif; ?>

	<div class="govalid-generator-layout">
		<!-- Main Content -->
		<div class="govalid-generator-main">
			<!-- Tab Navigation -->
			<nav class="govalid-tabs-nav">
				<?php foreach ( $govalid_tabs as $govalid_tab_key => $govalid_tab ) : ?>
					<a href="#<?php echo esc_attr( $govalid_tab_key ); ?>"
					   class="govalid-tab-link <?php echo esc_attr( $govalid_active_tab === $govalid_tab_key ? 'active' : '' ); ?>"
					   data-tab="<?php echo esc_attr( $govalid_tab_key ); ?>">
						<span class="dashicons <?php echo esc_attr( $govalid_tab['icon'] ); ?>"></span>
						<?php echo esc_html( $govalid_tab['label'] ); ?>
					</a>
				<?php endforeach; ?>
			</nav>

			<!-- Tab Panels -->

			<!-- Certificate -->
			<div id="govalid-tab-certificate"
				 class="govalid-tab-panel <?php echo esc_attr( $govalid_active_tab === 'certificate' ? 'active' : '' ); ?>">
				<div class="govalid-card">
					<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/tabs/tab-certificate.php'; ?>
				</div>
			</div>

			<!-- Products -->
			<div id="govalid-tab-products"
				 class="govalid-tab-panel <?php echo esc_attr( $govalid_active_tab === 'products' ? 'active' : '' ); ?>">
				<div class="govalid-card">
					<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/tabs/tab-product.php'; ?>
				</div>
			</div>

			<!-- Timeline -->
			<div id="govalid-tab-timeline"
				 class="govalid-tab-panel <?php echo esc_attr( $govalid_active_tab === 'timeline' ? 'active' : '' ); ?>">
				<div class="govalid-card">
					<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/tabs/tab-timeline.php'; ?>
				</div>
			</div>

			<!-- Documents -->
			<div id="govalid-tab-documents"
				 class="govalid-tab-panel <?php echo esc_attr( $govalid_active_tab === 'documents' ? 'active' : '' ); ?>">
				<div class="govalid-card">
					<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/tabs/tab-document.php'; ?>
				</div>
			</div>
		</div>

		<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/promo-sidebar.php'; ?>
	</div>
</div>
