<?php
/**
 * Settings page template.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$govalid_is_connected = GoValid_QR::is_connected();
$govalid_userinfo     = get_option( 'govalid_qr_userinfo', array() );
$govalid_client_id    = get_option( 'govalid_qr_client_id', '' );
$govalid_base_url     = get_option( 'govalid_qr_base_url', GOVALID_QR_DEFAULT_BASE_URL );

// Flash messages.
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only URL parameters.
$govalid_error         = isset( $_GET['error'] ) ? sanitize_text_field( wp_unslash( $_GET['error'] ) ) : '';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_connected     = isset( $_GET['connected'] );
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_disconnected  = isset( $_GET['disconnected'] );
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_cache_cleared = isset( $_GET['cache_cleared'] );
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_page_created  = isset( $_GET['page_created'] );

// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_active_tab = isset( $_GET['tab'] ) ? sanitize_key( wp_unslash( $_GET['tab'] ) ) : 'general';

// Custom Verification page data.
$govalid_verify_page_id     = (int) get_option( 'govalid_qr_verify_page_id', 0 );
$govalid_verify_page_exists = $govalid_verify_page_id && 'publish' === get_post_status( $govalid_verify_page_id );
$govalid_custom_verify_on   = get_option( 'govalid_qr_custom_verify_domain', '' ) === '1';

$govalid_settings_tabs = array(
	'general'          => array(
		'label' => __( 'General', 'govalid-qr' ),
		'icon'  => 'dashicons-admin-generic',
	),
	'custom-verify'    => array(
		'label' => __( 'Custom Verification', 'govalid-qr' ),
		'icon'  => 'dashicons-yes-alt',
	),
	'anti-counterfeit' => array(
		'label' => __( 'Anti-Counterfeit', 'govalid-qr' ),
		'icon'  => 'dashicons-shield',
	),
);
?>
<div class="wrap govalid-settings">
	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div>
			<h1><?php esc_html_e( 'GoValid QR Settings', 'govalid-qr' ); ?></h1>
			<p class="govalid-page-subtitle"><?php esc_html_e( 'Configure your GoValid connection and preferences.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<?php if ( $govalid_error ) : ?>
		<div class="notice notice-error is-dismissible">
			<p><?php echo esc_html( $govalid_error ); ?></p>
		</div>
	<?php endif; ?>

	<?php if ( $govalid_connected ) : ?>
		<div class="notice notice-success is-dismissible">
			<p><?php esc_html_e( 'Successfully connected to GoValid!', 'govalid-qr' ); ?></p>
		</div>
	<?php endif; ?>

	<?php if ( $govalid_disconnected ) : ?>
		<div class="notice notice-info is-dismissible">
			<p><?php esc_html_e( 'Disconnected from GoValid.', 'govalid-qr' ); ?></p>
		</div>
	<?php endif; ?>

	<?php if ( $govalid_cache_cleared ) : ?>
		<div class="notice notice-success is-dismissible">
			<p><?php esc_html_e( 'Cache cleared successfully.', 'govalid-qr' ); ?></p>
		</div>
	<?php endif; ?>

	<?php if ( $govalid_page_created ) : ?>
		<div class="notice notice-success is-dismissible">
			<p><?php esc_html_e( 'Verification page created successfully!', 'govalid-qr' ); ?></p>
		</div>
	<?php endif; ?>

	<div class="govalid-generator-layout">
	<div class="govalid-generator-main">

	<!-- Settings Tab Navigation -->
	<nav class="govalid-tabs-nav">
		<?php foreach ( $govalid_settings_tabs as $govalid_tab_key => $govalid_tab ) : ?>
			<a href="#<?php echo esc_attr( $govalid_tab_key ); ?>"
			   class="govalid-tab-link <?php echo esc_attr( $govalid_active_tab === $govalid_tab_key ? 'active' : '' ); ?>"
			   data-tab="<?php echo esc_attr( $govalid_tab_key ); ?>">
				<span class="dashicons <?php echo esc_attr( $govalid_tab['icon'] ); ?>"></span>
				<?php echo esc_html( $govalid_tab['label'] ); ?>
			</a>
		<?php endforeach; ?>
	</nav>

	<!-- General Tab -->
	<div id="govalid-tab-general" class="govalid-tab-panel <?php echo esc_attr( $govalid_active_tab === 'general' ? 'active' : '' ); ?>">

		<?php if ( $govalid_is_connected ) : ?>
			<!-- Connected state -->
			<div class="govalid-card govalid-connected-card">
				<h2><?php esc_html_e( 'Connected to GoValid', 'govalid-qr' ); ?></h2>
				<div class="govalid-user-info">
					<?php if ( ! empty( $govalid_userinfo['avatar'] ) ) : ?>
						<img src="<?php echo esc_url( $govalid_userinfo['avatar'] ); ?>"
							 alt="<?php esc_attr_e( 'Avatar', 'govalid-qr' ); ?>"
							 class="govalid-avatar" />
					<?php endif; ?>
					<div class="govalid-user-details">
						<?php if ( ! empty( $govalid_userinfo['name'] ) ) : ?>
							<p class="govalid-user-name"><?php echo esc_html( $govalid_userinfo['name'] ); ?></p>
						<?php endif; ?>
						<?php if ( ! empty( $govalid_userinfo['email'] ) ) : ?>
							<p class="govalid-user-email"><?php echo esc_html( $govalid_userinfo['email'] ); ?></p>
						<?php endif; ?>
					</div>
				</div>
				<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
					<input type="hidden" name="action" value="govalid_qr_disconnect" />
					<?php wp_nonce_field( 'govalid_qr_disconnect' ); ?>
					<button type="submit" class="button button-secondary govalid-disconnect-btn"
							onclick="return confirm(govalidQR.i18n.confirm_disconnect);">
						<?php esc_html_e( 'Disconnect', 'govalid-qr' ); ?>
					</button>
				</form>
			</div>

			<!-- Subscription & Quota -->
			<div class="govalid-card govalid-subscription-card" id="govalid-subscription-card">
				<div class="govalid-subscription-header">
					<div class="govalid-subscription-icon">
						<span class="dashicons dashicons-awards"></span>
					</div>
					<div>
						<h2 style="margin:0; font-size:16px;"><?php esc_html_e( 'Subscription & Quota', 'govalid-qr' ); ?></h2>
						<p style="margin:2px 0 0; font-size:12px; color:var(--gv-gray-400);"><?php esc_html_e( 'Your current plan and usage', 'govalid-qr' ); ?></p>
					</div>
				</div>

				<!-- Loading state -->
				<div id="govalid-sub-loading" class="govalid-sub-loading">
					<span class="dashicons dashicons-update govalid-spin" style="font-size:20px; width:20px; height:20px; color:var(--gv-gray-400);"></span>
					<span style="color:var(--gv-gray-400); font-size:13px;"><?php esc_html_e( 'Loading subscription info...', 'govalid-qr' ); ?></span>
				</div>

				<!-- Error state -->
				<div id="govalid-sub-error" style="display:none; padding:16px; background:var(--gv-danger-light); border-radius:8px; color:var(--gv-danger); font-size:13px;">
					<span class="dashicons dashicons-warning" style="font-size:16px; width:16px; height:16px; margin-right:6px; vertical-align:middle;"></span>
					<span id="govalid-sub-error-msg"><?php esc_html_e( 'Could not load subscription information.', 'govalid-qr' ); ?></span>
				</div>

				<!-- Data state -->
				<div id="govalid-sub-data" style="display:none;">

					<!-- Plan badge and name -->
					<div class="govalid-plan-badge-row">
						<span id="govalid-plan-badge" class="govalid-plan-badge govalid-plan-free"><?php esc_html_e( 'Free', 'govalid-qr' ); ?></span>
						<span id="govalid-plan-source" class="govalid-plan-source"></span>
					</div>

					<!-- QR Quota -->
					<div class="govalid-quota-section">
						<div class="govalid-quota-label-row">
							<span class="govalid-quota-label"><?php esc_html_e( 'QR Codes This Month', 'govalid-qr' ); ?></span>
							<span class="govalid-quota-numbers">
								<span id="govalid-qr-used">0</span>
								/ <span id="govalid-qr-limit">10</span>
							</span>
						</div>
						<div class="govalid-progress-bar">
							<div id="govalid-qr-progress" class="govalid-progress-fill" style="width:0%;"></div>
						</div>
						<p class="govalid-quota-remaining">
							<span id="govalid-qr-remaining">10</span> <?php esc_html_e( 'remaining', 'govalid-qr' ); ?>
						</p>
					</div>

					<!-- Feature grid -->
					<div class="govalid-features-grid" id="govalid-features-grid">
						<div class="govalid-feature-item">
							<span class="dashicons dashicons-media-default govalid-feature-icon"></span>
							<div>
								<div class="govalid-feature-value" id="govalid-storage-display">100 MB</div>
								<div class="govalid-feature-label"><?php esc_html_e( 'Storage', 'govalid-qr' ); ?></div>
							</div>
						</div>
						<div class="govalid-feature-item" id="govalid-feature-pdf" style="display:none;">
							<span class="dashicons dashicons-media-document govalid-feature-icon"></span>
							<div>
								<div class="govalid-feature-value"><?php esc_html_e( 'Enabled', 'govalid-qr' ); ?></div>
								<div class="govalid-feature-label"><?php esc_html_e( 'PDF Stamping', 'govalid-qr' ); ?></div>
							</div>
						</div>
						<div class="govalid-feature-item" id="govalid-feature-forms" style="display:none;">
							<span class="dashicons dashicons-feedback govalid-feature-icon"></span>
							<div>
								<div class="govalid-feature-value"><?php esc_html_e( 'Enabled', 'govalid-qr' ); ?></div>
								<div class="govalid-feature-label"><?php esc_html_e( 'Custom Forms', 'govalid-qr' ); ?></div>
							</div>
						</div>
						<div class="govalid-feature-item" id="govalid-feature-expiry" style="display:none;">
							<span class="dashicons dashicons-calendar-alt govalid-feature-icon"></span>
							<div>
								<div class="govalid-feature-value" id="govalid-expiry-display"></div>
								<div class="govalid-feature-label"><?php esc_html_e( 'Renewal', 'govalid-qr' ); ?></div>
							</div>
						</div>
					</div>

					<!-- Credit info (for credit-based users) -->
					<div id="govalid-credit-info" style="display:none;" class="govalid-credit-section">
						<div class="govalid-quota-label-row">
							<span class="govalid-quota-label"><?php esc_html_e( 'Credit Balance', 'govalid-qr' ); ?></span>
							<span class="govalid-quota-numbers" id="govalid-credit-balance">-</span>
						</div>
						<div class="govalid-credit-details">
							<span id="govalid-bonus-qr" style="display:none;">
								<span class="dashicons dashicons-star-filled" style="font-size:14px; width:14px; height:14px; color:#e68a00; vertical-align:middle;"></span>
								<span id="govalid-bonus-qr-count">0</span> <?php esc_html_e( 'bonus QR codes', 'govalid-qr' ); ?>
							</span>
						</div>
					</div>

					<!-- Manage link -->
					<div class="govalid-sub-actions">
						<a href="<?php echo esc_url( rtrim( $govalid_base_url, '/' ) ); ?>/subscription/plans/" target="_blank" class="button button-secondary" style="display:inline-flex; align-items:center; gap:6px;">
							<span class="dashicons dashicons-external" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
							<?php esc_html_e( 'Manage Subscription', 'govalid-qr' ); ?>
						</a>
					</div>
				</div>
			</div>

			<!-- Cache section -->
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Cache', 'govalid-qr' ); ?></h2>
				<p><?php esc_html_e( 'Clear cached QR code data and images.', 'govalid-qr' ); ?></p>
				<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
					<input type="hidden" name="action" value="govalid_qr_clear_cache" />
					<?php wp_nonce_field( 'govalid_qr_clear_cache' ); ?>
					<button type="submit" class="button button-secondary">
						<?php esc_html_e( 'Clear Cache', 'govalid-qr' ); ?>
					</button>
				</form>
			</div>

			<!-- Verify Widget section -->
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Smart Verify Widget', 'govalid-qr' ); ?></h2>
				<p><?php esc_html_e( 'Show a floating QR verification button on your site. Visitors can verify GoValid QR codes by ID, camera, or image upload.', 'govalid-qr' ); ?></p>
				<form method="post" action="options.php">
					<?php settings_fields( 'govalid_qr_widget_settings' ); ?>
					<table class="form-table">
						<tr>
							<th scope="row"><?php esc_html_e( 'Floating Widget', 'govalid-qr' ); ?></th>
							<td>
								<label>
									<input type="checkbox" name="govalid_qr_floating_verify" value="1"
										<?php checked( get_option( 'govalid_qr_floating_verify', '1' ), '1' ); ?> />
									<?php esc_html_e( 'Show floating verify button on all pages', 'govalid-qr' ); ?>
								</label>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="govalid_qr_verify_position"><?php esc_html_e( 'Position', 'govalid-qr' ); ?></label>
							</th>
							<td>
								<select id="govalid_qr_verify_position" name="govalid_qr_verify_position">
									<option value="bottom-right" <?php selected( get_option( 'govalid_qr_verify_position', 'bottom-right' ), 'bottom-right' ); ?>>
										<?php esc_html_e( 'Bottom Right', 'govalid-qr' ); ?>
									</option>
									<option value="bottom-left" <?php selected( get_option( 'govalid_qr_verify_position', 'bottom-right' ), 'bottom-left' ); ?>>
										<?php esc_html_e( 'Bottom Left', 'govalid-qr' ); ?>
									</option>
									<option value="top-right" <?php selected( get_option( 'govalid_qr_verify_position', 'bottom-right' ), 'top-right' ); ?>>
										<?php esc_html_e( 'Top Right', 'govalid-qr' ); ?>
									</option>
									<option value="top-left" <?php selected( get_option( 'govalid_qr_verify_position', 'bottom-right' ), 'top-left' ); ?>>
										<?php esc_html_e( 'Top Left', 'govalid-qr' ); ?>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row"><?php esc_html_e( 'Shortcode', 'govalid-qr' ); ?></th>
							<td>
								<code>[govalid_verify]</code>
								<p class="description">
									<?php esc_html_e( 'Embed an inline verify widget in any post or page.', 'govalid-qr' ); ?>
								</p>
							</td>
						</tr>
					</table>
					<?php submit_button( __( 'Save Widget Settings', 'govalid-qr' ) ); ?>
				</form>
			</div>

		<?php else : ?>
			<!-- Not connected state — Setup Guide -->
			<?php
			$govalid_oauth_callback_url = admin_url( 'admin.php?page=govalid-qr-oauth-callback' );
			$govalid_has_credentials    = ! empty( $govalid_client_id );
			?>
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Connect to GoValid', 'govalid-qr' ); ?></h2>
				<p style="font-size:13px; color:var(--gv-gray-500); line-height:1.6;">
					<?php esc_html_e( 'Follow these steps to connect your GoValid account to this WordPress site.', 'govalid-qr' ); ?>
				</p>

				<div class="govalid-setup-steps" style="margin-top:20px;">

					<!-- Step 1: GoValid account -->
					<div class="govalid-setup-step">
						<div class="govalid-step-number">1</div>
						<div class="govalid-step-content">
							<h3><?php esc_html_e( 'Create a GoValid account with a paid subscription', 'govalid-qr' ); ?></h3>
							<p style="font-size:13px; color:var(--gv-gray-500); line-height:1.6;">
								<?php esc_html_e( 'You need an active paid subscription to create OAuth applications. If you don\'t have one yet, sign up and choose a plan.', 'govalid-qr' ); ?>
							</p>
							<a href="<?php echo esc_url( rtrim( $govalid_base_url, '/' ) ); ?>/subscription/plans/" target="_blank" class="button button-secondary" style="display:inline-flex; align-items:center; gap:6px; margin-top:6px;">
								<span class="dashicons dashicons-external" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
								<?php esc_html_e( 'View Plans', 'govalid-qr' ); ?>
							</a>
						</div>
					</div>

					<!-- Step 2: Create OAuth App -->
					<div class="govalid-setup-step">
						<div class="govalid-step-number">2</div>
						<div class="govalid-step-content">
							<h3><?php esc_html_e( 'Create an OAuth application on GoValid', 'govalid-qr' ); ?></h3>
							<div style="font-size:13px; color:var(--gv-gray-500); line-height:1.8;">
								<ol style="margin:8px 0 0; padding-left:20px;">
									<li>
										<?php
										printf(
											/* translators: %s: link to security settings. */
											esc_html__( 'Go to %s', 'govalid-qr' ),
											'<a href="' . esc_url( rtrim( $govalid_base_url, '/' ) ) . '/pages/account_settings/security/" target="_blank" style="font-weight:500;">Account Settings &rarr; Security</a>'
										);
										?>
									</li>
									<li><?php esc_html_e( 'Scroll down to the "OAuth Applications" section', 'govalid-qr' ); ?></li>
									<li>
										<?php
										printf(
											/* translators: %s: button label. */
											esc_html__( 'Click %s', 'govalid-qr' ),
											'<strong>"+ OAuth Application"</strong>'
										);
										?>
									</li>
									<li>
										<?php esc_html_e( 'In the modal, paste this Redirect URI:', 'govalid-qr' ); ?>
										<div style="display:flex; align-items:center; gap:8px; margin:8px 0;">
											<code id="govalid-redirect-uri" style="flex:1; padding:8px 12px; background:var(--gv-gray-50); border:1px solid var(--gv-gray-200); border-radius:6px; font-size:12px; word-break:break-all; color:var(--gv-gray-800);"><?php echo esc_html( $govalid_oauth_callback_url ); ?></code>
											<button type="button" class="button button-secondary govalid-copy-shortcode" data-clipboard="<?php echo esc_attr( $govalid_oauth_callback_url ); ?>" style="flex-shrink:0; display:inline-flex; align-items:center; gap:4px;">
												<span class="dashicons dashicons-clipboard" style="font-size:14px; width:14px; height:14px;"></span>
												<?php esc_html_e( 'Copy', 'govalid-qr' ); ?>
											</button>
										</div>
									</li>
									<li><?php esc_html_e( 'Under "Requested Scopes", make sure all checkboxes are checked (read, write, profile, email, qr:read, qr:write, link:read, link:write, offline_access)', 'govalid-qr' ); ?></li>
									<li><?php esc_html_e( 'Save the application and copy the Client ID and Client Secret', 'govalid-qr' ); ?></li>
								</ol>
							</div>
						</div>
					</div>

					<!-- Step 3: Enter credentials -->
					<div class="govalid-setup-step">
						<div class="govalid-step-number <?php echo esc_attr( $govalid_has_credentials ? 'done' : '' ); ?>">3</div>
						<div class="govalid-step-content">
							<h3><?php esc_html_e( 'Enter your OAuth credentials', 'govalid-qr' ); ?></h3>
							<p style="font-size:13px; color:var(--gv-gray-500); line-height:1.6;">
								<?php esc_html_e( 'Paste the Client ID and Client Secret from the OAuth application you just created.', 'govalid-qr' ); ?>
							</p>

							<form method="post" action="options.php" style="margin-top:12px;">
								<?php settings_fields( 'govalid_qr_settings' ); ?>
								<table class="form-table">
									<tr>
										<th scope="row">
											<label for="govalid_qr_client_id"><?php esc_html_e( 'Client ID', 'govalid-qr' ); ?></label>
										</th>
										<td>
											<input type="text" id="govalid_qr_client_id" name="govalid_qr_client_id"
												   value="<?php echo esc_attr( $govalid_client_id ); ?>" class="regular-text" />
										</td>
									</tr>
									<tr>
										<th scope="row">
											<label for="govalid_qr_client_secret"><?php esc_html_e( 'Client Secret', 'govalid-qr' ); ?></label>
										</th>
										<td>
											<input type="password" id="govalid_qr_client_secret" name="govalid_qr_client_secret"
												   value="<?php echo esc_attr( get_option( 'govalid_qr_client_secret', '' ) ); ?>"
												   class="regular-text" />
										</td>
									</tr>
									<tr>
										<th scope="row">
											<label for="govalid_qr_base_url"><?php esc_html_e( 'GoValid URL', 'govalid-qr' ); ?></label>
										</th>
										<td>
											<input type="url" id="govalid_qr_base_url" name="govalid_qr_base_url"
												   value="<?php echo esc_attr( $govalid_base_url ); ?>" class="regular-text" />
											<p class="description">
												<?php esc_html_e( 'Default: https://my.govalid.org', 'govalid-qr' ); ?>
											</p>
										</td>
									</tr>
								</table>
								<?php submit_button( __( 'Save Credentials', 'govalid-qr' ) ); ?>
							</form>
						</div>
					</div>

					<!-- Step 4: Connect -->
					<div class="govalid-setup-step">
						<div class="govalid-step-number">4</div>
						<div class="govalid-step-content">
							<h3><?php esc_html_e( 'Connect to GoValid', 'govalid-qr' ); ?></h3>
							<?php if ( $govalid_has_credentials ) : ?>
								<p style="font-size:13px; color:var(--gv-gray-500); line-height:1.6;">
									<?php esc_html_e( 'Your credentials are saved. Click the button below to authorize the connection.', 'govalid-qr' ); ?>
								</p>
								<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" style="margin-top:10px;">
									<input type="hidden" name="action" value="govalid_qr_connect" />
									<?php wp_nonce_field( 'govalid_qr_connect' ); ?>
									<button type="submit" class="button button-primary button-hero govalid-connect-btn">
										<?php esc_html_e( 'Connect with GoValid', 'govalid-qr' ); ?>
									</button>
								</form>
							<?php else : ?>
								<p style="font-size:13px; color:var(--gv-gray-400);">
									<?php esc_html_e( 'Save your Client ID and Client Secret in Step 3 first, then the Connect button will appear here.', 'govalid-qr' ); ?>
								</p>
							<?php endif; ?>
						</div>
					</div>

				</div>
			</div>
		<?php endif; ?>

	</div>

	<!-- Custom Verification Tab -->
	<div id="govalid-tab-custom-verify" class="govalid-tab-panel <?php echo esc_attr( $govalid_active_tab === 'custom-verify' ? 'active' : '' ); ?>">

		<?php if ( ! $govalid_is_connected ) : ?>
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Custom Verification', 'govalid-qr' ); ?></h2>
				<p><?php esc_html_e( 'Connect to GoValid first to enable custom verification pages.', 'govalid-qr' ); ?></p>
			</div>
		<?php else : ?>

			<!-- Enable / disable toggle -->
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Custom Verification Page', 'govalid-qr' ); ?></h2>
				<p>
					<?php esc_html_e( 'Host QR code verification on your own site. When visitors scan your QR codes, they will land on your domain instead of govalid.org.', 'govalid-qr' ); ?>
				</p>

				<form method="post" action="options.php">
					<?php settings_fields( 'govalid_qr_verify_settings' ); ?>
					<table class="form-table">
						<tr>
							<th scope="row"><?php esc_html_e( 'Enable', 'govalid-qr' ); ?></th>
							<td>
								<label>
									<input type="checkbox" name="govalid_qr_custom_verify_domain" value="1"
										<?php checked( $govalid_custom_verify_on ); ?> />
									<?php
									printf(
										/* translators: %s: the verification URL path. */
										esc_html__( 'Enable verification at %s', 'govalid-qr' ),
										'<code>' . esc_html( home_url( '/v/{token}' ) ) . '</code>'
									);
									?>
								</label>
								<?php if ( $govalid_custom_verify_on ) : ?>
									<p class="description" style="color: #28a745; margin-top: 4px;">
										<strong><?php esc_html_e( 'Active', 'govalid-qr' ); ?></strong> &mdash;
										<?php esc_html_e( 'New QR codes will use your domain in the verification URL.', 'govalid-qr' ); ?>
									</p>
								<?php endif; ?>
							</td>
						</tr>
						<tr>
							<th scope="row"><?php esc_html_e( 'Powered by badge', 'govalid-qr' ); ?></th>
							<td>
								<label>
									<input type="checkbox" name="govalid_qr_show_powered_by" value="1"
										<?php checked( get_option( 'govalid_qr_show_powered_by', '' ), '1' ); ?> />
									<?php esc_html_e( 'Show "Powered by GoValid" badge on verification pages', 'govalid-qr' ); ?>
								</label>
							</td>
						</tr>
					</table>
					<?php submit_button( __( 'Save', 'govalid-qr' ) ); ?>
				</form>
			</div>

			<!-- Setup Guide -->
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Setup Guide', 'govalid-qr' ); ?></h2>

				<div class="govalid-setup-steps">
					<!-- Step 1 -->
					<div class="govalid-setup-step">
						<div class="govalid-step-number <?php echo esc_attr( $govalid_custom_verify_on ? 'done' : '' ); ?>">1</div>
						<div class="govalid-step-content">
							<h3><?php esc_html_e( 'Enable custom verification', 'govalid-qr' ); ?></h3>
							<p>
								<?php if ( $govalid_custom_verify_on ) : ?>
									<span style="color: #28a745;">&#10003;</span> <?php esc_html_e( 'Custom verification is enabled.', 'govalid-qr' ); ?>
								<?php else : ?>
									<?php esc_html_e( 'Toggle the checkbox above and save.', 'govalid-qr' ); ?>
								<?php endif; ?>
							</p>
						</div>
					</div>

					<!-- Step 2 -->
					<div class="govalid-setup-step">
						<div class="govalid-step-number <?php echo esc_attr( $govalid_verify_page_exists ? 'done' : '' ); ?>">2</div>
						<div class="govalid-step-content">
							<h3><?php esc_html_e( 'Create verification page', 'govalid-qr' ); ?></h3>
							<?php if ( $govalid_verify_page_exists ) : ?>
								<p>
									<span style="color: #28a745;">&#10003;</span>
									<?php
									printf(
										/* translators: %s: page title with link. */
										esc_html__( 'Page exists: %s', 'govalid-qr' ),
										'<a href="' . esc_url( get_edit_post_link( $govalid_verify_page_id ) ) . '">' . esc_html( get_the_title( $govalid_verify_page_id ) ) . '</a>'
									);
									?>
								</p>
								<p class="description">
									<?php esc_html_e( 'You can edit the page to customize the layout. The verification shortcode will display results automatically.', 'govalid-qr' ); ?>
								</p>
							<?php else : ?>
								<p><?php esc_html_e( 'Create a page with the verification shortcode. You can customize it later.', 'govalid-qr' ); ?></p>
								<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" style="margin-top: 8px;">
									<input type="hidden" name="action" value="govalid_qr_create_verify_page" />
									<?php wp_nonce_field( 'govalid_qr_create_verify_page' ); ?>
									<button type="submit" class="button button-primary">
										<?php esc_html_e( 'Create Verification Page', 'govalid-qr' ); ?>
									</button>
								</form>
							<?php endif; ?>
						</div>
					</div>

					<!-- Step 3 -->
					<div class="govalid-setup-step">
						<div class="govalid-step-number <?php echo ( $govalid_custom_verify_on && $govalid_verify_page_exists ) ? 'done' : ''; ?>">3</div>
						<div class="govalid-step-content">
							<h3><?php esc_html_e( 'Generate QR codes', 'govalid-qr' ); ?></h3>
							<p>
								<?php if ( $govalid_custom_verify_on && $govalid_verify_page_exists ) : ?>
									<span style="color: #28a745;">&#10003;</span>
									<?php
									printf(
										/* translators: %s: the live verification base URL. */
										esc_html__( 'Ready! New QR codes will verify at %s', 'govalid-qr' ),
										'<code>' . esc_html( home_url( '/v/' ) ) . '</code>'
									);
									?>
								<?php else : ?>
									<?php esc_html_e( 'Complete the steps above, then generate QR codes. They will use your domain for verification.', 'govalid-qr' ); ?>
								<?php endif; ?>
							</p>
						</div>
					</div>
				</div>
			</div>

			<!-- Shortcode Reference -->
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Available Shortcodes', 'govalid-qr' ); ?></h2>
				<p><?php esc_html_e( 'Use these shortcodes on your verification page to control what information is displayed.', 'govalid-qr' ); ?></p>

				<table class="wp-list-table widefat striped" style="margin-top: 12px;">
					<thead>
						<tr>
							<th style="width: 40%;"><?php esc_html_e( 'Shortcode', 'govalid-qr' ); ?></th>
							<th><?php esc_html_e( 'Description', 'govalid-qr' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><code>[govalid_verify_result]</code></td>
							<td>
								<strong><?php esc_html_e( 'Full verification card', 'govalid-qr' ); ?></strong><br>
								<?php esc_html_e( 'Shows everything: status, QR name, type, creator, institution, scans, alerts, and powered-by badge. This is the recommended shortcode.', 'govalid-qr' ); ?>
							</td>
						</tr>
						<tr>
							<td><code>[govalid_verify_status]</code></td>
							<td><?php esc_html_e( 'Status indicator only (Verified / Counterfeit / Inactive).', 'govalid-qr' ); ?></td>
						</tr>
						<tr>
							<td>
								<code>[govalid_verify_field field="name"]</code><br>
								<code>[govalid_verify_field field="type"]</code><br>
								<code>[govalid_verify_field field="creator"]</code><br>
								<code>[govalid_verify_field field="institution"]</code><br>
								<code>[govalid_verify_field field="scans"]</code><br>
								<code>[govalid_verify_field field="status"]</code><br>
								<code>[govalid_verify_field field="created"]</code>
							</td>
							<td><?php esc_html_e( 'Display a single field. Use these for custom layouts.', 'govalid-qr' ); ?></td>
						</tr>
						<tr>
							<td><code>[govalid_verify_alerts]</code></td>
							<td><?php esc_html_e( 'Security alerts and violation details (if any).', 'govalid-qr' ); ?></td>
						</tr>
						<tr>
							<td><code>[govalid_powered_by]</code></td>
							<td><?php esc_html_e( '"Powered by GoValid" badge. Optional — enable in settings above. Automatically included in [govalid_verify_result] when enabled.', 'govalid-qr' ); ?></td>
						</tr>
					</tbody>
				</table>
			</div>

		<?php endif; ?>

	</div>

	<!-- Anti-Counterfeit Tab -->
	<div id="govalid-tab-anti-counterfeit" class="govalid-tab-panel <?php echo esc_attr( $govalid_active_tab === 'anti-counterfeit' ? 'active' : '' ); ?>">

		<!-- Hero Section -->
		<div class="govalid-card" style="text-align:center; padding:32px 24px 28px;">
			<div style="display:inline-flex; align-items:center; justify-content:center; width:56px; height:56px; border-radius:14px; background:rgba(37,99,235,0.1); margin-bottom:14px;">
				<span class="dashicons dashicons-shield" style="font-size:28px; width:28px; height:28px; color:var(--gv-primary);"></span>
			</div>
			<h2 style="margin:0 0 8px; font-size:20px;"><?php esc_html_e( 'Anti-Counterfeit Detection', 'govalid-qr' ); ?></h2>
			<p style="font-size:14px; color:var(--gv-gray-500); line-height:1.6; max-width:540px; margin:0 auto 20px;">
				<?php esc_html_e( 'Protect your products and documents with intelligent fraud detection. Create detection profiles directly from your GoValid account and assign them to your QR codes.', 'govalid-qr' ); ?>
			</p>
			<a href="https://my.govalid.org/qr_codes/anti-counterfeit/profiles/" target="_blank" class="button button-primary" style="display:inline-flex; align-items:center; gap:6px; padding:8px 20px; font-size:14px;">
				<span class="dashicons dashicons-shield" style="font-size:16px; width:16px; height:16px; margin-top:2px;"></span>
				<?php esc_html_e( 'Manage Anti-Counterfeit Profiles', 'govalid-qr' ); ?>
			</a>
		</div>

		<!-- Detection Checks -->
		<div class="govalid-card" style="padding:24px;">
			<div style="display:flex; align-items:center; gap:12px; margin-bottom:20px;">
				<div style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; border-radius:10px; background:rgba(30,163,86,0.12);">
					<span class="dashicons dashicons-yes-alt" style="font-size:20px; width:20px; height:20px; color:#1ea356;"></span>
				</div>
				<div>
					<h3 style="margin:0; font-size:15px; font-weight:600;"><?php esc_html_e( 'Detection Checks', 'govalid-qr' ); ?></h3>
					<p style="margin:0; font-size:12px; color:var(--gv-gray-400);"><?php esc_html_e( 'Intelligent checks to detect suspicious scan activity', 'govalid-qr' ); ?></p>
				</div>
			</div>

			<div style="display:grid; grid-template-columns:repeat(auto-fill, minmax(240px, 1fr)); gap:12px;">

				<!-- City Spread -->
				<div style="border:1.5px solid var(--gv-gray-200); border-radius:10px; padding:16px; transition:border-color .2s, box-shadow .2s;">
					<div style="display:flex; align-items:center; gap:10px; margin-bottom:8px;">
						<div style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; border-radius:10px; background:rgba(37,99,235,0.12);">
							<span class="dashicons dashicons-location" style="font-size:18px; width:18px; height:18px; color:#2563eb;"></span>
						</div>
						<strong style="font-size:13px; color:var(--gv-gray-800);"><?php esc_html_e( 'City Spread', 'govalid-qr' ); ?></strong>
					</div>
					<p style="margin:0; font-size:12px; color:var(--gv-gray-500); line-height:1.5;"><?php esc_html_e( 'Flag when scanned in too many different cities within a time window.', 'govalid-qr' ); ?></p>
				</div>

				<!-- Distance Check -->
				<div style="border:1.5px solid var(--gv-gray-200); border-radius:10px; padding:16px; transition:border-color .2s, box-shadow .2s;">
					<div style="display:flex; align-items:center; gap:10px; margin-bottom:8px;">
						<div style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; border-radius:10px; background:rgba(0,168,199,0.12);">
							<span class="dashicons dashicons-editor-expand" style="font-size:18px; width:18px; height:18px; color:#00a8c7;"></span>
						</div>
						<strong style="font-size:13px; color:var(--gv-gray-800);"><?php esc_html_e( 'Distance Check', 'govalid-qr' ); ?></strong>
					</div>
					<p style="margin:0; font-size:12px; color:var(--gv-gray-500); line-height:1.5;"><?php esc_html_e( 'Flag when scanned too far from the original scan location.', 'govalid-qr' ); ?></p>
				</div>

				<!-- Impossible Travel -->
				<div style="border:1.5px solid var(--gv-gray-200); border-radius:10px; padding:16px; transition:border-color .2s, box-shadow .2s;">
					<div style="display:flex; align-items:center; gap:10px; margin-bottom:8px;">
						<div style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; border-radius:10px; background:rgba(214,48,49,0.12);">
							<span class="dashicons dashicons-airplane" style="font-size:18px; width:18px; height:18px; color:#d63031;"></span>
						</div>
						<strong style="font-size:13px; color:var(--gv-gray-800);"><?php esc_html_e( 'Impossible Travel', 'govalid-qr' ); ?></strong>
					</div>
					<p style="margin:0; font-size:12px; color:var(--gv-gray-500); line-height:1.5;"><?php esc_html_e( 'Detect physically impossible travel speed between scan locations.', 'govalid-qr' ); ?></p>
				</div>

				<!-- Time Limit -->
				<div style="border:1.5px solid var(--gv-gray-200); border-radius:10px; padding:16px; transition:border-color .2s, box-shadow .2s;">
					<div style="display:flex; align-items:center; gap:10px; margin-bottom:8px;">
						<div style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; border-radius:10px; background:rgba(230,138,0,0.12);">
							<span class="dashicons dashicons-clock" style="font-size:18px; width:18px; height:18px; color:#e68a00;"></span>
						</div>
						<strong style="font-size:13px; color:var(--gv-gray-800);"><?php esc_html_e( 'Time Limit', 'govalid-qr' ); ?></strong>
					</div>
					<p style="margin:0; font-size:12px; color:var(--gv-gray-500); line-height:1.5;"><?php esc_html_e( 'Flag scans that occur too long after the first scan.', 'govalid-qr' ); ?></p>
				</div>

				<!-- Rapid Repeat -->
				<div style="border:1.5px solid var(--gv-gray-200); border-radius:10px; padding:16px; transition:border-color .2s, box-shadow .2s;">
					<div style="display:flex; align-items:center; gap:10px; margin-bottom:8px;">
						<div style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; border-radius:10px; background:rgba(90,106,122,0.12);">
							<span class="dashicons dashicons-update" style="font-size:18px; width:18px; height:18px; color:#5a6a7a;"></span>
						</div>
						<strong style="font-size:13px; color:var(--gv-gray-800);"><?php esc_html_e( 'Rapid Repeat', 'govalid-qr' ); ?></strong>
					</div>
					<p style="margin:0; font-size:12px; color:var(--gv-gray-500); line-height:1.5;"><?php esc_html_e( 'Detect rapid scans from different sources in a short time window.', 'govalid-qr' ); ?></p>
				</div>

				<!-- Device Count -->
				<div style="border:1.5px solid var(--gv-gray-200); border-radius:10px; padding:16px; transition:border-color .2s, box-shadow .2s;">
					<div style="display:flex; align-items:center; gap:10px; margin-bottom:8px;">
						<div style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; border-radius:10px; background:rgba(59,66,83,0.12);">
							<span class="dashicons dashicons-smartphone" style="font-size:18px; width:18px; height:18px; color:#3b4253;"></span>
						</div>
						<strong style="font-size:13px; color:var(--gv-gray-800);"><?php esc_html_e( 'Device Count', 'govalid-qr' ); ?></strong>
					</div>
					<p style="margin:0; font-size:12px; color:var(--gv-gray-500); line-height:1.5;"><?php esc_html_e( 'Flag when too many unique devices scan the same QR code.', 'govalid-qr' ); ?></p>
				</div>

			</div>
		</div>

		<!-- Scan Limits & Violation Response -->
		<div style="display:grid; grid-template-columns:1fr 1fr; gap:16px;">

			<!-- Scan Limits -->
			<div class="govalid-card" style="padding:24px;">
				<div style="display:flex; align-items:center; gap:12px; margin-bottom:16px;">
					<div style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; border-radius:10px; background:rgba(0,168,199,0.12);">
						<span class="dashicons dashicons-visibility" style="font-size:20px; width:20px; height:20px; color:#00a8c7;"></span>
					</div>
					<div>
						<h3 style="margin:0; font-size:15px; font-weight:600;"><?php esc_html_e( 'Scan Limits', 'govalid-qr' ); ?></h3>
						<p style="margin:0; font-size:12px; color:var(--gv-gray-400);"><?php esc_html_e( 'Control how many times a QR can be scanned', 'govalid-qr' ); ?></p>
					</div>
				</div>
				<div style="display:flex; flex-direction:column; gap:8px;">
					<div style="display:flex; align-items:center; gap:10px; padding:10px 12px; border-radius:8px; background:rgba(214,48,49,0.06);">
						<span class="dashicons dashicons-marker" style="font-size:16px; width:16px; height:16px; color:#d63031;"></span>
						<span style="font-size:13px; color:var(--gv-gray-700);"><strong><?php esc_html_e( 'Single Use', 'govalid-qr' ); ?></strong> — <?php esc_html_e( 'One scan only. For tickets & vouchers.', 'govalid-qr' ); ?></span>
					</div>
					<div style="display:flex; align-items:center; gap:10px; padding:10px 12px; border-radius:8px; background:rgba(230,138,0,0.06);">
						<span class="dashicons dashicons-editor-ol" style="font-size:16px; width:16px; height:16px; color:#e68a00;"></span>
						<span style="font-size:13px; color:var(--gv-gray-700);"><strong><?php esc_html_e( 'Limited Scans', 'govalid-qr' ); ?></strong> — <?php esc_html_e( 'Set a max number of scans.', 'govalid-qr' ); ?></span>
					</div>
					<div style="display:flex; align-items:center; gap:10px; padding:10px 12px; border-radius:8px; background:rgba(30,163,86,0.06);">
						<span class="dashicons dashicons-controls-repeat" style="font-size:16px; width:16px; height:16px; color:#1ea356;"></span>
						<span style="font-size:13px; color:var(--gv-gray-700);"><strong><?php esc_html_e( 'Unlimited', 'govalid-qr' ); ?></strong> — <?php esc_html_e( 'No scan limit. Use detection checks.', 'govalid-qr' ); ?></span>
					</div>
				</div>
			</div>

			<!-- Violation Response -->
			<div class="govalid-card" style="padding:24px;">
				<div style="display:flex; align-items:center; gap:12px; margin-bottom:16px;">
					<div style="display:flex; align-items:center; justify-content:center; width:40px; height:40px; border-radius:10px; background:rgba(214,48,49,0.12);">
						<span class="dashicons dashicons-warning" style="font-size:20px; width:20px; height:20px; color:#d63031;"></span>
					</div>
					<div>
						<h3 style="margin:0; font-size:15px; font-weight:600;"><?php esc_html_e( 'Violation Response', 'govalid-qr' ); ?></h3>
						<p style="margin:0; font-size:12px; color:var(--gv-gray-400);"><?php esc_html_e( 'Choose what happens when a violation is detected', 'govalid-qr' ); ?></p>
					</div>
				</div>
				<div style="display:flex; flex-direction:column; gap:8px;">
					<div style="display:flex; align-items:center; gap:10px; padding:10px 12px; border-radius:8px; background:rgba(230,138,0,0.06);">
						<span class="dashicons dashicons-info-outline" style="font-size:16px; width:16px; height:16px; color:#e68a00;"></span>
						<span style="font-size:13px; color:var(--gv-gray-700);"><strong><?php esc_html_e( 'Show Warning', 'govalid-qr' ); ?></strong> — <?php esc_html_e( 'Alert user but still show content.', 'govalid-qr' ); ?></span>
					</div>
					<div style="display:flex; align-items:center; gap:10px; padding:10px 12px; border-radius:8px; background:rgba(214,48,49,0.06);">
						<span class="dashicons dashicons-dismiss" style="font-size:16px; width:16px; height:16px; color:#d63031;"></span>
						<span style="font-size:13px; color:var(--gv-gray-700);"><strong><?php esc_html_e( 'Block Content', 'govalid-qr' ); ?></strong> — <?php esc_html_e( 'Hide QR data on violation.', 'govalid-qr' ); ?></span>
					</div>
				</div>
			</div>

		</div>

		<!-- CTA -->
		<div class="govalid-card" style="text-align:center; padding:24px; background:linear-gradient(135deg, rgba(37,99,235,0.04), rgba(30,163,86,0.04));">
			<p style="font-size:14px; color:var(--gv-gray-600); margin:0 0 14px;">
				<?php esc_html_e( 'Create and manage your anti-counterfeit detection profiles from your GoValid dashboard.', 'govalid-qr' ); ?>
			</p>
			<a href="https://my.govalid.org/qr_codes/anti-counterfeit/profiles/" target="_blank" class="button button-primary" style="display:inline-flex; align-items:center; gap:6px; padding:8px 24px; font-size:14px;">
				<span class="dashicons dashicons-external" style="font-size:16px; width:16px; height:16px; margin-top:2px;"></span>
				<?php esc_html_e( 'Set Up Anti-Counterfeit Profiles', 'govalid-qr' ); ?>
			</a>
		</div>

	</div>

	</div><!-- /.govalid-generator-main -->
	<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/promo-sidebar.php'; ?>
	</div><!-- /.govalid-generator-layout -->

</div>
