<?php
/**
 * Humanize Links admin page template.
 *
 * Two-step flow: suggest → choose/edit → check → create.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$govalid_is_connected = GoValid_QR::is_connected();
?>
<div class="wrap govalid-links">
	<!-- Page Header -->
	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div>
			<h1><?php esc_html_e( 'Humanize Links', 'govalid-qr' ); ?></h1>
			<p class="govalid-page-subtitle"><?php esc_html_e( 'Create memorable AI-powered short links for your URLs.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<?php if ( ! $govalid_is_connected ) : ?>
		<div class="govalid-card" style="max-width:1000px; border-left:4px solid #2563eb; background:linear-gradient(135deg, rgba(37,99,235,0.04), #fff 40%);">
			<div style="display:flex; align-items:center; gap:14px;">
				<div style="display:flex; align-items:center; justify-content:center; width:44px; height:44px; border-radius:12px; background:rgba(37,99,235,0.12); flex-shrink:0;">
					<span class="dashicons dashicons-admin-links" style="font-size:22px; width:22px; height:22px; color:#2563eb;"></span>
				</div>
				<div style="flex:1;">
					<h3 style="margin:0 0 4px; font-size:14px; color:var(--gv-gray-800);"><?php esc_html_e( 'Try Humanize Links', 'govalid-qr' ); ?></h3>
					<p style="margin:0; font-size:13px; color:var(--gv-gray-500); line-height:1.5;">
						<?php esc_html_e( 'You can create up to 2 AI-powered humanize links without an account. Connect to GoValid for up to 5 free links.', 'govalid-qr' ); ?>
					</p>
				</div>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr' ) ); ?>" class="button button-primary" style="display:inline-flex; align-items:center; gap:6px; white-space:nowrap;">
					<span class="dashicons dashicons-admin-network" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
					<?php esc_html_e( 'Connect Now', 'govalid-qr' ); ?>
				</a>
			</div>
		</div>
	<?php endif; ?>

		<div class="govalid-generator-layout">
			<!-- Main Content -->
			<div class="govalid-generator-main">

				<!-- Step 1: Enter URL & Get Suggestions -->
				<div class="govalid-card govalid-form" id="govalid-link-form-card">
					<h2><?php esc_html_e( 'Create a Humanize Link', 'govalid-qr' ); ?></h2>

					<div class="govalid-field-group">
						<label class="govalid-field-label" for="govalid-link-url">
							<?php esc_html_e( 'Target URL', 'govalid-qr' ); ?>
							<span class="govalid-required">*</span>
						</label>
						<div class="govalid-input-wrap" style="max-width: 100%;">
							<span class="govalid-input-icon"><span class="dashicons dashicons-admin-links"></span></span>
							<input type="url" id="govalid-link-url" class="govalid-input"
								   placeholder="https://example.com/your-page" required />
						</div>
					</div>

					<div class="govalid-link-field-row" style="display: flex; gap: 14px;">
						<div class="govalid-field-group" style="flex: 1;">
							<label class="govalid-field-label" for="govalid-link-title">
								<?php esc_html_e( 'Title', 'govalid-qr' ); ?>
								<span class="govalid-badge"><?php esc_html_e( 'Optional', 'govalid-qr' ); ?></span>
							</label>
							<div class="govalid-input-wrap" style="max-width: 100%;">
								<input type="text" id="govalid-link-title" class="govalid-input"
									   placeholder="<?php esc_attr_e( 'Help AI generate a better slug', 'govalid-qr' ); ?>" />
							</div>
						</div>

						<div class="govalid-field-group" style="flex: 0 0 160px;">
							<label class="govalid-field-label" for="govalid-link-audience">
								<?php esc_html_e( 'Audience', 'govalid-qr' ); ?>
							</label>
							<select id="govalid-link-audience" class="govalid-select" style="max-width: 100%;">
								<option value="local"><?php esc_html_e( 'Local', 'govalid-qr' ); ?></option>
								<option value="global"><?php esc_html_e( 'Global', 'govalid-qr' ); ?></option>
								<option value="both"><?php esc_html_e( 'Both', 'govalid-qr' ); ?></option>
							</select>
						</div>
					</div>

					<div class="govalid-field-group">
						<label class="govalid-field-label" for="govalid-link-description">
							<?php esc_html_e( 'Description', 'govalid-qr' ); ?>
							<span class="govalid-badge"><?php esc_html_e( 'Optional', 'govalid-qr' ); ?></span>
						</label>
						<div class="govalid-input-wrap" style="max-width: 100%;">
							<input type="text" id="govalid-link-description" class="govalid-input"
								   placeholder="<?php esc_attr_e( 'Extra context for AI slug generation (max 150 chars)', 'govalid-qr' ); ?>"
								   maxlength="150" />
						</div>
					</div>

					<div class="govalid-form-actions">
						<button type="button" id="govalid-suggest-btn" class="govalid-btn govalid-btn-primary">
							<span class="dashicons dashicons-randomize"></span>
							<?php esc_html_e( 'Humanize', 'govalid-qr' ); ?>
						</button>
					</div>
				</div>

				<!-- Step 2: Suggestions + Edit + Check + Create -->
				<div id="govalid-suggestions-card" class="govalid-card govalid-form" style="display: none;">
					<h2><?php esc_html_e( 'Choose Your Link', 'govalid-qr' ); ?></h2>
					<p class="govalid-field-help" style="margin: -8px 0 16px;">
						<?php esc_html_e( 'Click a suggestion, edit the slug if you want, check availability, then create.', 'govalid-qr' ); ?>
					</p>

					<!-- Suggestion Cards -->
					<div id="govalid-suggestion-list" class="govalid-suggestion-list"></div>

					<!-- Editable Slug Area -->
					<div id="govalid-slug-editor" class="govalid-slug-editor" style="display: none;">
						<div class="govalid-field-group">
							<label class="govalid-field-label"><?php esc_html_e( 'Your Link', 'govalid-qr' ); ?></label>
							<div class="govalid-slug-edit-row">
								<span id="govalid-slug-domain-prefix" class="govalid-slug-domain-prefix"></span>
								<input type="text" id="govalid-slug-input" class="govalid-slug-input" />
								<button type="button" id="govalid-check-slug-btn" class="govalid-btn govalid-btn-sm">
									<?php esc_html_e( 'Check', 'govalid-qr' ); ?>
								</button>
							</div>
							<div id="govalid-slug-status" class="govalid-slug-status" style="display: none;"></div>
						</div>

						<div class="govalid-form-actions" style="margin-top: 16px;">
							<button type="button" id="govalid-create-link-btn" class="govalid-btn govalid-btn-primary" disabled>
								<span class="dashicons dashicons-yes-alt"></span>
								<?php esc_html_e( 'Create Link', 'govalid-qr' ); ?>
							</button>
							<button type="button" id="govalid-back-btn" class="govalid-btn" style="background: var(--gv-gray-100); color: var(--gv-gray-600); margin-left: 8px;">
								<span class="dashicons dashicons-arrow-left-alt2"></span>
								<?php esc_html_e( 'Back', 'govalid-qr' ); ?>
							</button>
						</div>
					</div>
				</div>

				<!-- Result Area -->
				<div id="govalid-link-result" class="govalid-card" style="display: none;">
					<h2><?php esc_html_e( 'Link Created', 'govalid-qr' ); ?></h2>
					<div class="govalid-link-result-main" style="display: flex; align-items: center; gap: 12px; margin-bottom: 14px;">
						<code id="govalid-link-result-url" style="flex: 1; font-size: 15px; padding: 10px 14px; background: var(--gv-gray-50); border: 1px solid var(--gv-gray-200); border-radius: 8px; word-break: break-all;"></code>
						<button type="button" class="govalid-btn govalid-btn-primary govalid-copy-shortcode" id="govalid-copy-link-btn" data-clipboard="">
							<span class="dashicons dashicons-clipboard"></span>
							<?php esc_html_e( 'Copy', 'govalid-qr' ); ?>
						</button>
					</div>
					<button type="button" id="govalid-create-another-btn" class="govalid-btn" style="background: var(--gv-gray-100); color: var(--gv-gray-600);">
						<span class="dashicons dashicons-plus-alt2"></span>
						<?php esc_html_e( 'Create Another', 'govalid-qr' ); ?>
					</button>
				</div>

				<!-- Links Table -->
				<div class="govalid-card">
					<h2><?php esc_html_e( 'Your Links', 'govalid-qr' ); ?></h2>
					<div id="govalid-links-list" class="govalid-links-list">
						<p class="govalid-loading"><?php esc_html_e( 'Loading links...', 'govalid-qr' ); ?></p>
					</div>
					<div id="govalid-links-pagination" class="govalid-links-pagination" style="display: none; margin-top: 16px; text-align: center;"></div>
				</div>

			</div>

			<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/promo-sidebar.php'; ?>
		</div>

</div>
