<?php
/**
 * Timeline tab form template.
 *
 * Matches the GoValid Django timeline_form.html structure.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$govalid_userinfo = get_option( 'govalid_qr_userinfo', array() );
$govalid_user_display     = ! empty( $govalid_userinfo['name'] ) ? $govalid_userinfo['name'] : '';
$govalid_today = wp_date( 'Y-m-d' );
?>
<p class="govalid-form-intro">
	<?php esc_html_e( 'Create QR codes for product history, journey tracking, or event timelines.', 'govalid-qr' ); ?>
</p>

<form id="govalid-form-timeline" class="govalid-form" method="post"
	  action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" enctype="multipart/form-data">
	<input type="hidden" name="action" value="govalid_qr_create" />
	<input type="hidden" name="qr_type" value="timeline" />
	<input type="hidden" name="content" value="timeline_data" />
	<input type="hidden" name="template_type" value="Timeline" />
	<?php wp_nonce_field( 'govalid_qr_create' ); ?>

	<!-- ===================== SECURITY LEVEL ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'Security Configuration', 'govalid-qr' ); ?></div>

		<div class="govalid-field-group">
			<label class="govalid-field-label" for="security_level_tl">
				<?php esc_html_e( 'Security Level', 'govalid-qr' ); ?>
			</label>
			<div class="govalid-security-cards">
				<label class="govalid-security-option active" data-level="SMART">
					<input type="radio" name="security_level" value="SMART" checked />
					<span class="govalid-security-icon"><span class="dashicons dashicons-shield"></span></span>
					<span class="govalid-security-info">
						<strong><?php esc_html_e( 'Smart QR', 'govalid-qr' ); ?></strong>
					</span>
				</label>
				<label class="govalid-security-option" data-level="SECURE">
					<input type="radio" name="security_level" value="SECURE" />
					<span class="govalid-security-icon"><span class="dashicons dashicons-lock"></span></span>
					<span class="govalid-security-info">
						<strong><?php esc_html_e( 'Secure QR', 'govalid-qr' ); ?></strong>
					</span>
				</label>
				<label class="govalid-security-option" data-level="ENTERPRISE">
					<input type="radio" name="security_level" value="ENTERPRISE" />
					<span class="govalid-security-icon"><span class="dashicons dashicons-shield-alt"></span></span>
					<span class="govalid-security-info">
						<strong><?php esc_html_e( 'Enterprise QR', 'govalid-qr' ); ?></strong>
					</span>
				</label>
			</div>
			<div class="govalid-security-desc" id="security_level_desc_tl">
				<?php esc_html_e( 'Compact QR code with 96-bit security. Perfect for tiny labels and product tags. Smallest QR code size.', 'govalid-qr' ); ?>
			</div>
		</div>
	</div>

	<!-- ===================== BASIC INFORMATION ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'Basic Information', 'govalid-qr' ); ?></div>

		<!-- QR Code Name -->
		<div class="govalid-field-group">
			<label class="govalid-field-label" for="qr_name_tl">
				<?php esc_html_e( 'QR Code Name', 'govalid-qr' ); ?> <span class="govalid-required">*</span>
			</label>
			<div class="govalid-input-wrap">
				<span class="govalid-input-icon"><span class="dashicons dashicons-edit"></span></span>
				<input type="text" id="qr_name_tl" name="qr_name" class="govalid-input" required
					   placeholder="<?php esc_attr_e( 'Enter a name for this QR code', 'govalid-qr' ); ?>" />
			</div>
		</div>

		<!-- Generated by -->
		<div class="govalid-field-group">
			<label class="govalid-field-label" for="field_generated_by_tl">
				<?php esc_html_e( 'Generated by', 'govalid-qr' ); ?>
			</label>
			<div class="govalid-input-wrap">
				<span class="govalid-input-icon"><span class="dashicons dashicons-admin-users"></span></span>
				<input type="text" id="field_generated_by_tl" name="field_generated_by"
					   class="govalid-input" readonly
					   value="<?php echo esc_attr( $govalid_user_display ); ?>" />
			</div>
			<p class="govalid-field-help"><?php esc_html_e( 'Auto-filled with your name.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<!-- ===================== TIMELINE DATA ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'Timeline Data', 'govalid-qr' ); ?></div>

		<!-- Identifier Code -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_identifier_tl" checked />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Identifier Code', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_identifier_tl" class="govalid-toggle-body">
				<div class="govalid-field-group">
					<label class="govalid-field-label govalid-field-label-sm" for="format_identifier_tl">
						<?php esc_html_e( 'Format', 'govalid-qr' ); ?>
					</label>
					<div style="display:flex;gap:8px;align-items:center;max-width:328px;">
						<select id="format_identifier_tl" class="govalid-select govalid-identifier-format" style="flex:1;">
							<option value="alpha5"><?php esc_html_e( '5-digit Alphanumeric (A1B2C)', 'govalid-qr' ); ?></option>
							<option value="numeric6"><?php esc_html_e( '6-digit Numeric (123456)', 'govalid-qr' ); ?></option>
							<option value="invoice"><?php esc_html_e( 'Invoice Format (INV-YYMMDD-XXX)', 'govalid-qr' ); ?></option>
							<option value="serial"><?php esc_html_e( 'Serial Number (SN-XXXXX-XXX)', 'govalid-qr' ); ?></option>
							<option value="dateseq"><?php esc_html_e( 'Date Sequential (DDMMYY-XXX)', 'govalid-qr' ); ?></option>
							<option value="institution_pattern"><?php esc_html_e( 'Institution Numbering Pattern', 'govalid-qr' ); ?></option>
							<option value="custom"><?php esc_html_e( 'Custom Pattern...', 'govalid-qr' ); ?></option>
						</select>
						<input type="number" class="govalid-generate-qty" value="1" min="1" max="999"
							   title="<?php esc_attr_e( 'Quantity', 'govalid-qr' ); ?>" />
						<button type="button" class="govalid-btn govalid-btn-sm govalid-generate-id-btn"
								data-target="field_identifier_tl" data-format="format_identifier_tl"
								style="margin-top:0;" title="<?php esc_attr_e( 'Generate', 'govalid-qr' ); ?>">
							<span class="dashicons dashicons-randomize"></span>
						</button>
					</div>
					<!-- Custom pattern (hidden by default) -->
					<div id="custom_pattern_container_tl" class="govalid-conditional" style="display:none;">
						<div class="govalid-custom-pattern-row">
							<div class="govalid-custom-pattern-input">
								<div class="govalid-input-wrap">
									<span class="govalid-input-icon"><span class="dashicons dashicons-editor-code"></span></span>
									<input type="text" id="custom_pattern_tl" class="govalid-input"
										   placeholder="<?php esc_attr_e( 'e.g. TL/{YYYY}/{MM}/{####}', 'govalid-qr' ); ?>" />
								</div>
							</div>
							<div class="govalid-custom-pattern-card">
								<div class="govalid-pattern-card-section">
									<span class="govalid-pattern-card-label"><?php esc_html_e( 'Click to use:', 'govalid-qr' ); ?></span>
									<div class="govalid-pattern-chips">
										<code class="govalid-pattern-example" data-pattern="TL/{YYYY}/{MM}/{####}">TL/{YYYY}/{MM}/{####}</code>
										<code class="govalid-pattern-example" data-pattern="EVT-{YY}{MM}{DD}-{###}">EVT-{YY}{MM}{DD}-{###}</code>
										<code class="govalid-pattern-example" data-pattern="TRACK/{YYYY}/{AA}-{###}">TRACK/{YYYY}/{AA}-{###}</code>
										<code class="govalid-pattern-example" data-pattern="{AA}{AA}-{######}">{AA}{AA}-{######}</code>
										<code class="govalid-pattern-example" data-pattern="SN-{YYYY}-{AAAAA}">SN-{YYYY}-{AAAAA}</code>
									</div>
								</div>
								<div class="govalid-pattern-card-syntax">
									<code>{#}</code> <?php esc_html_e( 'digit', 'govalid-qr' ); ?>
									&middot; <code>{A}</code> <?php esc_html_e( 'letter', 'govalid-qr' ); ?>
									&middot; <code>{YYYY}</code> <?php esc_html_e( 'year', 'govalid-qr' ); ?>
									&middot; <code>{MM}</code> <?php esc_html_e( 'month', 'govalid-qr' ); ?>
									&middot; <code>{DD}</code> <?php esc_html_e( 'day', 'govalid-qr' ); ?>
								</div>
							</div>
						</div>
					</div>
					<!-- Institution numbering pattern (hidden by default) -->
					<div id="institution_pattern_container_tl" class="govalid-conditional" style="display:none;">
						<p class="govalid-field-help" style="margin:0 0 6px;">
							<span class="dashicons dashicons-building" style="font-size:14px;width:14px;height:14px;vertical-align:middle;"></span>
							<?php esc_html_e( 'Select from your institution\'s numbering patterns', 'govalid-qr' ); ?>
						</p>
						<select id="institution_pattern_select_tl" class="govalid-select">
							<option value=""><?php esc_html_e( 'Loading patterns...', 'govalid-qr' ); ?></option>
						</select>
					</div>
				</div>
				<div class="govalid-field-group">
					<div class="govalid-input-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-nametag"></span></span>
						<textarea id="field_identifier_tl" name="field_identifier"
								  class="govalid-input govalid-textarea govalid-bulk-input" rows="3"
								  data-max-entries="999"
								  placeholder="<?php esc_attr_e( 'Enter unique identifier (max 50 chars each, up to 999 entries)', 'govalid-qr' ); ?>"></textarea>
					</div>
					<div class="govalid-entry-counter" style="display:flex;gap:4px;align-items:center;margin-top:4px;font-size:12px;color:#666;">
						<span class="dashicons dashicons-editor-ol" style="font-size:14px;width:14px;height:14px;"></span>
						<span class="govalid-counter-current">0</span> / <span class="govalid-counter-max">999</span>
						<?php esc_html_e( 'identifiers', 'govalid-qr' ); ?>
						<span class="govalid-bulk-badge" style="display:none;margin-left:6px;background:#2271b1;color:#fff;padding:1px 8px;border-radius:10px;font-size:11px;">
							<?php esc_html_e( 'Bulk mode', 'govalid-qr' ); ?>
						</span>
					</div>
				</div>
				<div class="govalid-field-option">
					<label class="govalid-switch">
						<input type="checkbox" name="mask_identifier" id="mask_identifier_tl" value="1" />
						<span class="govalid-switch-slider"></span>
					</label>
					<span class="govalid-switch-label"><?php esc_html_e( 'Partially mask identifier on verification (for security)', 'govalid-qr' ); ?></span>
				</div>
			</div>
		</div>

		<!-- Purpose -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_purpose_tl" checked />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Purpose', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_purpose_tl" class="govalid-toggle-body">
				<div class="govalid-input-wrap">
					<span class="govalid-input-icon"><span class="dashicons dashicons-tag"></span></span>
					<input type="text" id="field_purpose_tl" name="field_purpose" class="govalid-input"
						   placeholder="<?php esc_attr_e( 'Purpose of this timeline', 'govalid-qr' ); ?>" />
				</div>
			</div>
		</div>

		<!-- Product -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_product_tl" checked />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Product', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_product_tl" class="govalid-toggle-body">
				<div class="govalid-input-wrap">
					<span class="govalid-input-icon"><span class="dashicons dashicons-cart"></span></span>
					<input type="text" id="field_product_tl" name="field_product" class="govalid-input"
						   placeholder="<?php esc_attr_e( 'Product name or type', 'govalid-qr' ); ?>" />
				</div>
			</div>
		</div>

		<!-- Brand -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_brand_tl" checked />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Brand', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_brand_tl" class="govalid-toggle-body">
				<div class="govalid-input-wrap">
					<span class="govalid-input-icon"><span class="dashicons dashicons-megaphone"></span></span>
					<input type="text" id="field_brand_tl" name="field_brand" class="govalid-input"
						   placeholder="<?php esc_attr_e( 'Brand name', 'govalid-qr' ); ?>" />
				</div>
			</div>
		</div>
	</div>

	<!-- ===================== HISTORY ENTRIES ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'History Entries', 'govalid-qr' ); ?></div>

		<div id="timeline-entries-container">
			<!-- Entry #1 -->
			<div class="govalid-timeline-entry" data-entry-id="1">
				<div class="govalid-timeline-entry-header">
					<span class="govalid-timeline-entry-title">
						<span class="dashicons dashicons-clock"></span>
						<?php esc_html_e( 'History Entry #1', 'govalid-qr' ); ?>
					</span>
					<button type="button" class="govalid-btn govalid-btn-xs govalid-btn-danger-outline govalid-remove-timeline-entry"
							data-entry-id="1" title="<?php esc_attr_e( 'Remove this entry', 'govalid-qr' ); ?>">
						<span class="dashicons dashicons-trash"></span>
						<?php esc_html_e( 'Remove', 'govalid-qr' ); ?>
					</button>
				</div>

				<!-- Create Date (required) -->
				<div class="govalid-field-group">
					<label class="govalid-field-label" for="field_create_date_tl_1">
						<?php esc_html_e( 'Create Date', 'govalid-qr' ); ?> <span class="govalid-required">*</span>
					</label>
					<div class="govalid-input-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-calendar-alt"></span></span>
						<input type="date" id="field_create_date_tl_1" name="timeline_entries[0][create_date]"
							   class="govalid-input" required />
					</div>
				</div>

				<!-- Description -->
				<div class="govalid-field-group govalid-toggleable">
					<div class="govalid-toggle-header">
						<label class="govalid-switch">
							<input type="checkbox" class="govalid-field-toggle" data-target="container_description_tl_1" checked />
							<span class="govalid-switch-slider"></span>
						</label>
						<span class="govalid-toggle-label"><?php esc_html_e( 'Description', 'govalid-qr' ); ?></span>
					</div>
					<div id="container_description_tl_1" class="govalid-toggle-body">
						<div class="govalid-input-wrap">
							<span class="govalid-input-icon"><span class="dashicons dashicons-editor-alignleft"></span></span>
							<textarea id="field_description_tl_1" name="timeline_entries[0][description]"
									  class="govalid-input govalid-textarea" rows="3"
									  placeholder="<?php esc_attr_e( 'Describe this timeline event', 'govalid-qr' ); ?>"></textarea>
						</div>
					</div>
				</div>

				<!-- Upload Media -->
				<div class="govalid-field-group govalid-toggleable">
					<div class="govalid-toggle-header">
						<label class="govalid-switch">
							<input type="checkbox" class="govalid-field-toggle" data-target="container_upload_tl_1" checked />
							<span class="govalid-switch-slider"></span>
						</label>
						<span class="govalid-toggle-label"><?php esc_html_e( 'Upload Media', 'govalid-qr' ); ?></span>
					</div>
					<div id="container_upload_tl_1" class="govalid-toggle-body">
						<div class="govalid-file-upload" id="file_upload_area_tl_1">
							<input type="file" id="field_upload_tl_1" name="timeline_entries_media_0"
								   class="govalid-file-input" accept=".jpg,.jpeg,.png,.pdf" />
							<div class="govalid-file-upload-placeholder">
								<span class="dashicons dashicons-cloud-upload"></span>
								<p><?php esc_html_e( 'Drag & drop or click to upload', 'govalid-qr' ); ?></p>
								<small><?php esc_html_e( 'JPG, PNG, PDF (max 5MB)', 'govalid-qr' ); ?></small>
							</div>
							<div class="govalid-file-preview" style="display:none;">
								<span class="govalid-file-preview-name"></span>
								<button type="button" class="govalid-file-remove" title="<?php esc_attr_e( 'Remove', 'govalid-qr' ); ?>">
									<span class="dashicons dashicons-no-alt"></span>
								</button>
							</div>
						</div>
					</div>
				</div>

				<!-- Location -->
				<div class="govalid-field-group govalid-toggleable">
					<div class="govalid-toggle-header">
						<label class="govalid-switch">
							<input type="checkbox" class="govalid-field-toggle" data-target="container_map_tl_1" />
							<span class="govalid-switch-slider"></span>
						</label>
						<span class="govalid-toggle-label"><?php esc_html_e( 'Location', 'govalid-qr' ); ?></span>
					</div>
					<div id="container_map_tl_1" class="govalid-toggle-body" style="display:none;">
						<div class="govalid-map-wrap" id="map_wrap_tl_1">
							<div class="govalid-map-container" id="leaflet-map-tl-1" style="height:300px;"></div>
							<div class="govalid-map-overlay" id="map_overlay_tl_1">
								<button type="button" class="govalid-btn govalid-btn-primary govalid-load-map-btn" data-entry-id="1">
									<span class="dashicons dashicons-location"></span>
									<?php esc_html_e( 'Load Map', 'govalid-qr' ); ?>
								</button>
							</div>
							<div class="govalid-map-search" id="map_search_tl_1" style="display:none;">
								<div class="govalid-input-wrap">
									<input type="text" class="govalid-input govalid-map-search-input"
										   placeholder="<?php esc_attr_e( 'Search for a location...', 'govalid-qr' ); ?>" />
									<button type="button" class="govalid-input-action govalid-map-search-btn">
										<span class="dashicons dashicons-search"></span>
									</button>
								</div>
							</div>
							<div class="govalid-map-locate" id="map_locate_tl_1" style="display:none;">
								<button type="button" class="govalid-btn govalid-btn-sm govalid-btn-primary govalid-get-location-btn"
										data-entry-id="1" title="<?php esc_attr_e( 'Get my current location', 'govalid-qr' ); ?>">
									<span class="dashicons dashicons-location-alt"></span>
								</button>
							</div>
						</div>
						<div class="govalid-location-status" id="location_status_tl_1" style="display:none;">
							<div class="govalid-location-status-inner">
								<span class="dashicons dashicons-location"></span>
								<div class="govalid-location-info">
									<span class="govalid-location-address" id="location_address_tl_1"></span>
									<span class="govalid-location-coords" id="location_coords_tl_1"></span>
								</div>
								<button type="button" class="govalid-btn govalid-btn-xs govalid-btn-danger-outline govalid-clear-location-btn"
										data-entry-id="1">
									<span class="dashicons dashicons-no-alt"></span>
								</button>
							</div>
						</div>
						<input type="hidden" id="field_map_lat_tl_1" name="timeline_entries[0][map_lat]" value="" />
						<input type="hidden" id="field_map_lng_tl_1" name="timeline_entries[0][map_lng]" value="" />
						<input type="hidden" id="field_map_address_tl_1" name="timeline_entries[0][map_address]" value="" />
						<p class="govalid-field-help">
							<?php esc_html_e( 'Click "Load Map" to activate the location picker. Search, use current location, or drag the marker.', 'govalid-qr' ); ?>
						</p>
					</div>
				</div>
			</div>
		</div>

		<!-- Add entry button -->
		<div class="govalid-timeline-add-wrap">
			<button type="button" id="govalid-add-timeline-entry" class="govalid-btn govalid-btn-secondary">
				<span class="dashicons dashicons-plus-alt2"></span>
				<?php esc_html_e( 'Add History Entry', 'govalid-qr' ); ?>
			</button>
		</div>
	</div>

	<!-- ===================== ADVANCED SETTINGS ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'Advanced Settings', 'govalid-qr' ); ?></div>

		<!-- Anti-Counterfeit Tags -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" id="toggle_anti_counterfeit_tl"
						   data-target="container_anti_counterfeit_tl" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Anti-Counterfeit Tags', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_anti_counterfeit_tl" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-note-row">
					<!-- Left: Tag input -->
					<div class="govalid-note-row-main">
						<div class="govalid-input-wrap">
							<span class="govalid-input-icon"><span class="dashicons dashicons-tag"></span></span>
							<input type="text" id="anti_counterfeit_tags_tl" name="anti_counterfeit_tags"
								   class="govalid-input"
								   placeholder="<?php esc_attr_e( 'e.g., luxury, batch-2024, premium', 'govalid-qr' ); ?>" />
						</div>
						<div id="existing_tags_tl" class="govalid-existing-tags" style="display:none;">
							<small class="govalid-field-help" style="margin-bottom:4px;display:block;"><?php esc_html_e( 'Click to add:', 'govalid-qr' ); ?></small>
							<div class="govalid-tag-chips"></div>
						</div>
						<p class="govalid-field-help"><?php esc_html_e( 'Comma-separated tags for anti-counterfeit detection profiles.', 'govalid-qr' ); ?></p>
					</div>
					<!-- Right: Info note -->
					<div class="govalid-note-card">
						<div class="govalid-note-card-inner">
							<div class="govalid-note-title">
								<span class="dashicons dashicons-info-outline"></span>
								<?php esc_html_e( 'Anti-Counterfeit Tags', 'govalid-qr' ); ?>
							</div>
							<p class="govalid-note-text">
								<?php esc_html_e( 'Tags let you apply specific detection profiles to this QR code. Configure profiles in', 'govalid-qr' ); ?> <a href="https://my.govalid.org/qr_codes/anti-counterfeit/profiles/" target="_blank"><?php esc_html_e( 'Anti-Counterfeit Settings', 'govalid-qr' ); ?></a>.
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Password Protection -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" id="toggle_password_tl"
						   data-target="container_password_tl" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Password Protection', 'govalid-qr' ); ?></span>
			</div>
			<input type="hidden" name="is_password_protected" id="hidden_is_password_protected_timeline" value="false" />
			<div id="container_password_tl" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-note-row">
					<!-- Left: Password options -->
					<div class="govalid-note-row-main">
						<div class="govalid-radio-group">
							<label class="govalid-radio">
								<input type="radio" name="password_type" value="master" checked />
								<span class="govalid-radio-mark"></span>
								<span class="govalid-radio-text">
									<?php esc_html_e( 'Use QR-master password (from account settings)', 'govalid-qr' ); ?>
								</span>
							</label>
							<label class="govalid-radio">
								<input type="radio" name="password_type" value="unique" />
								<span class="govalid-radio-mark"></span>
								<span class="govalid-radio-text">
									<?php esc_html_e( 'Set QR-unique password', 'govalid-qr' ); ?>
								</span>
							</label>
						</div>
						<div id="unique_password_container_tl" class="govalid-conditional" style="display:none;">
							<div class="govalid-field-group">
								<div class="govalid-input-wrap">
									<span class="govalid-input-icon"><span class="dashicons dashicons-lock"></span></span>
									<input type="password" id="field_password_tl" name="field_password"
										   class="govalid-input" minlength="6"
										   placeholder="<?php esc_attr_e( 'Enter password for this QR code', 'govalid-qr' ); ?>" />
									<button type="button" class="govalid-input-action govalid-toggle-password" tabindex="-1">
										<span class="dashicons dashicons-visibility"></span>
									</button>
								</div>
								<div class="govalid-password-strength">
									<div class="govalid-password-bar" id="password_bar_tl"></div>
								</div>
							</div>
							<div class="govalid-field-group">
								<div class="govalid-input-wrap">
									<span class="govalid-input-icon"><span class="dashicons dashicons-shield"></span></span>
									<input type="password" id="field_password_confirm_tl" name="field_password_confirm"
										   class="govalid-input" minlength="6"
										   placeholder="<?php esc_attr_e( 'Confirm password', 'govalid-qr' ); ?>" />
									<button type="button" class="govalid-input-action govalid-toggle-password" tabindex="-1">
										<span class="dashicons dashicons-visibility"></span>
									</button>
								</div>
							</div>
						</div>
					</div>
					<!-- Right: Info note -->
					<div class="govalid-note-card">
						<div class="govalid-note-card-inner">
							<div class="govalid-note-title">
								<span class="dashicons dashicons-lock"></span>
								<?php esc_html_e( 'Password Protection', 'govalid-qr' ); ?>
							</div>
							<p class="govalid-note-text">
								<?php esc_html_e( 'When enabled, the content of this QR code will be protected with a password.', 'govalid-qr' ); ?>
							</p>
							<ul class="govalid-note-list">
								<li><strong><?php esc_html_e( 'QR-master password:', 'govalid-qr' ); ?></strong> <?php esc_html_e( 'Use the password from your', 'govalid-qr' ); ?> <a href="https://my.govalid.org/pages/account_settings/security/" target="_blank"><?php esc_html_e( 'account settings', 'govalid-qr' ); ?></a></li>
								<li><strong><?php esc_html_e( 'QR-unique password:', 'govalid-qr' ); ?></strong> <?php esc_html_e( 'Set a unique password for this specific QR code', 'govalid-qr' ); ?></li>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Invalid and Hiding Date -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" id="toggle_removal_tl"
						   data-target="container_removal_tl" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label">
					<?php esc_html_e( 'Invalid and Hiding Date', 'govalid-qr' ); ?>
					<span class="govalid-badge"><?php esc_html_e( 'Auto', 'govalid-qr' ); ?></span>
				</span>
			</div>
			<input type="hidden" name="combined_removal_datetime" id="combined_removal_datetime_tl" value="" />
			<div id="container_removal_tl" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-field-group">
					<label class="govalid-field-label govalid-field-label-sm" for="field_removal_type_tl">
						<?php esc_html_e( 'Type', 'govalid-qr' ); ?>
					</label>
					<select id="field_removal_type_tl" name="field_removal_type" class="govalid-select">
						<option value="removal">
							<?php esc_html_e( 'Invalidate QR (scans show error, data preserved)', 'govalid-qr' ); ?>
						</option>
						<option value="inactive">
							<?php esc_html_e( 'Hide QR (temporarily hide from verification)', 'govalid-qr' ); ?>
						</option>
					</select>
				</div>
				<div class="govalid-field-group">
					<label class="govalid-field-label govalid-field-label-sm" for="field_removal_date_tl">
						<?php esc_html_e( 'Date', 'govalid-qr' ); ?>
					</label>
					<div class="govalid-input-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-calendar-alt"></span></span>
						<input type="date" id="field_removal_date_tl" name="field_removal_date"
							   class="govalid-input" min="<?php echo esc_attr( $govalid_today ); ?>" />
					</div>
				</div>
				<div class="govalid-field-group">
					<label class="govalid-field-label govalid-field-label-sm" for="field_removal_time_tl">
						<?php esc_html_e( 'Time (optional)', 'govalid-qr' ); ?>
					</label>
					<div class="govalid-input-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-clock"></span></span>
						<input type="time" id="field_removal_time_tl" name="field_removal_time"
							   class="govalid-input" />
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- ===================== SUBMIT ===================== -->
	<div class="govalid-form-actions">
		<button type="submit" id="generate-timeline-btn" class="govalid-btn govalid-btn-primary">
			<span class="dashicons dashicons-backup"></span>
			<?php esc_html_e( 'Generate Timeline QR', 'govalid-qr' ); ?>
		</button>
	</div>

</form>
