<?php
/**
 * List QR page template.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$govalid_is_connected  = GoValid_QR::is_connected();
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only URL parameters.
$govalid_created       = isset( $_GET['created'] ) ? sanitize_text_field( wp_unslash( $_GET['created'] ) ) : '';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_bulk_created  = isset( $_GET['bulk_created'] ) ? absint( $_GET['bulk_created'] ) : 0;
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$govalid_bulk_errors   = isset( $_GET['bulk_errors'] ) ? sanitize_text_field( wp_unslash( $_GET['bulk_errors'] ) ) : '';
?>
<div class="wrap govalid-list">
	<?php if ( $govalid_created ) : ?>
		<div class="notice notice-success is-dismissible">
			<p>
			<?php esc_html_e( 'QR code created successfully!', 'govalid-qr' ); ?>
			<a href="#" id="govalid-qr-layout-created" class="button button-small" style="margin-left:8px;vertical-align:baseline;">
				<span class="dashicons dashicons-grid-view" style="font-size:14px;width:14px;height:14px;vertical-align:text-bottom;"></span>
				<?php esc_html_e( 'Label Layout', 'govalid-qr' ); ?>
			</a>
		</p>
		</div>
	<?php endif; ?>
	<?php if ( $govalid_bulk_created > 0 ) : ?>
		<div class="notice notice-success is-dismissible">
			<p>
				<?php
				printf(
					/* translators: %d: number of QR codes created */
					esc_html( _n(
						'%d QR code created successfully!',
						'%d QR codes created successfully!',
						$govalid_bulk_created,
						'govalid-qr'
					) ),
					(int) $govalid_bulk_created
				);
				?>
			</p>
		</div>
		<?php if ( $govalid_bulk_errors ) : ?>
			<div class="notice notice-warning is-dismissible">
				<p><?php echo esc_html( $govalid_bulk_errors ); ?></p>
			</div>
		<?php endif; ?>
	<?php endif; ?>

	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div>
			<h1><?php esc_html_e( 'List QR', 'govalid-qr' ); ?></h1>
			<p class="govalid-page-subtitle"><?php esc_html_e( 'Browse and manage all your QR codes.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<?php if ( ! $govalid_is_connected ) : ?>
		<div class="govalid-card" style="max-width:1000px; border-left:4px solid #2563eb; background:linear-gradient(135deg, rgba(37,99,235,0.04), #fff 40%);">
			<div style="display:flex; align-items:center; gap:14px;">
				<div style="display:flex; align-items:center; justify-content:center; width:44px; height:44px; border-radius:12px; background:rgba(37,99,235,0.12); flex-shrink:0;">
					<span class="dashicons dashicons-admin-links" style="font-size:22px; width:22px; height:22px; color:#2563eb;"></span>
				</div>
				<div style="flex:1;">
					<h3 style="margin:0 0 4px; font-size:14px; color:var(--gv-gray-800);"><?php esc_html_e( 'Connect to GoValid', 'govalid-qr' ); ?></h3>
					<p style="margin:0; font-size:13px; color:var(--gv-gray-500); line-height:1.5;">
						<?php esc_html_e( 'Connect your free GoValid account to generate and manage QR codes.', 'govalid-qr' ); ?>
					</p>
				</div>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr' ) ); ?>" class="button button-primary" style="display:inline-flex; align-items:center; gap:6px; white-space:nowrap;">
					<span class="dashicons dashicons-admin-network" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
					<?php esc_html_e( 'Connect Now', 'govalid-qr' ); ?>
				</a>
			</div>
		</div>
	<?php endif; ?>

	<div class="govalid-generator-layout">
		<!-- Main Content -->
		<div class="govalid-generator-main">
			<div class="govalid-card">
				<div class="govalid-qr-list-header">
					<div class="govalid-qr-list-header-left">
						<label class="govalid-qr-checkbox-wrap govalid-qr-select-all-wrap">
							<input type="checkbox" id="govalid-qr-select-all" />
							<span class="govalid-qr-checkmark"></span>
						</label>
						<h2><?php esc_html_e( 'Your QR Codes', 'govalid-qr' ); ?></h2>
						<button type="button" id="govalid-qr-bulk-delete" class="govalid-btn govalid-btn-xs govalid-btn-danger-outline" style="display:none;">
							<span class="dashicons dashicons-trash"></span>
							<?php esc_html_e( 'Delete Selected', 'govalid-qr' ); ?> (<span class="govalid-bulk-count">0</span>)
						</button>
						<button type="button" id="govalid-qr-label-layout-btn" class="govalid-btn govalid-btn-xs govalid-btn-primary-outline" style="display:none;">
							<span class="dashicons dashicons-grid-view"></span>
							<?php esc_html_e( 'Label Layout', 'govalid-qr' ); ?> (<span class="govalid-bulk-count">0</span>)
						</button>
					</div>
					<div class="govalid-input-wrap govalid-qr-search-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-search"></span></span>
						<input type="text" id="govalid-qr-search" class="govalid-input"
							   placeholder="<?php esc_attr_e( 'Search QR codes...', 'govalid-qr' ); ?>" />
					</div>
				</div>
				<div id="govalid-qr-list" class="govalid-qr-list">
					<?php if ( ! $govalid_is_connected ) : ?>
						<div style="text-align:center; padding:40px 20px; color:var(--gv-gray-400);">
							<span class="dashicons dashicons-screenoptions" style="font-size:40px; width:40px; height:40px; display:block; margin:0 auto 10px;"></span>
							<p><?php esc_html_e( 'No QR codes yet. Connect to GoValid to start generating.', 'govalid-qr' ); ?></p>
						</div>
					<?php else : ?>
						<p class="govalid-loading"><?php esc_html_e( 'Loading QR codes...', 'govalid-qr' ); ?></p>
					<?php endif; ?>
				</div>
				<div id="govalid-qr-pagination" class="govalid-qr-pagination" style="display: none;"></div>
			</div>
		</div>

		<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/promo-sidebar.php'; ?>
	</div>

	<!-- Label Layout Full-Screen Modal -->
	<div id="govalid-label-layout-modal" class="govalid-label-layout-overlay" style="display:none;">
		<div class="govalid-label-layout-container">
			<!-- Header Bar -->
			<div class="govalid-ll-header">
				<div class="govalid-ll-header-left">
					<span class="dashicons dashicons-grid-view"></span>
					<h2><?php esc_html_e( 'QR Label Layout', 'govalid-qr' ); ?></h2>
				</div>
				<div class="govalid-ll-header-actions">
					<button type="button" id="govalid-ll-export-pdf" class="govalid-btn govalid-btn-xs govalid-btn-primary" disabled>
						<span class="dashicons dashicons-pdf"></span> <?php esc_html_e( 'PDF', 'govalid-qr' ); ?>
					</button>
					<button type="button" id="govalid-ll-export-png" class="govalid-btn govalid-btn-xs" disabled>
						<span class="dashicons dashicons-format-image"></span> <?php esc_html_e( 'PNG', 'govalid-qr' ); ?>
					</button>
					<button type="button" id="govalid-ll-export-jpg" class="govalid-btn govalid-btn-xs" disabled>
						<span class="dashicons dashicons-format-image"></span> <?php esc_html_e( 'JPG', 'govalid-qr' ); ?>
					</button>
					<button type="button" id="govalid-ll-print" class="govalid-btn govalid-btn-xs" disabled>
						<span class="dashicons dashicons-printer"></span> <?php esc_html_e( 'Print', 'govalid-qr' ); ?>
					</button>
					<button type="button" id="govalid-ll-close" class="govalid-ll-close-btn">
						<span class="dashicons dashicons-no-alt"></span>
					</button>
				</div>
			</div>

			<!-- Main Content Area -->
			<div class="govalid-ll-body">
				<!-- Left Panel: Controls -->
				<div class="govalid-ll-controls">
					<!-- Layout Presets -->
					<div class="govalid-ll-section govalid-ll-preset-section">
						<h3><?php esc_html_e( 'Layout Presets', 'govalid-qr' ); ?></h3>
						<div class="govalid-ll-preset-row">
							<select id="govalid-ll-preset-select" class="govalid-ll-input">
								<option value="" disabled selected><?php esc_html_e( '— Select Preset —', 'govalid-qr' ); ?></option>
							</select>
						</div>
						<div class="govalid-ll-preset-actions">
							<button type="button" id="govalid-ll-preset-save" class="govalid-btn govalid-btn-xs govalid-btn-primary">
								<span class="dashicons dashicons-saved"></span> <?php esc_html_e( 'Save Current', 'govalid-qr' ); ?>
							</button>
							<button type="button" id="govalid-ll-preset-delete" class="govalid-btn govalid-btn-xs" disabled>
								<span class="dashicons dashicons-trash"></span> <?php esc_html_e( 'Delete', 'govalid-qr' ); ?>
							</button>
						</div>
					</div>

					<!-- Selected QR Codes -->
					<div class="govalid-ll-section">
						<h3><?php esc_html_e( 'Selected QR Codes', 'govalid-qr' ); ?> (<span id="govalid-ll-qr-count">0</span>)</h3>
						<div id="govalid-ll-qr-tags" class="govalid-ll-qr-tags"></div>
						<button type="button" id="govalid-ll-add-more" class="govalid-btn govalid-btn-xs" style="margin-top:8px;">
							<span class="dashicons dashicons-plus-alt2"></span> <?php esc_html_e( 'Add More', 'govalid-qr' ); ?>
						</button>
					</div>

					<!-- Paper Settings -->
					<div class="govalid-ll-section govalid-ll-collapsible" data-section="paper">
						<h3 class="govalid-ll-section-toggle">
							<?php esc_html_e( 'Paper Settings', 'govalid-qr' ); ?>
							<span class="dashicons dashicons-arrow-down-alt2"></span>
						</h3>
						<div class="govalid-ll-section-body">
							<div class="govalid-ll-field">
								<label for="govalid-ll-paper-size"><?php esc_html_e( 'Paper Size', 'govalid-qr' ); ?></label>
								<select id="govalid-ll-paper-size" class="govalid-ll-input">
									<option value="a4">A4 (210 x 297 mm)</option>
									<option value="letter">Letter (216 x 279 mm)</option>
									<option value="a3">A3 (297 x 420 mm)</option>
									<option value="legal">Legal (216 x 356 mm)</option>
									<option value="custom"><?php esc_html_e( 'Custom', 'govalid-qr' ); ?></option>
								</select>
							</div>
							<div id="govalid-ll-custom-size" class="govalid-ll-field-row" style="display:none;">
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'Width (mm)', 'govalid-qr' ); ?></label>
									<input type="number" id="govalid-ll-custom-w" class="govalid-ll-input" value="210" min="50" max="600" />
								</div>
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'Height (mm)', 'govalid-qr' ); ?></label>
									<input type="number" id="govalid-ll-custom-h" class="govalid-ll-input" value="297" min="50" max="600" />
								</div>
							</div>
							<div class="govalid-ll-field">
								<label><?php esc_html_e( 'Orientation', 'govalid-qr' ); ?></label>
								<div class="govalid-ll-radio-group">
									<label class="govalid-ll-radio"><input type="radio" name="govalid-ll-orientation" value="portrait" checked /> <?php esc_html_e( 'Portrait', 'govalid-qr' ); ?></label>
									<label class="govalid-ll-radio"><input type="radio" name="govalid-ll-orientation" value="landscape" /> <?php esc_html_e( 'Landscape', 'govalid-qr' ); ?></label>
								</div>
							</div>
							<div class="govalid-ll-field-row">
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'Columns', 'govalid-qr' ); ?> (<span id="govalid-ll-cols-val">3</span>)</label>
									<input type="range" id="govalid-ll-cols" min="1" max="10" value="3" class="govalid-ll-range" />
								</div>
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'Rows', 'govalid-qr' ); ?> (<span id="govalid-ll-rows-val">4</span>)</label>
									<input type="range" id="govalid-ll-rows" min="1" max="10" value="4" class="govalid-ll-range" />
								</div>
							</div>
							<div class="govalid-ll-field-row">
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'Margin T (mm)', 'govalid-qr' ); ?></label>
									<input type="number" id="govalid-ll-margin-top" class="govalid-ll-input" value="10" min="0" max="50" />
								</div>
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'Margin R (mm)', 'govalid-qr' ); ?></label>
									<input type="number" id="govalid-ll-margin-right" class="govalid-ll-input" value="10" min="0" max="50" />
								</div>
							</div>
							<div class="govalid-ll-field-row">
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'Margin B (mm)', 'govalid-qr' ); ?></label>
									<input type="number" id="govalid-ll-margin-bottom" class="govalid-ll-input" value="10" min="0" max="50" />
								</div>
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'Margin L (mm)', 'govalid-qr' ); ?></label>
									<input type="number" id="govalid-ll-margin-left" class="govalid-ll-input" value="10" min="0" max="50" />
								</div>
							</div>
							<div class="govalid-ll-field-row">
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'H. Spacing (mm)', 'govalid-qr' ); ?></label>
									<input type="number" id="govalid-ll-spacing-h" class="govalid-ll-input" value="2" min="0" max="20" />
								</div>
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'V. Spacing (mm)', 'govalid-qr' ); ?></label>
									<input type="number" id="govalid-ll-spacing-v" class="govalid-ll-input" value="2" min="0" max="20" />
								</div>
							</div>
							<div class="govalid-ll-field">
								<label><?php esc_html_e( 'QR Size', 'govalid-qr' ); ?> (<span id="govalid-ll-qr-size-val">85</span>%)</label>
								<input type="range" id="govalid-ll-qr-size" min="10" max="100" value="85" class="govalid-ll-range" />
							</div>
							<div class="govalid-ll-field-row">
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'QR H. Pos', 'govalid-qr' ); ?> (<span id="govalid-ll-qr-hpos-val">50</span>%)</label>
									<input type="range" id="govalid-ll-qr-hpos" min="0" max="100" value="50" class="govalid-ll-range" />
								</div>
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'QR V. Pos', 'govalid-qr' ); ?> (<span id="govalid-ll-qr-vpos-val">50</span>%)</label>
									<input type="range" id="govalid-ll-qr-vpos" min="0" max="100" value="50" class="govalid-ll-range" />
								</div>
							</div>
						</div>
					</div>

					<!-- Label Settings -->
					<div class="govalid-ll-section govalid-ll-collapsible" data-section="labels">
						<h3 class="govalid-ll-section-toggle">
							<?php esc_html_e( 'Label Settings', 'govalid-qr' ); ?>
							<span class="dashicons dashicons-arrow-down-alt2"></span>
						</h3>
						<div class="govalid-ll-section-body">
							<div class="govalid-ll-field">
								<label><input type="checkbox" id="govalid-ll-show-labels" checked /> <?php esc_html_e( 'Show Labels', 'govalid-qr' ); ?></label>
							</div>
							<div id="govalid-ll-label-options">
								<div class="govalid-ll-field">
									<label for="govalid-ll-label-content"><?php esc_html_e( 'Content', 'govalid-qr' ); ?></label>
									<select id="govalid-ll-label-content" class="govalid-ll-input">
										<option value="name"><?php esc_html_e( 'Name', 'govalid-qr' ); ?></option>
										<option value="id"><?php esc_html_e( 'Formatted ID', 'govalid-qr' ); ?></option>
										<option value="both"><?php esc_html_e( 'Both', 'govalid-qr' ); ?></option>
									</select>
								</div>
								<div class="govalid-ll-field">
									<label for="govalid-ll-label-position"><?php esc_html_e( 'Position', 'govalid-qr' ); ?></label>
									<select id="govalid-ll-label-position" class="govalid-ll-input">
										<option value="bottom"><?php esc_html_e( 'Bottom', 'govalid-qr' ); ?></option>
										<option value="top"><?php esc_html_e( 'Top', 'govalid-qr' ); ?></option>
										<option value="left"><?php esc_html_e( 'Left', 'govalid-qr' ); ?></option>
										<option value="right"><?php esc_html_e( 'Right', 'govalid-qr' ); ?></option>
									</select>
								</div>
								<div class="govalid-ll-field-row">
									<div class="govalid-ll-field">
										<label><?php esc_html_e( 'Label H. Offset', 'govalid-qr' ); ?> (<span id="govalid-ll-label-hoffset-val">0</span>px)</label>
										<input type="range" id="govalid-ll-label-hoffset" min="-40" max="40" value="0" class="govalid-ll-range" />
									</div>
									<div class="govalid-ll-field">
										<label><?php esc_html_e( 'Label V. Offset', 'govalid-qr' ); ?> (<span id="govalid-ll-label-voffset-val">0</span>px)</label>
										<input type="range" id="govalid-ll-label-voffset" min="-40" max="40" value="0" class="govalid-ll-range" />
									</div>
								</div>
								<div class="govalid-ll-field-row">
									<div class="govalid-ll-field">
										<label for="govalid-ll-label-font"><?php esc_html_e( 'Font', 'govalid-qr' ); ?></label>
										<select id="govalid-ll-label-font" class="govalid-ll-input">
											<option value="Arial, sans-serif">Arial</option>
											<option value="'Trebuchet MS', sans-serif">Trebuchet MS</option>
											<option value="Verdana, sans-serif">Verdana</option>
											<option value="'Courier New', monospace">Courier New</option>
											<option value="Georgia, serif">Georgia</option>
											<option value="'Times New Roman', serif">Times New Roman</option>
										</select>
									</div>
									<div class="govalid-ll-field">
										<label><?php esc_html_e( 'Size', 'govalid-qr' ); ?> (<span id="govalid-ll-label-size-val">10</span>pt)</label>
										<input type="range" id="govalid-ll-label-size" min="6" max="24" value="10" class="govalid-ll-range" />
									</div>
								</div>
								<div class="govalid-ll-field-row">
									<div class="govalid-ll-field">
										<label for="govalid-ll-label-color"><?php esc_html_e( 'Color', 'govalid-qr' ); ?></label>
										<input type="color" id="govalid-ll-label-color" value="#333333" class="govalid-ll-color" />
									</div>
									<div class="govalid-ll-field govalid-ll-btn-group">
										<label><?php esc_html_e( 'Style', 'govalid-qr' ); ?></label>
										<div>
											<button type="button" class="govalid-ll-style-btn" data-style="bold" title="Bold"><strong>B</strong></button>
											<button type="button" class="govalid-ll-style-btn" data-style="italic" title="Italic"><em>I</em></button>
											<button type="button" class="govalid-ll-style-btn" data-style="underline" title="Underline"><u>U</u></button>
										</div>
									</div>
								</div>
								<div class="govalid-ll-field">
									<label><input type="checkbox" id="govalid-ll-label-bg" /> <?php esc_html_e( 'Label Background', 'govalid-qr' ); ?></label>
									<input type="color" id="govalid-ll-label-bg-color" value="#ffffff" class="govalid-ll-color" style="display:none;" />
								</div>
							</div>
						</div>
					</div>

					<!-- Frame Settings -->
					<div class="govalid-ll-section govalid-ll-collapsible" data-section="frames">
						<h3 class="govalid-ll-section-toggle">
							<?php esc_html_e( 'Frame Settings', 'govalid-qr' ); ?>
							<span class="dashicons dashicons-arrow-down-alt2"></span>
						</h3>
						<div class="govalid-ll-section-body">
							<div class="govalid-ll-field">
								<label><?php esc_html_e( 'Frame Style', 'govalid-qr' ); ?></label>
								<div id="govalid-ll-frame-selector" class="govalid-ll-frame-grid"></div>
							</div>
							<div id="govalid-ll-frame-options" style="display:none;">
								<div class="govalid-ll-field-row">
									<div class="govalid-ll-field">
										<label><?php esc_html_e( 'Frame Color', 'govalid-qr' ); ?></label>
										<input type="color" id="govalid-ll-frame-color" value="#000000" class="govalid-ll-color" />
									</div>
									<div class="govalid-ll-field">
										<label><?php esc_html_e( 'Fill Color', 'govalid-qr' ); ?></label>
										<input type="color" id="govalid-ll-frame-fill" value="#ffffff" class="govalid-ll-color" />
									</div>
								</div>
								<div class="govalid-ll-field">
									<label><?php esc_html_e( 'Stroke Width', 'govalid-qr' ); ?> (<span id="govalid-ll-frame-stroke-val">2</span>px)</label>
									<input type="range" id="govalid-ll-frame-stroke" min="1" max="8" value="2" class="govalid-ll-range" />
								</div>
							</div>
						</div>
					</div>
				</div>

				<!-- Right Panel: Preview -->
				<div class="govalid-ll-preview-area">
					<div class="govalid-ll-preview-toolbar">
						<div class="govalid-ll-zoom-controls">
							<button type="button" id="govalid-ll-zoom-out" class="govalid-ll-zoom-btn" title="<?php esc_attr_e( 'Zoom Out', 'govalid-qr' ); ?>">
								<span class="dashicons dashicons-minus"></span>
							</button>
							<span id="govalid-ll-zoom-level">100%</span>
							<button type="button" id="govalid-ll-zoom-in" class="govalid-ll-zoom-btn" title="<?php esc_attr_e( 'Zoom In', 'govalid-qr' ); ?>">
								<span class="dashicons dashicons-plus-alt2"></span>
							</button>
							<button type="button" id="govalid-ll-zoom-reset" class="govalid-ll-zoom-btn" title="<?php esc_attr_e( 'Reset', 'govalid-qr' ); ?>">
								<span class="dashicons dashicons-image-rotate"></span>
							</button>
						</div>
						<div class="govalid-ll-page-nav">
							<button type="button" id="govalid-ll-prev-page" class="govalid-ll-zoom-btn" disabled>
								<span class="dashicons dashicons-arrow-left-alt2"></span>
							</button>
							<span><?php esc_html_e( 'Page', 'govalid-qr' ); ?> <span id="govalid-ll-current-page">1</span> / <span id="govalid-ll-total-pages">1</span></span>
							<button type="button" id="govalid-ll-next-page" class="govalid-ll-zoom-btn" disabled>
								<span class="dashicons dashicons-arrow-right-alt2"></span>
							</button>
						</div>
					</div>
					<div id="govalid-ll-preview-container" class="govalid-ll-preview-scroll">
						<div id="govalid-ll-paper" class="govalid-ll-paper"></div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
