<?php
/**
 * Certificate tab form template.
 *
 * Matches the GoValid Django certificate_form.html structure.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$govalid_userinfo = get_option( 'govalid_qr_userinfo', array() );
$user_display     = ! empty( $govalid_userinfo['name'] ) ? $govalid_userinfo['name'] : '';
$today = wp_date( 'Y-m-d' );
?>
<form id="govalid-form-certificate" class="govalid-form" method="post"
	  action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" enctype="multipart/form-data">
	<input type="hidden" name="action" value="govalid_qr_create" />
	<input type="hidden" name="qr_type" value="certificate" />
	<input type="hidden" name="content" value="certificate_data" />
	<input type="hidden" name="template_type" value="Certificate" />
	<?php wp_nonce_field( 'govalid_qr_create' ); ?>

	<!-- ===================== SECURITY LEVEL ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'Security Configuration', 'govalid-qr' ); ?></div>

		<div class="govalid-field-group">
			<label class="govalid-field-label" for="security_level_cert">
				<?php esc_html_e( 'Security Level', 'govalid-qr' ); ?>
			</label>
			<div class="govalid-security-cards">
				<label class="govalid-security-option active" data-level="SMART">
					<input type="radio" name="security_level" value="SMART" checked />
					<span class="govalid-security-icon"><span class="dashicons dashicons-shield"></span></span>
					<span class="govalid-security-info">
						<strong><?php esc_html_e( 'Smart QR', 'govalid-qr' ); ?></strong>
					</span>
				</label>
				<label class="govalid-security-option" data-level="SECURE">
					<input type="radio" name="security_level" value="SECURE" />
					<span class="govalid-security-icon"><span class="dashicons dashicons-lock"></span></span>
					<span class="govalid-security-info">
						<strong><?php esc_html_e( 'Secure QR', 'govalid-qr' ); ?></strong>
					</span>
				</label>
				<label class="govalid-security-option" data-level="ENTERPRISE">
					<input type="radio" name="security_level" value="ENTERPRISE" />
					<span class="govalid-security-icon"><span class="dashicons dashicons-shield-alt"></span></span>
					<span class="govalid-security-info">
						<strong><?php esc_html_e( 'Enterprise QR', 'govalid-qr' ); ?></strong>
					</span>
				</label>
			</div>
			<div class="govalid-security-desc" id="security_level_desc_cert">
				<?php esc_html_e( 'Compact QR code with 96-bit security. Perfect for tiny labels and product tags. Smallest QR code size.', 'govalid-qr' ); ?>
			</div>
		</div>
	</div>

	<!-- ===================== BASIC INFORMATION ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'Basic Information', 'govalid-qr' ); ?></div>

		<!-- QR Code Name -->
		<div class="govalid-field-group">
			<label class="govalid-field-label" for="qr_name_cert">
				<?php esc_html_e( 'QR Code Name', 'govalid-qr' ); ?> <span class="govalid-required">*</span>
			</label>
			<div class="govalid-input-wrap">
				<span class="govalid-input-icon"><span class="dashicons dashicons-edit"></span></span>
				<input type="text" id="qr_name_cert" name="qr_name" class="govalid-input" required
					   placeholder="<?php esc_attr_e( 'Enter a name for this QR code', 'govalid-qr' ); ?>" />
			</div>
		</div>

		<!-- Generated by -->
		<div class="govalid-field-group">
			<label class="govalid-field-label" for="field_generated_by_cert">
				<?php esc_html_e( 'Generated by', 'govalid-qr' ); ?>
			</label>
			<div class="govalid-input-wrap">
				<span class="govalid-input-icon"><span class="dashicons dashicons-admin-users"></span></span>
				<input type="text" id="field_generated_by_cert" name="field_generated_by"
					   class="govalid-input" readonly
					   value="<?php echo esc_attr( $user_display ); ?>" />
			</div>
			<p class="govalid-field-help"><?php esc_html_e( 'Auto-filled with your name.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<!-- ===================== CERTIFICATE DATA ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'Certificate Data', 'govalid-qr' ); ?></div>

		<!-- Name (bulk support) -->
		<div class="govalid-field-group">
			<label class="govalid-field-label" for="field_name_cert">
				<?php esc_html_e( 'Name', 'govalid-qr' ); ?> <span class="govalid-required">*</span>
			</label>
			<div class="govalid-note-row">
				<!-- Left: Name input -->
				<div class="govalid-note-row-main">
					<div class="govalid-input-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-id-alt"></span></span>
						<textarea id="field_name_cert" name="field_name" class="govalid-input govalid-textarea govalid-bulk-input" rows="3" required
								  data-max-entries="999"
								  placeholder="<?php esc_attr_e( 'Name of recipient (for bulk, add multiple values separated by line breaks or semicolons)', 'govalid-qr' ); ?>"></textarea>
					</div>
					<div class="govalid-entry-counter" id="name_counter_cert">
						<span class="govalid-counter-current">0</span> / <span class="govalid-counter-max">999</span>
						<?php esc_html_e( 'entries', 'govalid-qr' ); ?>
					</div>
					<div class="govalid-field-option">
						<label class="govalid-switch">
							<input type="checkbox" name="mask_name" id="mask_name_cert" value="1" />
							<span class="govalid-switch-slider"></span>
						</label>
						<span class="govalid-switch-label"><?php esc_html_e( 'Partially mask name on verification (for privacy)', 'govalid-qr' ); ?></span>
					</div>
				</div>
				<!-- Right: Bulk rules note -->
				<div class="govalid-note-card">
					<div class="govalid-note-card-inner">
						<div class="govalid-note-title">
							<span class="dashicons dashicons-info-outline"></span>
							<?php esc_html_e( 'Bulk Certificate Generation Rules', 'govalid-qr' ); ?>
						</div>
						<p class="govalid-note-text">
							<?php esc_html_e( 'Allowed combinations:', 'govalid-qr' ); ?>
						</p>
						<ul class="govalid-note-list">
							<li><strong><?php esc_html_e( 'Equal counts:', 'govalid-qr' ); ?></strong> <?php esc_html_e( 'Multiple names + Multiple identifiers (same count)', 'govalid-qr' ); ?></li>
							<li><strong><?php esc_html_e( 'One identifier for all:', 'govalid-qr' ); ?></strong> <?php esc_html_e( 'Multiple names + 1 identifier', 'govalid-qr' ); ?></li>
						</ul>
						<p class="govalid-note-text" style="margin-top:6px;">
							<?php esc_html_e( 'Use line breaks or semicolons (;) to separate values', 'govalid-qr' ); ?>
						</p>
					</div>
				</div>
			</div>
		</div>

		<!-- Identifier Code -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_identifier_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Identifier Code', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_identifier_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-field-group">
					<label class="govalid-field-label govalid-field-label-sm" for="format_identifier_cert">
						<?php esc_html_e( 'Format', 'govalid-qr' ); ?>
					</label>
					<div style="display:flex;gap:8px;align-items:center;max-width:328px;">
						<select id="format_identifier_cert" class="govalid-select govalid-identifier-format" style="flex:1;">
							<option value="alpha5"><?php esc_html_e( '5-digit Alphanumeric (A1B2C)', 'govalid-qr' ); ?></option>
							<option value="numeric6"><?php esc_html_e( '6-digit Numeric (123456)', 'govalid-qr' ); ?></option>
							<option value="invoice"><?php esc_html_e( 'Invoice Format (INV-YYMMDD-XXX)', 'govalid-qr' ); ?></option>
							<option value="serial"><?php esc_html_e( 'Serial Number (SN-XXXXX-XXX)', 'govalid-qr' ); ?></option>
							<option value="dateseq"><?php esc_html_e( 'Date Sequential (DDMMYY-XXX)', 'govalid-qr' ); ?></option>
							<option value="institution_pattern"><?php esc_html_e( 'Institution Numbering Pattern', 'govalid-qr' ); ?></option>
							<option value="custom"><?php esc_html_e( 'Custom Pattern...', 'govalid-qr' ); ?></option>
						</select>
						<input type="number" class="govalid-generate-qty" value="1" min="1" max="999"
							   title="<?php esc_attr_e( 'Quantity', 'govalid-qr' ); ?>" />
						<button type="button" class="govalid-btn govalid-btn-sm govalid-generate-id-btn"
								data-target="field_identifier_cert" data-format="format_identifier_cert"
								style="margin-top:0;" title="<?php esc_attr_e( 'Generate', 'govalid-qr' ); ?>">
							<span class="dashicons dashicons-randomize"></span>
						</button>
					</div>
					<!-- Custom pattern (hidden by default) -->
					<div id="custom_pattern_container_cert" class="govalid-conditional" style="display:none;">
						<div class="govalid-custom-pattern-row">
							<div class="govalid-custom-pattern-input">
								<div class="govalid-input-wrap">
									<span class="govalid-input-icon"><span class="dashicons dashicons-editor-code"></span></span>
									<input type="text" id="custom_pattern_cert" class="govalid-input"
										   placeholder="<?php esc_attr_e( 'e.g. CERT/{YYYY}/{MM}/{####}', 'govalid-qr' ); ?>" />
								</div>
							</div>
							<div class="govalid-custom-pattern-card">
								<div class="govalid-pattern-card-section">
									<span class="govalid-pattern-card-label"><?php esc_html_e( 'Click to use:', 'govalid-qr' ); ?></span>
									<div class="govalid-pattern-chips">
										<code class="govalid-pattern-example" data-pattern="CERT/{YYYY}/{MM}/{####}">CERT/{YYYY}/{MM}/{####}</code>
										<code class="govalid-pattern-example" data-pattern="INV-{YY}{MM}{DD}-{###}">INV-{YY}{MM}{DD}-{###}</code>
										<code class="govalid-pattern-example" data-pattern="DOC/{YYYY}/{AA}-{###}">DOC/{YYYY}/{AA}-{###}</code>
										<code class="govalid-pattern-example" data-pattern="{AA}{AA}-{######}">{AA}{AA}-{######}</code>
										<code class="govalid-pattern-example" data-pattern="SN-{YYYY}-{AAAAA}">SN-{YYYY}-{AAAAA}</code>
									</div>
								</div>
								<div class="govalid-pattern-card-syntax">
									<code>{#}</code> <?php esc_html_e( 'digit', 'govalid-qr' ); ?>
									&middot; <code>{A}</code> <?php esc_html_e( 'letter', 'govalid-qr' ); ?>
									&middot; <code>{YYYY}</code> <?php esc_html_e( 'year', 'govalid-qr' ); ?>
									&middot; <code>{MM}</code> <?php esc_html_e( 'month', 'govalid-qr' ); ?>
									&middot; <code>{DD}</code> <?php esc_html_e( 'day', 'govalid-qr' ); ?>
								</div>
							</div>
						</div>
					</div>
					<!-- Institution numbering pattern (hidden by default) -->
					<div id="institution_pattern_container_cert" class="govalid-conditional" style="display:none;">
						<p class="govalid-field-help" style="margin:0 0 6px;">
							<span class="dashicons dashicons-building" style="font-size:14px;width:14px;height:14px;vertical-align:middle;"></span>
							<?php esc_html_e( 'Select from your institution\'s numbering patterns', 'govalid-qr' ); ?>
						</p>
						<select id="institution_pattern_select_cert" class="govalid-select">
							<option value=""><?php esc_html_e( 'Loading patterns...', 'govalid-qr' ); ?></option>
						</select>
					</div>
				</div>
				<div class="govalid-field-group">
					<div class="govalid-input-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-nametag"></span></span>
						<textarea id="field_identifier_cert" name="field_identifier"
								  class="govalid-input govalid-textarea" rows="3"
								  placeholder="<?php esc_attr_e( 'Enter unique identifier (max 50 chars each, up to 999 entries)', 'govalid-qr' ); ?>"></textarea>
					</div>
				</div>
				<div class="govalid-field-option">
					<label class="govalid-switch">
						<input type="checkbox" name="mask_identifier" id="mask_identifier_cert" value="1" />
						<span class="govalid-switch-slider"></span>
					</label>
					<span class="govalid-switch-label"><?php esc_html_e( 'Partially mask identifier on verification (for security)', 'govalid-qr' ); ?></span>
				</div>
			</div>
		</div>
	</div>

	<!-- ===================== OPTIONAL FIELDS ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'Certificate Details', 'govalid-qr' ); ?></div>

		<!-- Created Date -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_created_date_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Created Date', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_created_date_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-input-wrap">
					<span class="govalid-input-icon"><span class="dashicons dashicons-calendar-alt"></span></span>
					<input type="date" id="field_created_date_cert" name="field_created_date"
						   class="govalid-input" value="<?php echo esc_attr( $today ); ?>" />
				</div>
			</div>
		</div>

		<!-- Expire Date -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_expire_date_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Expire Date', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_expire_date_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-input-wrap">
					<span class="govalid-input-icon"><span class="dashicons dashicons-calendar"></span></span>
					<input type="date" id="field_expire_date_cert" name="field_expire_date"
						   class="govalid-input" />
				</div>
			</div>
		</div>

		<!-- Purpose / Title -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_purpose_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Purpose / Title', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_purpose_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-input-wrap">
					<span class="govalid-input-icon"><span class="dashicons dashicons-tag"></span></span>
					<input type="text" id="field_purpose_cert" name="field_purpose" class="govalid-input"
						   placeholder="<?php esc_attr_e( 'Certificate purpose or title', 'govalid-qr' ); ?>" />
				</div>
			</div>
		</div>

		<!-- Description -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_description_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Description', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_description_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-input-wrap">
					<span class="govalid-input-icon"><span class="dashicons dashicons-editor-alignleft"></span></span>
					<textarea id="field_description_cert" name="field_description"
							  class="govalid-input govalid-textarea" rows="3"
							  placeholder="<?php esc_attr_e( 'Certificate description', 'govalid-qr' ); ?>"></textarea>
				</div>
			</div>
		</div>

		<!-- Upload File / Image -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" data-target="container_upload_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Upload File / Image', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_upload_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-file-upload" id="file_upload_area_cert">
					<input type="file" id="field_upload_cert" name="field_upload_certificate"
						   class="govalid-file-input" accept=".jpg,.jpeg,.png,.pdf" />
					<div class="govalid-file-upload-placeholder">
						<span class="dashicons dashicons-cloud-upload"></span>
						<p><?php esc_html_e( 'Drag & drop or click to upload', 'govalid-qr' ); ?></p>
						<small><?php esc_html_e( 'JPG, PNG, PDF (max 5MB)', 'govalid-qr' ); ?></small>
					</div>
					<div class="govalid-file-preview" style="display:none;">
						<span class="govalid-file-preview-name"></span>
						<button type="button" class="govalid-file-remove" title="<?php esc_attr_e( 'Remove', 'govalid-qr' ); ?>">
							<span class="dashicons dashicons-no-alt"></span>
						</button>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- ===================== ADVANCED SETTINGS ===================== -->
	<div class="govalid-form-section">
		<div class="govalid-section-title"><?php esc_html_e( 'Advanced Settings', 'govalid-qr' ); ?></div>

		<!-- Signed by -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" id="toggle_sign_by_cert"
						   data-target="container_sign_by_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Signed by', 'govalid-qr' ); ?></span>
			</div>
			<input type="hidden" name="field_sign_by" id="hidden_field_sign_by_cert" value="" />
			<input type="hidden" name="pin_verified" id="hidden_pin_verified_cert" value="false" />
			<div id="container_sign_by_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-sign-by-row">
					<!-- Left: Signed by name (readonly) -->
					<div class="govalid-sign-by-name">
						<div class="govalid-input-wrap">
							<span class="govalid-input-icon"><span class="dashicons dashicons-businessperson"></span></span>
							<input type="text" id="field_sign_by_display_cert" class="govalid-input" readonly
								   value="<?php echo esc_attr( $user_display ); ?>" />
						</div>
						<p class="govalid-field-help"><?php esc_html_e( 'Auto-filled from your account.', 'govalid-qr' ); ?></p>
					</div>
					<!-- Right: PIN Verification Card -->
					<div class="govalid-pin-card" id="pin_card_cert">
						<div class="govalid-pin-card-inner">
							<div class="govalid-pin-title">
								<span class="dashicons dashicons-lock"></span>
								<?php esc_html_e( 'Identity Verification', 'govalid-qr' ); ?>
							</div>
							<!-- PIN Not Set -->
							<div id="pin_not_set_cert" style="display:none;">
								<p class="govalid-pin-msg govalid-pin-warning">
									<?php esc_html_e( 'You need to set up a signing PIN before you can sign documents.', 'govalid-qr' ); ?>
								</p>
								<a href="https://my.govalid.org/settings/security/" target="_blank" class="govalid-btn govalid-btn-warning govalid-btn-xs">
									<span class="dashicons dashicons-lock"></span>
									<?php esc_html_e( 'Set Up PIN', 'govalid-qr' ); ?>
								</a>
							</div>
							<!-- PIN Input -->
							<div id="pin_input_section_cert" style="display:none;">
								<p class="govalid-pin-msg"><?php esc_html_e( 'Enter your 6-digit signing PIN:', 'govalid-qr' ); ?></p>
								<div class="govalid-pin-inputs" id="pin_inputs_cert">
									<input type="password" class="govalid-pin-digit" maxlength="1" data-index="1" />
									<input type="password" class="govalid-pin-digit" maxlength="1" data-index="2" />
									<input type="password" class="govalid-pin-digit" maxlength="1" data-index="3" />
									<input type="password" class="govalid-pin-digit" maxlength="1" data-index="4" />
									<input type="password" class="govalid-pin-digit" maxlength="1" data-index="5" />
									<input type="password" class="govalid-pin-digit" maxlength="1" data-index="6" />
								</div>
								<button type="button" class="govalid-btn govalid-btn-success govalid-btn-xs" id="verify_pin_btn_cert">
									<span class="dashicons dashicons-yes"></span>
									<?php esc_html_e( 'Verify PIN', 'govalid-qr' ); ?>
								</button>
							</div>
							<!-- PIN Success -->
							<div id="pin_success_cert" style="display:none;">
								<div class="govalid-pin-success-icon">
									<span class="dashicons dashicons-yes-alt"></span>
								</div>
								<p class="govalid-pin-msg govalid-pin-ok"><?php esc_html_e( 'Identity verified!', 'govalid-qr' ); ?></p>
							</div>
							<!-- PIN Locked -->
							<div id="pin_locked_cert" style="display:none;">
								<p class="govalid-pin-msg govalid-pin-error">
									<?php esc_html_e( 'PIN locked due to too many failed attempts.', 'govalid-qr' ); ?>
								</p>
								<a href="https://my.govalid.org/settings/security/" target="_blank" class="govalid-btn govalid-btn-danger-outline govalid-btn-xs">
									<span class="dashicons dashicons-update"></span>
									<?php esc_html_e( 'Reset PIN', 'govalid-qr' ); ?>
								</a>
							</div>
							<!-- PIN Error -->
							<div id="pin_error_cert" class="govalid-pin-error-msg" style="display:none;"></div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Anti-Counterfeit Tags -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" id="toggle_anti_counterfeit_cert"
						   data-target="container_anti_counterfeit_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Anti-Counterfeit Tags', 'govalid-qr' ); ?></span>
			</div>
			<div id="container_anti_counterfeit_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-note-row">
					<!-- Left: Tag input -->
					<div class="govalid-note-row-main">
						<div class="govalid-input-wrap">
							<span class="govalid-input-icon"><span class="dashicons dashicons-tag"></span></span>
							<input type="text" id="anti_counterfeit_tags_cert" name="anti_counterfeit_tags"
								   class="govalid-input"
								   placeholder="<?php esc_attr_e( 'e.g., luxury, batch-2024, premium', 'govalid-qr' ); ?>" />
						</div>
						<div id="existing_tags_cert" class="govalid-existing-tags" style="display:none;">
							<small class="govalid-field-help" style="margin-bottom:4px;display:block;"><?php esc_html_e( 'Click to add:', 'govalid-qr' ); ?></small>
							<div class="govalid-tag-chips"></div>
						</div>
						<p class="govalid-field-help"><?php esc_html_e( 'Comma-separated tags for anti-counterfeit detection profiles.', 'govalid-qr' ); ?></p>
					</div>
					<!-- Right: Info note -->
					<div class="govalid-note-card">
						<div class="govalid-note-card-inner">
							<div class="govalid-note-title">
								<span class="dashicons dashicons-info-outline"></span>
								<?php esc_html_e( 'Anti-Counterfeit Tags', 'govalid-qr' ); ?>
							</div>
							<p class="govalid-note-text">
								<?php esc_html_e( 'Tags let you apply specific detection profiles to this QR code. Configure profiles in', 'govalid-qr' ); ?> <a href="https://my.govalid.org/qr_codes/anti-counterfeit/profiles/" target="_blank"><?php esc_html_e( 'Anti-Counterfeit Settings', 'govalid-qr' ); ?></a>.
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Password Protection -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" id="toggle_password_cert"
						   data-target="container_password_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label"><?php esc_html_e( 'Password Protection', 'govalid-qr' ); ?></span>
			</div>
			<input type="hidden" name="is_password_protected" id="hidden_is_password_protected_certificate" value="false" />
			<div id="container_password_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-note-row">
					<!-- Left: Password options -->
					<div class="govalid-note-row-main">
						<div class="govalid-radio-group">
							<label class="govalid-radio">
								<input type="radio" name="password_type" value="master" checked />
								<span class="govalid-radio-mark"></span>
								<span class="govalid-radio-text">
									<?php esc_html_e( 'Use QR-master password (from account settings)', 'govalid-qr' ); ?>
								</span>
							</label>
							<label class="govalid-radio">
								<input type="radio" name="password_type" value="unique" />
								<span class="govalid-radio-mark"></span>
								<span class="govalid-radio-text">
									<?php esc_html_e( 'Set QR-unique password', 'govalid-qr' ); ?>
								</span>
							</label>
						</div>
						<div id="unique_password_container_cert" class="govalid-conditional" style="display:none;">
							<div class="govalid-field-group">
								<div class="govalid-input-wrap">
									<span class="govalid-input-icon"><span class="dashicons dashicons-lock"></span></span>
									<input type="password" id="field_password_cert" name="field_password"
										   class="govalid-input" minlength="6"
										   placeholder="<?php esc_attr_e( 'Enter password for this QR code', 'govalid-qr' ); ?>" />
									<button type="button" class="govalid-input-action govalid-toggle-password" tabindex="-1">
										<span class="dashicons dashicons-visibility"></span>
									</button>
								</div>
								<div class="govalid-password-strength">
									<div class="govalid-password-bar" id="password_bar_cert"></div>
								</div>
							</div>
							<div class="govalid-field-group">
								<div class="govalid-input-wrap">
									<span class="govalid-input-icon"><span class="dashicons dashicons-shield"></span></span>
									<input type="password" id="field_password_confirm_cert" name="field_password_confirm"
										   class="govalid-input" minlength="6"
										   placeholder="<?php esc_attr_e( 'Confirm password', 'govalid-qr' ); ?>" />
									<button type="button" class="govalid-input-action govalid-toggle-password" tabindex="-1">
										<span class="dashicons dashicons-visibility"></span>
									</button>
								</div>
							</div>
						</div>
					</div>
					<!-- Right: Info note -->
					<div class="govalid-note-card">
						<div class="govalid-note-card-inner">
							<div class="govalid-note-title">
								<span class="dashicons dashicons-lock"></span>
								<?php esc_html_e( 'Password Protection', 'govalid-qr' ); ?>
							</div>
							<p class="govalid-note-text">
								<?php esc_html_e( 'When enabled, the content of this QR code will be protected with a password.', 'govalid-qr' ); ?>
							</p>
							<ul class="govalid-note-list">
								<li><strong><?php esc_html_e( 'QR-master password:', 'govalid-qr' ); ?></strong> <?php esc_html_e( 'Use the password from your', 'govalid-qr' ); ?> <a href="https://my.govalid.org/pages/account_settings/security/" target="_blank"><?php esc_html_e( 'account settings', 'govalid-qr' ); ?></a></li>
								<li><strong><?php esc_html_e( 'QR-unique password:', 'govalid-qr' ); ?></strong> <?php esc_html_e( 'Set a unique password for this specific QR code', 'govalid-qr' ); ?></li>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Invalid and Hiding Date -->
		<div class="govalid-field-group govalid-toggleable">
			<div class="govalid-toggle-header">
				<label class="govalid-switch">
					<input type="checkbox" class="govalid-field-toggle" id="toggle_removal_cert"
						   data-target="container_removal_cert" />
					<span class="govalid-switch-slider"></span>
				</label>
				<span class="govalid-toggle-label">
					<?php esc_html_e( 'Invalid and Hiding Date', 'govalid-qr' ); ?>
					<span class="govalid-badge"><?php esc_html_e( 'Auto', 'govalid-qr' ); ?></span>
				</span>
			</div>
			<input type="hidden" name="combined_removal_datetime" id="combined_removal_datetime_cert" value="" />
			<div id="container_removal_cert" class="govalid-toggle-body" style="display:none;">
				<div class="govalid-field-group">
					<label class="govalid-field-label govalid-field-label-sm" for="field_removal_type_cert">
						<?php esc_html_e( 'Type', 'govalid-qr' ); ?>
					</label>
					<select id="field_removal_type_cert" name="field_removal_type" class="govalid-select">
						<option value="removal">
							<?php esc_html_e( 'Invalidate QR (scans show error, data preserved)', 'govalid-qr' ); ?>
						</option>
						<option value="inactive">
							<?php esc_html_e( 'Hide QR (temporarily hide from verification)', 'govalid-qr' ); ?>
						</option>
					</select>
				</div>
				<div class="govalid-field-group">
					<label class="govalid-field-label govalid-field-label-sm" for="field_removal_date_cert">
						<?php esc_html_e( 'Date', 'govalid-qr' ); ?>
					</label>
					<div class="govalid-input-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-calendar-alt"></span></span>
						<input type="date" id="field_removal_date_cert" name="field_removal_date"
							   class="govalid-input" min="<?php echo esc_attr( $today ); ?>" />
					</div>
				</div>
				<div class="govalid-field-group">
					<label class="govalid-field-label govalid-field-label-sm" for="field_removal_time_cert">
						<?php esc_html_e( 'Time (optional)', 'govalid-qr' ); ?>
					</label>
					<div class="govalid-input-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-clock"></span></span>
						<input type="time" id="field_removal_time_cert" name="field_removal_time"
							   class="govalid-input" />
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- ===================== SUBMIT ===================== -->
	<div class="govalid-form-actions">
		<button type="submit" id="generate-certificate-btn" class="govalid-btn govalid-btn-primary">
			<span class="dashicons dashicons-awards"></span>
			<?php esc_html_e( 'Generate Certificate QR', 'govalid-qr' ); ?>
		</button>
	</div>

</form>
