<?php
/**
 * List QR page template.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$is_connected  = GoValid_QR::is_connected();
$created       = isset( $_GET['created'] ) ? sanitize_text_field( wp_unslash( $_GET['created'] ) ) : '';
$bulk_created  = isset( $_GET['bulk_created'] ) ? absint( $_GET['bulk_created'] ) : 0;
$bulk_errors   = isset( $_GET['bulk_errors'] ) ? sanitize_text_field( wp_unslash( $_GET['bulk_errors'] ) ) : '';
?>
<div class="wrap govalid-list">
	<?php if ( $created ) : ?>
		<div class="notice notice-success is-dismissible">
			<p><?php esc_html_e( 'QR code created successfully!', 'govalid-qr' ); ?></p>
		</div>
	<?php endif; ?>
	<?php if ( $bulk_created > 0 ) : ?>
		<div class="notice notice-success is-dismissible">
			<p>
				<?php
				printf(
					/* translators: %d: number of QR codes created */
					esc_html( _n(
						'%d QR code created successfully!',
						'%d QR codes created successfully!',
						$bulk_created,
						'govalid-qr'
					) ),
					$bulk_created
				);
				?>
			</p>
		</div>
		<?php if ( $bulk_errors ) : ?>
			<div class="notice notice-warning is-dismissible">
				<p><?php echo esc_html( $bulk_errors ); ?></p>
			</div>
		<?php endif; ?>
	<?php endif; ?>

	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div>
			<h1><?php esc_html_e( 'List QR', 'govalid-qr' ); ?></h1>
			<p class="govalid-page-subtitle"><?php esc_html_e( 'Browse and manage all your QR codes.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<?php if ( ! $is_connected ) : ?>
		<div class="govalid-card" style="max-width:1000px; border-left:4px solid #2563eb; background:linear-gradient(135deg, rgba(37,99,235,0.04), #fff 40%);">
			<div style="display:flex; align-items:center; gap:14px;">
				<div style="display:flex; align-items:center; justify-content:center; width:44px; height:44px; border-radius:12px; background:rgba(37,99,235,0.12); flex-shrink:0;">
					<span class="dashicons dashicons-admin-links" style="font-size:22px; width:22px; height:22px; color:#2563eb;"></span>
				</div>
				<div style="flex:1;">
					<h3 style="margin:0 0 4px; font-size:14px; color:var(--gv-gray-800);"><?php esc_html_e( 'Connect to GoValid', 'govalid-qr' ); ?></h3>
					<p style="margin:0; font-size:13px; color:var(--gv-gray-500); line-height:1.5;">
						<?php esc_html_e( 'Connect your free GoValid account to generate and manage QR codes.', 'govalid-qr' ); ?>
					</p>
				</div>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr' ) ); ?>" class="button button-primary" style="display:inline-flex; align-items:center; gap:6px; white-space:nowrap;">
					<span class="dashicons dashicons-admin-network" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
					<?php esc_html_e( 'Connect Now', 'govalid-qr' ); ?>
				</a>
			</div>
		</div>
	<?php endif; ?>

	<div class="govalid-generator-layout">
		<!-- Main Content -->
		<div class="govalid-generator-main">
			<div class="govalid-card">
				<div class="govalid-qr-list-header">
					<div class="govalid-qr-list-header-left">
						<label class="govalid-qr-checkbox-wrap govalid-qr-select-all-wrap">
							<input type="checkbox" id="govalid-qr-select-all" />
							<span class="govalid-qr-checkmark"></span>
						</label>
						<h2><?php esc_html_e( 'Your QR Codes', 'govalid-qr' ); ?></h2>
						<button type="button" id="govalid-qr-bulk-delete" class="govalid-btn govalid-btn-xs govalid-btn-danger-outline" style="display:none;">
							<span class="dashicons dashicons-trash"></span>
							<?php esc_html_e( 'Delete Selected', 'govalid-qr' ); ?> (<span class="govalid-bulk-count">0</span>)
						</button>
					</div>
					<div class="govalid-input-wrap govalid-qr-search-wrap">
						<span class="govalid-input-icon"><span class="dashicons dashicons-search"></span></span>
						<input type="text" id="govalid-qr-search" class="govalid-input"
							   placeholder="<?php esc_attr_e( 'Search QR codes...', 'govalid-qr' ); ?>" />
					</div>
				</div>
				<div id="govalid-qr-list" class="govalid-qr-list">
					<?php if ( ! $is_connected ) : ?>
						<div style="text-align:center; padding:40px 20px; color:var(--gv-gray-400);">
							<span class="dashicons dashicons-screenoptions" style="font-size:40px; width:40px; height:40px; display:block; margin:0 auto 10px;"></span>
							<p><?php esc_html_e( 'No QR codes yet. Connect to GoValid to start generating.', 'govalid-qr' ); ?></p>
						</div>
					<?php else : ?>
						<p class="govalid-loading"><?php esc_html_e( 'Loading QR codes...', 'govalid-qr' ); ?></p>
					<?php endif; ?>
				</div>
				<div id="govalid-qr-pagination" class="govalid-qr-pagination" style="display: none;"></div>
			</div>
		</div>

		<?php include GOVALID_QR_PLUGIN_DIR . 'admin/partials/promo-sidebar.php'; ?>
	</div>
</div>
