<?php
/**
 * Forms list page template.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$deleted = isset( $_GET['deleted'] ) ? 1 : 0;
?>
<div class="wrap govalid-forms">
	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div>
			<h1><?php esc_html_e( 'Forms', 'govalid-qr' ); ?></h1>
			<p class="govalid-page-subtitle"><?php esc_html_e( 'Create forms, collect submissions, and generate QR codes.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<?php if ( $deleted ) : ?>
		<div class="notice notice-success is-dismissible">
			<p><?php esc_html_e( 'Form deleted successfully.', 'govalid-qr' ); ?></p>
		</div>
	<?php endif; ?>

	<!-- Form limit upgrade banner (hidden by default, shown by JS when free user hits limit) -->
	<div id="govalid-form-limit-banner" class="govalid-card" style="display:none; max-width:1000px; border-left:4px solid #e68a00; background:linear-gradient(135deg, rgba(230,138,0,0.04), #fff 40%);">
		<div style="display:flex; align-items:center; gap:14px;">
			<div style="display:flex; align-items:center; justify-content:center; width:44px; height:44px; border-radius:12px; background:rgba(230,138,0,0.12); flex-shrink:0;">
				<span class="dashicons dashicons-lock" style="font-size:22px; width:22px; height:22px; color:#e68a00;"></span>
			</div>
			<div style="flex:1;">
				<h3 style="margin:0 0 4px; font-size:14px; color:var(--gv-gray-800);"><?php esc_html_e( 'Form limit reached', 'govalid-qr' ); ?></h3>
				<p style="margin:0; font-size:13px; color:var(--gv-gray-500); line-height:1.5;">
					<?php esc_html_e( 'Free accounts can create 1 form. Upgrade your GoValid subscription to create unlimited forms.', 'govalid-qr' ); ?>
				</p>
			</div>
			<a href="<?php echo esc_url( rtrim( get_option( 'govalid_qr_base_url', GOVALID_QR_DEFAULT_BASE_URL ), '/' ) ); ?>/subscription/plans/" target="_blank" class="button button-primary" style="display:inline-flex; align-items:center; gap:6px; white-space:nowrap;">
				<span class="dashicons dashicons-external" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
				<?php esc_html_e( 'Upgrade Plan', 'govalid-qr' ); ?>
			</a>
		</div>
	</div>

	<div class="govalid-card" style="max-width: 1000px;">
		<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
			<h2 style="margin: 0;"><?php esc_html_e( 'Your Forms', 'govalid-qr' ); ?></h2>
			<a id="govalid-new-form-btn" href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr-form-builder' ) ); ?>"
			   class="govalid-btn govalid-btn-primary">
				<span class="dashicons dashicons-plus-alt2"></span>
				<?php esc_html_e( 'New Form', 'govalid-qr' ); ?>
			</a>
		</div>

		<div id="govalid-forms-list">
			<p class="govalid-loading">
				<span class="dashicons dashicons-update govalid-spin"></span>
				<?php esc_html_e( 'Loading forms...', 'govalid-qr' ); ?>
			</p>
		</div>
	</div>
</div>
