<?php
/**
 * Form Submissions page template.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$form_id = absint( $_GET['form_id'] ?? 0 );
$form    = $form_id ? GoValid_Form_Model::get_form( $form_id ) : null;
?>
<div class="wrap govalid-forms">
	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div style="flex: 1;">
			<h1>
				<?php
				if ( $form ) {
					/* translators: %s: form title */
					printf( esc_html__( 'Submissions: %s', 'govalid-qr' ), esc_html( $form->title ) );
				} else {
					esc_html_e( 'Form Submissions', 'govalid-qr' );
				}
				?>
			</h1>
			<p class="govalid-page-subtitle"><?php esc_html_e( 'View and manage form submissions.', 'govalid-qr' ); ?></p>
		</div>
		<div style="display: flex; gap: 8px;">
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr-forms' ) ); ?>"
			   class="button"><?php esc_html_e( 'Back to Forms', 'govalid-qr' ); ?></a>
			<?php if ( $form_id ) : ?>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr-form-builder&form_id=' . $form_id ) ); ?>"
				   class="button">
					<span class="dashicons dashicons-edit" style="margin-top: 4px;"></span>
					<?php esc_html_e( 'Edit Form', 'govalid-qr' ); ?>
				</a>
				<button type="button" class="button button-primary" onclick="govalidExportCSV(<?php echo (int) $form_id; ?>)">
					<span class="dashicons dashicons-download" style="margin-top: 4px;"></span>
					<?php esc_html_e( 'Export CSV', 'govalid-qr' ); ?>
				</button>
			<?php endif; ?>
		</div>
	</div>

	<?php if ( ! $form ) : ?>
		<div class="notice notice-error">
			<p><?php esc_html_e( 'Form not found. Please select a form from the forms list.', 'govalid-qr' ); ?></p>
		</div>
	<?php else : ?>
		<!-- Statistics Dashboard -->
		<div id="govalid-stats-dashboard" data-form-id="<?php echo esc_attr( $form_id ); ?>" style="margin-bottom: 20px;">
			<!-- Summary Cards -->
			<div class="govalid-stats-cards">
				<div class="govalid-stat-card">
					<div class="govalid-stat-icon" style="background: var(--gv-primary-light); color: var(--gv-primary);">
						<span class="dashicons dashicons-forms"></span>
					</div>
					<div class="govalid-stat-body">
						<span class="govalid-stat-value" id="govalid-stat-total">—</span>
						<span class="govalid-stat-label"><?php esc_html_e( 'Total Submissions', 'govalid-qr' ); ?></span>
					</div>
				</div>
				<div class="govalid-stat-card">
					<div class="govalid-stat-icon" style="background: #f0fdf4; color: var(--gv-success);">
						<span class="dashicons dashicons-calendar-alt"></span>
					</div>
					<div class="govalid-stat-body">
						<span class="govalid-stat-value" id="govalid-stat-today">—</span>
						<span class="govalid-stat-label"><?php esc_html_e( 'Today', 'govalid-qr' ); ?></span>
					</div>
				</div>
				<div class="govalid-stat-card">
					<div class="govalid-stat-icon" style="background: #eff6ff; color: #3b82f6;">
						<span class="dashicons dashicons-chart-bar"></span>
					</div>
					<div class="govalid-stat-body">
						<span class="govalid-stat-value" id="govalid-stat-week">—</span>
						<span class="govalid-stat-label"><?php esc_html_e( 'This Week', 'govalid-qr' ); ?></span>
					</div>
				</div>
				<div class="govalid-stat-card">
					<div class="govalid-stat-icon" style="background: #faf5ff; color: #8b5cf6;">
						<span class="dashicons dashicons-chart-line"></span>
					</div>
					<div class="govalid-stat-body">
						<span class="govalid-stat-value" id="govalid-stat-month">—</span>
						<span class="govalid-stat-label"><?php esc_html_e( 'This Month', 'govalid-qr' ); ?></span>
					</div>
				</div>
			</div>

			<!-- Charts Row: Timeline -->
			<div class="govalid-card govalid-stats-chart-card" style="max-width: none;">
				<h3 class="govalid-stats-chart-title">
					<span class="dashicons dashicons-chart-area"></span>
					<?php esc_html_e( 'Submission Timeline (Last 30 Days)', 'govalid-qr' ); ?>
				</h3>
				<div style="position: relative; height: 260px;">
					<canvas id="govalid-chart-timeline"></canvas>
				</div>
			</div>

			<!-- Dynamic Field Charts + Hourly + Devices (rendered by JS) -->
			<div id="govalid-stats-charts-grid" class="govalid-stats-grid"></div>
		</div>

		<!-- Submissions Table -->
		<div class="govalid-card" style="max-width: none; overflow-x: auto;">
			<div id="govalid-submissions-list" data-form-id="<?php echo esc_attr( $form_id ); ?>">
				<p class="govalid-loading">
					<span class="dashicons dashicons-update govalid-spin"></span>
					<?php esc_html_e( 'Loading submissions...', 'govalid-qr' ); ?>
				</p>
			</div>
		</div>
	<?php endif; ?>
</div>

<!-- Modal overlay styles -->
<style>
	.govalid-modal-overlay {
		position: fixed;
		inset: 0;
		background: rgba(0, 0, 0, 0.5);
		display: flex;
		align-items: center;
		justify-content: center;
		z-index: 100000;
	}
</style>
