<?php
/**
 * Form Builder page template.
 *
 * Drag & drop form builder with palette, canvas, and properties panel.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$form_id = absint( $_GET['form_id'] ?? 0 );
$saved   = isset( $_GET['saved'] ) ? 1 : 0;
?>
<div class="wrap govalid-form-builder-wrap">
	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div style="flex: 1;">
			<div style="display: flex; align-items: center; gap: 12px;">
				<input type="text" id="govalid-fb-title"
					   class="govalid-fb-title-input"
					   placeholder="<?php esc_attr_e( 'Form Title', 'govalid-qr' ); ?>"
					   value="" />
				<span id="govalid-fb-status-badge" class="govalid-fb-badge govalid-fb-badge--draft">
					<?php esc_html_e( 'Draft', 'govalid-qr' ); ?>
				</span>
			</div>
		</div>
		<div class="govalid-fb-actions">
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr-forms' ) ); ?>"
			   class="button"><?php esc_html_e( 'Back to Forms', 'govalid-qr' ); ?></a>
			<button type="button" id="govalid-fb-save" class="button">
				<span class="dashicons dashicons-saved" style="margin-top: 4px;"></span>
				<?php esc_html_e( 'Save Draft', 'govalid-qr' ); ?>
			</button>
			<button type="button" id="govalid-fb-publish" class="button button-primary">
				<span class="dashicons dashicons-yes-alt" style="margin-top: 4px;"></span>
				<?php esc_html_e( 'Publish', 'govalid-qr' ); ?>
			</button>
		</div>
	</div>

	<?php if ( $saved ) : ?>
		<div class="notice notice-success is-dismissible" style="max-width: none;">
			<p><?php esc_html_e( 'Form saved successfully.', 'govalid-qr' ); ?></p>
		</div>
	<?php endif; ?>

	<!-- Shortcode banner (shown after save for published forms) -->
	<div id="govalid-fb-shortcode-bar" class="govalid-card" style="max-width: none; display: none; padding: 14px 20px;">
		<div style="display: flex; align-items: center; gap: 12px;">
			<span class="dashicons dashicons-shortcode" style="color: var(--gv-primary);"></span>
			<code id="govalid-fb-shortcode-text" style="background: var(--gv-gray-100); padding: 4px 10px; border-radius: 6px; font-size: 13px;"></code>
			<button type="button" class="button button-small" id="govalid-fb-copy-shortcode">
				<?php esc_html_e( 'Copy', 'govalid-qr' ); ?>
			</button>
		</div>
	</div>

	<!-- Three-column layout -->
	<div class="govalid-fb-layout">
		<!-- LEFT: Field Palette -->
		<div class="govalid-fb-palette">
			<h3><?php esc_html_e( 'Fields', 'govalid-qr' ); ?></h3>
			<div class="govalid-fb-palette-search-wrap">
				<span class="dashicons dashicons-search"></span>
				<input type="text" id="govalid-fb-palette-search" placeholder="<?php esc_attr_e( 'Search fields...', 'govalid-qr' ); ?>" />
			</div>
			<div class="govalid-fb-palette-scroll">
				<div class="govalid-fb-palette-list" id="govalid-fb-palette">
					<?php
					$field_categories = array(
						__( 'Basic', 'govalid-qr' ) => array(
							'text'      => array( 'label' => __( 'Text', 'govalid-qr' ),      'icon' => 'dashicons-editor-textcolor' ),
							'textarea'  => array( 'label' => __( 'Textarea', 'govalid-qr' ),   'icon' => 'dashicons-editor-paragraph' ),
							'email'     => array( 'label' => __( 'Email', 'govalid-qr' ),      'icon' => 'dashicons-email' ),
							'phone'     => array( 'label' => __( 'Phone', 'govalid-qr' ),      'icon' => 'dashicons-phone' ),
							'number'    => array( 'label' => __( 'Number', 'govalid-qr' ),     'icon' => 'dashicons-calculator' ),
							'url'       => array( 'label' => __( 'URL', 'govalid-qr' ),        'icon' => 'dashicons-admin-links' ),
						),
						__( 'Choices', 'govalid-qr' ) => array(
							'select'    => array( 'label' => __( 'Select', 'govalid-qr' ),     'icon' => 'dashicons-arrow-down-alt2' ),
							'radio'     => array( 'label' => __( 'Radio', 'govalid-qr' ),      'icon' => 'dashicons-marker' ),
							'checkbox'  => array( 'label' => __( 'Checkbox', 'govalid-qr' ),   'icon' => 'dashicons-yes' ),
							'gender'    => array( 'label' => __( 'Sex / Gender', 'govalid-qr' ), 'icon' => 'dashicons-admin-users' ),
						),
						__( 'Upload & Media', 'govalid-qr' ) => array(
							'file'      => array( 'label' => __( 'File', 'govalid-qr' ),       'icon' => 'dashicons-upload' ),
							'camera'    => array( 'label' => __( 'Camera / Selfie', 'govalid-qr' ), 'icon' => 'dashicons-camera' ),
							'date'      => array( 'label' => __( 'Date', 'govalid-qr' ),       'icon' => 'dashicons-calendar-alt' ),
							'time'      => array( 'label' => __( 'Time', 'govalid-qr' ),       'icon' => 'dashicons-clock' ),
							'rating'    => array( 'label' => __( 'Rating', 'govalid-qr' ),     'icon' => 'dashicons-star-filled' ),
							'signature' => array( 'label' => __( 'Signature', 'govalid-qr' ),  'icon' => 'dashicons-edit-page' ),
						),
						__( 'Social', 'govalid-qr' ) => array(
							'whatsapp'  => array( 'label' => __( 'WhatsApp', 'govalid-qr' ),   'icon' => 'dashicons-smartphone' ),
							'linkedin'  => array( 'label' => __( 'LinkedIn', 'govalid-qr' ),   'icon' => 'dashicons-linkedin' ),
							'facebook'  => array( 'label' => __( 'Facebook', 'govalid-qr' ),   'icon' => 'dashicons-facebook-alt' ),
							'instagram' => array( 'label' => __( 'Instagram', 'govalid-qr' ),  'icon' => 'dashicons-instagram' ),
							'twitter'   => array( 'label' => __( 'X / Twitter', 'govalid-qr' ), 'icon' => 'dashicons-twitter' ),
							'youtube'   => array( 'label' => __( 'YouTube', 'govalid-qr' ),    'icon' => 'dashicons-video-alt3' ),
							'tiktok'    => array( 'label' => __( 'TikTok', 'govalid-qr' ),     'icon' => 'dashicons-controls-play' ),
							'telegram'  => array( 'label' => __( 'Telegram', 'govalid-qr' ),   'icon' => 'dashicons-airplane' ),
						),
						__( 'Academic', 'govalid-qr' ) => array(
							'orcid'           => array( 'label' => __( 'ORCID', 'govalid-qr' ),           'icon' => 'dashicons-id-alt' ),
							'scopus'          => array( 'label' => __( 'Scopus', 'govalid-qr' ),          'icon' => 'dashicons-book-alt' ),
							'google_scholar'  => array( 'label' => __( 'Google Scholar', 'govalid-qr' ),  'icon' => 'dashicons-welcome-learn-more' ),
							'researchgate'    => array( 'label' => __( 'ResearchGate', 'govalid-qr' ),    'icon' => 'dashicons-clipboard' ),
							'academia'        => array( 'label' => __( 'Academia.edu', 'govalid-qr' ),    'icon' => 'dashicons-building' ),
							'pubmed'          => array( 'label' => __( 'PubMed', 'govalid-qr' ),          'icon' => 'dashicons-heart' ),
							'web_of_science'  => array( 'label' => __( 'Web of Science', 'govalid-qr' ),  'icon' => 'dashicons-analytics' ),
							'semantic_scholar' => array( 'label' => __( 'Semantic Scholar', 'govalid-qr' ), 'icon' => 'dashicons-search' ),
						),
						__( 'Layout', 'govalid-qr' ) => array(
							'heading'   => array( 'label' => __( 'Heading', 'govalid-qr' ),    'icon' => 'dashicons-heading' ),
							'separator'    => array( 'label' => __( 'Divider', 'govalid-qr' ),      'icon' => 'dashicons-minus' ),
							'image_banner' => array( 'label' => __( 'Image Banner', 'govalid-qr' ), 'icon' => 'dashicons-format-image' ),
							'page_break'   => array( 'label' => __( 'Page Break', 'govalid-qr' ),   'icon' => 'dashicons-editor-break' ),
						),
					);
					foreach ( $field_categories as $cat_label => $cat_fields ) :
					?>
						<div class="govalid-fb-palette-category" data-category="<?php echo esc_attr( sanitize_title( $cat_label ) ); ?>">
							<div class="govalid-fb-palette-cat-label"><?php echo esc_html( $cat_label ); ?></div>
							<?php foreach ( $cat_fields as $type => $ft ) : ?>
								<div class="govalid-fb-palette-item" data-type="<?php echo esc_attr( $type ); ?>" data-search="<?php echo esc_attr( strtolower( $ft['label'] ) ); ?>">
									<span class="dashicons <?php echo esc_attr( $ft['icon'] ); ?>"></span>
									<span><?php echo esc_html( $ft['label'] ); ?></span>
								</div>
							<?php endforeach; ?>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>

		<!-- CENTER: Canvas -->
		<div class="govalid-fb-canvas-wrap">
			<div class="govalid-fb-canvas" id="govalid-fb-canvas">
				<div class="govalid-fb-canvas-empty" id="govalid-fb-empty-msg">
					<span class="dashicons dashicons-move" style="font-size: 32px; color: var(--gv-gray-300); margin-bottom: 8px;"></span>
					<p><?php esc_html_e( 'Drag fields from the left panel to start building your form.', 'govalid-qr' ); ?></p>
				</div>
			</div>
		</div>

		<!-- RIGHT: Properties Panel -->
		<div class="govalid-fb-properties" id="govalid-fb-properties">
			<div class="govalid-fb-props-empty">
				<span class="dashicons dashicons-admin-generic" style="font-size: 28px; color: var(--gv-gray-300);"></span>
				<p><?php esc_html_e( 'Click a field to edit its properties.', 'govalid-qr' ); ?></p>
			</div>

			<div class="govalid-fb-props-form" id="govalid-fb-props-form" style="display: none;">
				<h3><?php esc_html_e( 'Field Properties', 'govalid-qr' ); ?></h3>

				<div class="govalid-fb-prop-group">
					<label><?php esc_html_e( 'Label', 'govalid-qr' ); ?></label>
					<input type="text" id="govalid-fb-prop-label" class="govalid-fb-prop-input" />
				</div>

				<div class="govalid-fb-prop-group" id="govalid-fb-prop-placeholder-wrap">
					<label><?php esc_html_e( 'Placeholder', 'govalid-qr' ); ?></label>
					<input type="text" id="govalid-fb-prop-placeholder" class="govalid-fb-prop-input" />
				</div>

				<div class="govalid-fb-prop-group" id="govalid-fb-prop-required-wrap">
					<label>
						<input type="checkbox" id="govalid-fb-prop-required" />
						<?php esc_html_e( 'Required', 'govalid-qr' ); ?>
					</label>
				</div>

				<div class="govalid-fb-prop-group" id="govalid-fb-prop-options-wrap" style="display: none;">
					<label><?php esc_html_e( 'Options (one per line)', 'govalid-qr' ); ?></label>
					<textarea id="govalid-fb-prop-options" class="govalid-fb-prop-input" rows="4"></textarea>
				</div>

				<!-- Separator settings -->
			<div class="govalid-fb-prop-group" id="govalid-fb-prop-separator-wrap" style="display: none;">
				<label><?php esc_html_e( 'Line Style', 'govalid-qr' ); ?></label>
				<select id="govalid-fb-prop-separator-style" class="govalid-fb-prop-input">
					<option value="solid"><?php esc_html_e( 'Solid', 'govalid-qr' ); ?></option>
					<option value="dashed"><?php esc_html_e( 'Dashed', 'govalid-qr' ); ?></option>
					<option value="dotted"><?php esc_html_e( 'Dotted', 'govalid-qr' ); ?></option>
					<option value="none"><?php esc_html_e( 'No Line', 'govalid-qr' ); ?></option>
				</select>
				<label style="margin-top: 8px;"><?php esc_html_e( 'Height (px)', 'govalid-qr' ); ?></label>
				<input type="number" id="govalid-fb-prop-separator-height" class="govalid-fb-prop-input" min="0" max="100" value="16" />
			</div>

			<!-- Image Banner settings -->
			<div class="govalid-fb-prop-group" id="govalid-fb-prop-banner-wrap" style="display: none;">
				<label><?php esc_html_e( 'Image URL', 'govalid-qr' ); ?></label>
				<div style="display: flex; gap: 6px;">
					<input type="text" id="govalid-fb-prop-banner-url" class="govalid-fb-prop-input" placeholder="<?php esc_attr_e( 'https://...', 'govalid-qr' ); ?>" />
					<button type="button" id="govalid-fb-prop-banner-browse" class="button" style="flex-shrink: 0;">
						<?php esc_html_e( 'Browse', 'govalid-qr' ); ?>
					</button>
				</div>
				<div id="govalid-fb-prop-banner-preview" style="margin-top: 8px; display: none;">
					<img id="govalid-fb-prop-banner-img" src="" alt="" style="max-width: 100%; max-height: 120px; border-radius: 6px; border: 1px solid var(--gv-gray-200);" />
				</div>
			</div>

			<!-- Rating settings -->
		<div class="govalid-fb-prop-group" id="govalid-fb-prop-rating-wrap" style="display: none;">
			<label><?php esc_html_e( 'Max Stars', 'govalid-qr' ); ?></label>
			<input type="number" id="govalid-fb-prop-rating-max" class="govalid-fb-prop-input" min="3" max="10" value="5" />
		</div>

		<!-- Signature settings -->
		<div class="govalid-fb-prop-group" id="govalid-fb-prop-signature-wrap" style="display: none;">
			<label><?php esc_html_e( 'Canvas Height (px)', 'govalid-qr' ); ?></label>
			<input type="number" id="govalid-fb-prop-signature-height" class="govalid-fb-prop-input" min="100" max="400" value="200" />
		</div>

		<!-- Page Break settings -->
		<div class="govalid-fb-prop-group" id="govalid-fb-prop-pagebreak-wrap" style="display: none;">
			<label><?php esc_html_e( 'Step Label', 'govalid-qr' ); ?></label>
			<input type="text" id="govalid-fb-prop-pagebreak-label" class="govalid-fb-prop-input" placeholder="<?php esc_attr_e( 'e.g. Step 2', 'govalid-qr' ); ?>" />
		</div>

		<!-- Conditional Logic -->
				<div class="govalid-fb-prop-group" id="govalid-fb-prop-conditional-wrap">
					<label>
						<input type="checkbox" id="govalid-fb-prop-conditional-enabled" />
						<?php esc_html_e( 'Conditional Logic', 'govalid-qr' ); ?>
					</label>
					<div id="govalid-fb-conditional-config" style="display: none; margin-top: 8px;">
						<div style="display: flex; gap: 8px; align-items: center; flex-wrap: wrap;">
							<select id="govalid-fb-cond-action" class="govalid-fb-prop-input" style="width: auto;">
								<option value="show"><?php esc_html_e( 'Show', 'govalid-qr' ); ?></option>
								<option value="hide"><?php esc_html_e( 'Hide', 'govalid-qr' ); ?></option>
							</select>
							<span><?php esc_html_e( 'when', 'govalid-qr' ); ?></span>
							<select id="govalid-fb-cond-field" class="govalid-fb-prop-input" style="width: auto; min-width: 120px;"></select>
							<select id="govalid-fb-cond-operator" class="govalid-fb-prop-input" style="width: auto;">
								<option value="equals"><?php esc_html_e( 'equals', 'govalid-qr' ); ?></option>
								<option value="not_equals"><?php esc_html_e( 'not equals', 'govalid-qr' ); ?></option>
								<option value="contains"><?php esc_html_e( 'contains', 'govalid-qr' ); ?></option>
								<option value="not_empty"><?php esc_html_e( 'is not empty', 'govalid-qr' ); ?></option>
							</select>
							<input type="text" id="govalid-fb-cond-value" class="govalid-fb-prop-input"
								   placeholder="<?php esc_attr_e( 'Value', 'govalid-qr' ); ?>" style="width: 120px;" />
						</div>
					</div>
				</div>

				<div style="margin-top: 16px; padding-top: 16px; border-top: 1px solid var(--gv-gray-200);">
					<button type="button" id="govalid-fb-remove-field" class="button" style="color: var(--gv-danger);">
						<span class="dashicons dashicons-trash" style="margin-top: 4px;"></span>
						<?php esc_html_e( 'Remove Field', 'govalid-qr' ); ?>
					</button>
				</div>
			</div>
		</div>
	</div>

	<!-- Form Settings (below the builder) -->
	<div class="govalid-card" style="max-width: none; margin-top: 20px;">
		<h3 style="margin-top: 0;">
			<span class="dashicons dashicons-admin-generic" style="margin-right: 6px;"></span>
			<?php esc_html_e( 'Form Settings', 'govalid-qr' ); ?>
		</h3>
		<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
			<div class="govalid-fb-prop-group">
				<label><?php esc_html_e( 'Submit Button Text', 'govalid-qr' ); ?></label>
				<input type="text" id="govalid-fb-setting-submit-text" class="govalid-fb-prop-input"
					   value="<?php esc_attr_e( 'Submit', 'govalid-qr' ); ?>" />
			</div>
			<div class="govalid-fb-prop-group">
				<label><?php esc_html_e( 'Success Message', 'govalid-qr' ); ?></label>
				<input type="text" id="govalid-fb-setting-success-msg" class="govalid-fb-prop-input"
					   value="<?php esc_attr_e( 'Thank you! Your submission has been received.', 'govalid-qr' ); ?>" />
			</div>
			<div class="govalid-fb-prop-group">
				<label>
					<input type="checkbox" id="govalid-fb-setting-email-notification" />
					<?php esc_html_e( 'Email notification on new submission', 'govalid-qr' ); ?>
				</label>
			</div>
			<div class="govalid-fb-prop-group" id="govalid-fb-notif-email-wrap" style="display: none;">
				<label><?php esc_html_e( 'Notification Email', 'govalid-qr' ); ?></label>
				<input type="email" id="govalid-fb-setting-notif-email" class="govalid-fb-prop-input"
					   value="<?php echo esc_attr( get_option( 'admin_email' ) ); ?>" />
			</div>
		</div>
	</div>
</div>

<script>
	// Pass form ID and REST config to the builder JS.
	var govalidFormBuilder = {
		formId: <?php echo (int) $form_id; ?>,
		restUrl: '<?php echo esc_js( rest_url( 'govalid-qr/v1/' ) ); ?>',
		nonce: '<?php echo esc_js( wp_create_nonce( 'wp_rest' ) ); ?>',
		builderUrl: '<?php echo esc_js( admin_url( 'admin.php?page=govalid-qr-form-builder' ) ); ?>',
		submissionsUrl: '<?php echo esc_js( admin_url( 'admin.php?page=govalid-qr-form-submissions' ) ); ?>',
		i18n: {
			saved: '<?php echo esc_js( __( 'Form saved!', 'govalid-qr' ) ); ?>',
			published: '<?php echo esc_js( __( 'Form published!', 'govalid-qr' ) ); ?>',
			confirmRemove: '<?php echo esc_js( __( 'Remove this field?', 'govalid-qr' ) ); ?>',
			untitled: '<?php echo esc_js( __( 'Untitled Form', 'govalid-qr' ) ); ?>',
			saving: '<?php echo esc_js( __( 'Saving...', 'govalid-qr' ) ); ?>',
			copied: '<?php echo esc_js( __( 'Copied!', 'govalid-qr' ) ); ?>',
		}
	};
</script>
