<?php
/**
 * Dashboard widget template.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$api   = new GoValid_QR_API();
$stats = $api->get_dashboard_stats();

if ( is_wp_error( $stats ) ) :
	?>
	<p class="govalid-widget-error">
		<?php esc_html_e( 'Unable to load stats. Please check your GoValid connection.', 'govalid-qr' ); ?>
	</p>
	<?php
	return;
endif;

$total_qr    = isset( $stats['total_qr_codes'] ) ? absint( $stats['total_qr_codes'] ) : 0;
$total_scans = isset( $stats['total_scans'] ) ? absint( $stats['total_scans'] ) : 0;
$recent      = isset( $stats['recent_scans'] ) ? (array) $stats['recent_scans'] : array();
?>
<div class="govalid-dashboard-widget">
	<div class="govalid-stats-grid">
		<div class="govalid-stat">
			<span class="govalid-stat-number"><?php echo esc_html( number_format_i18n( $total_qr ) ); ?></span>
			<span class="govalid-stat-label"><?php esc_html_e( 'QR Codes', 'govalid-qr' ); ?></span>
		</div>
		<div class="govalid-stat">
			<span class="govalid-stat-number"><?php echo esc_html( number_format_i18n( $total_scans ) ); ?></span>
			<span class="govalid-stat-label"><?php esc_html_e( 'Total Scans', 'govalid-qr' ); ?></span>
		</div>
	</div>

	<?php if ( ! empty( $recent ) ) : ?>
		<h4><?php esc_html_e( 'Recent Scans', 'govalid-qr' ); ?></h4>
		<ul class="govalid-recent-scans">
			<?php foreach ( array_slice( $recent, 0, 5 ) as $scan ) : ?>
				<li>
					<strong><?php echo esc_html( $scan['qr_name'] ?? '' ); ?></strong>
					<span class="govalid-scan-meta">
						<?php echo esc_html( $scan['location'] ?? '' ); ?>
						&mdash;
						<?php echo esc_html( $scan['scanned_at'] ?? '' ); ?>
					</span>
				</li>
			<?php endforeach; ?>
		</ul>
	<?php endif; ?>

	<p class="govalid-widget-footer">
		<a href="<?php echo esc_url( GoValid_QR::get_base_url() . '/dashboard/' ); ?>" target="_blank">
			<?php esc_html_e( 'View All in GoValid', 'govalid-qr' ); ?> &rarr;
		</a>
	</p>
</div>
