<?php
/**
 * Analytics page template.
 *
 * @package GoValid_QR
 */

defined( 'ABSPATH' ) || exit;

$is_connected = GoValid_QR::is_connected();
?>
<div class="wrap govalid-analytics">
	<div class="govalid-page-header">
		<img src="<?php echo esc_url( GOVALID_QR_PLUGIN_URL . 'assets/images/govalid-hero.png' ); ?>"
			 alt="GoValid" class="govalid-page-header-logo" />
		<div>
			<h1><?php esc_html_e( 'Analytics', 'govalid-qr' ); ?></h1>
			<p class="govalid-page-subtitle"><?php esc_html_e( 'Track scan activity and performance insights.', 'govalid-qr' ); ?></p>
		</div>
	</div>

	<?php if ( ! $is_connected ) : ?>
		<div class="govalid-card" style="max-width:1000px; border-left:4px solid #2563eb; background:linear-gradient(135deg, rgba(37,99,235,0.04), #fff 40%);">
			<div style="display:flex; align-items:center; gap:14px;">
				<div style="display:flex; align-items:center; justify-content:center; width:44px; height:44px; border-radius:12px; background:rgba(37,99,235,0.12); flex-shrink:0;">
					<span class="dashicons dashicons-admin-links" style="font-size:22px; width:22px; height:22px; color:#2563eb;"></span>
				</div>
				<div style="flex:1;">
					<h3 style="margin:0 0 4px; font-size:14px; color:var(--gv-gray-800);"><?php esc_html_e( 'Connect to GoValid', 'govalid-qr' ); ?></h3>
					<p style="margin:0; font-size:13px; color:var(--gv-gray-500); line-height:1.5;">
						<?php esc_html_e( 'Connect your free GoValid account to track scan activity and view analytics.', 'govalid-qr' ); ?>
					</p>
				</div>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=govalid-qr' ) ); ?>" class="button button-primary" style="display:inline-flex; align-items:center; gap:6px; white-space:nowrap;">
					<span class="dashicons dashicons-admin-network" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
					<?php esc_html_e( 'Connect Now', 'govalid-qr' ); ?>
				</a>
			</div>
		</div>
	<?php endif; ?>

	<div class="govalid-analytics-wide" id="govalid-analytics-root">

		<!-- Summary Cards -->
		<div class="govalid-analytics-summary" id="analytics-summary">
			<div class="govalid-stat-card govalid-shimmer">
				<span class="dashicons dashicons-screenoptions govalid-stat-icon"></span>
				<div class="govalid-stat-value" id="stat-qr-codes">—</div>
				<div class="govalid-stat-label"><?php esc_html_e( 'QR Codes', 'govalid-qr' ); ?></div>
			</div>
			<div class="govalid-stat-card govalid-shimmer">
				<span class="dashicons dashicons-visibility govalid-stat-icon"></span>
				<div class="govalid-stat-value" id="stat-total-scans">—</div>
				<div class="govalid-stat-label"><?php esc_html_e( 'Total Scans', 'govalid-qr' ); ?></div>
			</div>
			<div class="govalid-stat-card govalid-shimmer">
				<span class="dashicons dashicons-calendar-alt govalid-stat-icon"></span>
				<div class="govalid-stat-value" id="stat-month-scans">—</div>
				<div class="govalid-stat-label"><?php esc_html_e( 'This Month', 'govalid-qr' ); ?></div>
			</div>
			<div class="govalid-stat-card govalid-shimmer">
				<span class="dashicons dashicons-admin-site-alt3 govalid-stat-icon"></span>
				<div class="govalid-stat-value" id="stat-countries">—</div>
				<div class="govalid-stat-label"><?php esc_html_e( 'Countries', 'govalid-qr' ); ?></div>
			</div>
		</div>

		<!-- Map -->
		<div class="govalid-card govalid-analytics-map-card">
			<h2><?php esc_html_e( 'Scan Locations', 'govalid-qr' ); ?></h2>
			<div id="govalid-analytics-map"></div>
			<p class="govalid-empty-state" id="map-empty" style="display:none;">
				<?php esc_html_e( 'No location data available yet.', 'govalid-qr' ); ?>
			</p>
		</div>

		<!-- Charts Row 1: Daily Trend + Countries -->
		<div class="govalid-analytics-row">
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Daily Scan Trend', 'govalid-qr' ); ?></h2>
				<div class="govalid-chart-wrap"><canvas id="chart-daily-trend"></canvas></div>
				<p class="govalid-empty-state" id="trend-empty" style="display:none;">
					<?php esc_html_e( 'No scan data in the last 30 days.', 'govalid-qr' ); ?>
				</p>
			</div>
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Countries', 'govalid-qr' ); ?></h2>
				<div class="govalid-chart-wrap"><canvas id="chart-countries"></canvas></div>
				<p class="govalid-empty-state" id="countries-empty" style="display:none;">
					<?php esc_html_e( 'No country data available yet.', 'govalid-qr' ); ?>
				</p>
			</div>
		</div>

		<!-- Charts Row 2: Devices + QR Types -->
		<div class="govalid-analytics-row">
			<div class="govalid-card">
				<h2><?php esc_html_e( 'Devices & Browsers', 'govalid-qr' ); ?></h2>
				<div class="govalid-chart-wrap"><canvas id="chart-devices"></canvas></div>
				<p class="govalid-empty-state" id="devices-empty" style="display:none;">
					<?php esc_html_e( 'No device data available yet.', 'govalid-qr' ); ?>
				</p>
			</div>
			<div class="govalid-card">
				<h2><?php esc_html_e( 'QR Code Types', 'govalid-qr' ); ?></h2>
				<div class="govalid-chart-wrap"><canvas id="chart-qr-types"></canvas></div>
				<p class="govalid-empty-state" id="types-empty" style="display:none;">
					<?php esc_html_e( 'No QR type data available.', 'govalid-qr' ); ?>
				</p>
			</div>
		</div>

		<!-- Top QR Codes Table -->
		<div class="govalid-card">
			<h2><?php esc_html_e( 'Top QR Codes', 'govalid-qr' ); ?></h2>
			<table class="widefat striped" id="top-qr-table" style="display:none;">
				<thead>
					<tr>
						<th><?php esc_html_e( 'Name', 'govalid-qr' ); ?></th>
						<th><?php esc_html_e( 'Type', 'govalid-qr' ); ?></th>
						<th style="text-align:right;"><?php esc_html_e( 'Scans', 'govalid-qr' ); ?></th>
						<th style="text-align:center;"><?php esc_html_e( 'Drilldown', 'govalid-qr' ); ?></th>
					</tr>
				</thead>
				<tbody id="top-qr-body"></tbody>
			</table>
			<p class="govalid-empty-state" id="top-qr-empty" style="display:none;">
				<?php esc_html_e( 'No QR codes found.', 'govalid-qr' ); ?>
			</p>
		</div>

		<!-- QR Drilldown -->
		<div class="govalid-card" id="qr-drilldown-card" style="display:none;">
			<div class="govalid-drilldown-header">
				<h2 id="drilldown-title"><?php esc_html_e( 'QR Code Detail', 'govalid-qr' ); ?></h2>
				<button type="button" class="button" id="drilldown-close">&times; <?php esc_html_e( 'Close', 'govalid-qr' ); ?></button>
			</div>
			<div id="drilldown-loading" class="govalid-drilldown-loading" style="display:none;">
				<span class="spinner is-active"></span>
				<?php esc_html_e( 'Loading analytics...', 'govalid-qr' ); ?>
			</div>
			<div id="drilldown-content" style="display:none;">
				<div class="govalid-analytics-summary govalid-analytics-summary-sm">
					<div class="govalid-stat-card">
						<div class="govalid-stat-value" id="dd-total-scans">—</div>
						<div class="govalid-stat-label"><?php esc_html_e( 'Total Scans', 'govalid-qr' ); ?></div>
					</div>
					<div class="govalid-stat-card">
						<div class="govalid-stat-value" id="dd-unique-scanners">—</div>
						<div class="govalid-stat-label"><?php esc_html_e( 'Unique Scanners', 'govalid-qr' ); ?></div>
					</div>
				</div>
				<div class="govalid-analytics-row">
					<div>
						<h3><?php esc_html_e( 'Daily Scans', 'govalid-qr' ); ?></h3>
						<div class="govalid-chart-wrap govalid-chart-wrap-sm"><canvas id="dd-chart-daily"></canvas></div>
					</div>
					<div>
						<h3><?php esc_html_e( 'Geographic Distribution', 'govalid-qr' ); ?></h3>
						<div class="govalid-chart-wrap govalid-chart-wrap-sm"><canvas id="dd-chart-geo"></canvas></div>
					</div>
				</div>
			</div>
		</div>

	</div>
</div>
