{**
 * templates/settingsForm.tpl
 *
 * Copyright (c) 2025 GoValid
 * Distributed under the GNU GPL v3.
 *
 * GoValid OJS plugin settings form
 *}

<script>
	$(function() {ldelim}
		$('#govalidSettingsForm').pkpHandler('$.pkp.controllers.form.AjaxFormHandler');
	{rdelim});
</script>

<form
	class="pkp_form"
	id="govalidSettingsForm"
	method="POST"
	action="{url router=$smarty.const.ROUTE_COMPONENT op="manage" category="generic" plugin=$pluginName verb="settings" save=true}"
>
	{csrf}

	{fbvFormArea id="govalidSettings"}

		{* FAB Visibility Settings *}
		<div class="pkp_form_section" style="background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
			<h4 style="margin-top: 0; margin-bottom: 15px; color: #333;">
				<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align: middle; margin-right: 8px;"><circle cx="12" cy="12" r="3"></circle><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"></path></svg>
				Toolbar Visibility
			</h4>
			<p style="color: #666; margin-bottom: 15px; font-size: 13px;">
				Control who can see the GoValid floating toolbar (FAB) in the dashboard. The toolbar provides quick access to Certificate Designer and Email Designer.
			</p>

			<div style="background: white; padding: 15px; border-radius: 6px; border: 1px solid #e0e0e0;">
				<label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 12px;">
					<input type="checkbox" name="showFabForManagers" value="1" {if $showFabForManagers}checked{/if} style="margin-right: 10px; width: 18px; height: 18px;">
					<span style="font-weight: 500;">Journal Managers</span>
					<span style="color: #666; font-size: 12px; margin-left: 8px;">(Full administrative access)</span>
				</label>

				<label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 12px;">
					<input type="checkbox" name="showFabForEditors" value="1" {if $showFabForEditors}checked{/if} style="margin-right: 10px; width: 18px; height: 18px;">
					<span style="font-weight: 500;">Editors & Section Editors</span>
					<span style="color: #666; font-size: 12px; margin-left: 8px;">(Editorial workflow access)</span>
				</label>

				<label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 12px;">
					<input type="checkbox" name="showFabForCopyeditors" value="1" {if $showFabForCopyeditors}checked{/if} style="margin-right: 10px; width: 18px; height: 18px;">
					<span style="font-weight: 500;">Copyeditors & Layout Editors</span>
					<span style="color: #666; font-size: 12px; margin-left: 8px;">(Production stage access)</span>
				</label>

				<label style="display: flex; align-items: center; cursor: pointer;">
					<input type="checkbox" name="showFabForAssistants" value="1" {if $showFabForAssistants}checked{/if} style="margin-right: 10px; width: 18px; height: 18px;">
					<span style="font-weight: 500;">Editorial Assistants</span>
					<span style="color: #666; font-size: 12px; margin-left: 8px;">(Support staff access)</span>
				</label>
			</div>
		</div>

		{* Designer Tools *}
		<div class="pkp_form_section" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 20px; border-radius: 8px; margin-bottom: 20px; color: white;">
			<h4 style="margin-top: 0; margin-bottom: 15px; color: white;">
				<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align: middle; margin-right: 8px;"><path d="M12 19l7-7 3 3-7 7-3-3z"></path><path d="M18 13l-1.5-7.5L2 2l3.5 14.5L13 18l5-5z"></path><path d="M2 2l7.586 7.586"></path><circle cx="11" cy="11" r="2"></circle></svg>
				Designer Tools
			</h4>
			<p style="margin-bottom: 20px; opacity: 0.9; font-size: 13px;">
				Create and customize certificates and email templates for your journal.
			</p>

			<div style="display: flex; gap: 12px; flex-wrap: wrap;">
				<a href="{$designerUrl}" target="_blank"
				   style="display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.2); color: white; padding: 12px 20px; border-radius: 6px; text-decoration: none; font-weight: 500; transition: background 0.2s;">
					<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><polyline points="10 9 9 9 8 9"></polyline></svg>
					Certificate Designer
				</a>
				<a href="{$emailTemplateManagerUrl}" target="_blank"
				   style="display: inline-flex; align-items: center; gap: 8px; background: rgba(255,255,255,0.2); color: white; padding: 12px 20px; border-radius: 6px; text-decoration: none; font-weight: 500; transition: background 0.2s;">
					<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>
					Email Designer
				</a>
			</div>
		</div>

		{* Smart Verify Widget Settings *}
		<div class="pkp_form_section" style="background: #e8f5e9; padding: 20px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #a5d6a7;">
			<h4 style="margin-top: 0; margin-bottom: 15px; color: #2e7d32;">
				<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align: middle; margin-right: 8px;"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg>
				Smart Verify Widget
			</h4>
			<p style="color: #558b2f; margin-bottom: 15px; font-size: 13px;">
				Add a floating verification widget to your journal's public pages. Visitors can verify GoValid QR codes by entering the QR ID, scanning with camera, or uploading an image.
			</p>

			<div style="background: white; padding: 15px; border-radius: 6px; border: 1px solid #c8e6c9;">
				<label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 12px;">
					<input type="checkbox" name="enableSmartVerifyWidget" value="1" {if $enableSmartVerifyWidget}checked{/if} style="margin-right: 10px; width: 18px; height: 18px;">
					<span style="font-weight: 500;">Enable Smart Verify Widget</span>
					<span style="color: #666; font-size: 12px; margin-left: 8px;">(Shows floating button on public pages)</span>
				</label>

				<div style="margin-left: 28px; padding-left: 15px; border-left: 2px solid #e0e0e0;">
					<label style="display: block; margin-bottom: 8px; font-size: 13px; color: #555;">Widget Position:</label>
					<div style="display: flex; gap: 15px; flex-wrap: wrap;">
						<label style="display: flex; align-items: center; cursor: pointer;">
							<input type="radio" name="smartVerifyWidgetPosition" value="bottom-right" {if $smartVerifyWidgetPosition == 'bottom-right' || !$smartVerifyWidgetPosition}checked{/if} style="margin-right: 6px;">
							<span style="font-size: 13px;">Bottom Right</span>
						</label>
						<label style="display: flex; align-items: center; cursor: pointer;">
							<input type="radio" name="smartVerifyWidgetPosition" value="bottom-left" {if $smartVerifyWidgetPosition == 'bottom-left'}checked{/if} style="margin-right: 6px;">
							<span style="font-size: 13px;">Bottom Left</span>
						</label>
						<label style="display: flex; align-items: center; cursor: pointer;">
							<input type="radio" name="smartVerifyWidgetPosition" value="middle-right" {if $smartVerifyWidgetPosition == 'middle-right'}checked{/if} style="margin-right: 6px;">
							<span style="font-size: 13px;">Middle Right</span>
						</label>
						<label style="display: flex; align-items: center; cursor: pointer;">
							<input type="radio" name="smartVerifyWidgetPosition" value="middle-left" {if $smartVerifyWidgetPosition == 'middle-left'}checked{/if} style="margin-right: 6px;">
							<span style="font-size: 13px;">Middle Left</span>
						</label>
						<label style="display: flex; align-items: center; cursor: pointer;">
							<input type="radio" name="smartVerifyWidgetPosition" value="top-right" {if $smartVerifyWidgetPosition == 'top-right'}checked{/if} style="margin-right: 6px;">
							<span style="font-size: 13px;">Top Right</span>
						</label>
						<label style="display: flex; align-items: center; cursor: pointer;">
							<input type="radio" name="smartVerifyWidgetPosition" value="top-left" {if $smartVerifyWidgetPosition == 'top-left'}checked{/if} style="margin-right: 6px;">
							<span style="font-size: 13px;">Top Left</span>
						</label>
					</div>
				</div>
			</div>
		</div>

		{* GoValid Links & Support *}
		<div class="pkp_form_section" style="background: #fff; padding: 20px; border: 1px solid #e0e0e0; border-radius: 8px; margin-bottom: 20px;">
			<div style="display: flex; gap: 20px; align-items: flex-start; flex-wrap: wrap;">
				{* Logo on left *}
				<div style="flex-shrink: 0;">
					<a href="https://govalid.org/" target="_blank" style="display: inline-block; text-decoration: none;">
						<img src="https://my.govalid.org/static/assets/img/logo/Strip_blue.png" alt="GoValid" style="width: 160px; height: auto; transition: opacity 0.3s ease;" onmouseover="this.style.opacity='0.8'" onmouseout="this.style.opacity='1'">
					</a>
					<div style="font-size: 10px; color: #666; margin-top: 4px;">Authentication for Everyone</div>
				</div>

				{* Content on right *}
				<div style="flex: 1; min-width: 200px;">
					<h4 style="margin-top: 0; margin-bottom: 10px; color: #333; font-size: 14px;">
						GoValid Resources
					</h4>
					<p style="color: #666; margin-bottom: 12px; font-size: 12px;">
						Visit GoValid for documentation, FAQ, and support.
					</p>

					<div style="display: flex; gap: 10px; flex-wrap: wrap;">
						<a href="https://govalid.org" target="_blank"
						   style="display: inline-flex; align-items: center; gap: 6px; background: #f8f9fa; color: #333; padding: 8px 12px; border-radius: 6px; text-decoration: none; border: 1px solid #ddd; font-size: 12px;">
							<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="2" y1="12" x2="22" y2="12"></line><path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path></svg>
							Website
						</a>
						<a href="https://my.govalid.org" target="_blank"
						   style="display: inline-flex; align-items: center; gap: 6px; background: #f8f9fa; color: #333; padding: 8px 12px; border-radius: 6px; text-decoration: none; border: 1px solid #ddd; font-size: 12px;">
							<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><line x1="3" y1="9" x2="21" y2="9"></line><line x1="9" y1="21" x2="9" y2="9"></line></svg>
							Dashboard & FAQ
						</a>
						<a href="https://my.govalid.org/staff-tech/support/tickets/create/" target="_blank"
						   style="display: inline-flex; align-items: center; gap: 6px; background: #f8f9fa; color: #333; padding: 8px 12px; border-radius: 6px; text-decoration: none; border: 1px solid #ddd; font-size: 12px;">
							<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="12" y1="18" x2="12" y2="12"></line><line x1="9" y1="15" x2="15" y2="15"></line></svg>
							Support Ticket
						</a>
					</div>
				</div>
			</div>
		</div>

		{* Version Info *}
		<div style="text-align: center; padding: 10px 0; color: #999; font-size: 11px;">
			GoValidOJS v{$pluginVersion}
		</div>

	{/fbvFormArea}

	{fbvFormButtons submitText="common.save"}
</form>
