{**
 * plugins/generic/goValidOJS/templates/designer.tpl
 *
 * Copyright (c) 2025 Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * Certificate Designer Template
 *}

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GoValid Certificate Designer - OJS Plugin</title>
    <link rel="stylesheet" href="{$baseUrl}/lib/pkp/styles/fontawesome/fontawesome.css">

    {* External CSS file *}
    <link rel="stylesheet" href="{$baseUrl}/plugins/generic/goValidOJS/css/designer.css?v=20251211SWAP">

    <style>
        /* Modern button hover effects */
        .cert-format-option {
            display: flex;
            align-items: center;
            cursor: pointer;
            padding: 8px 16px;
            border: 2px solid #ddd;
            border-radius: 8px;
            transition: all 0.2s;
            background: #fff;
        }

        .cert-format-option:hover {
            border-color: #059669;
            background: #f0fdf4;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(5, 150, 105, 0.15);
        }

        .cert-format-option input[type="radio"]:checked + i + span,
        .cert-format-option:has(input[type="radio"]:checked) {
            border-color: #059669;
            background: #f0fdf4;
        }

        .cert-cancel-btn {
            padding: 10px 24px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            background: #fff;
            color: #424242;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
            font-size: 14px;
        }

        .cert-cancel-btn:hover {
            border-color: #9e9e9e;
            background: #f5f5f5;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .cert-send-btn {
            padding: 10px 24px;
            border: none;
            border-radius: 8px;
            background: linear-gradient(135deg, #059669 0%, #047857 100%);
            color: #fff;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            box-shadow: 0 2px 8px rgba(5, 150, 105, 0.3);
            font-size: 14px;
        }

        .cert-send-btn:hover {
            background: linear-gradient(135deg, #047857 0%, #065f46 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(5, 150, 105, 0.4);
        }

        .cert-send-btn:disabled {
            background: #9e9e9e;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }

        /* Email preview - reset contenteditable styling to match actual email rendering */
        #certEmailBody {
            line-height: normal;
            letter-spacing: normal;
            word-spacing: normal;
        }

        /* Ensure nested elements in email preview maintain their styling */
        #certEmailBody * {
            box-sizing: border-box;
        }

        /* Remove any default margins/padding that might be inherited */
        #certEmailBody > div {
            margin: 0;
        }
    </style>
</head>
<body>
    <div class="designer-container">
        {* Security overlay when not authenticated *}
        <div id="authOverlay" style="display: none; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 9998; align-items: center; justify-content: center;">
            <div style="background: white; padding: 40px; border-radius: 16px; text-align: center; max-width: 400px;">
                <i class="fa fa-lock" style="font-size: 48px; color: #667eea; margin-bottom: 20px;"></i>
                <h3 style="margin: 0 0 10px 0; color: #333;">Authentication Required</h3>
                <p style="color: #666; margin-bottom: 20px;">Please log in to use the certificate designer</p>
                <button onclick="showLoginModal()" style="background: #667eea; color: white; border: none; padding: 12px 24px; border-radius: 8px; cursor: pointer; font-size: 16px;">
                    <i class="fa fa-sign-in"></i> Login to Continue
                </button>
            </div>
        </div>
        
        <div class="designer-header" id="designerTopHeader">
            <div class="header-left" id="designerGoValidSection">
                <a href="https://govalid.org/" target="_blank" style="display: inline-block; text-decoration: none;">
                    <img src="https://my.govalid.org/static/assets/img/logo/Strip_blue.png" alt="GoValid" style="width: 220px; height: 80px; object-fit: contain; transition: opacity 0.3s ease;" onmouseover="this.style.opacity='0.8'" onmouseout="this.style.opacity='1'">
                </a>
                <p style="margin: 5px 0 0 0; font-size: 13px; color: #667eea; font-weight: 500; font-style: italic;">Authentication for Everyone</p>
            </div>
            <div class="header-right" id="designerJournalSection">
                <div style="text-align: right;" id="designerJournalInfo">
                    <div id="journalLogo" style="margin-bottom: 8px;"></div>
                    <div id="journalName" style="font-size: 16px; font-weight: 600; color: #333;"></div>
                </div>
            </div>
        </div>

        <div class="designer-toolbar" style="position: relative;">
            <div style="display: flex; flex-wrap: wrap; gap: 20px; align-items: center; flex: 1; padding-right: 240px;">
                <div class="toolbar-section">
                    <label>Orientation:</label>
                    <div class="orientation-selector">
                        <input type="radio" id="portrait" name="orientation" value="portrait">
                        <label for="portrait">📄 Portrait</label>
                        <input type="radio" id="landscape" name="orientation" value="landscape" checked>
                        <label for="landscape">📃 Landscape</label>
                    </div>
                </div>

                <div class="toolbar-section">
                    <label for="bgColor">Background:</label>
                    <input type="color" id="bgColor" value="#ffffff" title="Background Color" style="width: 32px; height: 32px; border: 2px solid rgba(255,255,255,0.5); border-radius: 50%; cursor: pointer;">
                    <button type="button" id="addBgImage" class="secondary"><i class="fa fa-picture-o"></i> Background Image</button>
                    <select id="bgImageMode" style="padding: 8px; border: 1px solid #ddd; border-radius: 6px; background: rgba(255,255,255,0.9); margin-left: 8px; display: none;">
                        <option value="fit">Fit (maintain ratio)</option>
                        <option value="fill">Fill (stretch to paper)</option>
                        <option value="cover">Cover (fill paper, may crop)</option>
                        <option value="tile">Tile (repeat pattern)</option>
                        <option value="top">Top (fit width)</option>
                        <option value="bottom">Bottom (fit width)</option>
                        <option value="center">Center (cover paper)</option>
                        <option value="left">Left (fit height)</option>
                        <option value="right">Right (fit height)</option>
                    </select>
                    <button type="button" id="removeBgImage" class="secondary" style="margin-left: 8px; display: none;"><i class="fa fa-times"></i> Remove</button>
                </div>

                <div class="toolbar-section">
                    <button type="button" id="addText"><i class="fa fa-font"></i> Add Text</button>
                    <button type="button" id="addImage"><i class="fa fa-image"></i> Add Image</button>
                    <select id="addShapeDropdown" style="padding: 8px 12px; border: 1px solid #ddd; border-radius: 6px; background: rgba(255,255,255,0.9); cursor: pointer; font-size: 14px; min-width: 150px; color: #667eea;">
                        <option value="" style="color: #667eea;">▸ Add Shape...</option>
                        <option value="rectangle" style="color: #333;">▭ Rectangle</option>
                        <option value="square" style="color: #333;">■ Square</option>
                        <option value="circle" style="color: #333;">○ Circle</option>
                        <option value="ellipse" style="color: #333;">● Ellipse</option>
                        <option value="triangle" style="color: #333;">▲ Triangle</option>
                        <option value="line" style="color: #333;">─ Line</option>
                    </select>
                </div>

                {* Template controls *}
                <div class="toolbar-section" style="border-left: 1px solid rgba(255,255,255,0.3); padding-left: 12px;">
                    <input type="text" id="templateNameToolbar" placeholder="Template name..." style="padding: 8px 12px; border: 1px solid rgba(255,255,255,0.3); border-radius: 6px; background: rgba(255,255,255,0.9); font-size: 13px; width: 140px;">
                    <button type="button" id="saveTemplateToolbar" title="Save Template" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; border: none; padding: 8px 12px; border-radius: 6px; cursor: pointer; font-size: 14px; transition: all 0.2s;">
                        <i class="fa fa-save"></i>
                    </button>
                    <button type="button" id="loadTemplateToolbar" title="Load Template" style="background: rgba(255,255,255,0.9); color: #333; border: 1px solid rgba(255,255,255,0.3); padding: 8px 12px; border-radius: 6px; cursor: pointer; font-size: 14px; transition: all 0.2s;">
                        <i class="fa fa-folder-open"></i>
                    </button>
                    <button type="button" id="templateGalleryBtnToolbar" title="Template Gallery" style="background: rgba(255,255,255,0.9); color: #333; border: 1px solid rgba(255,255,255,0.3); padding: 8px 12px; border-radius: 6px; cursor: pointer; font-size: 14px; transition: all 0.2s;">
                        <i class="fa fa-th"></i> Gallery
                    </button>
                </div>

                <div class="toolbar-section">
                    <button type="button" id="downloadJPG" class="generate-btn" onclick="testDownloadJPG()" style="background: #10b981;"><i class="fa fa-download"></i> Download</button>
                    <button type="button" id="sendCertificateEmail" class="generate-btn" style="background: #059669; margin-left: 8px;"><i class="fa fa-envelope"></i> Send Email</button>
                    <a href="{$baseUrl}/index.php/{$contextPath}/govalidojs/emailTemplateDesigner" target="_blank" title="Open Email Template Designer" style="display: inline-flex; align-items: center; justify-content: center; width: 38px; height: 38px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 50%; margin-left: 8px; text-decoration: none; box-shadow: 0 2px 8px rgba(16, 185, 129, 0.3); transition: all 0.2s;" onmouseover="this.style.transform='scale(1.1)'; this.style.boxShadow='0 4px 12px rgba(16, 185, 129, 0.4)';" onmouseout="this.style.transform='scale(1)'; this.style.boxShadow='0 2px 8px rgba(16, 185, 129, 0.3)';">
                        <i class="fa fa-paint-brush" style="color: white; font-size: 16px;"></i>
                    </a>
                </div>
            </div>

            {* Account Section - Absolute Right Side - Three Row Layout *}
            <div style="position: absolute; right: 20px; top: 50%; transform: translateY(-50%);">
                <!-- User Info Section (shown when logged in) -->
                <div id="userInfoSection" style="display: none;">
                    <div style="display: flex; flex-direction: column; gap: 12px; min-width: 200px; align-items: flex-end;">
                        <!-- Row 1: Photo (larger size, right aligned with padding) -->
                        <div style="display: flex; align-items: center; justify-content: flex-end; padding-right: 8px;">
                            <div id="userAvatarWrapper" style="position: relative; width: 56px; height: 56px;">
                                <div id="userAvatarContainer" style="width: 56px; height: 56px; border-radius: 50%; overflow: hidden; background: rgba(255,255,255,0.2); display: flex; align-items: center; justify-content: center; border: 2px solid white; box-shadow: 0 2px 8px rgba(0,0,0,0.2);">
                                    <i class="fa fa-user-circle" id="userAvatarIcon" style="font-size: 56px; color: white;"></i>
                                    <img id="userAvatarImage" src="" alt="Profile" style="width: 100%; height: 100%; object-fit: cover; display: none;">
                                </div>
                                <!-- Badge overlay -->
                                <div id="userBadgeOverlay" style="display: none; position: absolute; bottom: -2px; right: -2px; width: 17px; height: 17px; border-radius: 50%; background-color: #fff; background-size: 16px 16px; background-position: center; background-repeat: no-repeat;" title=""></div>
                            </div>
                        </div>

                        <!-- Row 2: Subscription Info -->
                        <div id="subscriptionRow" style="background: rgba(255,255,255,0.15); border-radius: 4px; padding: 8px 10px; display: none; width: 100%;">
                            <span style="color: white; font-size: 11px; font-weight: 500;">
                                <i class="fa fa-star" style="color: #ffd700;"></i>
                                <span id="subscriptionInfo">Loading...</span>
                            </span>
                        </div>

                        <!-- Row 3: Quota + Refresh -->
                        <div id="quotaRow" style="display: none; width: 100%;">
                            <div style="display: flex; align-items: center; justify-content: space-between; background: rgba(255,255,255,0.15); border-radius: 4px; padding: 8px 10px;">
                                <span id="quotaInfo" style="color: white; font-size: 11px; font-weight: 500;"></span>
                                <button type="button" id="refreshQuota" class="secondary" style="padding: 4px 8px; font-size: 10px; background: rgba(255,255,255,0.2); border: none; color: white; border-radius: 4px; cursor: pointer;">
                                    <i class="fa fa-refresh"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Row 4: Logout Button (moved below subscription) -->
                        <button type="button" id="logoutBtn" onclick="performLogout()" style="background: rgba(239, 68, 68, 0.9); color: white; border: none; padding: 8px 14px; border-radius: 6px; cursor: pointer; font-size: 11px; font-weight: 500; transition: all 0.2s; display: flex; align-items: center; gap: 4px; width: 100%; justify-content: center;">
                            <i class="fa fa-sign-out"></i>
                            <span>Logout</span>
                        </button>
                    </div>
                </div>

                <!-- Login Status (shown when not logged in) -->
                <div id="govalidAuthStatus" class="govalid-auth-status" style="cursor: pointer;" onclick="showLoginModal()">
                    <i class="fa fa-user-circle" style="color: white;"></i>
                    <span id="authStatusText" style="color: white; font-size: 12px;">Login to use GoValid</span>
                </div>
            </div>
        </div>

        <div class="designer-content">
            <div class="canvas-area">
                {* Canvas Controls - Modern horizontal toolbar at the top of grey area *}
                <div class="canvas-controls-bar">
                    {* Zoom controls - Icon only *}
                    <button type="button" id="zoomOut" class="canvas-control-btn icon-only" title="Zoom Out">
                        <i class="fa fa-search-minus"></i>
                    </button>
                    <span id="zoomLevel" class="zoom-level-display">100%</span>
                    <button type="button" id="zoomIn" class="canvas-control-btn icon-only" title="Zoom In">
                        <i class="fa fa-search-plus"></i>
                    </button>
                    <button type="button" id="zoomFit" class="canvas-control-btn icon-only" title="Fit to Screen">
                        <i class="fa fa-expand"></i>
                    </button>

                    <div class="canvas-controls-divider"></div>

                    {* Undo/Redo/Copy/Paste/Delete controls *}
                    <button type="button" id="undoBtn2" onclick="undo()" class="canvas-control-btn icon-only" title="Undo (Ctrl+Z)">
                        <i class="fa fa-undo"></i>
                    </button>
                    <button type="button" id="redoBtn2" onclick="redo()" class="canvas-control-btn icon-only" title="Redo (Ctrl+Y)">
                        <i class="fa fa-repeat"></i>
                    </button>
                    <button type="button" id="copyBtn2" onclick="copyObject()" class="canvas-control-btn icon-only" title="Copy (Ctrl+C)">
                        <i class="fa fa-copy"></i>
                    </button>
                    <button type="button" id="pasteBtn2" onclick="pasteObject()" class="canvas-control-btn icon-only" title="Paste (Ctrl+V)">
                        <i class="fa fa-paste"></i>
                    </button>
                    <button type="button" id="deleteBtn2" onclick="deleteSelectedObject()" class="canvas-control-btn icon-only danger" title="Delete (Del)">
                        <i class="fa fa-trash"></i>
                    </button>

                    <div class="canvas-controls-divider"></div>

                    <button type="button" id="clearCanvas" class="canvas-control-btn danger" title="Clear All">
                        <i class="fa fa-trash"></i>
                        <span>Clear All</span>
                    </button>
                </div>

                <div class="canvas-wrapper">
                    <canvas id="certificateCanvas"></canvas>
                </div>
            </div>
            
            <div class="properties-panel">
                {* Tab Navigation *}
                <div class="panel-tabs">
                    <button type="button" class="tab-btn active" data-tab="content"><span class="step-number">1</span> Content</button>
                    <button type="button" class="tab-btn" data-tab="qr-settings"><span class="step-number">2</span> QR Content</button>
                    <button type="button" class="tab-btn" data-tab="properties"><span class="step-number">3</span> Properties</button>
                </div>
                
                <div class="tab-contents-wrapper">
                    {* Properties Tab *}
                    <div class="tab-content" id="properties-tab" style="padding-top: 0;">
                    <div class="tab-content-inner">
                    <div class="properties-container">
                        <div class="properties-header">
                            <h5>Object Properties</h5>
                            <button type="button" id="toggleProperties" class="toggle-btn" title="Collapse/Expand Properties">
                                <i class="fa fa-chevron-down"></i>
                            </button>
                        </div>
                        <div id="objectProperties" class="properties-content collapsed">
                            <p>Select an object to edit properties</p>
                        </div>
                    </div>
                    
                    <div id="saveStatus" class="save-status"></div>
                    
                    <div class="field-placeholders">
                        <h5>Drag Fields to Canvas:</h5>
                        
                        <div class="fields-grid">
                            <div class="draggable-field" draggable="true" data-field="{literal}{REVIEWER_NAME}{/literal}" data-label="Reviewer Name">
                                Reviewer Name
                            </div>
                            <div class="draggable-field" draggable="true" data-field="{literal}{AUTHOR_NAME}{/literal}" data-label="Author Name">
                                Author Name
                            </div>
                            <div class="draggable-field" draggable="true" data-field="{literal}{EDITOR_NAME}{/literal}" data-label="Editor Name">
                                Editor Name
                            </div>
                            <div class="draggable-field" draggable="true" data-field="{literal}{JOURNAL_NAME}{/literal}" data-label="Journal Name">
                                Journal Name
                            </div>
                            <div class="draggable-field" draggable="true" data-field="{literal}{JOURNAL_LOGO}{/literal}" data-label="Journal Logo" data-type="image">
                                <i class="fa fa-image" style="margin-right: 5px;"></i> Journal Logo
                            </div>
                            <div class="draggable-field" draggable="true" data-field="{literal}{ARTICLE_TITLE}{/literal}" data-label="Article Title">
                                Article Title
                            </div>
                            <div class="draggable-field" draggable="true" data-field="{literal}{REVIEW_DATE}{/literal}" data-label="Review Date">
                                Review Date
                            </div>
                            <div class="draggable-field" draggable="true" data-field="{literal}{ARTICLE_DOI}{/literal}" data-label="Article DOI">
                                Article DOI
                            </div>
                            <div class="draggable-field" draggable="true" data-field="{literal}{SUBMISSION_ID}{/literal}" data-label="Submission ID">
                                Submission ID
                            </div>
                            <div class="draggable-field" draggable="true" data-field="{literal}{ISSUE_TITLE}{/literal}" data-label="Issue Title">
                                Issue Title
                            </div>
                            <div class="compact-field-group">
                                <div class="draggable-field" draggable="true" data-field="{literal}{ISSUE_VOLUME}{/literal}" data-label="Issue Volume">
                                    Volume
                                </div>
                                <div class="draggable-field" draggable="true" data-field="{literal}{ISSUE_NUMBER}{/literal}" data-label="Issue Number">
                                    Number
                                </div>
                                <div class="draggable-field" draggable="true" data-field="{literal}{ISSUE_YEAR}{/literal}" data-label="Issue Year">
                                    Year
                                </div>
                            </div>
                            <div class="compact-field-group" style="grid-template-columns: 1fr 1fr;">
                                <div class="draggable-field" draggable="true" data-field="{literal}{ISSN_ONLINE}{/literal}" data-label="ISSN Online">
                                    <i class="fa fa-globe" style="margin-right: 5px;"></i> ISSN Online
                                </div>
                                <div class="draggable-field" draggable="true" data-field="{literal}{ISSN_PRINT}{/literal}" data-label="ISSN Print">
                                    <i class="fa fa-print" style="margin-right: 5px;"></i> ISSN Print
                                </div>
                            </div>

                            <!-- QR Code Data - Compact 2x2 Grid -->
                            <div style="margin-top: 10px; display: grid; grid-template-columns: 1fr 1fr; gap: 6px; width: 100%; grid-column: span 2;">
                                <div class="draggable-field special" draggable="true" data-field="{literal}{QR_ID}{/literal}" data-label="QR ID" style="background: #fffbea;">
                                    <i class="fa fa-id-badge"></i> QR ID
                                </div>
                                <div class="draggable-field special" draggable="true" data-field="{literal}{QR_IDENTIFIER}{/literal}" data-label="QR Identifier" style="background: #fffbea;">
                                    <i class="fa fa-barcode"></i> Identifier
                                </div>
                                <div class="draggable-field special" draggable="true" data-field="{literal}{QR_ISSUE_DATE}{/literal}" data-label="QR Issue Date" style="background: #fffbea;">
                                    <i class="fa fa-calendar-check"></i> Issue Date
                                </div>
                                <div class="draggable-field special" draggable="true" data-field="{literal}{QR_EXPIRE_DATE}{/literal}" data-label="QR Expire Date" style="background: #fffbea;">
                                    <i class="fa fa-calendar-times"></i> Expire Date
                                </div>
                            </div>
                        </div>
                    </div>

                    <div style="margin-top: 15px; padding-bottom: 20px; border-bottom: 1px solid #ddd;">
                        <button type="button" class="content-btn primary" id="refreshCanvas" title="Load content data to canvas" style="width: 100%; justify-content: center;">
                            <i class="fa fa-refresh"></i> Refresh/Load to Canvas
                        </button>
                    </div>

                    <div class="layer-controls-container" style="margin-top: 20px;">
                        <div class="layer-controls-header">
                            <h5><i class="fa fa-layers"></i> Layer Order</h5>
                            <button type="button" id="toggleLayers" class="toggle-btn" title="Collapse/Expand Layers">
                                <i class="fa fa-chevron-up"></i>
                            </button>
                        </div>
                        <div id="layerControlsContent" class="layer-controls-content expanded">
                            <div class="layer-list-container">
                                <div class="layer-help-text">
                                    <p>Drag items to reorder layers</p>
                                </div>
                                <div id="layerList" class="layer-list">
                                    <p class="empty-layer-message">No objects on canvas</p>
                                    <!-- Layer items will be added here dynamically -->
                                </div>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>

                {* QR Content Tab *}
                <div class="tab-content" id="qr-settings-tab" style="padding: 0;">
                    <div class="tab-content-inner">
                    <h4>QR Content</h4>
                    <div class="content-form">
                        <p style="font-size: 12px; color: #666; margin-bottom: 15px;">
                            This information will be displayed on the verification page when someone scans the QR code.
                        </p>
                        <div class="qr-field">
                            <label for="qr_security_level">Security Level</label>
                            <select id="qr_security_level" class="qr-input" style="width: calc(100% - 10px);">
                                <option value="SMART" selected>Smart (Ultra-Compact)</option>
                                <option value="SECURE">Secure (Balance)</option>
                                <option value="ENTERPRISE">Enterprise (PIN Required)</option>
                            </select>
                        </div>
                        
                        <div class="qr-field">
                            <label for="qr_name">QR Name</label>
                            <input type="text" id="qr_name" class="qr-input" placeholder="Reviewer Vol2No1 or LoA ..." style="width: calc(100% - 10px);">
                        </div>
                        
                        <div class="qr-field full-width" style="display: none;">
                            <label for="qr_generated_by">Generated By</label>
                            <select id="qr_generated_by" class="qr-input" disabled style="background: #f5f5f5; cursor: not-allowed; width: calc(100% - 10px);">
                                <option value="">Login to see options</option>
                            </select>
                        </div>
                        
                        <div class="qr-field full-width identifier-field-container">
                            <label for="qr_identifier_code">Identifier Code</label>

                            {* Format Selection Dropdown *}
                            <div class="identifier-format-row" style="margin-bottom: 8px;">
                                <select id="identifier_format_select" class="qr-input" style="width: calc(100% - 10px);">
                                    <option value="alpha5">5-digit Alphanumeric (A1B2C)</option>
                                    <option value="numeric6">6-digit Numeric (123456)</option>
                                    <option value="invoice">Invoice Format (INV-YYMMDD-XXX)</option>
                                    <option value="serial">Serial Number (SN-XXXXX-XXX)</option>
                                    <option value="dateseq">Date Sequential (DDMMYY-XXX)</option>
                                    <option value="cert" selected>Certificate (CERT-YYYYMMDD-XXX)</option>
                                    <option value="institution_pattern">Institution Numbering Pattern</option>
                                    <option value="custom">Custom Pattern...</option>
                                </select>
                            </div>

                            {* Custom Pattern Input (shows only when custom selected) *}
                            <div id="custom_pattern_container" style="display: none; margin-bottom: 8px;">
                                <input type="text" id="custom_pattern_input" class="qr-input" placeholder="Example: CERT-#SEQ#-??" style="width: calc(100% - 10px);">
                                <div style="display: flex; gap: 8px; margin-top: 6px; align-items: center;">
                                    <label style="font-size: 11px; color: #666; white-space: nowrap;">Start #:</label>
                                    <input type="number" id="custom_sequence_start" class="qr-input" min="1" max="999" value="1" style="width: 70px; padding: 4px 8px;">
                                    <label style="font-size: 11px; display: flex; align-items: center; gap: 4px; cursor: pointer;">
                                        <input type="checkbox" id="remember_sequence" checked style="width: 14px; height: 14px;">
                                        <span style="color: #666;">Remember</span>
                                    </label>
                                </div>
                            </div>

                            {* Institution Pattern Section (shows only when institution pattern selected) *}
                            <div id="identifier_pattern_section" style="display: none; margin-bottom: 8px; padding: 10px; background: #f0f9ff; border-radius: 4px; border: 1px solid #bae6fd;">
                                <label style="font-size: 11px; font-weight: 600; margin-bottom: 4px; display: block; color: #0369a1;">
                                    <i class="fa fa-building"></i> Select Institution Pattern:
                                </label>
                                <select id="pattern_selector" class="qr-input" style="margin-bottom: 8px; width: 100%;">
                                    <option value="">Select a numbering pattern...</option>
                                </select>
                                <div id="pattern_info" style="font-size: 11px; color: #666; margin-bottom: 8px; padding: 8px; background: white; border-radius: 3px;"></div>
                            </div>

                            {* Main Identifier Input with Generate Button *}
                            <div style="display: flex; gap: 4px; margin-bottom: 6px; align-items: center;">
                                <input type="text" id="qr_identifier_code" class="qr-input" placeholder="Click Generate or enter manually" style="flex: 1;">
                                <button type="button" id="generate_identifier_btn" style="padding: 8px 10px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border: none; color: white; border-radius: 6px; cursor: pointer;" title="Generate Identifier">
                                    <i class="fa fa-magic"></i>
                                </button>
                            </div>

                            {* Preview Section *}
                            <div id="identifier_preview" style="background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 6px; padding: 10px; margin-bottom: 8px;">
                                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 6px;">
                                    <span style="font-size: 11px; color: #64748b;">Preview:</span>
                                    <span id="preview_format_label" style="font-size: 10px; color: #059669; background: #ecfdf5; padding: 2px 8px; border-radius: 10px;">Certificate</span>
                                </div>
                                <div id="preview_content" style="font-family: monospace; font-size: 13px; color: #1e293b; word-break: break-all;"></div>
                                <div id="preview_sequence_info" style="font-size: 10px; color: #059669; margin-top: 4px; display: none;">
                                    <i class="fa fa-sort-numeric-asc"></i> <span id="sequence_info_text"></span>
                                </div>
                            </div>

                            {* Custom Pattern Help (shows only when custom selected) *}
                            <div id="custom_pattern_help" style="display: none; background: #fffbeb; border: 1px solid #fcd34d; border-radius: 6px; padding: 10px; margin-bottom: 8px;">
                                <div style="font-size: 11px; font-weight: 600; color: #92400e; margin-bottom: 6px;">
                                    <i class="fa fa-lightbulb-o"></i> Pattern Placeholders:
                                </div>
                                <div style="font-size: 10px; color: #78350f; line-height: 1.6;">
                                    <code style="background: #fef3c7; padding: 1px 4px; border-radius: 2px;">#</code> = Random digit (0-9)<br>
                                    <code style="background: #fef3c7; padding: 1px 4px; border-radius: 2px;">?</code> = Random letter (A-Z)<br>
                                    <code style="background: #fef3c7; padding: 1px 4px; border-radius: 2px;">*</code> = Random alphanumeric<br>
                                    <code style="background: #fef3c7; padding: 1px 4px; border-radius: 2px;">#SEQ#</code> = Sequential number (001, 002...)
                                </div>
                                <div style="font-size: 10px; color: #92400e; margin-top: 6px;">
                                    <strong>Examples:</strong><br>
                                    <code>CERT-#SEQ#</code> → CERT-001, CERT-002<br>
                                    <code>DOC-??-####</code> → DOC-AB-1234
                                </div>
                            </div>

                            <small style="display: block; color: #94a3b8; font-size: 10px; font-style: italic;">
                                If blank, will use auto-generated unique identifier
                            </small>
                        </div>
                        
                        <div class="qr-field full-width">
                            <label for="qr_awarded_to">Awarded To</label>
                            <div style="display: flex; gap: 5px; margin-bottom: 5px;">
                                <select id="qr_name_selector" class="qr-input" style="width: 110px;" onchange="selectAwardedName()">
                                    <option value="">Select...</option>
                                    <option value="reviewer" selected>Reviewer</option>
                                    <option value="author">Author</option>
                                    <option value="editor">Editor</option>
                                </select>
                                <input type="text" id="qr_awarded_to" class="qr-input" placeholder="{literal}{REVIEWER_NAME}{/literal}" value="{literal}{REVIEWER_NAME}{/literal}" style="width: calc(100% - 120px);">
                            </div>
                            <div style="margin-top: 3px; display: flex; align-items: center; gap: 4px;">
                                <input type="checkbox" id="qr_mask_name" style="width: 16px; height: 16px; margin: 0;">
                                <label for="qr_mask_name" style="font-weight: normal; font-size: 12px; margin: 0; cursor: pointer;">Mask Name <span style="color: #999;">(And********)</span></label>
                            </div>
                        </div>
                        
                        <div class="qr-field full-width">
                            <label for="qr_purpose">
                                Purpose
                                <label class="toggle-switch" style="float: right; margin-right: 10px;">
                                    <input type="checkbox" id="qr_purpose_toggle">
                                    <span class="toggle-slider"></span>
                                </label>
                            </label>
                            <input type="text" id="qr_purpose" class="qr-input" placeholder="Peer Review Recognition" style="width: calc(100% - 10px);">
                        </div>

                        <div class="qr-field full-width">
                            <label for="qr_description">
                                Description
                                <label class="toggle-switch" style="float: right; margin-right: 10px;">
                                    <input type="checkbox" id="qr_description_toggle">
                                    <span class="toggle-slider"></span>
                                </label>
                            </label>
                            <textarea id="qr_description" class="qr-input" rows="3" placeholder="Certificate details and description" style="min-height: 60px; width: calc(100% - 10px);"></textarea>
                        </div>
                        
                        <!-- Issue Date and Expire Date in One Row -->
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-bottom: 6px;">
                            <div class="qr-field" style="margin-bottom: 0;">
                                <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 4px;">
                                    <label for="qr_start_date" style="margin: 0; font-size: 11px;">
                                        <i class="fa fa-calendar-check"></i> Issue Date
                                    </label>
                                    <label class="toggle-switch" style="margin: 0;">
                                        <input type="checkbox" id="qr_start_date_toggle" checked>
                                        <span class="toggle-slider"></span>
                                    </label>
                                </div>
                                <input type="date" id="qr_start_date" class="qr-input" style="width: 100%; font-size: 11px; margin-top: 5px; margin-bottom: 0;">
                            </div>
                            <div class="qr-field" style="margin-bottom: 0;">
                                <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 4px;">
                                    <label for="qr_end_date" style="margin: 0; font-size: 11px;">
                                        <i class="fa fa-calendar-times"></i> Expire Date
                                    </label>
                                    <label class="toggle-switch" style="margin: 0;">
                                        <input type="checkbox" id="qr_end_date_toggle" checked>
                                        <span class="toggle-slider"></span>
                                    </label>
                                </div>
                                <input type="date" id="qr_end_date" class="qr-input" style="width: 100%; font-size: 11px; margin-top: 5px; margin-bottom: 0;">
                            </div>
                        </div>
                        
                        <div class="qr-field full-width" style="margin-bottom: 8px; margin-top: 0;">
                            <label for="qr_password_protection" style="margin-bottom: 2px;">
                                Password Protection
                                <label class="toggle-switch" style="float: right; margin-right: 10px;">
                                    <input type="checkbox" id="qr_password_protection_toggle">
                                    <span class="toggle-slider"></span>
                                </label>
                            </label>
                            <div id="password_options" style="display: none; margin-top: 2px;">
                                <select id="qr_password_type" class="qr-input" style="margin-bottom: 4px; width: calc(100% - 10px);">
                                    <option value="master">Master Password</option>
                                    <option value="unique">Unique Password</option>
                                </select>
                                <input type="password" id="qr_password" class="qr-input" placeholder="Enter password (only for unique)" style="display: none; width: calc(100% - 10px);">
                            </div>
                        </div>

                        <!-- Anti-Counterfeit Tags Field -->
                        <div class="qr-field full-width">
                            <label for="qr_anti_counterfeit_tags">
                                Anti-Counterfeit Tags
                                <label class="toggle-switch" style="float: right; margin-right: 10px;">
                                    <input type="checkbox" id="qr_anti_counterfeit_toggle">
                                    <span class="toggle-slider"></span>
                                </label>
                            </label>
                            <div id="antiCounterfeitSection" style="display: none;">
                                <input type="text" id="qr_anti_counterfeit_tags" class="qr-input" placeholder="e.g., luxury, batch-2024, premium" style="width: calc(100% - 10px); margin-bottom: 8px;">
                                <div id="existingAntiCounterfeitTagsContainer" style="display: none; margin-bottom: 8px;">
                                    <small style="color: #6c757d; display: block; margin-bottom: 5px;">Click to add:</small>
                                    <div id="existingAntiCounterfeitTagsList" style="display: flex; flex-wrap: wrap; gap: 4px;"></div>
                                </div>
                                <small style="color: #666; font-size: 11px; display: block;">Comma-separated tags for anti-counterfeit tracking</small>
                            </div>
                        </div>

                        <div class="qr-field full-width">
                            <label for="qr_signed_by">
                                Signed By
                                <label class="toggle-switch" style="float: right; margin-right: 10px;">
                                    <input type="checkbox" id="qr_signed_by_toggle">
                                    <span class="toggle-slider"></span>
                                </label>
                            </label>
                            <div id="signedBySection" style="display: none;">
                                <input type="text" id="qr_signed_by" class="qr-input" readonly style="background: #f5f5f5; cursor: not-allowed; margin-bottom: 8px; width: calc(100% - 10px);" placeholder="Login to see your name">
                                <small style="color: #666; font-size: 11px; display: block; margin-bottom: 6px;">Automatically set to your account name</small>

                                <!-- PIN Verification Section -->
                                <div id="pinSection">
                                    <!-- PIN Not Set Warning -->
                                    <div id="pinNotSet" style="display: none; text-align: center; padding: 10px 0;">
                                        <p style="margin-bottom: 10px; color: #e67e22; font-size: 12px;">
                                            <i class="fa fa-exclamation-triangle"></i> You need to set up a signing PIN before you can sign documents.
                                        </p>
                                        <a href="https://my.govalid.org/account/security/" target="_blank" style="background: #667eea; color: white; border: none; padding: 8px 16px; border-radius: 6px; font-size: 12px; cursor: pointer; text-decoration: none; display: inline-block;">
                                            <i class="fa fa-lock"></i> Set Up PIN
                                        </a>
                                    </div>

                                    <!-- PIN Input Section -->
                                    <div id="pinInputSection" style="display: none;">
                                        <div style="border: 2px solid #667eea; border-radius: 8px; padding: 10px; background: linear-gradient(135deg, #f0f0ff 0%, #e8e8ff 100%); width: 100%; box-sizing: border-box;">
                                            <h6 style="margin: 0 0 8px 0; color: #1f2937; font-size: 13px; font-weight: 600;"><i class="fa fa-key"></i> Enter Signing PIN</h6>
                                            <p style="margin: 0 0 8px 0; font-size: 11px; color: #666;">Enter your 6-digit signing PIN to verify:</p>
                                            <div style="display: flex; justify-content: center; gap: 4px; margin-bottom: 8px; width: 100%; box-sizing: border-box;" id="pin-inputs">
                                                <input type="password" class="pin-input" maxlength="1" id="pin-1" style="width: 30px; height: 40px; font-size: 16px; font-weight: bold; text-align: center; border: 2px solid #667eea; border-radius: 6px; padding: 0; margin: 0;">
                                                <input type="password" class="pin-input" maxlength="1" id="pin-2" style="width: 30px; height: 40px; font-size: 16px; font-weight: bold; text-align: center; border: 2px solid #667eea; border-radius: 6px; padding: 0; margin: 0;">
                                                <input type="password" class="pin-input" maxlength="1" id="pin-3" style="width: 30px; height: 40px; font-size: 16px; font-weight: bold; text-align: center; border: 2px solid #667eea; border-radius: 6px; padding: 0; margin: 0;">
                                                <input type="password" class="pin-input" maxlength="1" id="pin-4" style="width: 30px; height: 40px; font-size: 16px; font-weight: bold; text-align: center; border: 2px solid #667eea; border-radius: 6px; padding: 0; margin: 0;">
                                                <input type="password" class="pin-input" maxlength="1" id="pin-5" style="width: 30px; height: 40px; font-size: 16px; font-weight: bold; text-align: center; border: 2px solid #667eea; border-radius: 6px; padding: 0; margin: 0;">
                                                <input type="password" class="pin-input" maxlength="1" id="pin-6" style="width: 30px; height: 40px; font-size: 16px; font-weight: bold; text-align: center; border: 2px solid #667eea; border-radius: 6px; padding: 0; margin: 0;">
                                            </div>
                                            <button type="button" id="verifyPinBtn" style="background: #667eea; color: white; border: none; padding: 10px 16px; border-radius: 6px; font-size: 13px; cursor: pointer; width: 100%; box-sizing: border-box; font-weight: 500;">
                                                <i class="fa fa-check"></i> Verify PIN
                                            </button>
                                            <div id="pinVerifyStatus" style="margin-top: 4px; font-size: 11px; width: 100%; box-sizing: border-box;"></div>
                                            <p style="margin: 8px 0 0 0; font-size: 10px; color: #666; text-align: center;">
                                                <a href="https://my.govalid.org/account/security/" target="_blank" style="color: #667eea;">Forgot PIN? Reset in account settings</a>
                                            </p>
                                        </div>
                                    </div>

                                    <!-- PIN Locked Warning -->
                                    <div id="pinLocked" style="display: none; text-align: center; padding: 10px 0;">
                                        <p style="margin-bottom: 10px; color: #dc3545; font-size: 12px;">
                                            <i class="fa fa-lock"></i> Your PIN is temporarily locked due to too many failed attempts.
                                        </p>
                                        <a href="https://my.govalid.org/account/security/" target="_blank" style="color: #667eea; font-size: 11px;">Reset PIN in account settings</a>
                                    </div>

                                    <!-- Success Message -->
                                    <div id="pinSuccess" style="display: none; max-width: 100%; box-sizing: border-box; padding: 0;">
                                        <div style="background: #d1fae5; border: 1px solid #10b981; border-radius: 4px; padding: 8px; margin: 0; color: #065f46; font-size: 11px; width: 100%; box-sizing: border-box;">
                                            <i class="fa fa-check-circle"></i> PIN verified successfully
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="qr-actions">
                            <button type="button" class="qr-btn primary" id="saveQRSettings" style="width: calc(100% - 10px);"><i class="fa fa-qrcode"></i> Generate QR</button>
                        </div>

                        {* QR Preview Section *}
                        <div id="qrPreviewSection" style="display: none; margin-top: 20px; text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px; border: 1px solid #dee2e6;">
                            <h6 style="margin: 0 0 15px 0; font-size: 14px; color: #555; font-weight: 600;">
                                <i class="fa fa-qrcode" style="margin-right: 5px;"></i>Generated QR Code
                            </h6>
                            <img id="qrPreviewImage" src="" alt="QR Code" style="max-width: 200px; border: 2px solid #ddd; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                            <div style="margin-top: 15px; display: flex; gap: 10px; justify-content: center;">
                                <button type="button" id="downloadQRBtn" class="qr-btn secondary" style="padding: 8px 16px; font-size: 13px;" title="Download QR Code">
                                    <i class="fa fa-download"></i> Download
                                </button>
                                <button type="button" id="verifyQRBtn" class="qr-btn primary" style="padding: 8px 16px; font-size: 13px;" title="Open Verification Link">
                                    <i class="fa fa-external-link"></i> Verify
                                </button>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
                
                {* Content Tab *}
                <div class="tab-content active" id="content-tab" style="padding: 0;">
                    <div class="tab-content-inner">
                    <h4>Certificate Content</h4>
                    <div class="content-form">
                        <div class="content-field" style="display: none;">
                            <label for="content_journal_name">Journal Name</label>
                            <input type="text" id="content_journal_name" class="content-input" value="{$journalInfo.name|escape}" readonly style="background: #f8f9fa; width: calc(100% - 10px);">
                        </div>

                        <div class="content-field">
                            <label for="submission_id_search">Search by Submission ID</label>
                            <div style="display: flex; gap: 5px; align-items: stretch;">
                                <input type="number" id="submission_id_search" class="content-input" placeholder="Enter ID" style="width: 120px; flex: none; padding: 5px 10px; margin: 0;">
                                <button type="button" id="search_submission_btn" style="padding: 0 10px; background: #667eea; border: 1px solid #667eea; border-radius: 6px; cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 4px; color: #fff; white-space: nowrap; flex-shrink: 0; font-size: 13px; box-sizing: border-box; margin: 0;">
                                    <i class="fa fa-search"></i> Search
                                </button>
                            </div>
                            <small style="color: #666; font-size: 11px;">Find any submission (including unpublished) by its ID</small>
                        </div>

                        <div class="content-field">
                            <label for="content_issue_select">Select Issue</label>
                            <select id="content_issue_select" class="content-input">
                                <option value="">-- Select an Issue --</option>
                            </select>
                        </div>
                        
                        <div class="volume-number-year-row" style="display: none;">
                            <div class="content-field">
                                <label for="content_issue_title">Issue Title</label>
                                <input type="text" id="content_issue_title" class="content-input" readonly style="background: #f8f9fa; width: 120px;">
                            </div>
                            <div class="content-field">
                                <label for="content_issue_volume">Vol</label>
                                <input type="text" id="content_issue_volume" class="content-input" style="width: 50px;" readonly>
                            </div>
                            <div class="content-field">
                                <label for="content_issue_number">No</label>
                                <input type="text" id="content_issue_number" class="content-input" style="width: 50px;" readonly>
                            </div>
                            <div class="content-field">
                                <label for="content_issue_year">Year</label>
                                <input type="text" id="content_issue_year" class="content-input" style="width: 65px;" readonly>
                            </div>
                        </div>
                        
                        <div class="content-field">
                            <label for="content_article_select">Select Article</label>
                            <select id="content_article_select" class="content-input">
                                <option value="">-- Select an Article --</option>
                            </select>
                        </div>
                        
                        <div class="content-field" style="display: none;">
                            <label for="content_article_title">Article Title</label>
                            <input type="text" id="content_article_title" class="content-input" readonly style="background: #f8f9fa; width: calc(100% - 10px);">
                        </div>
                        
                        <div class="volume-number-year-row">
                            <div class="content-field" style="flex: 1;">
                                <label for="content_article_doi">Article DOI</label>
                                <input type="text" id="content_article_doi" class="content-input" readonly style="background: #f8f9fa; width: 100%;">
                            </div>
                            <div class="content-field" style="flex: 0 0 100px;">
                                <label for="content_submission_id">ID</label>
                                <input type="text" id="content_submission_id" class="content-input" readonly style="background: #f8f9fa; width: 100%;">
                            </div>
                        </div>

                        <hr style="margin: 20px 0; border: none; border-top: 2px solid #e2e8f0;">

                        <div class="content-field">
                            <label for="content_reviewer_name">Reviewer Name <span style="color: #999; font-size: 11px;">(Select article first)</span></label>
                            <select id="content_reviewer_name" class="content-input" disabled>
                                <option value="">-- Select article first --</option>
                            </select>
                        </div>

                        <div class="content-field">
                            <label for="content_author_name">Author Name <span style="color: #999; font-size: 11px;">(Select article first)</span></label>
                            <select id="content_author_name" class="content-input" disabled>
                                <option value="">-- Select article first --</option>
                            </select>
                        </div>

                        <div class="content-field">
                            <label for="content_editor_name">Editor Name <span style="color: #999; font-size: 11px;">(Select article first)</span></label>
                            <select id="content_editor_name" class="content-input" disabled>
                                <option value="">-- Select article first --</option>
                            </select>
                        </div>

                        <div class="content-actions">
                            <button type="button" class="content-btn primary" id="continueToQR" onclick="switchToTab('qr-settings')">
                                <i class="fa fa-arrow-right"></i> Continue
                            </button>
                        </div>
                        
                        <div id="contentStatus" style="margin-top: 15px; display: none;">
                            <p style="color: #666; font-size: 12px;"></p>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Preview Modal -->
    <div id="previewModal" class="preview-modal">
        <div class="preview-modal-content" style="max-width: 800px; max-height: 90vh; overflow-y: auto;">
            <div class="preview-modal-header">
                <h3>Certificate Preview</h3>
                <span class="preview-close">&times;</span>
            </div>
            
            <!-- Preview Setup Section -->
            <div id="previewSetup" style="padding: 20px; text-align: center;">
                <p style="color: #666; margin-bottom: 20px;">
                    This will generate a preview of your certificate using the actual data from your selections.
                </p>
                
                <div class="preview-info" style="background: #f8f9fa; border-radius: 8px; padding: 15px; margin-bottom: 20px; text-align: left;">
                    <h4 style="margin: 0 0 10px 0; font-size: 14px; color: #333;">Preview will use:</h4>
                    <ul style="margin: 0; padding-left: 20px; font-size: 12px; color: #666;">
                        <li><strong>Journal:</strong> {$journalInfo.name|escape}</li>
                        <li><strong>Issue:</strong> <span id="previewIssueInfo">Selected issue data</span></li>
                        <li><strong>Article:</strong> <span id="previewArticleInfo">Selected article data</span></li>
                        <li><strong>Reviewer:</strong> <span id="previewReviewerInfo">Name from certificate field</span></li>
                        <li><strong>Date:</strong> Today's date</li>
                    </ul>
                </div>
                
                <div class="preview-warning" style="background: #fef5e7; border: 1px solid #fcdc94; border-radius: 8px; padding: 10px; margin-bottom: 20px; text-align: left; font-size: 12px;">
                    <i class="fa fa-info-circle" style="color: #f39c12;"></i>
                    <strong>Note:</strong> Make sure you have selected an issue and article in the Content tab before generating preview.
                </div>
                
                <div class="preview-actions">
                    <button type="button" class="preview-btn primary" id="generatePreview">
                        <i class="fa fa-file-pdf-o"></i> Generate Preview
                    </button>
                    <button type="button" class="preview-btn secondary" id="closePreview">Cancel</button>
                </div>
                
                <div id="previewStatus" style="margin-top: 20px; display: none;">
                    <p style="color: #666;"><i class="fa fa-spinner fa-spin"></i> Generating preview...</p>
                </div>
            </div>
            
            <!-- Preview Display Section -->
            <div id="previewDisplay" style="display: none; padding: 20px;">
                <div style="text-align: center; margin-bottom: 15px;">
                    <h4 style="margin: 0; color: #333;">Certificate Preview</h4>
                    <p style="margin: 5px 0; color: #666; font-size: 12px;">This is how your certificate will look</p>
                </div>
                
                <div id="previewContainer" style="border: 1px solid #ddd; border-radius: 8px; background: #f9f9f9; text-align: center; min-height: 400px; display: flex; align-items: center; justify-content: center;">
                    <iframe id="previewFrame" style="width: 100%; height: 500px; border: none; background: white;" title="Certificate Preview"></iframe>
                </div>
                
                <div style="text-align: center; margin-top: 15px;">
                    <button type="button" class="preview-btn primary" id="downloadPreview" style="margin-right: 10px;">
                        <i class="fa fa-download"></i> Download PDF
                    </button>
                    <button type="button" class="preview-btn secondary" id="backToSetup">
                        <i class="fa fa-arrow-left"></i> Back to Setup
                    </button>
                </div>
            </div>
        </div>
    </div>

    {* GoValid Login Modal - Mobile Design Match *}
    <div id="govalidLoginModal" class="modal" style="display: none !important;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" onclick="hideLoginModal(); return false;">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="login-logo">
                        <img src="https://my.govalid.org/static/assets/img/logo/Strip_blue.png" alt="GoValid">
                    </div>
                    <p class="login-tagline">Authentication for Everyone</p>
                    
                    <h2 class="welcome-text">Welcome Back</h2>
                    <p class="welcome-subtitle">Sign in to your GoValid account</p>
                    
                    <form id="govalidLoginForm">
                        <div class="form-group">
                            <label for="govalid_username">Username or Email</label>
                            <div class="input-group">
                                <i class="fa fa-user input-icon"></i>
                                <input type="text" class="form-control" id="govalid_username" name="username" required placeholder="Enter your username or email">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="govalid_password">Password</label>
                            <div class="input-group">
                                <i class="fa fa-lock input-icon"></i>
                                <input type="password" class="form-control" id="govalid_password" name="password" required placeholder="Enter your password">
                                <button type="button" class="password-toggle" id="togglePassword">
                                    <i class="fa fa-eye"></i>
                                </button>
                            </div>
                        </div>
                        
                        <div class="form-options">
                            <div class="remember-me">
                                <input type="checkbox" id="govalid_remember" name="remember">
                                <label for="govalid_remember">Remember me</label>
                            </div>
                            <div class="forgot-password">
                                <a href="#" onclick="alert('Please visit https://my.govalid.org to reset your password')">Forgot Password?</a>
                            </div>
                        </div>
                        
                        <div class="alert alert-danger" id="loginError" style="display: none;"></div>

                        <!-- 2FA Verification Section -->
                        <div id="twoFASection" style="display: none; margin-bottom: 15px;">
                            <div style="background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 8px; padding: 15px;">
                                <h5 style="margin: 0 0 10px 0; font-size: 14px; color: #495057;">
                                    <i class="fa fa-shield"></i> 2FA Verification Required
                                </h5>
                                <p style="margin: 0 0 15px 0; font-size: 13px; color: #6c757d;">
                                    Enter the 6-digit code from your authenticator app
                                </p>
                                <div style="display: flex; gap: 5px; justify-content: center; margin-bottom: 10px;" id="twofa-inputs">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="0" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="1" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="2" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="3" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="4" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="5" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                </div>
                                <div id="twoFAError" style="color: #dc3545; font-size: 12px; text-align: center; display: none; margin-top: 5px;"></div>
                                <button type="button" class="btn btn-primary" id="verify2FABtn" onclick="verify2FA()" style="width: 100%; margin-top: 10px;">
                                    <span id="verify2FAText">Verify Code</span>
                                    <i class="fa fa-spinner fa-spin" id="verify2FASpinner" style="display: none;"></i>
                                </button>
                                <button type="button" class="btn btn-link" onclick="cancel2FA()" style="width: 100%; margin-top: 5px; font-size: 12px;">
                                    Back to Login
                                </button>
                            </div>
                        </div>

                        <!-- Email OTP Verification Section (Risk-Based Authentication) -->
                        <div id="emailOTPSection" style="display: none; margin-bottom: 15px;">
                            <div style="background: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; padding: 15px;">
                                <h5 style="margin: 0 0 10px 0; font-size: 14px; color: #856404;">
                                    <i class="fa fa-exclamation-triangle"></i> Security Verification Required
                                </h5>
                                <p id="emailOTPMessage" style="margin: 0 0 15px 0; font-size: 13px; color: #856404;">
                                    Please check your email for the verification code.
                                </p>
                                <div style="display: flex; gap: 5px; justify-content: center; margin-bottom: 10px;" id="email-otp-inputs">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="0" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="1" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="2" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="3" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="4" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="5" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                </div>
                                <div id="emailOTPError" style="color: #dc3545; font-size: 12px; text-align: center; display: none; margin-top: 5px;"></div>
                                <button type="button" class="btn btn-warning" id="verifyEmailOTPBtn" onclick="verifyEmailOTP()" style="width: 100%; margin-top: 10px;">
                                    <span id="verifyEmailOTPText">Verify Code</span>
                                    <i class="fa fa-spinner fa-spin" id="verifyEmailOTPSpinner" style="display: none;"></i>
                                </button>
                                <button type="button" class="btn btn-link" onclick="cancelEmailOTP()" style="width: 100%; margin-top: 5px; font-size: 12px;">
                                    Back to Login
                                </button>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary" id="loginSubmitBtn">
                            <span class="login-text">Sign In</span>
                            <i class="fa fa-spinner login-spinner"></i>
                        </button>
                        
                        <div class="divider">
                            <span>OR</span>
                        </div>
                        
                        <a href="https://my.govalid.org/register" target="_blank" class="btn btn-outline btn-register">
                            <i class="fa fa-user-plus"></i>
                            Create New Account
                        </a>
                    </form>
                    
                    <div class="footer-links">
                        <p>By signing in, you agree to our <a href="https://my.govalid.org/terms" target="_blank">Terms of Service</a> and <a href="https://my.govalid.org/privacy" target="_blank">Privacy Policy</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {* Template Gallery Modal *}
    <div id="templateGalleryModal" class="preview-modal" style="display: none;">
        <div class="preview-modal-content" style="max-width: 1200px; max-height: 90vh; overflow-y: auto;">
            <div class="preview-modal-header">
                <h3><i class="fa fa-th"></i> Template Gallery</h3>
                <span class="preview-close" onclick="closeTemplateGallery()">&times;</span>
            </div>

            <div class="gallery-tabs" style="display: flex; gap: 10px; margin-bottom: 20px; border-bottom: 2px solid #e3e8ee; padding-bottom: 10px;">
                <button type="button" class="gallery-tab-btn active" data-tab="default" onclick="switchGalleryTab('default')" style="padding: 10px 20px; background: #667eea; color: white; border: none; border-radius: 6px; cursor: pointer; font-weight: 500; transition: all 0.3s;">
                    <i class="fa fa-star"></i> Default Templates
                </button>
                <button type="button" class="gallery-tab-btn" data-tab="my" onclick="switchGalleryTab('my')" style="padding: 10px 20px; background: #e3e8ee; color: #555; border: none; border-radius: 6px; cursor: pointer; font-weight: 500; transition: all 0.3s;">
                    <i class="fa fa-user"></i> My Templates
                </button>
            </div>

            <div class="gallery-content">
                {* Default Templates Grid *}
                <div id="defaultTemplatesGrid" class="template-grid" style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; padding: 20px;"></div>

                {* My Templates List *}
                <div id="myTemplatesList" class="template-list" style="display: none; padding: 20px;"></div>
            </div>
        </div>
    </div>


    {* Load Fabric.js library *}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fabric.js/5.3.0/fabric.min.js"></script>

    {* Pass PHP variables to JavaScript *}
    <script>
        // Plugin AJAX URL for API calls
        window.pluginAjaxUrl = '{$baseUrl}/index.php/{$contextPath}/govalidojs/designer';

        // Journal information
        {if $journalInfo}
        console.log('DEBUG: journalInfo from Smarty:', {$journalInfo|@json_encode nofilter});
        window.goValidJournalInfo = {
            name: '{$journalInfo.name|escape:'javascript'}',
            logo: {if $journalInfo.logo}'{$journalInfo.logo|escape:'javascript'}'{else}null{/if},
            onlineIssn: '{$journalInfo.onlineIssn|escape:'javascript'}',
            printIssn: '{$journalInfo.printIssn|escape:'javascript'}'
        };
        console.log('Journal Info from PHP:', window.goValidJournalInfo);
        console.log('Logo value from PHP: "{$journalInfo.logo|escape:'javascript'}"');
        console.log('ISSN Online: "{$journalInfo.onlineIssn|escape:'javascript'}"');
        console.log('ISSN Print: "{$journalInfo.printIssn|escape:'javascript'}"');
        {else}
        window.goValidJournalInfo = {
            name: 'Open Journal Systems',
            logo: null,
            onlineIssn: '',
            printIssn: ''
        };
        console.log('Journal Info (no data from PHP):', window.goValidJournalInfo);
        {/if}

        // Existing template data if available
        {if $existingTemplate}
        window.goValidExistingTemplate = {$existingTemplate|json_encode};
        {/if}
    </script>

    {* Send Certificate Email Modal *}
    <div id="sendCertificateEmailModal" class="etd-modal" style="display: none;">
        <div class="etd-modal-overlay"></div>
        <div class="etd-modal-content" style="max-width: 750px;">
            <div class="etd-modal-header">
                <h3>Send Certificate via Email</h3>
                <button type="button" class="etd-modal-close" onclick="closeSendCertificateEmailModal()">&times;</button>
            </div>
            <div class="etd-modal-body">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 12px;">
                    <div class="etd-form-group">
                        <label for="certEmailTemplate">Email Template *</label>
                        <select id="certEmailTemplate" class="etd-input" required>
                            <option value="">Loading templates...</option>
                        </select>
                    </div>

                    <div class="etd-form-group">
                        <label for="certToEmail">To (Email Address) *</label>
                        <div class="etd-input-wrapper">
                            <input type="email" id="certToEmail" class="etd-input etd-autocomplete-input" placeholder="Enter recipient email address" required autocomplete="off" />
                            <div id="certToEmailAutocomplete" class="etd-autocomplete-dropdown"></div>
                        </div>
                        <div id="emailSuggestions" style="display: none; margin-top: 8px; flex-wrap: wrap; gap: 8px;"></div>
                    </div>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 12px;">
                    <div class="etd-form-group">
                        <label for="certCcEmail">CC (Carbon Copy)</label>
                        <div class="etd-input-wrapper">
                            <input type="text" id="certCcEmail" class="etd-input etd-autocomplete-input" placeholder="Enter CC emails (comma-separated)" autocomplete="off" />
                            <div id="certCcEmailAutocomplete" class="etd-autocomplete-dropdown"></div>
                        </div>
                    </div>

                    <div class="etd-form-group">
                        <label for="certBccEmail">BCC (Blind Carbon Copy)</label>
                        <div class="etd-input-wrapper">
                            <input type="text" id="certBccEmail" class="etd-input etd-autocomplete-input" placeholder="Enter BCC emails (comma-separated)" autocomplete="off" />
                            <div id="certBccEmailAutocomplete" class="etd-autocomplete-dropdown"></div>
                        </div>
                    </div>
                </div>

                <div class="etd-form-group">
                    <label for="certEmailSubject">
                        Email Subject *
                        <span style="font-size: 11px; color: #666; font-weight: normal; margin-left: 8px;">(Click to edit)</span>
                    </label>
                    <input type="text" id="certEmailSubject" class="etd-input" placeholder="Select a template to load content..." style="padding: 10px;" />
                </div>

                <div class="etd-form-group">
                    <label for="certEmailBody">
                        Email Body *
                        <span style="font-size: 11px; color: #666; font-weight: normal; margin-left: 8px;">(Click to edit text directly)</span>
                    </label>
                    <div id="certEmailBody" class="cert-editable-preview" contenteditable="true" spellcheck="true" style="padding: 0; border: 1px solid #ddd; border-radius: 4px; min-height: 300px; max-height: 450px; overflow-y: auto; background: #f5f5f5; outline: none;">
                        Select a template to load content...
                    </div>
                </div>

                <div class="etd-form-group">
                    <div style="padding: 8px 12px; background: #e3f2fd; border: 1px solid #2196f3; border-radius: 4px; font-size: 12px; color: #1565c0;">
                        <i class="fa fa-image"></i> <strong>Certificate Attachment:</strong> Certificate will be <em>automatically</em> attached as JPG image (max 5MB)
                    </div>
                </div>

                <div class="etd-form-group">
                    <label for="certAttachmentInput">Additional Attachments (Optional)</label>
                    <div class="etd-file-upload-wrapper">
                        <input type="file" id="certAttachmentInput" class="etd-file-input" accept=".pdf,.jpg,.jpeg,.png,.gif" multiple style="display: none;" onchange="handleCertAttachmentSelection(event)" />
                        <button type="button" class="etd-btn etd-btn-secondary" onclick="document.getElementById('certAttachmentInput').click()">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="vertical-align: middle; margin-right: 5px;">
                                <path d="M21.44 11.05l-9.19 9.19a6 6 0 0 1-8.49-8.49l9.19-9.19a4 4 0 0 1 5.66 5.66l-9.2 9.19a2 2 0 0 1-2.83-2.83l8.49-8.48"></path>
                            </svg>
                            Choose Files
                        </button>
                        <span id="certAttachmentFileCount" style="margin-left: 10px; color: #718096; font-size: 13px;">No files selected</span>
                    </div>
                    <div id="certAttachmentsList" style="margin-top: 8px;"></div>
                    <small style="color: #718096; font-size: 12px;">Max 5MB per file. Allowed: PDF, JPG, PNG, GIF</small>
                    <div id="certAttachmentError" style="display: none; margin-top: 6px; padding: 8px; background: #fee; border: 1px solid #fcc; border-radius: 4px; color: #c00; font-size: 12px;"></div>
                </div>

                <div class="etd-form-group" style="margin-bottom: 0;">
                    <div style="display: flex; gap: 12px; justify-content: flex-end;">
                        <button type="button" class="cert-cancel-btn" onclick="closeSendCertificateEmailModal()">
                            <i class="fa fa-times" style="margin-right: 6px;"></i>Cancel
                        </button>
                        <button type="button" class="cert-send-btn" id="modalSendCertificateBtn" onclick="submitSendCertificateEmail()">
                            <i class="fa fa-paper-plane" style="margin-right: 6px;"></i>Send Email
                        </button>
                    </div>
                </div>

                <div id="certModalAuthWarning" style="display: none; margin-top: 12px; padding: 12px; background: #fff3cd; border: 1px solid #ffc107; border-radius: 6px; color: #856404; font-size: 13px;"></div>
            </div>
        </div>
    </div>

    {* External JavaScript files - Load in dependency order *}
    <script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-core.js?v=20251215CREDIT"></script>
    <script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-auth.js?v=20251216BADGE2"></script>
    <script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-canvas.js?v=20251211LOGO2"></script>
    <script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-shapes.js?v=20251104AJ"></script>
    <script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-ui.js?v=20251216AWARDED"></script>
    <script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-content.js?v=20260102SEARCH"></script>
    <script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-gallery.js?v=20251211LOGO2"></script>
    <script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-email.js?v=20251215CREDIT"></script>
    <script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-init.js?v=20251211LOGO3"></script>
</body>
</html>
