# GoValid OJS Plugin - Information

## Plugin Information

**Plugin Name**: GoValid OJS
**Version**: 5.11.0
**Release Date**: November 5, 2025
**Type**: Generic Plugin
**Author**: Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia
**License**: GNU GPL v3

## System Requirements

### Compatible OJS Version
- **OJS Version**: 3.4.0.4 (tested and verified)
- **OJS Type**: ojs2

### Server Requirements
- **PHP Version**: 8.3.6 or higher
- **Web Server**: Apache 2.4.58 or higher (Ubuntu)
- **Database**: MySQL 8.0.43 or higher
- **Operating System**: Linux (Ubuntu) - Kernel 6.8.0-85-generic
- **Required PHP Extensions**:
  - GD (for image processing)
  - JSON
  - MySQL/MySQLi
  - cURL
  - mbstring

### Browser Requirements
- Modern browsers with JavaScript enabled
- HTML5 Canvas support
- Support for:
  - Fabric.js (canvas manipulation)
  - Base64 encoding/decoding
  - Blob API
  - FormData API

## Features

### Certificate Designer
- **Visual Canvas Editor**: Drag-and-drop interface for designing certificates
- **High Resolution Export**: 3x resolution multiplier (300 DPI quality)
- **Flexible Layouts**: Support for both Portrait and Landscape orientations
- **Template System**: Save and load custom certificate templates
- **Background Support**: Upload and manage background images

### Design Elements
- **Text Fields**: Dynamic text fields with center alignment by default
  - Reviewer Name
  - Author Name
  - Editor Name
  - Article Title
  - Journal Name
  - Submission ID
  - Review Date
  - Issue information
  - And many more...
- **Journal Logo**: Auto-scaled to 150px width with aspect ratio preservation
- **QR Codes**: Support for QR code generation and placement
- **Shapes**: Basic shapes (rectangle, circle, line)
- **Custom Images**: Upload and place custom images

### Email Integration
- **Direct Email Sending**: Send certificates directly via email
- **Email Templates**: Customizable email templates
- **Multi-recipient Support**: To, CC, and BCC fields
- **Attachment Management**: Attach certificates as JPG (up to 5MB)
- **Additional Attachments**: Support for multiple file attachments (total 10MB max)

### Export Options
- **JPG Export**: High-quality JPEG download (3x resolution)
- **Direct Download**: One-click download functionality
- **Email Delivery**: Send certificates via email with attachments

### Authentication & Security
- **GoValid Integration**: Integrated with GoValid authentication system
- **Login Protection**: Requires login for:
  - Saving templates
  - Loading templates
  - Downloading certificates
  - Sending emails
- **Subscription Verification**: Checks user subscription status before operations
- **Template Limits**: Maximum 5 templates per user (configurable)

### User Interface
- **Icon-only Buttons**: Clean, minimal interface for Save/Load/Download buttons
- **Confirmation Dialogs**:
  - Save confirmation with template details
  - Overwrite warning for existing templates
- **Live Preview**: Real-time canvas preview (no separate preview button needed)
- **Responsive Design**: Works on various screen sizes

## Installation

1. Extract the plugin to: `/path/to/ojs/plugins/generic/goValidOJS`
2. Clear OJS cache: `php tools/runScheduledTasks.php`
3. Login to OJS as Administrator
4. Navigate to: Settings > Website > Plugins
5. Find "GoValid OJS Plugin" and click "Enable"

## Configuration

### Initial Setup
1. Enable the plugin in OJS settings
2. Configure journal logo in Journal Settings
3. Set up GoValid authentication credentials
4. Configure SMTP settings for email functionality

### Template Management
- Maximum 5 templates per user
- Templates are saved to database
- Templates include canvas data, orientation, and timestamp

### Email Settings
- Configure sender email in Journal Settings
- Set up SMTP server for email delivery
- File size limits:
  - Certificate: 5MB max
  - Total attachments: 10MB max

## Usage

### Creating a Certificate
1. Login to GoValid
2. Navigate to the Certificate Designer
3. Design your certificate using the canvas tools
4. Save as a template (optional)
5. Download or send via email

### Designer Interface
**Main Toolbar**:
- **Download**: Export certificate as high-quality JPG
- **Send Email**: Send certificate via email to recipients

**Canvas Controls**:
- **Save** (icon): Save current design as template
- **Load** (icon): Load saved template
- **Gallery**: Browse template gallery
- **Clear All**: Clear entire canvas

**Properties Panel**:
- Drag and drop fields onto canvas
- Configure text properties (font, size, color, alignment)
- Manage background images
- Add shapes and elements

### Keyboard Shortcuts
- **Delete**: Remove selected object
- **Ctrl+C**: Copy selected object
- **Ctrl+V**: Paste copied object
- **Ctrl+Z**: Undo (browser native)

## Technical Specifications

### Canvas Specifications
- **Default DPI**: 96 DPI (screen display)
- **Export DPI**: 300 DPI (3x multiplier)
- **A4 Dimensions**:
  - Landscape: 1123px × 794px (screen) / 3369px × 2382px (export)
  - Portrait: 794px × 1123px (screen) / 2382px × 3369px (export)

### File Format Support
- **Export**: JPEG (high quality, 92% initial quality)
- **Backgrounds**: PNG, JPG, GIF
- **Attachments**: PDF, PNG, JPG, GIF

### Performance
- **Maximum Template Size**: Limited by browser memory
- **Export Time**: ~2-5 seconds for 3x resolution
- **File Size Optimization**: Automatic quality reduction if file exceeds 5MB

## Recent Updates (Version 5.11.0)

### Major Improvements
1. **Fixed Email Attachment Corruption**: Switched from base64 string to Blob upload method
2. **Increased Resolution**: Export resolution increased to 3x (300 DPI)
3. **Journal Logo Enhancement**: Auto-scaled to 150px width with aspect ratio
4. **Text Alignment**: All text fields now center-aligned by default
5. **UI Simplification**:
   - Removed Preview button (live preview on canvas)
   - Removed Generate Certificate button
   - Made Save/Load/Download buttons icon-only
6. **Enhanced Confirmations**: Added save confirmations and overwrite warnings
7. **Authentication**: Added GoValid login checks to all main actions
8. **Bug Fixes**: Fixed Preview button error after removal

### Technical Improvements
- Blob-based file upload for better binary data handling
- Improved canvas export with resolution multiplier
- Enhanced error handling and user feedback
- Optimized JavaScript module loading

## Troubleshooting

### Common Issues

**Issue**: Certificate attachment corrupted in email
**Solution**: Ensure you're using version 5.11.0 or higher with Blob upload fix

**Issue**: Login button not updating after login
**Solution**: Check browser console for errors, clear cache, reload page

**Issue**: "Preview button error" in console
**Solution**: Update to version 5.11.0 which fixes this issue

**Issue**: Template save fails
**Solution**: Ensure GoValid login is active and subscription is valid

### Cache Issues
If changes don't appear, clear OJS cache:
```bash
/var/www/ojs-dev/FIX_CACHE.sh
```

Or manually:
```bash
rm -rf /path/to/ojs/cache/*
sudo systemctl restart apache2
```

## Support

For issues, questions, or feature requests:
- **Institution**: University Of Muhammadiyah Makassar, Indonesia
- **Contact**: System Administrator
- **Documentation**: See plugin files and inline comments

## Changelog

### Version 5.11.0 (2025-11-05)
- Fixed: Email attachment corruption (Blob method)
- Enhanced: Export resolution to 3x (300 DPI)
- Added: Journal logo auto-sizing (150px width)
- Added: Center alignment default for all text fields
- Removed: Preview button (live preview on canvas)
- Removed: Generate Certificate button
- Changed: Save/Load/Download buttons to icon-only
- Added: Save confirmation dialogs
- Added: GoValid login requirement for all actions
- Fixed: Preview button error in console

### Version 1.0.0 (2025-07-10)
- Initial release
- Basic certificate designer
- Template management
- Email integration
- GoValid authentication

## License

Copyright (c) 2025 Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

## Credits

- **Development**: Naufal Naufal
- **Institution**: University Of Muhammadiyah Makassar, Indonesia
- **Framework**: Open Journal Systems (OJS) 3.4
- **Libraries Used**:
  - Fabric.js (Canvas manipulation)
  - QRCode.js (QR code generation)
  - Laravel Mail (Email functionality)
  - Font Awesome (Icons)

---

**Last Updated**: November 5, 2025
**Plugin Version**: 5.11.0
**OJS Compatibility**: 3.4.0.4
