# GoValid OJS Plugin - Changelog

## Version 1.3.5.1-ojs35 (2025-12-17)

### OJS 3.5.x Compatibility Release

This version is specifically built for **OJS 3.5.x** with **PHP 8.5.x** support.

### Features
- Certificate Designer with QR code integration
- Email Designer with visual template editor
- GoValid authentication integration
- Smart Verify Widget for article verification
- Email template management with OJS integration
- Certificate email sending with attachments
- Anti-counterfeit tag generation

### OJS 3.5 Specific Implementations

#### Handler System
- Uses fully namespaced classes
- Modern PSR-4 autoloading
- Handler class with OJS 3.5 patterns

#### Email Templates
- Uses `PKP\mail\Mailable` system
- Laravel-based email infrastructure
- Modern template rendering with Blade-style templates

#### File Management
- `PublicFileManager` with modern API
- Context-aware file path handling

#### Context/Journal
- Uses `$context->getLocalizedData('setting')` for localized settings
- Modern context handling with type hints

#### Plugin Settings
- `$plugin->getSetting($contextId, 'settingName')`
- `$plugin->updateSetting($contextId, 'settingName', $value)`

### PHP Compatibility Notes
- Requires PHP 8.5.x
- Uses typed properties and return types
- Uses constructor property promotion
- Uses named arguments where beneficial
- Uses match expressions
- Uses null-safe operator (?->)

### Requirements
- OJS 3.5.x
- PHP 8.5.x
- MySQL 8.0+ or PostgreSQL 13+

### Installation
1. Download and extract to `plugins/generic/goValidOJS/`
2. Enable plugin in Website Settings > Plugins
3. Configure GoValid API credentials in plugin settings

### Migration from OJS 3.3
If upgrading from OJS 3.3:
1. Backup your existing plugin settings
2. Remove old plugin directory
3. Install this OJS 3.5 version
4. Re-configure plugin settings
5. Test all functionality
