{**
 * plugins/generic/goValidOJS/templates/emailTemplateDesigner.tpl
 *
 * Copyright (c) 2025 Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * Enhanced Email Template Designer with Visual Controls
 *}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Template Designer - {$journalName|escape}</title>
    <link rel="stylesheet" href="{$baseUrl}/lib/pkp/styles/fontawesome/fontawesome.css">
</head>
<body style="margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">

<div id="emailTemplateDesigner" class="etd-container">
    {* Top Header with GoValid and Journal Logos *}
    <div class="etd-top-header" id="etdTopHeader">
        <div class="etd-top-header-left" id="etdGoValidSection">
            {* GoValid Logo *}
            <div style="text-align: left;">
                <a href="https://govalid.org/" target="_blank" style="display: inline-block; text-decoration: none;">
                    <img src="https://my.govalid.org/static/assets/img/logo/Strip_blue.png" alt="GoValid" style="width: 200px; height: 70px; object-fit: contain; transition: opacity 0.3s ease;" onmouseover="this.style.opacity='0.8'" onmouseout="this.style.opacity='1'">
                </a>
                <p style="margin: 5px 0 0 0; font-size: 12px; color: #667eea; font-weight: 500; font-style: italic;">Authentication for Everyone</p>
            </div>
        </div>
        <div class="etd-top-header-right" id="etdJournalSection">
            {* Journal Info *}
            <div style="display: flex; align-items: center; gap: 20px;">
                <div style="text-align: right;" id="etdJournalName">
                    <div style="font-size: 18px; font-weight: 600; color: #333; line-height: 1.4;">{$journalName|escape}</div>
                </div>
                {if $journalLogoUrl}
                <div id="etdJournalLogo">
                    <img src="{$journalLogoUrl|escape}" alt="{$journalName|escape}" style="max-height: 100px; max-width: 280px; object-fit: contain;">
                </div>
                {/if}
            </div>
        </div>
    </div>
    <!-- Header Bar -->
    <div class="etd-header">
        <div class="etd-header-left">
            <h1 class="etd-title">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <rect x="2" y="5" width="20" height="14" rx="2"></rect>
                    <polyline points="2,10 12,15 22,10"></polyline>
                </svg>
                Email Template Designer
            </h1>

            <a href="{url op="emailTemplateManager"}" class="etd-btn etd-btn-ghost">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="19" y1="12" x2="5" y2="12"></line>
                    <polyline points="12 19 5 12 12 5"></polyline>
                </svg>
                Back
            </a>
        </div>
        <div class="etd-header-right">
            {* GoValid User Account Section *}
            <div style="display: flex; align-items: center; gap: 15px;">
                {* User Account Section (when logged in) *}
                <div id="userAccountSectionHeader" style="display: none;">
                    <div style="display: flex; align-items: center; gap: 10px;">
                        {* Photo *}
                        <div id="userAvatarContainerHeader" style="width: 36px; height: 36px; border-radius: 50%; overflow: hidden; background: #e2e8f0; display: flex; align-items: center; justify-content: center; border: 2px solid #667eea;">
                            <i class="fa fa-user-circle" id="userAvatarIconHeader" style="font-size: 36px; color: #667eea;"></i>
                            <img id="userAvatarImageHeader" src="" alt="Profile" style="width: 100%; height: 100%; object-fit: cover; display: none;">
                        </div>

                        {* Subscription & Quota Info *}
                        <div style="display: flex; flex-direction: column; gap: 4px;">
                            <div id="subscriptionRowHeader" style="font-size: 11px; color: #334155; font-weight: 500; display: none;">
                                <i class="fa fa-star" style="color: #fbbf24; font-size: 10px;"></i>
                                <span id="subscriptionInfoHeader">Loading...</span>
                            </div>
                            <div id="quotaRowHeader" style="font-size: 11px; color: #334155; font-weight: 500; display: none;">
                                <span id="quotaInfoHeader"></span>
                                <button type="button" id="refreshQuotaHeader" onclick="refreshGoValidQuota()" style="padding: 2px 6px; font-size: 9px; background: #667eea; border: none; color: white; border-radius: 3px; cursor: pointer; margin-left: 6px;">
                                    <i class="fa fa-refresh"></i>
                                </button>
                            </div>
                        </div>

                        {* Logout Button *}
                        <button type="button" id="logoutBtnHeader" onclick="performLogout()" style="background: #ef4444; color: white; border: none; padding: 8px 14px; border-radius: 6px; cursor: pointer; font-size: 12px; font-weight: 500; transition: all 0.2s; display: flex; align-items: center; gap: 4px;">
                            <i class="fa fa-sign-out"></i>
                            <span>Logout</span>
                        </button>
                    </div>
                </div>

                {* Login Button (when not logged in) *}
                <div id="loginSectionHeader" style="display: block;">
                    <button type="button" onclick="showLoginModal()" style="background: #667eea; color: white; border: none; padding: 8px 16px; border-radius: 6px; cursor: pointer; font-size: 12px; font-weight: 500; display: flex; align-items: center; gap: 6px;">
                        <i class="fa fa-user-circle"></i>
                        <span>Login to GoValid</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content Area -->
    <div class="etd-main">
        <!-- Left Panel - Design Controls -->
        <div class="etd-left-panel">
            <!-- Tab Navigation -->
            <div class="etd-tabs">
                <button class="etd-tab active" data-tab="ojs-templates" onclick="switchTab('ojs-templates')">
                    Setup
                </button>
                <button class="etd-tab" data-tab="design" onclick="switchTab('design')">
                    Design
                </button>
                <button class="etd-tab" data-tab="content" onclick="switchTab('content')">
                    Content
                </button>
            </div>

            <!-- Tab Content -->
            <div class="etd-tab-content">
                <!-- Design Tab (Header + Footer) -->
                <div id="tab-design" class="etd-tab-panel">
                    <!-- Header Section with Blue Background -->
                    <div class="etd-section-wrapper header-section">
                        <div class="etd-section-title">Header Settings</div>
                        <!-- Logo Settings Row 1: Show Logo + Jurnal beside logo -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item auto">
                            <label class="etd-label">
                                <span>Show Logo</span>
                                <input type="checkbox" id="header_showLogo" checked onchange="updatePreview()">
                            </label>
                        </div>
                        <div class="etd-control-row-item">
                            <label class="etd-label">
                                <span>Jurnal beside logo</span>
                                <input type="checkbox" id="header_showNameBesideLogo" checked onchange="updatePreview()">
                            </label>
                        </div>
                    </div>

                    <!-- Logo Settings Row 2: Logo Width + Logo Position -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item small">
                            <label class="etd-label">Logo Width (px)</label>
                            <input type="number" id="header_logoMaxWidth" class="etd-input" value="200" min="50" max="400" oninput="updatePreview()">
                        </div>
                        <div class="etd-control-row-item">
                            <label class="etd-label">Logo Position</label>
                            <select id="header_logoPosition" class="etd-select" onchange="updatePreview()">
                                <option value="center">Center</option>
                                <option value="left" selected>Left</option>
                                <option value="right">Right</option>
                            </select>
                        </div>
                    </div>

                    <!-- Background Row: Type + Colors in one row -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item small">
                            <label class="etd-label">Background</label>
                            <select id="header_bgType" onchange="toggleHeaderBgType()" class="etd-select">
                                <option value="solid">Solid Color</option>
                                <option value="gradient" selected>Gradient</option>
                            </select>
                        </div>
                        <div id="header_solidBg" class="etd-control-row-item" style="display:none;">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Background</label>
                                <input type="color" id="header_bgColor" value="#2c3e50" onchange="updatePreview()">
                            </div>
                        </div>
                        <div id="header_gradientBg" class="etd-control-row-item">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Start</label>
                                <input type="color" id="header_gradientStart" value="#667eea" onchange="updatePreview()">
                            </div>
                        </div>
                        <div id="header_gradientBg2" class="etd-control-row-item">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">End</label>
                                <input type="color" id="header_gradientEnd" value="#764ba2" onchange="updatePreview()">
                            </div>
                        </div>
                    </div>

                    <!-- Title Row: Title + Text Color -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item">
                            <label class="etd-label">Title</label>
                            <input type="text" id="header_title" class="etd-input" placeholder="e.g., Certificate of Review" value="Certificate of Review" oninput="updatePreview()">
                        </div>
                        <div class="etd-control-row-item auto">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Text</label>
                                <input type="color" id="header_textColor" value="#ffffff" onchange="updatePreview()">
                            </div>
                        </div>
                    </div>

                    <div class="etd-control-group">
                        <label class="etd-label">Subtitle</label>
                        <input type="text" id="header_subtitle" class="etd-input" placeholder="Use {ldelim}{ldelim}journal_name{rdelim}{rdelim} for journal" value="{ldelim}{ldelim}journal_name{rdelim}{rdelim}" oninput="updatePreview()">
                    </div>

                        <div class="etd-control-group">
                            <label class="etd-label">Padding (px)</label>
                            <input type="range" id="header_padding" min="20" max="80" value="40" oninput="updatePreview()" class="etd-range">
                            <span class="etd-range-value"><span id="header_padding_value">40</span>px</span>
                        </div>
                    </div>
                    <!-- End Header Section -->

                    <!-- Footer Section with Green Background -->
                    <div class="etd-section-wrapper footer-section">
                        <div class="etd-section-title">Footer Settings</div>

                        <!-- Colors Row: Background + Text + Link -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item auto">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Background</label>
                                <input type="color" id="footer_bgColor" value="#ecf0f1" onchange="updatePreview()">
                            </div>
                        </div>
                        <div class="etd-control-row-item auto">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Text</label>
                                <input type="color" id="footer_textColor" value="#2c3e50" onchange="updatePreview()">
                            </div>
                        </div>
                        <div class="etd-control-row-item auto">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Link</label>
                                <input type="color" id="footer_linkColor" value="#3498db" onchange="updatePreview()">
                            </div>
                        </div>
                    </div>

                    <!-- Signature Row: Signature Line + Show URL Checkbox -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item">
                            <label class="etd-label">Signature Line</label>
                            <input type="text" id="footer_signature" class="etd-input" placeholder="e.g., Best regards," value="" oninput="updatePreview()">
                        </div>
                        <div class="etd-control-row-item auto">
                            <label class="etd-label">
                                <span>Show URL</span>
                                <input type="checkbox" id="footer_showUrl" checked onchange="updatePreview()">
                            </label>
                        </div>
                    </div>

                    <!-- Signature Name (full width) -->
                    <div class="etd-control-group">
                        <label class="etd-label">Signature Name</label>
                        <input type="text" id="footer_signatureName" class="etd-input" placeholder="Use {ldelim}{ldelim}journal_name{rdelim}{rdelim}" value="{ldelim}{ldelim}journal_name{rdelim}{rdelim} Editorial Team" oninput="updatePreview()">
                    </div>

                    <!-- Padding & Border Width Row -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item">
                            <label class="etd-label">Padding (px)</label>
                            <input type="range" id="footer_padding" min="15" max="50" value="25" oninput="updatePreview()" class="etd-range">
                            <span class="etd-range-value"><span id="footer_padding_value">25</span>px</span>
                        </div>
                        <div class="etd-control-row-item">
                            <label class="etd-label">Border Width (px)</label>
                            <input type="range" id="footer_borderWidth" min="0" max="5" value="3" oninput="updatePreview()" class="etd-range">
                            <span class="etd-range-value"><span id="footer_borderWidth_value">3</span>px</span>
                        </div>
                    </div>

                        <!-- Border Color -->
                        <div class="etd-control-group">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Border Color</label>
                                <input type="color" id="footer_borderColor" value="#2c3e50" onchange="updatePreview()">
                            </div>
                        </div>
                    </div>
                    <!-- End Footer Section -->
                </div>

                <!-- Content Tab -->
                <div id="tab-content" class="etd-tab-panel">
                    <!-- Subject Line (full width) -->
                    <div class="etd-control-group">
                        <label class="etd-label">Subject Line</label>
                        <input type="text" id="content_subject" class="etd-input" placeholder="Email subject" value="Certificate of Review - {ldelim}{ldelim}journal_name{rdelim}{rdelim}" oninput="syncSubjectFields(this); updatePreview()">
                    </div>

                    <!-- Greeting (full width) -->
                    <div class="etd-control-group">
                        <label class="etd-label">Greeting</label>
                        <input type="text" id="content_greeting" class="etd-input" placeholder="e.g., Dear {ldelim}{ldelim}reviewer_name{rdelim}{rdelim}," value="Dear {ldelim}{ldelim}reviewer_name{rdelim}{rdelim}," oninput="updatePreview()">
                    </div>

                    <!-- Opening Message (full width) -->
                    <div class="etd-control-group">
                        <label class="etd-label">Opening Message</label>
                        <textarea id="content_message" class="etd-textarea" rows="4" oninput="updatePreview()">Thank you for your valuable contribution to the peer review process. Your expertise and dedication help maintain the high standards of scholarly publishing.</textarea>
                    </div>

                    <!-- Article Details Row: Checkbox + Details Box Background -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item auto">
                            <label class="etd-label">
                                <span>Show Article Details</span>
                                <input type="checkbox" id="content_showDetailsBox" checked onchange="toggleArticleDetailsVisibility(); updatePreview();">
                            </label>
                        </div>
                        <div class="etd-control-row-item auto" id="articleDetailsColorWrapper">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Color</label>
                                <input type="color" id="content_detailsBgColor" value="#dfebfb" onchange="updatePreview()">
                            </div>
                        </div>
                    </div>

                    <!-- Article Details Content (full width) -->
                    <div class="etd-control-group" id="articleDetailsGroup">
                        <label class="etd-label">Article Details Content</label>
                        <textarea id="content_articleDetails" class="etd-textarea" rows="5" oninput="updatePreview()" placeholder="Article details will be auto-filled from OJS templates. You can also manually add details like:
Title: {$submissionTitle}
Authors: {$authors}
Date: {$dateSubmitted}"></textarea>
                        <small style="color: #718096; font-size: 0.8125rem; display: block; margin-top: 6px;">Auto-filled from OJS templates. Use variables like {$submissionTitle}, {$authors}</small>
                    </div>

                    <!-- Closing Message (full width) -->
                    <div class="etd-control-group">
                        <label class="etd-label">Closing Message</label>
                        <textarea id="content_closing" class="etd-textarea" rows="3" oninput="updatePreview()">Your certificate of review is attached to this email as recognition of your professional contribution.

{ldelim}{ldelim}custom_message{rdelim}{rdelim}</textarea>
                    </div>

                    <!-- Colors Row: Background + Text + Padding -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item auto">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Background</label>
                                <input type="color" id="content_bgColor" value="#ffffff" onchange="updatePreview()">
                            </div>
                        </div>
                        <div class="etd-control-row-item auto">
                            <div class="etd-color-picker-wrapper">
                                <label class="etd-label">Text</label>
                                <input type="color" id="content_textColor" value="#333333" onchange="updatePreview()">
                            </div>
                        </div>
                        <div class="etd-control-row-item">
                            <label class="etd-label">Padding (px)</label>
                            <input type="range" id="content_padding" min="20" max="60" value="40" oninput="updatePreview()" class="etd-range">
                            <span class="etd-range-value"><span id="content_padding_value">40</span>px</span>
                        </div>
                    </div>

                    <div class="etd-variables-quick">
                        <label class="etd-label">Insert Variable:</label>
                        <div class="etd-var-buttons">
                            <button type="button" onclick="insertVariable('reviewer_name')" class="etd-var-btn">{ldelim}{ldelim}reviewer_name{rdelim}{rdelim}</button>
                            <button type="button" onclick="insertVariable('article_title')" class="etd-var-btn">{ldelim}{ldelim}article_title{rdelim}{rdelim}</button>
                            <button type="button" onclick="insertVariable('journal_name')" class="etd-var-btn">{ldelim}{ldelim}journal_name{rdelim}{rdelim}</button>
                            <button type="button" onclick="insertVariable('review_date')" class="etd-var-btn">{ldelim}{ldelim}review_date{rdelim}{rdelim}</button>
                        </div>
                    </div>
                </div>

                <!-- Setup Tab -->
                <div id="tab-ojs-templates" class="etd-tab-panel active">
                    <div class="etd-section-title">Load Email Template</div>

                    <div class="etd-control-group">
                        <label class="etd-label">Select Template</label>
                        <input type="text" id="ojsTemplateSearch" class="etd-input" placeholder="Search templates..." oninput="filterOJSTemplates()" style="margin-bottom: 8px;">
                        <div style="display: flex; gap: 8px; align-items: center;">
                            <select id="ojsTemplateSelector" class="etd-select" onchange="onOJSTemplateSelected()" style="flex: 1;">
                                <option value="">-- Loading templates... --</option>
                            </select>
                            <button type="button" class="etd-btn etd-btn-primary" onclick="loadOJSTemplate()" id="loadOJSTemplateBtn" disabled style="padding: 10px; min-width: 40px;" title="Load Template">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                    <polyline points="14 2 14 8 20 8"></polyline>
                                    <line x1="9" y1="12" x2="15" y2="12"></line>
                                    <polyline points="12 9 15 12 12 15"></polyline>
                                </svg>
                            </button>
                        </div>
                        <div style="margin-top: 8px; font-size: 11px; color: #718096;">
                            <span style="color: #718096;">■</span> = May not appear in OJS's native workflow email menus
                        </div>
                    </div>

                    <div id="ojsTemplateInfo" style="display: none; margin-top: 15px; padding: 12px; background: #f8f9fa; border-radius: 6px; border-left: 3px solid #667eea;">
                        <div style="font-size: 13px; font-weight: 600; color: #2d3748; margin-bottom: 8px;" id="ojsTemplateTitle"></div>
                        <div style="font-size: 12px; color: #718096; line-height: 1.5;" id="ojsTemplateDesc"></div>
                        <div style="margin-top: 10px; padding-top: 10px; border-top: 1px solid #e2e8f0;">
                            <div style="font-size: 11px; color: #a0aec0; margin-bottom: 4px;">Status:</div>
                            <div style="font-size: 12px; font-weight: 500;" id="ojsTemplateStatus"></div>
                        </div>
                        <div style="margin-top: 10px; padding-top: 10px; border-top: 1px solid #e2e8f0;">
                            <div style="font-size: 11px; color: #a0aec0; margin-bottom: 4px;">Available Variables:</div>
                            <div style="font-size: 12px; color: #4a5568; max-height: 150px; overflow-y: auto;" id="ojsVariablesList">
                                <em style="color: #a0aec0;">Select a template to see available variables</em>
                            </div>
                        </div>
                    </div>

                    <div id="saveOJSTemplateSection" style="display: none; margin-top: 15px; padding: 15px; background: #edf2f7; border-radius: 8px; border: 2px solid #667eea;">
                        <div style="font-size: 13px; font-weight: 600; color: #2d3748; margin-bottom: 10px;">
                            <svg style="display: inline-block; vertical-align: middle; margin-right: 6px;" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <circle cx="12" cy="12" r="10"></circle>
                                <line x1="12" y1="16" x2="12" y2="12"></line>
                                <line x1="12" y1="8" x2="12.01" y2="8"></line>
                            </svg>
                            Template Loaded: <span id="loadedTemplateName" style="color: #667eea;"></span>
                        </div>
                        <div id="saveButtonsContainer" style="display: flex; gap: 10px;">
                            <button type="button" class="etd-btn etd-btn-primary" onclick="saveOJSTemplate()" style="flex: 1;">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path>
                                    <polyline points="17 21 17 13 7 13 7 21"></polyline>
                                    <polyline points="7 3 7 8 15 8"></polyline>
                                </svg>
                                Save Changes
                            </button>
                            <button type="button" id="saveAsButton" class="etd-btn etd-btn-secondary" onclick="saveAsOJSTemplate()" style="flex: 1;">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path>
                                    <polyline points="17 21 17 13 7 13 7 21"></polyline>
                                    <polyline points="7 3 7 8 15 8"></polyline>
                                    <line x1="9" y1="9" x2="15" y2="3"></line>
                                </svg>
                                Save As
                            </button>
                        </div>
                    </div>

                    <!-- HIDDEN: Load Custom Email Template Section (not needed for now) -->
                    <div style="display: none;">
                        <div class="etd-section-title" style="margin-top: 30px;">Load Custom Email Template</div>
                        <p style="font-size: 13px; color: #718096; margin-bottom: 15px;">
                            Load your previously saved custom email templates (including those based on OJS templates).
                        </p>

                        <div class="etd-control-group">
                            <label class="etd-label">Select Template</label>
                            <input type="text" id="customTemplateSearch" class="etd-input" placeholder="Search custom templates..." oninput="filterCustomTemplates()" style="margin-bottom: 8px;">
                            <div style="display: flex; gap: 8px; align-items: center;">
                                <select id="customTemplateSelector" class="etd-select" onchange="onCustomTemplateSelected()" style="flex: 1;">
                                    <option value="">-- Loading templates... --</option>
                                </select>
                                <button type="button" class="etd-btn etd-btn-primary" onclick="loadCustomTemplate()" id="loadCustomTemplateBtn" disabled style="padding: 10px; min-width: 40px;" title="Load Template">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                        <polyline points="14 2 14 8 20 8"></polyline>
                                        <line x1="9" y1="12" x2="15" y2="12"></line>
                                        <polyline points="12 9 15 12 12 15"></polyline>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <div id="customTemplateInfo" style="display: none; margin-top: 15px; padding: 12px; background: #f8f9fa; border-radius: 6px; border-left: 3px solid #10b981;">
                            <div style="font-size: 13px; font-weight: 600; color: #2d3748; margin-bottom: 8px;" id="customTemplateTitle"></div>
                            <div style="font-size: 12px; color: #718096; line-height: 1.5;" id="customTemplateDesc"></div>
                            <div style="margin-top: 10px; padding-top: 10px; border-top: 1px solid #e2e8f0;">
                                <div style="font-size: 11px; color: #a0aec0; margin-bottom: 4px;">Created:</div>
                                <div style="font-size: 12px; font-weight: 500;" id="customTemplateDate"></div>
                            </div>
                        </div>
                    </div>
                    <!-- END HIDDEN SECTION -->

                    <!-- Settings Section (formerly in Settings tab) -->
                    <div class="etd-section-title" style="margin-top: 30px;">Email Settings</div>

                    <!-- Row 1: Email Width + Font Family -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item small">
                            <label class="etd-label">Email Width (px)</label>
                            <input type="number" id="settings_emailWidth" class="etd-input" value="600" min="400" max="800" oninput="updatePreview()">
                        </div>
                        <div class="etd-control-row-item">
                            <label class="etd-label">Font Family</label>
                            <select id="settings_fontFamily" class="etd-select" onchange="updatePreview()">
                                <option value="Arial, sans-serif" selected>Arial</option>
                                <option value="'Segoe UI', Tahoma, Geneva, Verdana, sans-serif">Segoe UI</option>
                                <option value="Helvetica, Arial, sans-serif">Helvetica</option>
                                <option value="'Trebuchet MS', Helvetica, sans-serif">Trebuchet MS</option>
                                <option value="Calibri, Candara, 'Segoe UI', sans-serif">Calibri</option>
                                <option value="Verdana, Geneva, sans-serif">Verdana</option>
                                <option value="Georgia, serif">Georgia</option>
                                <option value="'Times New Roman', Times, serif">Times New Roman</option>
                                <option value="Garamond, Baskerville, serif">Garamond</option>
                                <option value="'Palatino Linotype', 'Book Antiqua', Palatino, serif">Palatino</option>
                                <option value="'Courier New', Courier, monospace">Courier New</option>
                                <option value="'Lucida Console', Monaco, monospace">Lucida Console</option>
                                <option value="'Comic Sans MS', cursive, sans-serif">Comic Sans MS</option>
                                <option value="Impact, Charcoal, sans-serif">Impact</option>
                                <option value="'Arial Black', Gadget, sans-serif">Arial Black</option>
                            </select>
                        </div>
                    </div>

                    <!-- Row 2: Font Size + Line Height -->
                    <div class="etd-control-row">
                        <div class="etd-control-row-item">
                            <label class="etd-label">Font Size (px)</label>
                            <input type="range" id="settings_fontSize" min="12" max="18" value="16" oninput="updatePreview()" class="etd-range">
                            <span class="etd-range-value"><span id="settings_fontSize_value">16</span>px</span>
                        </div>
                        <div class="etd-control-row-item">
                            <label class="etd-label">Line Height</label>
                            <input type="range" id="settings_lineHeight" min="1.2" max="2" step="0.1" value="1.6" oninput="updatePreview()" class="etd-range">
                            <span class="etd-range-value"><span id="settings_lineHeight_value">1.6</span></span>
                        </div>
                    </div>

                    <!-- Hidden field for outer background (kept for backward compatibility but not shown in UI) -->
                    <input type="hidden" id="settings_outerBgColor" value="#f8f9fa">

                    <!-- Presets Section -->
                    <div class="etd-section-title" style="margin-top: 15px;">Design Presets</div>
                    <div class="etd-presets">
                        <button type="button" onclick="loadPreset('professional')" class="etd-preset-btn">Professional</button>
                        <button type="button" onclick="loadPreset('modern')" class="etd-preset-btn">Modern</button>
                        <button type="button" onclick="loadPreset('minimal')" class="etd-preset-btn">Minimal</button>
                    </div>

                </div>
            </div>
        </div>

        <!-- Right Panel - Live Preview -->
        <div class="etd-right-panel">
            <div class="etd-preview-header">
                <div style="display: flex; align-items: center; gap: 10px;">
                    {* Template Name and Subject fields *}
                    <label style="font-weight: 600; color: #2d3748; margin-right: 4px; font-size: 13px;">Name:</label>
                    <input type="text" id="templateName" class="etd-template-name" placeholder="Template Name" value="{$templateName|escape|default:'New Template'}" style="max-width: 200px;">
                    <label style="font-weight: 600; color: #2d3748; margin-left: 10px; margin-right: 4px; font-size: 13px;">Subject:</label>
                    <input type="text" id="templateSubject" class="etd-template-name" placeholder="Email Subject" value="Certificate of Review - {ldelim}{ldelim}journal_name{rdelim}{rdelim}" style="width: 350px !important; flex: 0 0 auto;" oninput="syncSubjectFields(this)">

                    {* Save Button *}
                    <button type="button" class="etd-btn etd-btn-primary" onclick="saveTemplate()" id="saveTemplateBtn" style="margin-left: 10px;">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path>
                            <polyline points="17 21 17 13 7 13 7 21"></polyline>
                            <polyline points="7 3 7 8 15 8"></polyline>
                        </svg>
                        Save
                        <i class="fa fa-lock" style="margin-left: 4px; font-size: 11px; display: none;" id="saveTemplateLock"></i>
                    </button>

                    {* Send Email Button *}
                    <button type="button" class="etd-btn" onclick="sendTestEmail()" id="sendTestBtn" style="margin-left: 10px; background: #10b981; color: white; border: none;">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <line x1="22" y1="2" x2="11" y2="13"></line>
                            <polygon points="22 2 15 22 11 13 2 9 22 2"></polygon>
                        </svg>
                        Send Email
                        <i class="fa fa-lock" style="margin-left: 4px; font-size: 11px; display: none;" id="sendTestLock"></i>
                    </button>
                </div>

                {* Live Preview and device icons moved to the right *}
                <div style="display: flex; align-items: center; gap: 10px;">
                    <h3 style="margin: 0;">Live Preview</h3>
                    <div class="etd-preview-actions">
                        <button type="button" class="etd-preview-btn active" data-view="desktop" onclick="togglePreviewView('desktop')" title="Desktop View">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                                <line x1="8" y1="21" x2="16" y2="21"></line>
                                <line x1="12" y1="17" x2="12" y2="21"></line>
                            </svg>
                        </button>
                        <button type="button" class="etd-preview-btn" data-view="mobile" onclick="togglePreviewView('mobile')" title="Mobile View">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <rect x="5" y="2" width="14" height="20" rx="2" ry="2"></rect>
                                <line x1="12" y1="18" x2="12.01" y2="18"></line>
                            </svg>
                        </button>
                    </div>
                </div>

                {* Old GoValid section removed - now in main header - keep hidden for backward compatibility *}
                <div style="display: none;">
                    {* User Account Section (when logged in) *}
                    <div id="userAccountSection" style="display: none;">
                        <div style="display: flex; align-items: center; gap: 10px;">
                            {* Photo *}
                            <div id="userAvatarContainer" style="width: 36px; height: 36px; border-radius: 50%; overflow: hidden; background: #e2e8f0; display: flex; align-items: center; justify-content: center; border: 2px solid #667eea;">
                                <i class="fa fa-user-circle" id="userAvatarIcon" style="font-size: 36px; color: #667eea;"></i>
                                <img id="userAvatarImage" src="" alt="Profile" style="width: 100%; height: 100%; object-fit: cover; display: none;">
                            </div>

                            {* Subscription & Quota Info *}
                            <div style="display: flex; flex-direction: column; gap: 4px;">
                                <div id="subscriptionRow" style="font-size: 11px; color: #334155; font-weight: 500; display: none;">
                                    <i class="fa fa-star" style="color: #fbbf24; font-size: 10px;"></i>
                                    <span id="subscriptionInfo">Loading...</span>
                                </div>
                                <div id="quotaRow" style="font-size: 11px; color: #334155; font-weight: 500; display: none;">
                                    <span id="quotaInfo"></span>
                                    <button type="button" id="refreshQuota" onclick="refreshGoValidQuota()" style="padding: 2px 6px; font-size: 9px; background: #667eea; border: none; color: white; border-radius: 3px; cursor: pointer; margin-left: 6px;">
                                        <i class="fa fa-refresh"></i>
                                    </button>
                                </div>
                            </div>

                            {* Logout Button *}
                            <button type="button" id="logoutBtn" onclick="performLogout()" style="background: #ef4444; color: white; border: none; padding: 6px 12px; border-radius: 6px; cursor: pointer; font-size: 11px; font-weight: 500; transition: all 0.2s; display: flex; align-items: center; gap: 4px;">
                                <i class="fa fa-sign-out"></i>
                                <span>Logout</span>
                            </button>
                        </div>
                    </div>

                    {* Login Button (when not logged in) *}
                    <div id="loginSection" style="display: block;">
                        <button type="button" onclick="showLoginModal()" style="background: #667eea; color: white; border: none; padding: 8px 16px; border-radius: 6px; cursor: pointer; font-size: 12px; font-weight: 500; display: flex; align-items: center; gap: 6px;">
                            <i class="fa fa-user-circle"></i>
                            <span>Login to GoValid</span>
                        </button>
                    </div>

                    {* Hidden element for designer-auth.js compatibility *}
                    <div id="govalidAuthStatus" style="display: none;">
                        <span id="authStatusText"></span>
                    </div>
                </div>
            </div>
            <div class="etd-preview-container">
                <div id="emailPreview" class="etd-preview-content">
                    <!-- Preview will be generated here -->
                </div>
            </div>
        </div>
    </div>

    {* GoValid Login Modal *}
    <div id="govalidLoginModal" class="modal" style="display: none !important;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" onclick="hideLoginModal(); return false;">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="login-logo">
                        <img src="https://my.govalid.org/static/assets/img/logo/Strip_blue.png" alt="GoValid">
                    </div>
                    <p class="login-tagline">Authentication for Everyone</p>

                    <h2 class="welcome-text">Welcome Back</h2>
                    <p class="welcome-subtitle">Sign in to your GoValid account</p>

                    <form id="govalidLoginForm">
                        <div class="form-group">
                            <label for="govalid_username">Username or Email</label>
                            <div class="input-group">
                                <i class="fa fa-user input-icon"></i>
                                <input type="text" class="form-control" id="govalid_username" name="username" required placeholder="Enter your username or email">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="govalid_password">Password</label>
                            <div class="input-group">
                                <i class="fa fa-lock input-icon"></i>
                                <input type="password" class="form-control" id="govalid_password" name="password" required placeholder="Enter your password">
                                <button type="button" class="password-toggle" id="togglePassword">
                                    <i class="fa fa-eye"></i>
                                </button>
                            </div>
                        </div>

                        <div class="form-options">
                            <div class="remember-me">
                                <input type="checkbox" id="govalid_remember" name="remember">
                                <label for="govalid_remember">Remember me</label>
                            </div>
                            <div class="forgot-password">
                                <a href="#" onclick="alert('Please visit https://my.govalid.org to reset your password'); return false;">Forgot Password?</a>
                            </div>
                        </div>

                        <div class="alert alert-danger" id="loginError" style="display: none;"></div>

                        {* 2FA Verification Section *}
                        <div id="twoFASection" style="display: none; margin-bottom: 15px;">
                            <div style="background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 8px; padding: 15px;">
                                <h5 style="margin: 0 0 10px 0; font-size: 14px; color: #495057;">
                                    <i class="fa fa-shield"></i> 2FA Verification Required
                                </h5>
                                <p style="margin: 0 0 15px 0; font-size: 13px; color: #6c757d;">
                                    Enter the 6-digit code from your authenticator app
                                </p>
                                <div style="display: flex; gap: 5px; justify-content: center; margin-bottom: 10px;" id="twofa-inputs">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="0" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="1" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="2" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="3" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="4" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                    <input type="text" class="twofa-input" maxlength="1" data-index="5" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ced4da; border-radius: 8px;">
                                </div>
                                <div id="twoFAError" style="color: #dc3545; font-size: 12px; text-align: center; display: none; margin-top: 5px;"></div>
                                <button type="button" class="btn btn-primary" id="verify2FABtn" onclick="verify2FA()" style="width: 100%; margin-top: 10px;">
                                    <span id="verify2FAText">Verify Code</span>
                                    <i class="fa fa-spinner fa-spin" id="verify2FASpinner" style="display: none;"></i>
                                </button>
                                <button type="button" class="btn btn-link" onclick="cancel2FA()" style="width: 100%; margin-top: 5px; font-size: 12px;">
                                    Back to Login
                                </button>
                            </div>
                        </div>

                        {* Email OTP Verification Section (Risk-Based Authentication) *}
                        <div id="emailOTPSection" style="display: none; margin-bottom: 15px;">
                            <div style="background: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; padding: 15px;">
                                <h5 style="margin: 0 0 10px 0; font-size: 14px; color: #856404;">
                                    <i class="fa fa-exclamation-triangle"></i> Security Verification Required
                                </h5>
                                <p id="emailOTPMessage" style="margin: 0 0 15px 0; font-size: 13px; color: #856404;">
                                    Please check your email for the verification code.
                                </p>
                                <div style="display: flex; gap: 5px; justify-content: center; margin-bottom: 10px;" id="email-otp-inputs">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="0" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="1" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="2" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="3" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="4" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                    <input type="text" class="email-otp-input" maxlength="1" data-index="5" style="width: 38px; height: 50px; font-size: 24px; font-weight: bold; text-align: center; border: 2px solid #ffc107; border-radius: 8px;">
                                </div>
                                <div id="emailOTPError" style="color: #dc3545; font-size: 12px; text-align: center; display: none; margin-top: 5px;"></div>
                                <button type="button" class="btn btn-warning" id="verifyEmailOTPBtn" onclick="verifyEmailOTP()" style="width: 100%; margin-top: 10px;">
                                    <span id="verifyEmailOTPText">Verify Code</span>
                                    <i class="fa fa-spinner fa-spin" id="verifyEmailOTPSpinner" style="display: none;"></i>
                                </button>
                                <button type="button" class="btn btn-link" onclick="cancelEmailOTP()" style="width: 100%; margin-top: 5px; font-size: 12px;">
                                    Back to Login
                                </button>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary" id="loginSubmitBtn">
                            <span class="login-text">Sign In</span>
                            <i class="fa fa-spinner login-spinner"></i>
                        </button>

                        <div class="divider">
                            <span>OR</span>
                        </div>

                        <a href="https://my.govalid.org/register" target="_blank" class="btn btn-outline btn-register">
                            <i class="fa fa-user-plus"></i>
                            Create New Account
                        </a>
                    </form>

                    <div class="footer-links">
                        <p>By signing in, you agree to our <a href="https://my.govalid.org/terms" target="_blank">Terms of Service</a> and <a href="https://my.govalid.org/privacy" target="_blank">Privacy Policy</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden form to store template data -->
<form id="templateForm" style="display:none;">
    {csrf}
    <input type="hidden" name="templateId" value="{$templateId|escape|default:''}">
    <input type="hidden" name="templateData" id="templateData">
</form>

<link rel="stylesheet" href="{$baseUrl}/plugins/generic/goValidOJS/css/email-designer.css">
<link rel="stylesheet" href="{$baseUrl}/plugins/generic/goValidOJS/css/designer.css">

<script>
{literal}
// Initialize Smarty delimiters for JavaScript
var lb = '{{';
var rb = '}}';

{/literal}
// Plugin AJAX URL for API calls
window.pluginAjaxUrl = '{$baseUrl}/index.php/{$contextPath}/govalidojs/emailTemplateDesigner';
{literal}

// Helper function to build clean AJAX URL
function getAjaxURL() {
    const pluginPath = window.pluginAjaxUrl;
    console.log('Email Designer AJAX Base URL:', pluginPath);
    return pluginPath;
}

function buildActionURL(action) {
    let baseURL = getAjaxURL();
    const actionURL = baseURL + '?action=' + action;
    console.log('Email Designer Action URL for ' + action + ':', actionURL);
    return actionURL;
}

// GoValid Authentication State
var goValidAuth = {
    isAuthenticated: false,
    token: null,
    expiry: null,
    sessionDuration: 3600000, // 1 hour in milliseconds
    userInfo: null,
    subscription: null,
    sessionStart: null,
    lastCheck: null,
    accessToken: null,
    initializing: false
};

// Pass journal info from PHP to JavaScript
{/literal}
window.journalLogoUrl = '{$journalLogoUrl|escape:"javascript"}';
window.journalName = '{$journalName|escape:"javascript"}';
window.journalLogoAlt = '{$journalLogoAlt|escape:"javascript"}';
window.journalLogoWidth = {$journalLogoWidth};
window.journalLogoHeight = {$journalLogoHeight};
{literal}

console.log('Journal Logo URL:', window.journalLogoUrl);
console.log('Journal Name:', window.journalName);

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    initializeDesigner();
    updatePreview();

    // Setup GoValid authentication
    if (typeof setupAuthentication === 'function') {
        setupAuthentication();
    }
});

// Refresh GoValid quota function
function refreshGoValidQuota() {
    if (typeof checkAuthStatus === 'function') {
        checkAuthStatus(true);
    }
}

// Stub functions for designer-auth.js compatibility
function updateUserNameFields() {
    // Email designer doesn't use QR settings, so this is a no-op
    console.log('updateUserNameFields called (email designer - no-op)');
}

// Sync subject fields (top header and content tab)
function syncSubjectFields(sourceField) {
    const value = sourceField.value;
    if (sourceField.id === 'templateSubject') {
        document.getElementById('content_subject').value = value;
    } else if (sourceField.id === 'content_subject') {
        document.getElementById('templateSubject').value = value;
    }
}

// Toggle visibility of article details fields based on checkbox
function toggleArticleDetailsVisibility() {
    const checkbox = document.getElementById('content_showDetailsBox');
    const colorWrapper = document.getElementById('articleDetailsColorWrapper');
    const detailsGroup = document.getElementById('articleDetailsGroup');

    if (checkbox.checked) {
        colorWrapper.style.display = '';
        detailsGroup.style.display = '';
    } else {
        colorWrapper.style.display = 'none';
        detailsGroup.style.display = 'none';
    }
}

// ========================================================================
// OJS Email Template Integration Functions
// ========================================================================

var currentOJSTemplates = [];
var currentOJSTemplateKey = null;
var currentOJSMailableKey = null; // The base Mailable key (for alternates)

// Load OJS templates on page load
async function loadOJSTemplatesList() {
    try {
        const response = await fetch(buildActionURL('getOJSEmailTemplates'));
        const data = await response.json();

        if (data.status && data.content.templates) {
            currentOJSTemplates = data.content.templates;
            const selector = document.getElementById('ojsTemplateSelector');

            selector.innerHTML = '<option value="">-- Select a template --</option>';

            data.content.templates.forEach(template => {
                const option = document.createElement('option');
                option.value = template.key;
                // Add small square indicator for CUSTOM_ templates
                const indicator = template.key.startsWith('CUSTOM_') ? ' ■' : '';
                option.textContent = `${template.name}${template.isCustom ? ' (Customized)' : ''}${indicator}`;
                selector.appendChild(option);
            });

            console.log('Loaded', currentOJSTemplates.length, 'OJS templates');
        }
    } catch (error) {
        console.error('Error loading OJS templates:', error);
        document.getElementById('ojsTemplateSelector').innerHTML = '<option value="">Error loading templates</option>';
    }
}

// Filter OJS templates based on search input
function filterOJSTemplates() {
    const searchInput = document.getElementById('ojsTemplateSearch');
    const selector = document.getElementById('ojsTemplateSelector');
    const searchTerm = searchInput.value.toLowerCase();

    // Get all options
    const options = Array.from(selector.options);

    let visibleCount = 0;

    // Filter and show/hide options
    options.forEach(option => {
        if (!option.value) {
            // Keep the "Loading..." or empty option
            return;
        }

        const text = option.textContent.toLowerCase();
        if (text.includes(searchTerm)) {
            option.style.display = '';
            visibleCount++;
        } else {
            option.style.display = 'none';
        }
    });

    // Automatically expand dropdown to show filtered results
    if (searchTerm && visibleCount > 0) {
        // Set size to show multiple options (max 8)
        selector.size = Math.min(visibleCount, 8);
        selector.style.height = 'auto';
    } else {
        // Collapse back to dropdown mode
        selector.size = 1;
        selector.style.height = '';
    }

    // If current selection is hidden, clear selection
    if (selector.value && selector.selectedOptions[0] && selector.selectedOptions[0].style.display === 'none') {
        selector.value = '';
        onOJSTemplateSelected();
    }
}

// When user selects an OJS template
function onOJSTemplateSelected() {
    const selector = document.getElementById('ojsTemplateSelector');
    const templateKey = selector.value;

    // Collapse dropdown back to normal mode when selection is made
    selector.size = 1;
    selector.style.height = '';

    if (!templateKey) {
        document.getElementById('ojsTemplateInfo').style.display = 'none';
        document.getElementById('loadOJSTemplateBtn').disabled = true;
        document.getElementById('ojsVariablesList').innerHTML = '<em style="color: #a0aec0;">Select a template to see available variables</em>';
        currentOJSTemplateKey = null;
        return;
    }

    currentOJSTemplateKey = templateKey;
    const template = currentOJSTemplates.find(t => t.key === templateKey);

    if (template) {
        // Store the base mailable key (for creating alternates)
        currentOJSMailableKey = template.mailableKey || templateKey;

        document.getElementById('ojsTemplateTitle').textContent = template.name;
        document.getElementById('ojsTemplateDesc').textContent = template.description || 'No description available';
        document.getElementById('ojsTemplateStatus').innerHTML = template.isCustom
            ? '<span style="color: #f59e0b;">⚠️ Customized</span>'
            : '<span style="color: #10b981;">✓ Default</span>';
        document.getElementById('ojsTemplateInfo').style.display = 'block';
        document.getElementById('loadOJSTemplateBtn').disabled = false;

        // Show/hide "Save As" button based on whether template supports alternates
        const saveAsBtn = document.getElementById('saveAsButton');
        if (saveAsBtn) {
            if (template.supportsTemplates) {
                saveAsBtn.style.display = 'flex'; // Show button for templates that support alternates
            } else {
                saveAsBtn.style.display = 'none'; // Hide button for single-edit templates
            }
        }

        // Load variables
        loadOJSVariables(templateKey);
    }
}

// Extract article/submission details from OJS template body
/**
 * Extract greeting from template body
 * Detects patterns like: Dear {$recipientName}, Hello {$authorName}, etc.
 * Returns both the greeting and the body with greeting removed
 */
function extractGreeting(templateBody) {
    // Common greeting patterns in OJS templates
    const greetingPatterns = [
        // Pattern: <p>Dear {$variable},</p> or <p>Hello {$name}</p>
        /<p>\s*(Dear|Hello|Hi|Greetings|Good\s+(?:morning|afternoon|evening))\s+\{?\$[^}]+\}?\s*,?\s*<\/p>/gi,
        // Pattern: Dear {$variable}, (without <p> tags)
        /^(Dear|Hello|Hi|Greetings|Good\s+(?:morning|afternoon|evening))\s+\{?\$[^}]+\}?\s*,?\s*$/gim,
        // Pattern: <p>Dear Reviewer,</p> or <p>Dear Author,</p>
        /<p>\s*(Dear|Hello|Hi)\s+(Reviewer|Author|Editor|Reader|Colleague|Dr\.|Professor)\s*,?\s*<\/p>/gi
    ];

    let detectedGreeting = '';
    let bodyWithoutGreeting = templateBody;
    let matchedPattern = null;

    // Try each pattern
    for (const pattern of greetingPatterns) {
        const match = templateBody.match(pattern);
        if (match && match[0]) {
            // Found a greeting, extract it
            detectedGreeting = match[0]
                .replace(/<\/?p>/gi, '') // Remove <p> tags
                .trim();
            matchedPattern = match[0];
            break;
        }
    }

    // If no pattern matched, check first line/paragraph for common greetings
    if (!detectedGreeting) {
        const firstParagraph = templateBody.match(/<p>([^<]+)<\/p>/i);
        if (firstParagraph && firstParagraph[1]) {
            const firstLine = firstParagraph[1].trim();
            if (/^(Dear|Hello|Hi|Greetings)/i.test(firstLine) && firstLine.length < 100) {
                detectedGreeting = firstLine;
                matchedPattern = firstParagraph[0];
            }
        }
    }

    // Remove the greeting from the body
    if (matchedPattern) {
        bodyWithoutGreeting = templateBody.replace(matchedPattern, '').trim();
    }

    return {
        greeting: detectedGreeting,
        bodyWithoutGreeting: bodyWithoutGreeting
    };
}

function extractArticleDetails(templateBody) {
    // List of article/submission-related OJS variables
    const articleVariables = [
        '{$submissionTitle}', '{$submissionAbstract}', '{$authorName}', '{$authors}',
        '{$submissionUrl}', '{$dateSubmitted}', '{$submissionId}',
        '{$reviewDueDate}', '{$reviewAssignmentUrl}', '{$reviewerName}',
        '{$editorName}', '{$decisionDescription}'
    ];

    // Check if template contains article/submission variables
    let hasArticleInfo = false;
    for (const variable of articleVariables) {
        if (templateBody.includes(variable)) {
            hasArticleInfo = true;
            break;
        }
    }

    if (!hasArticleInfo) {
        return {
            mainContent: templateBody,
            articleDetails: '',
            hasArticleInfo: false
        };
    }

    // Try to detect structured article information blocks
    // Common patterns in OJS templates:
    // - Lines starting with "Title:", "Submission:", "Article:", "Manuscript:"
    // - Bullet lists with article info
    // - Sections with multiple article variables close together

    let articleDetails = '';
    let mainContent = templateBody;

    // Pattern 1: Look for explicit sections with article info (lines with "Title:", "Authors:", etc.)
    const detailsPattern = /((?:Title|Submission|Article|Manuscript|Authors?|Abstract|URL|Review Due|Reviewer|Editor|Decision):\s*\{?\$[^}]+\}?.*\n?){2,}/gi;
    const detailsMatches = templateBody.match(detailsPattern);

    if (detailsMatches && detailsMatches.length > 0) {
        // Found structured details block
        articleDetails = detailsMatches[0].trim();
        mainContent = templateBody.replace(detailsMatches[0], '').trim();
    } else {
        // Pattern 2: Look for paragraphs/sections that contain multiple article variables
        const lines = templateBody.split('\n');
        const detailLines = [];
        const contentLines = [];

        for (let i = 0; i < lines.length; i++) {
            const line = lines[i];
            // Count article variables in this line
            let varCount = 0;
            for (const variable of articleVariables) {
                if (line.includes(variable)) {
                    varCount++;
                }
            }

            // If line has article variables or follows a line with variables, consider it a detail line
            if (varCount > 0 || (detailLines.length > 0 && i < lines.length - 1 && line.trim().length < 100)) {
                detailLines.push(line);
            } else if (line.trim().length > 0) {
                contentLines.push(line);
            }
        }

        if (detailLines.length > 0) {
            articleDetails = detailLines.join('\n').trim();
            mainContent = contentLines.join('\n').trim();
        } else {
            // Fallback: Generate article details from detected variables
            articleDetails = '';
            if (templateBody.includes('{$submissionTitle}')) {
                articleDetails += 'Title: {$submissionTitle}\n';
            }
            if (templateBody.includes('{$authors}') || templateBody.includes('{$authorName}')) {
                articleDetails += 'Authors: {$authors}\n';
            }
            if (templateBody.includes('{$submissionAbstract}')) {
                articleDetails += 'Abstract: {$submissionAbstract}\n';
            }
            if (templateBody.includes('{$submissionUrl}')) {
                articleDetails += 'View: {$submissionUrl}\n';
            }
        }
    }

    return {
        mainContent: mainContent || templateBody,
        articleDetails: articleDetails,
        hasArticleInfo: hasArticleInfo
    };
}

// Detect if template already has goValid design wrapper and extract components AND design settings
function unwrapDesignedTemplate(htmlBody) {
    console.log('=== unwrapDesignedTemplate v20251104f CALLED ===');

    // Check if template contains goValid design structure (has our wrapper div)
    const hasWrapper = htmlBody.includes('<!-- Header -->') && (htmlBody.includes('<!-- Content -->') || htmlBody.includes('<!-- Original Content -->')) && htmlBody.includes('<!-- Footer -->');

    console.log('Has wrapper comments?', hasWrapper);

    if (!hasWrapper) {
        // Not a designed template, return as-is
        return {
            isDesigned: false,
            content: {
                headerTitle: '',
                headerSubtitle: '',
                greeting: '',
                message: htmlBody,
                articleDetails: '',
                closing: '',
                footerSignature: '',
                footerSignatureName: ''
            },
            design: null
        };
    }

    console.log('Template already designed, unwrapping components and design settings...');

    // Parse the designed template and extract components
    const parser = new DOMParser();
    const doc = parser.parseFromString(htmlBody, 'text/html');

    // Extract main wrapper div
    const wrapperDiv = doc.querySelector('div[style*="font-family"]');

    // Extract header - find the div with <!-- Header --> comment
    let headerDiv = null;
    let contentDiv = null;
    let footerDiv = null;

    // Search by comment nodes directly
    const walker = doc.createTreeWalker(doc.body, NodeFilter.SHOW_COMMENT);
    let currentComment;
    while (currentComment = walker.nextNode()) {
        console.log('Found comment:', currentComment.textContent.trim());
        if (currentComment.textContent.trim() === 'Header' && !headerDiv) {
            headerDiv = currentComment.nextElementSibling;
            console.log('Header div found:', !!headerDiv);
        } else if (currentComment.textContent.trim() === 'Content' || currentComment.textContent.trim() === 'Original Content' && !contentDiv) {
            contentDiv = currentComment.nextElementSibling;
            console.log('Content div found:', !!contentDiv);
        } else if (currentComment.textContent.trim() === 'Footer' && !footerDiv) {
            footerDiv = currentComment.nextElementSibling;
            console.log('Footer div found:', !!footerDiv);
        }
    }

    console.log('After comment search - headerDiv:', !!headerDiv, 'contentDiv:', !!contentDiv, 'footerDiv:', !!footerDiv);

    // ==================== EXTRACT DESIGN SETTINGS ====================

    // Helper function to convert RGB to Hex
    function rgbToHex(rgb) {
        // Match rgb(r, g, b) or rgba(r, g, b, a)
        const match = rgb.match(/rgba?\((\d+),\s*(\d+),\s*(\d+)/);
        if (!match) return rgb; // Return as-is if not RGB

        const r = parseInt(match[1]);
        const g = parseInt(match[2]);
        const b = parseInt(match[3]);

        return '#' + [r, g, b].map(x => {
            const hex = x.toString(16);
            return hex.length === 1 ? '0' + hex : hex;
        }).join('');
    }

    // Helper function to extract CSS value from style attribute string
    function getStyleValue(element, property) {
        if (!element) return null;

        // Try to get from style object first
        const styleObj = element.style[property];
        if (styleObj) return styleObj;

        // If not found, parse the style attribute string
        const styleAttr = element.getAttribute('style');
        if (!styleAttr) return null;

        // Parse style string for the property
        const regex = new RegExp(property + '\\s*:\\s*([^;]+)', 'i');
        const match = styleAttr.match(regex);
        return match ? match[1].trim() : null;
    }

    const design = {};

    // Settings from wrapper
    if (wrapperDiv) {
        design.fontFamily = getStyleValue(wrapperDiv, 'font-family') || 'Arial, sans-serif';
        const maxWidth = getStyleValue(wrapperDiv, 'max-width');
        design.emailWidth = maxWidth ? parseInt(maxWidth) : 700;
        design.outerBgColor = getStyleValue(wrapperDiv, 'background') || '#f5f7fa';
    }

    // Header design settings
    if (headerDiv) {
        const headerBg = getStyleValue(headerDiv, 'background') || '';

        // Check if gradient or solid
        if (headerBg.includes('linear-gradient')) {
            design.headerBgType = 'gradient';
            // Extract gradient colors - could be hex (#123456) or rgb(r, g, b)
            const hexColors = headerBg.match(/#[0-9a-fA-F]{6}/g);
            const rgbColors = headerBg.match(/rgb\(\d+,\s*\d+,\s*\d+\)/g);

            if (hexColors && hexColors.length >= 2) {
                design.headerGradientStart = hexColors[0];
                design.headerGradientEnd = hexColors[1];
            } else if (rgbColors && rgbColors.length >= 2) {
                design.headerGradientStart = rgbToHex(rgbColors[0]);
                design.headerGradientEnd = rgbToHex(rgbColors[1]);
            } else {
                // Default gradient if not found
                design.headerGradientStart = '#667eea';
                design.headerGradientEnd = '#764ba2';
            }
        } else {
            design.headerBgType = 'solid';
            // Convert RGB to hex if needed
            design.headerBgColor = headerBg.includes('rgb') ? rgbToHex(headerBg) : (headerBg || '#667eea');
        }

        const headerColor = getStyleValue(headerDiv, 'color') || '#ffffff';
        design.headerTextColor = headerColor.includes('rgb') ? rgbToHex(headerColor) : headerColor;
        design.headerPadding = parseInt(getStyleValue(headerDiv, 'padding')) || 40;

        // Detect logo position and settings
        const logoImg = headerDiv.querySelector('img');
        design.showLogo = !!logoImg;
        if (logoImg) {
            design.logoMaxWidth = parseInt(getStyleValue(logoImg, 'max-width')) || 200;
        }

        // Detect layout
        const flexDiv = headerDiv.querySelector('div[style*="display: flex"]') ||
                         headerDiv.querySelector('div[style*="display:flex"]');
        if (flexDiv) {
            const flexDirection = getStyleValue(flexDiv, 'flex-direction') || '';
            if (flexDirection.includes('row-reverse')) {
                design.logoPosition = 'right';
            } else if (flexDirection.includes('row')) {
                design.logoPosition = 'left';
            }
            // Check if name is beside logo
            design.showNameBesideLogo = flexDiv.querySelectorAll('div').length > 1;
        } else {
            design.logoPosition = 'center';
            design.showNameBesideLogo = false;
        }
    }

    // Content design settings
    if (contentDiv) {
        const contentBg = getStyleValue(contentDiv, 'background') || '#ffffff';
        design.contentBgColor = contentBg.includes('rgb') ? rgbToHex(contentBg) : contentBg;

        const contentColor = getStyleValue(contentDiv, 'color') || '#2d3748';
        design.contentTextColor = contentColor.includes('rgb') ? rgbToHex(contentColor) : contentColor;

        design.contentPadding = parseInt(getStyleValue(contentDiv, 'padding')) || 40;
        design.fontSize = parseInt(getStyleValue(contentDiv, 'font-size')) || 16;
        design.lineHeight = parseFloat(getStyleValue(contentDiv, 'line-height')) || 1.6;

        // Detect article details box
        const detailsBox = contentDiv.querySelector('div[style*="border-radius"]');
        if (detailsBox) {
            design.showDetailsBox = true;
            const detailsBg = getStyleValue(detailsBox, 'background') || '#f7fafc';
            design.detailsBgColor = detailsBg.includes('rgb') ? rgbToHex(detailsBg) : detailsBg;
        } else {
            design.showDetailsBox = false;
        }
    }

    // Footer design settings
    if (footerDiv) {
        const footerBg = getStyleValue(footerDiv, 'background') || '#f7fafc';
        design.footerBgColor = footerBg.includes('rgb') ? rgbToHex(footerBg) : footerBg;

        const footerColor = getStyleValue(footerDiv, 'color') || '#718096';
        design.footerTextColor = footerColor.includes('rgb') ? rgbToHex(footerColor) : footerColor;

        design.footerPadding = parseInt(getStyleValue(footerDiv, 'padding')) || 30;

        const borderTop = getStyleValue(footerDiv, 'border-top') || '';
        design.footerBorderWidth = parseInt(borderTop) || 2;

        // Extract border color from borderTop style (could be hex or rgb)
        const hexMatch = borderTop.match(/#[0-9a-fA-F]{6}/);
        const rgbMatch = borderTop.match(/rgb\(\d+,\s*\d+,\s*\d+\)/);
        if (hexMatch) {
            design.footerBorderColor = hexMatch[0];
        } else if (rgbMatch) {
            design.footerBorderColor = rgbToHex(rgbMatch[0]);
        } else {
            design.footerBorderColor = '#e2e8f0';
        }

        // Detect if URL is shown
        design.showUrl = !!footerDiv.querySelector('a');

        // Extract link color
        const linkElement = footerDiv.querySelector('a');
        if (linkElement) {
            const linkColor = getStyleValue(linkElement, 'color') || '#667eea';
            design.footerLinkColor = linkColor.includes('rgb') ? rgbToHex(linkColor) : linkColor;
        }
    }

    // ==================== EXTRACT CONTENT ====================

    // Extract header title and subtitle
    let headerTitle = '';
    let headerSubtitle = '';
    if (headerDiv) {
        const h1 = headerDiv.querySelector('h1');
        const p = headerDiv.querySelector('p');
        headerTitle = h1?.textContent?.trim() || '';
        headerSubtitle = p?.textContent?.trim() || '';
    }

    // Extract content components
    let greeting = '';
    let message = '';
    let articleDetails = '';
    let closing = '';

    if (contentDiv) {
        // Get all direct children
        const children = Array.from(contentDiv.children);

        // First <p> is usually greeting (if short)
        const firstP = children.find(el => el.tagName === 'P');
        if (firstP && firstP.textContent.trim().length < 150) {
            greeting = firstP.textContent.trim();
        }

        // Find article details box (styled div with background and border-radius)
        const detailsBox = Array.from(contentDiv.querySelectorAll('div')).find(div =>
            div.style.background && div.style.borderRadius
        );
        if (detailsBox) {
            articleDetails = detailsBox.innerHTML.replace(/<br\s*\/?>/gi, '\n').replace(/<[^>]+>/g, '').trim();
        }

        // Find main message div (typically a div with margin)
        const messageDiv = children.find(el => el.tagName === 'DIV' && el !== detailsBox);
        if (messageDiv) {
            message = messageDiv.innerHTML.replace(/<br\s*\/?>/gi, '\n').replace(/<[^>]+>/g, '').trim();
        }

        // Last <p> is usually closing (if exists and different from greeting)
        const allPs = Array.from(contentDiv.querySelectorAll('p'));
        const lastP = allPs[allPs.length - 1];
        if (lastP && lastP !== firstP) {
            closing = lastP.textContent.trim();
        }
    }

    // Extract footer signature
    let footerSignature = '';
    let footerSignatureName = '';

    if (footerDiv) {
        const footerPs = Array.from(footerDiv.querySelectorAll('p'));
        // Filter out the URL paragraph
        const textPs = footerPs.filter(p => !p.querySelector('a'));
        if (textPs[0]) footerSignature = textPs[0].textContent.trim();
        if (textPs[1]) footerSignatureName = textPs[1].textContent.trim();
    }

    console.log('Unwrapped components and design:');
    console.log('Content:', {
        headerTitle,
        headerSubtitle,
        greeting: greeting.substring(0, 50),
        message: message.substring(0, 50),
        articleDetails: articleDetails.substring(0, 50),
        closing,
        footerSignature,
        footerSignatureName
    });
    console.log('Design settings:', design);

    // Debug: log raw style attributes
    if (headerDiv) {
        console.log('Header style attribute:', headerDiv.getAttribute('style'));
        console.log('Header extracted background:', getStyleValue(headerDiv, 'background'));
    }
    if (contentDiv) {
        console.log('Content style attribute:', contentDiv.getAttribute('style'));
        console.log('Content extracted background:', getStyleValue(contentDiv, 'background'));
    }
    if (footerDiv) {
        console.log('Footer style attribute:', footerDiv.getAttribute('style'));
        console.log('Footer extracted background:', getStyleValue(footerDiv, 'background'));
    }

    return {
        isDesigned: true,
        content: {
            headerTitle,
            headerSubtitle,
            greeting,
            message,
            articleDetails,
            closing,
            footerSignature,
            footerSignatureName
        },
        design
    };
}

// Load OJS template into designer
async function loadOJSTemplate() {
    if (!isGoValidAuthenticated) {
        alert('⚠️ GoValid Login Required\n\nYou must be logged in to load templates.\n\nClick "Login to GoValid" button in the top right corner.');
        showLoginModal();
        return;
    }

    if (!currentOJSTemplateKey) {
        alert('Please select a template first');
        return;
    }

    try {
        const response = await fetch(buildActionURL('getOJSEmailTemplate') + '&templateKey=' + currentOJSTemplateKey);
        const data = await response.json();

        if (data.status && data.content.template) {
            const template = data.content.template;

            // Update template name and subject
            document.getElementById('templateName').value = template.name;
            document.getElementById('templateSubject').value = template.subject;
            document.getElementById('content_subject').value = template.subject;

            // Check if template is already designed (has wrapper)
            const unwrapped = unwrapDesignedTemplate(template.body);

            if (unwrapped.isDesigned) {
                console.log('Template already designed, restoring all settings...');

                // Populate CONTENT fields
                document.getElementById('header_title').value = unwrapped.content.headerTitle || '{$contextName}';
                document.getElementById('header_subtitle').value = unwrapped.content.headerSubtitle || template.subject;
                document.getElementById('content_greeting').value = unwrapped.content.greeting;
                document.getElementById('content_message').value = unwrapped.content.message;
                document.getElementById('content_articleDetails').value = unwrapped.content.articleDetails;
                document.getElementById('content_showDetailsBox').checked = !!unwrapped.content.articleDetails;
                document.getElementById('content_closing').value = unwrapped.content.closing;
                document.getElementById('footer_signature').value = unwrapped.content.footerSignature;
                document.getElementById('footer_signatureName').value = unwrapped.content.footerSignatureName;

                // Populate DESIGN settings
                if (unwrapped.design) {
                    const d = unwrapped.design;

                    // Settings tab
                    if (d.fontFamily) document.getElementById('settings_fontFamily').value = d.fontFamily;
                    if (d.fontSize) document.getElementById('settings_fontSize').value = d.fontSize;
                    if (d.lineHeight) document.getElementById('settings_lineHeight').value = d.lineHeight;
                    if (d.emailWidth) document.getElementById('settings_emailWidth').value = d.emailWidth;
                    if (d.outerBgColor) document.getElementById('settings_outerBgColor').value = d.outerBgColor;

                    // Header tab
                    if (d.headerBgType) document.getElementById('header_bgType').value = d.headerBgType;
                    if (d.headerBgColor) document.getElementById('header_bgColor').value = d.headerBgColor;
                    if (d.headerGradientStart) document.getElementById('header_gradientStart').value = d.headerGradientStart;
                    if (d.headerGradientEnd) document.getElementById('header_gradientEnd').value = d.headerGradientEnd;
                    if (d.headerTextColor) document.getElementById('header_textColor').value = d.headerTextColor;
                    if (d.headerPadding) document.getElementById('header_padding').value = d.headerPadding;
                    if (d.showLogo !== undefined) document.getElementById('header_showLogo').checked = d.showLogo;
                    if (d.logoPosition) document.getElementById('header_logoPosition').value = d.logoPosition;
                    if (d.logoMaxWidth) document.getElementById('header_logoMaxWidth').value = d.logoMaxWidth;
                    if (d.showNameBesideLogo !== undefined) document.getElementById('header_showNameBesideLogo').checked = d.showNameBesideLogo;
                    toggleHeaderBgType(); // Update visibility of gradient/solid fields

                    // Content tab
                    if (d.contentBgColor) document.getElementById('content_bgColor').value = d.contentBgColor;
                    if (d.contentTextColor) document.getElementById('content_textColor').value = d.contentTextColor;
                    if (d.contentPadding) document.getElementById('content_padding').value = d.contentPadding;
                    if (d.showDetailsBox !== undefined) document.getElementById('content_showDetailsBox').checked = d.showDetailsBox;
                    if (d.detailsBgColor) document.getElementById('content_detailsBgColor').value = d.detailsBgColor;

                    // Footer tab
                    if (d.footerBgColor) document.getElementById('footer_bgColor').value = d.footerBgColor;
                    if (d.footerTextColor) document.getElementById('footer_textColor').value = d.footerTextColor;
                    if (d.footerPadding) document.getElementById('footer_padding').value = d.footerPadding;
                    if (d.footerBorderWidth) document.getElementById('footer_borderWidth').value = d.footerBorderWidth;
                    if (d.footerBorderColor) document.getElementById('footer_borderColor').value = d.footerBorderColor;
                    if (d.showUrl !== undefined) document.getElementById('footer_showUrl').checked = d.showUrl;
                    if (d.footerLinkColor) document.getElementById('footer_linkColor').value = d.footerLinkColor;

                    console.log('All design settings restored from template');
                }
            } else {
                console.log('Template not designed yet, processing as plain template...');

                // Set header title to journal name variable (default)
                document.getElementById('header_title').value = '{$contextName}';

                // Set header subtitle to the template subject
                document.getElementById('header_subtitle').value = template.subject;

                // Detect and extract greeting from template body
                const { greeting, bodyWithoutGreeting } = extractGreeting(template.body);
                if (greeting) {
                    console.log('Detected greeting:', greeting);
                    document.getElementById('content_greeting').value = greeting;
                } else {
                    // Default greeting if none detected
                    document.getElementById('content_greeting').value = 'Dear Reader,';
                }

                // Detect and extract article details from the template body (use body without greeting)
                const { mainContent, articleDetails, hasArticleInfo } = extractArticleDetails(bodyWithoutGreeting);

                // Place the main content in the message field
                document.getElementById('content_message').value = mainContent;

                // If article details detected, populate the article details field but keep checkbox unchecked by default
                if (hasArticleInfo && articleDetails) {
                    document.getElementById('content_articleDetails').value = articleDetails;
                    document.getElementById('content_showDetailsBox').checked = false;
                } else {
                    // Clear article details if none found
                    document.getElementById('content_articleDetails').value = '';
                    document.getElementById('content_showDetailsBox').checked = false;
                }

                // Clear closing message by default when loading OJS template
                document.getElementById('content_closing').value = '';
            }

            // Load variables for this template
            loadOJSVariables(currentOJSTemplateKey);

            // Show the save section
            document.getElementById('saveOJSTemplateSection').style.display = 'block';
            document.getElementById('loadedTemplateName').textContent = template.name;

            // Switch to Content tab so user can see and edit the body
            switchTab('content');

            // Update the preview to show the template body inside the current design
            updatePreview();

            alert('Template "' + template.name + '" loaded!\n\nThe template body is now in the Content section.\nYou can edit it and adjust the header/footer design, then save back to OJS.');

            console.log('Loaded OJS template:', template);
        } else {
            alert('Error: ' + (data.content.error || 'Failed to load template'));
        }
    } catch (error) {
        console.error('Error loading OJS template:', error);
        alert('Error loading template: ' + error.message);
    }
}

// Load variables for selected template
async function loadOJSVariables(templateKey) {
    try {
        const response = await fetch(buildActionURL('getOJSEmailVariables'));
        const data = await response.json();

        if (data.status && data.content.variables) {
            const variables = data.content.variables;
            const container = document.getElementById('ojsVariablesList');

            let html = '<div style="display: grid; gap: 8px;">';
            Object.keys(variables).forEach(varName => {
                html += `<div style="display: flex; justify-content: space-between; padding: 6px 8px; background: #f7fafc; border-radius: 4px; border: 1px solid #e2e8f0;">
                    <code style="color: #667eea; font-size: 11px; font-weight: 600;">${varName}</code>
                    <span style="color: #718096; font-size: 11px;">${variables[varName]}</span>
                </div>`;
            });
            html += '</div>';

            container.innerHTML = html;
        }
    } catch (error) {
        console.error('Error loading variables:', error);
    }
}

// Custom Template Functions
let currentCustomTemplates = [];
let currentCustomTemplateId = null;

async function loadCustomTemplatesList() {
    try {
        const response = await fetch(buildActionURL('getCustomEmailTemplates'));
        const data = await response.json();

        if (data.status && data.content.templates) {
            currentCustomTemplates = data.content.templates;
            const selector = document.getElementById('customTemplateSelector');

            selector.innerHTML = '<option value="">-- Select a template --</option>';

            data.content.templates.forEach(template => {
                const option = document.createElement('option');
                option.value = template.id;
                option.textContent = template.name || 'Untitled Template';
                option.dataset.subject = template.subject || '';
                option.dataset.created = template.created_at || '';
                selector.appendChild(option);
            });

            console.log('Loaded', data.content.templates.length, 'custom templates');
        } else {
            console.error('Failed to load custom templates:', data.content ? data.content.error : 'Unknown error');
        }
    } catch (error) {
        console.error('Error loading custom templates:', error);
    }
}

function filterCustomTemplates() {
    const searchInput = document.getElementById('customTemplateSearch');
    const selector = document.getElementById('customTemplateSelector');
    const searchTerm = searchInput.value.toLowerCase();

    const options = Array.from(selector.options);
    let visibleCount = 0;

    options.forEach(option => {
        if (!option.value) {
            return;
        }

        const text = option.textContent.toLowerCase();
        const subject = (option.dataset.subject || '').toLowerCase();

        if (text.includes(searchTerm) || subject.includes(searchTerm)) {
            option.style.display = '';
            visibleCount++;
        } else {
            option.style.display = 'none';
        }
    });

    if (searchTerm && visibleCount > 0) {
        selector.size = Math.min(visibleCount + 1, 10);
        selector.style.height = 'auto';
    } else {
        selector.size = 1;
        selector.style.height = '';
    }
}

function onCustomTemplateSelected() {
    const selector = document.getElementById('customTemplateSelector');
    const templateId = selector.value;

    selector.size = 1;
    selector.style.height = '';

    if (!templateId) {
        document.getElementById('customTemplateInfo').style.display = 'none';
        document.getElementById('loadCustomTemplateBtn').disabled = true;
        currentCustomTemplateId = null;
        return;
    }

    const template = currentCustomTemplates.find(t => t.id == templateId);

    if (template) {
        currentCustomTemplateId = templateId;
        document.getElementById('customTemplateTitle').textContent = template.name || 'Untitled Template';
        document.getElementById('customTemplateDesc').textContent = template.subject || 'No subject';
        document.getElementById('customTemplateDate').textContent = template.created_at || 'Unknown';
        document.getElementById('customTemplateInfo').style.display = 'block';
        document.getElementById('loadCustomTemplateBtn').disabled = false;
    }
}

async function loadCustomTemplate() {
    if (!isGoValidAuthenticated) {
        alert('⚠️ GoValid Login Required\n\nYou must be logged in to load templates.\n\nClick "Login to GoValid" button in the top right corner.');
        showLoginModal();
        return;
    }

    if (!currentCustomTemplateId) {
        alert('Please select a template first');
        return;
    }

    try {
        const response = await fetch(buildActionURL('getCustomEmailTemplate') + '&templateId=' + currentCustomTemplateId);
        const data = await response.json();

        if (data.status && data.content.template) {
            const template = data.content.template;

            // Load all template data
            document.getElementById('templateName').value = template.name || '';
            document.getElementById('templateSubject').value = template.subject || '';

            // Load content
            document.getElementById('content_greeting').value = template.greeting || '';
            document.getElementById('content_message').value = template.message || '';
            document.getElementById('content_articleDetails').value = template.article_details || '';
            document.getElementById('content_closing').value = template.closing || '';

            // Load design settings if available
            if (template.design) {
                const d = template.design;

                // Header settings
                if (d.headerBgType) document.getElementById('header_bgType').value = d.headerBgType;
                if (d.headerBgColor) document.getElementById('header_bgColor').value = d.headerBgColor;
                if (d.headerGradientStart) document.getElementById('header_gradientStart').value = d.headerGradientStart;
                if (d.headerGradientEnd) document.getElementById('header_gradientEnd').value = d.headerGradientEnd;
                if (d.headerTextColor) document.getElementById('header_textColor').value = d.headerTextColor;
                if (d.headerTitle) document.getElementById('header_title').value = d.headerTitle;
                if (d.headerSubtitle) document.getElementById('header_subtitle').value = d.headerSubtitle;
                if (d.showLogo !== undefined) document.getElementById('header_showLogo').checked = d.showLogo;
                if (d.logoPosition) document.getElementById('header_logoPosition').value = d.logoPosition;
                if (d.logoMaxWidth) document.getElementById('header_logoMaxWidth').value = d.logoMaxWidth;
                if (d.showNameBesideLogo !== undefined) document.getElementById('header_showNameBesideLogo').checked = d.showNameBesideLogo;
                if (d.headerPadding) document.getElementById('header_padding').value = d.headerPadding;

                // Content settings
                if (d.contentBgColor) document.getElementById('content_bgColor').value = d.contentBgColor;
                if (d.contentTextColor) document.getElementById('content_textColor').value = d.contentTextColor;
                if (d.contentPadding) document.getElementById('content_padding').value = d.contentPadding;
                if (d.showDetailsBox !== undefined) document.getElementById('content_showDetailsBox').checked = d.showDetailsBox;
                if (d.detailsBgColor) document.getElementById('content_detailsBgColor').value = d.detailsBgColor;

                // Footer settings
                if (d.footerBgColor) document.getElementById('footer_bgColor').value = d.footerBgColor;
                if (d.footerTextColor) document.getElementById('footer_textColor').value = d.footerTextColor;
                if (d.footerSignature) document.getElementById('footer_signature').value = d.footerSignature;
                if (d.footerPadding) document.getElementById('footer_padding').value = d.footerPadding;
                if (d.footerBorderWidth) document.getElementById('footer_borderWidth').value = d.footerBorderWidth;
                if (d.footerBorderColor) document.getElementById('footer_borderColor').value = d.footerBorderColor;
                if (d.showUrl !== undefined) document.getElementById('footer_showUrl').checked = d.showUrl;
                if (d.footerLinkColor) document.getElementById('footer_linkColor').value = d.footerLinkColor;

                // Settings
                if (d.emailWidth) document.getElementById('settings_emailWidth').value = d.emailWidth;
                if (d.fontFamily) document.getElementById('settings_fontFamily').value = d.fontFamily;
                if (d.fontSize) document.getElementById('settings_fontSize').value = d.fontSize;
                if (d.lineHeight) document.getElementById('settings_lineHeight').value = d.lineHeight;
            }

            // Update preview
            updatePreview();

            alert('Custom template "' + (template.name || 'Untitled') + '" loaded successfully!');

            console.log('Loaded custom template:', template);
        } else {
            alert('Error: ' + (data.content.error || 'Failed to load template'));
        }
    } catch (error) {
        console.error('Error loading custom template:', error);
        alert('Error loading template: ' + error.message);
    }
}

// Apply current design to OJS template
async function applyDesignToOJS() {
    const targetKey = document.getElementById('ojsTargetTemplate').value;

    if (!targetKey) {
        alert('Please select a target template');
        return;
    }

    if (!confirm('This will apply your current design to the OJS template "' + targetKey + '".\n\nThe original text content will be preserved, but wrapped with your design.\n\nContinue?')) {
        return;
    }

    try {
        // Get current design config
        const designConfig = getCurrentDesignConfig();

        const formData = new FormData();
        formData.append('action', 'applyDesignToOJSTemplate');
        formData.append('templateKey', targetKey);
        formData.append('designConfig', JSON.stringify(designConfig));

        const response = await fetch(buildActionURL('applyDesignToOJSTemplate'), {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.status) {
            alert('Success! Design applied to ' + targetKey);
            loadOJSTemplatesList(); // Refresh list
        } else {
            alert('Error: ' + (data.content.error || data.content.message || 'Failed to apply design'));
        }
    } catch (error) {
        console.error('Error applying design:', error);
        alert('Error: ' + error.message);
    }
}

// Get current design configuration
function getCurrentDesignConfig() {
    return {
        settings: {
            fontFamily: document.getElementById('settings_fontFamily').value,
            fontSize: parseInt(document.getElementById('settings_fontSize').value),
            lineHeight: document.getElementById('settings_lineHeight').value,
            emailWidth: parseInt(document.getElementById('settings_emailWidth').value),
            outerBgColor: document.getElementById('settings_outerBgColor').value
        },
        header: {
            bgType: document.getElementById('header_bgType').value,
            bgColor: document.getElementById('header_bgColor').value,
            gradientStart: document.getElementById('header_gradientStart').value,
            gradientEnd: document.getElementById('header_gradientEnd').value,
            textColor: document.getElementById('header_textColor').value,
            padding: parseInt(document.getElementById('header_padding').value),
            title: document.getElementById('header_title').value,
            subtitle: document.getElementById('header_subtitle').value,
            showLogo: document.getElementById('header_showLogo').checked,
            logoPosition: document.getElementById('header_logoPosition').value,
            logoMaxWidth: parseInt(document.getElementById('header_logoMaxWidth').value),
            showNameBesideLogo: document.getElementById('header_showNameBesideLogo').checked
        },
        content: {
            bgColor: document.getElementById('content_bgColor').value,
            textColor: document.getElementById('content_textColor').value,
            padding: parseInt(document.getElementById('content_padding').value),
            greeting: document.getElementById('content_greeting').value,
            message: document.getElementById('content_message').value,
            closing: document.getElementById('content_closing').value,
            showDetailsBox: document.getElementById('content_showDetailsBox').checked,
            articleDetails: document.getElementById('content_articleDetails').value,
            detailsBgColor: document.getElementById('content_detailsBgColor').value
        },
        footer: {
            bgColor: document.getElementById('footer_bgColor').value,
            textColor: document.getElementById('footer_textColor').value,
            linkColor: document.getElementById('footer_linkColor').value,
            padding: parseInt(document.getElementById('footer_padding').value),
            borderWidth: parseInt(document.getElementById('footer_borderWidth').value),
            borderColor: document.getElementById('footer_borderColor').value,
            signature: document.getElementById('footer_signature').value,
            signatureName: document.getElementById('footer_signatureName').value,
            showUrl: document.getElementById('footer_showUrl').checked
        }
    };
}

// Load design library
async function loadDesignLibrary() {
    try {
        const response = await fetch(buildActionURL('getDesignTemplates'));
        const data = await response.json();

        if (data.status && data.content.templates) {
            const library = document.getElementById('designLibrary');
            const templates = data.content.templates;

            let html = '<div style="display: grid; gap: 10px;">';
            Object.keys(templates).forEach(key => {
                const template = templates[key];
                html += `<button type="button" onclick="applyDesignLibraryTemplate('${key}')" class="etd-preset-btn" style="text-align: left; padding: 12px;">
                    <div style="font-weight: 600; margin-bottom: 4px;">${template.name}</div>
                    <div style="font-size: 11px; color: #718096;">${template.description}</div>
                </button>`;
            });
            html += '</div>';

            library.innerHTML = html;
        }
    } catch (error) {
        console.error('Error loading design library:', error);
    }
}

// Apply design from library
async function applyDesignLibraryTemplate(templateKey) {
    try {
        const response = await fetch(buildActionURL('getDesignTemplate') + '&templateKey=' + templateKey);
        const data = await response.json();

        if (data.status && data.content.template) {
            const config = data.content.template.config;

            // Apply to form fields
            applyDesignConfigToForm(config);
            updatePreview();

            alert('Design template "' + data.content.template.name + '" applied!');
        }
    } catch (error) {
        console.error('Error loading design template:', error);
        alert('Error: ' + error.message);
    }
}

// Apply design config to form
function applyDesignConfigToForm(config) {
    // Settings
    if (config.settings) {
        document.getElementById('settings_fontFamily').value = config.settings.fontFamily;
        document.getElementById('settings_fontSize').value = config.settings.fontSize;
        document.getElementById('settings_lineHeight').value = config.settings.lineHeight;
        document.getElementById('settings_emailWidth').value = config.settings.emailWidth;
        document.getElementById('settings_outerBgColor').value = config.settings.outerBgColor;
    }

    // Header
    if (config.header) {
        document.getElementById('header_bgType').value = config.header.bgType;
        document.getElementById('header_bgColor').value = config.header.bgColor;
        document.getElementById('header_gradientStart').value = config.header.gradientStart;
        document.getElementById('header_gradientEnd').value = config.header.gradientEnd;
        document.getElementById('header_textColor').value = config.header.textColor;
        document.getElementById('header_padding').value = config.header.padding;
        document.getElementById('header_title').value = config.header.title;
        document.getElementById('header_subtitle').value = config.header.subtitle || '';
        document.getElementById('header_showLogo').checked = config.header.showLogo;
        document.getElementById('header_logoPosition').value = config.header.logoPosition;
        document.getElementById('header_logoMaxWidth').value = config.header.logoMaxWidth;
        document.getElementById('header_showNameBesideLogo').checked = config.header.showNameBesideLogo;
        toggleHeaderBgType();
    }

    // Content
    if (config.content) {
        document.getElementById('content_bgColor').value = config.content.bgColor;
        document.getElementById('content_textColor').value = config.content.textColor;
        document.getElementById('content_padding').value = config.content.padding;
        document.getElementById('content_greeting').value = config.content.greeting;
        document.getElementById('content_message').value = config.content.message;
        document.getElementById('content_closing').value = config.content.closing;
        document.getElementById('content_showDetailsBox').checked = config.content.showDetailsBox;
        document.getElementById('content_detailsBgColor').value = config.content.detailsBgColor;
    }

    // Footer
    if (config.footer) {
        document.getElementById('footer_bgColor').value = config.footer.bgColor;
        document.getElementById('footer_textColor').value = config.footer.textColor;
        document.getElementById('footer_linkColor').value = config.footer.linkColor;
        document.getElementById('footer_padding').value = config.footer.padding;
        document.getElementById('footer_borderWidth').value = config.footer.borderWidth;
        document.getElementById('footer_borderColor').value = config.footer.borderColor;
        document.getElementById('footer_signature').value = config.footer.signature;
        document.getElementById('footer_signatureName').value = config.footer.signatureName;
        document.getElementById('footer_showUrl').checked = config.footer.showUrl;
    }
}

// Save the current design + content back to OJS
async function saveOJSTemplate() {
    if (!isGoValidAuthenticated) {
        alert('⚠️ GoValid Login Required\n\nYou must be logged in to save templates.\n\nClick "Login to GoValid" button in the top right corner.');
        showLoginModal();
        return;
    }

    if (!currentOJSTemplateKey) {
        alert('No template loaded. Please load a template first.');
        return;
    }

    if (!confirm('Save the current design and content to OJS template "' + currentOJSTemplateKey + '"?\n\nThis will update the email template in OJS.')) {
        return;
    }

    try {
        // Get the current design configuration
        const designConfig = getCurrentDesignConfig();

        // Generate the full HTML email by wrapping the content with header and footer
        const fullHTML = generateFullEmailHTML(designConfig);

        // Get the subject
        const subject = document.getElementById('content_subject').value || document.getElementById('templateSubject').value;

        // Save to OJS
        const formData = new FormData();
        formData.append('action', 'saveOJSEmailTemplate');
        formData.append('templateKey', currentOJSTemplateKey);
        formData.append('subject', subject);
        formData.append('body', fullHTML);

        const response = await fetch(buildActionURL('saveOJSEmailTemplate'), {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.status) {
            alert('Success! Template saved to OJS.\n\nThe email template has been updated and will be used for OJS emails.');
            // Reload the template list to refresh any changes
            loadOJSTemplatesList();
        } else {
            alert('Error: ' + (data.content.error || 'Failed to save template'));
        }
    } catch (error) {
        console.error('Error saving OJS template:', error);
        alert('Error saving template: ' + error.message);
    }
}

// Save As - Create a new template with a custom key
async function saveAsOJSTemplate() {
    if (!isGoValidAuthenticated) {
        alert('⚠️ GoValid Login Required\n\nYou must be logged in to create templates.\n\nClick "Login to GoValid" button in the top right corner.');
        showLoginModal();
        return;
    }

    if (!currentOJSTemplateKey) {
        alert('No template loaded. Please load a template first.');
        return;
    }

    // Prompt for new template key
    const newTemplateKey = prompt('Enter a unique key for the new template:\n\n(Use letters, numbers, underscores, and hyphens)\nExamples: my_custom_template, editorial-reminder-v2, custom_email_1\n\nNote: This will create a new custom email template in OJS.', currentOJSTemplateKey + '_custom');

    if (!newTemplateKey) {
        return; // User cancelled
    }

    // Validate template key format (alphanumeric, underscores, hyphens only)
    if (!/^[a-zA-Z0-9_-]+$/.test(newTemplateKey)) {
        alert('Invalid template key format.\n\nPlease use only letters, numbers, underscores (_), and hyphens (-).\n\nExamples: my_custom_template, editorial-reminder-v2');
        return;
    }

    // Prompt for template name
    const templateName = prompt('Enter a display name for the new template:', document.getElementById('templateName').value + ' (Custom)');

    if (!templateName) {
        return; // User cancelled
    }

    // Ask if this should be an alternate template (to show in native OJS UI)
    // Use the base mailable key (handles case where current template is already an alternate)
    const baseMailableKey = currentOJSMailableKey || currentOJSTemplateKey;

    const makeAlternate = confirm('Make this an ALTERNATE template?\n\n✓ YES - This will be an alternate of "' + baseMailableKey + '"\n        and will appear in OJS native email management UI\n\n✗ NO - This will be a standalone template\n        (only visible in goValid Designer)');

    const alternateTo = makeAlternate ? baseMailableKey : null;

    const confirmMsg = makeAlternate
        ? 'Create new ALTERNATE template?\n\nKey: ' + newTemplateKey + '\nName: ' + templateName + '\nAlternate of: ' + baseMailableKey + '\n\nThis will appear in OJS native email management UI under "' + baseMailableKey + '".'
        : 'Create new STANDALONE template?\n\nKey: ' + newTemplateKey + '\nName: ' + templateName + '\n\nThis will only be visible in goValid Designer (not in OJS native UI).';

    if (!confirm(confirmMsg)) {
        return;
    }

    try {
        // Get the current design configuration
        const designConfig = getCurrentDesignConfig();

        // Generate the full HTML email by wrapping the content with header and footer
        const fullHTML = generateFullEmailHTML(designConfig);

        // Get the subject
        const subject = document.getElementById('content_subject').value || document.getElementById('templateSubject').value;

        // Save to OJS with new key
        const formData = new FormData();
        formData.append('action', 'saveOJSEmailTemplate');
        formData.append('templateKey', newTemplateKey);
        formData.append('templateName', templateName);
        formData.append('subject', subject);
        formData.append('body', fullHTML);
        if (alternateTo) {
            formData.append('alternateTo', alternateTo);
        }

        const response = await fetch(buildActionURL('saveOJSEmailTemplate'), {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.status) {
            alert('Success! New template "' + templateName + '" created in OJS.\n\nKey: ' + newTemplateKey + '\n\nThe new template is now available in OJS.');

            // Reload the template list to show the new template
            await loadOJSTemplatesList();

            // Switch to the new template
            currentOJSTemplateKey = newTemplateKey;

            // Update UI elements if they exist
            const selectElement = document.getElementById('ojsTemplateSelect');
            if (selectElement) {
                selectElement.value = newTemplateKey;
            }

            const loadedNameElement = document.getElementById('loadedTemplateName');
            if (loadedNameElement) {
                loadedNameElement.textContent = templateName;
            }

            const templateNameElement = document.getElementById('templateName');
            if (templateNameElement) {
                templateNameElement.value = templateName;
            }
        } else {
            alert('Error: ' + (data.content.error || 'Failed to create template'));
        }
    } catch (error) {
        console.error('Error creating new OJS template:', error);
        alert('Error creating template: ' + error.message);
    }
}

// Generate the full HTML email with header, content, and footer
function generateFullEmailHTML(config) {
    // Build header background style
    let headerBgStyle = '';
    if (config.header.bgType === 'gradient') {
        headerBgStyle = `background: linear-gradient(135deg, ${config.header.gradientStart} 0%, ${config.header.gradientEnd} 100%);`;
    } else {
        headerBgStyle = `background: ${config.header.bgColor};`;
    }

    // Generate header content with logo positioning
    let headerContent = '';
    const logoPosition = config.header.logoPosition || 'center';
    const showLogo = config.header.showLogo;
    const showNameBesideLogo = config.header.showNameBesideLogo;
    const logoMaxWidth = config.header.logoMaxWidth || 200;

    // Get journal logo URL from window (set by PHP)
    const journalLogoUrl = window.journalLogoUrl || '';
    const journalName = window.journalName || '{$contextName}';

    // Logo HTML with actual URL
    const logoHTML = showLogo && journalLogoUrl ? `<img src="${journalLogoUrl}" alt="${journalName}" style="max-width: ${logoMaxWidth}px; height: auto; display: block;">` : '';

    if (logoPosition === 'center') {
        headerContent = `
        <div style="text-align: center;">
            ${showLogo ? `<div style="margin-bottom: 20px; display: flex; justify-content: center;">${logoHTML}</div>` : ''}
            ${config.header.title ? `<h1 style="margin: 0; color: ${config.header.textColor}; font-size: 28px; font-weight: 600;">${config.header.title}</h1>` : ''}
            ${config.header.subtitle ? `<p style="margin: 10px 0 0 0; font-size: 18px; opacity: 0.9;">${config.header.subtitle}</p>` : ''}
        </div>`;
    } else if (logoPosition === 'left' || logoPosition === 'right') {
        const flexDirection = logoPosition === 'left' ? 'row' : 'row-reverse';
        const textAlign = logoPosition === 'left' ? 'left' : 'right';

        if (showNameBesideLogo && showLogo) {
            headerContent = `
            <div style="display: flex; align-items: center; gap: 20px; flex-direction: ${flexDirection};">
                <div style="flex-shrink: 0;">${logoHTML}</div>
                <div style="flex: 1; text-align: ${textAlign};">
                    ${config.header.title ? `<h1 style="margin: 0; color: ${config.header.textColor}; font-size: 28px; font-weight: 600;">${config.header.title}</h1>` : ''}
                    ${config.header.subtitle ? `<p style="margin: 10px 0 0 0; font-size: 18px; opacity: 0.9;">${config.header.subtitle}</p>` : ''}
                </div>
            </div>`;
        } else {
            const alignItems = logoPosition === 'left' ? 'flex-start' : 'flex-end';
            headerContent = `
            <div style="display: flex; flex-direction: column; align-items: ${alignItems};">
                ${showLogo ? `<div style="margin-bottom: 20px;">${logoHTML}</div>` : ''}
                <div style="text-align: ${textAlign}; width: 100%;">
                    ${config.header.title ? `<h1 style="margin: 0; color: ${config.header.textColor}; font-size: 28px; font-weight: 600;">${config.header.title}</h1>` : ''}
                    ${config.header.subtitle ? `<p style="margin: 10px 0 0 0; font-size: 18px; opacity: 0.9;">${config.header.subtitle}</p>` : ''}
                </div>
            </div>`;
        }
    } else {
        // Fallback to center
        headerContent = `
        <div style="text-align: center;">
            ${config.header.title ? `<h1 style="margin: 0; color: ${config.header.textColor}; font-size: 28px; font-weight: 600;">${config.header.title}</h1>` : ''}
            ${config.header.subtitle ? `<p style="margin: 10px 0 0 0; font-size: 18px; opacity: 0.9;">${config.header.subtitle}</p>` : ''}
        </div>`;
    }

    // Build the complete HTML
    const html = `
<div style="font-family: ${config.settings.fontFamily}; max-width: ${config.settings.emailWidth}px; margin: 0 auto; background: ${config.settings.outerBgColor};">
    <!-- Header -->
    <div style="${headerBgStyle} color: ${config.header.textColor}; padding: ${config.header.padding}px;">
        ${headerContent}
    </div>

    <!-- Content -->
    <div style="padding: ${config.content.padding}px; background: ${config.content.bgColor}; color: ${config.content.textColor}; line-height: ${config.settings.lineHeight}; font-size: ${config.settings.fontSize}px;">
        ${config.content.greeting ? `<p style="margin: 0 0 15px 0;">${config.content.greeting}</p>` : ''}
        <div style="margin: 15px 0;">
            ${config.content.message}
        </div>
        ${config.content.showDetailsBox && config.content.articleDetails ? `
        <div style="margin: 20px 0; padding: 15px; background: ${config.content.detailsBgColor}; border-radius: 6px; border-left: 3px solid ${config.header.gradientStart || config.header.bgColor};">
            ${config.content.articleDetails.replace(/\n/g, '<br>')}
        </div>` : ''}
        ${config.content.closing ? `<p style="margin: 15px 0 0 0;">${config.content.closing}</p>` : ''}
    </div>

    <!-- Footer -->
    <div style="background: ${config.footer.bgColor}; padding: ${config.footer.padding}px; text-align: center; border-top: ${config.footer.borderWidth}px solid ${config.footer.borderColor};">
        ${config.footer.signature ? `<p style="margin: 0 0 10px 0; font-size: ${config.settings.fontSize}px; color: ${config.footer.textColor};">${config.footer.signature}</p>` : ''}
        ${config.footer.signatureName ? `<p style="margin: 0 0 15px 0; font-size: ${config.settings.fontSize}px; color: ${config.footer.textColor}; font-weight: bold;">${config.footer.signatureName}</p>` : ''}
        ${config.footer.showUrl ? `<p style="margin: 0; font-size: 14px; color: ${config.footer.textColor};"><a href="{$contextUrl}" style="color: ${config.footer.linkColor}; text-decoration: none;">{$contextUrl}</a></p>` : ''}
    </div>
</div>`;

    return html.trim();
}

// Load templates when page loads
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(() => {
        loadOJSTemplatesList();
        loadCustomTemplatesList();
    }, 500);
});

{/literal}
</script>

{* Send Email Modal *}
<div id="sendEmailModal" class="etd-modal" style="display: none;">
    <div class="etd-modal-overlay"></div>
    <div class="etd-modal-content">
        <div class="etd-modal-header">
            <h3>Send Email</h3>
            <button type="button" class="etd-modal-close" onclick="closeSendEmailModal()">&times;</button>
        </div>
        <div class="etd-modal-body">
            <div class="etd-form-group">
                <label for="testEmailInput">To (Email Address) *</label>
                <div class="etd-input-wrapper">
                    <input type="email" id="testEmailInput" class="etd-input etd-autocomplete-input" placeholder="Enter recipient email address" required autocomplete="off" />
                    <div id="testEmailAutocomplete" class="etd-autocomplete-dropdown"></div>
                </div>
            </div>
            <div class="etd-form-group">
                <label for="ccEmailInput">CC (Carbon Copy)</label>
                <div class="etd-input-wrapper">
                    <input type="text" id="ccEmailInput" class="etd-input etd-autocomplete-input" placeholder="Enter CC email addresses (comma-separated)" autocomplete="off" />
                    <div id="ccEmailAutocomplete" class="etd-autocomplete-dropdown"></div>
                </div>
                <small style="color: #718096; font-size: 12px;">Optional. Separate multiple emails with commas.</small>
            </div>
            <div class="etd-form-group">
                <label for="bccEmailInput">BCC (Blind Carbon Copy)</label>
                <div class="etd-input-wrapper">
                    <input type="text" id="bccEmailInput" class="etd-input etd-autocomplete-input" placeholder="Enter BCC email addresses (comma-separated)" autocomplete="off" />
                    <div id="bccEmailAutocomplete" class="etd-autocomplete-dropdown"></div>
                </div>
                <small style="color: #718096; font-size: 12px;">Optional. Separate multiple emails with commas.</small>
            </div>
            <div class="etd-form-group">
                <label for="attachmentInput">Attachments (Optional)</label>
                <div class="etd-file-upload-wrapper">
                    <input type="file" id="attachmentInput" class="etd-file-input" accept=".pdf,.jpg,.jpeg,.png,.gif" multiple style="display: none;" onchange="handleAttachmentSelection(event)" />
                    <button type="button" class="etd-btn etd-btn-secondary" onclick="document.getElementById('attachmentInput').click()">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="vertical-align: middle; margin-right: 5px;">
                            <path d="M21.44 11.05l-9.19 9.19a6 6 0 0 1-8.49-8.49l9.19-9.19a4 4 0 0 1 5.66 5.66l-9.2 9.19a2 2 0 0 1-2.83-2.83l8.49-8.48"></path>
                        </svg>
                        Choose Files
                    </button>
                    <span id="attachmentFileCount" style="margin-left: 10px; color: #718096; font-size: 13px;">No files selected</span>
                </div>
                <div id="attachmentsList" style="margin-top: 8px;"></div>
                <small style="color: #718096; font-size: 12px;">Max 5MB per file. Allowed: PDF, JPG, PNG, GIF</small>
                <div id="attachmentError" style="display: none; margin-top: 6px; padding: 8px; background: #fee; border: 1px solid #fcc; border-radius: 4px; color: #c00; font-size: 12px;"></div>
            </div>
            <p class="etd-modal-note">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="vertical-align: middle;">
                    <circle cx="12" cy="12" r="10"></circle>
                    <line x1="12" y1="16" x2="12" y2="12"></line>
                    <line x1="12" y1="8" x2="12.01" y2="8"></line>
                </svg>
                The email will be sent with the current template design and subject.
            </p>
            <div id="modalAuthWarning" style="display: none; margin-top: 12px; padding: 12px; background: #fff3cd; border: 1px solid #ffc107; border-radius: 6px; color: #856404; font-size: 13px;"></div>
        </div>
        <div class="etd-modal-footer">
            <button type="button" class="etd-btn etd-btn-secondary" onclick="closeSendEmailModal()">Cancel</button>
            <button type="button" class="etd-btn etd-btn-primary" id="modalSendEmailBtn" onclick="submitSendEmail()">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="vertical-align: middle; margin-right: 5px;">
                    <line x1="22" y1="2" x2="11" y2="13"></line>
                    <polygon points="22 2 15 22 11 13 2 9 22 2"></polygon>
                </svg>
                Send Email
            </button>
        </div>
    </div>
</div>

<script src="{$baseUrl}/plugins/generic/goValidOJS/js/designer-auth.js?v=20251215CREDIT"></script>
<script src="{$baseUrl}/plugins/generic/goValidOJS/js/email-designer.js?v=20251215CREDIT"></script>
<link rel="stylesheet" href="{$baseUrl}/plugins/generic/goValidOJS/css/designer.css?v=20251104AD">

<script>
{literal}
// Override updateUIAuthState after designer-auth.js is loaded
// The certificate designer version references canvas which doesn't exist in email designer
function updateUIAuthState() {
    console.log('Email Designer: updateUIAuthState called - delegating to updateAccessControlUI');
    if (typeof updateAccessControlUI === 'function') {
        updateAccessControlUI();
    }
}
{/literal}
</script>

</body>
</html>
