# Default Certificate Templates

This directory contains pre-designed certificate templates that are shipped with the goValidOJS plugin. These templates are available to all users and can be loaded, customized, and used as starting points for creating publication certificates.

## Available Templates

### 1. Certificate - Basic (`certificate_basic.json`)
- **Style**: Classic and professional
- **Features**: Double border, centered layout
- **Best for**: General publication certificates
- **Colors**: Dark blue/gray scheme
- **Typography**: Georgia (serif)

### 2. Certificate - Elegant (`certificate_elegant.json`)
- **Style**: Elegant with decorative elements
- **Features**: Golden borders, corner ornaments
- **Best for**: Special achievements, awards
- **Colors**: Brown/gold scheme
- **Typography**: Palatino (serif)

### 3. Certificate - Modern (`certificate_modern.json`)
- **Style**: Contemporary minimalist
- **Features**: Blue accent border, left-aligned text
- **Best for**: Modern journals, tech publications
- **Colors**: Blue and gray scheme
- **Typography**: Calibri (sans-serif)

### 4. Diploma - Classic (`diploma_classic.json`)
- **Style**: Traditional formal diploma
- **Features**: Triple border, golden accents, formal layout
- **Best for**: Formal recognitions, academic honors
- **Colors**: Gold and beige scheme
- **Typography**: Times New Roman (serif)

### 5. Award - Simple (`award_simple.json`)
- **Style**: Clean and contemporary
- **Features**: Green accents, minimalist design
- **Best for**: Excellence awards, recognitions
- **Colors**: Green and white scheme
- **Typography**: Century Gothic (sans-serif)

## Template Variables

All templates support the following placeholder variables that are automatically replaced:

- `{{article_title}}` - Title of the published article
- `{{author_name}}` - Name of the article author
- `{{journal_name}}` - Name of the journal
- `{{volume}}` - Volume number
- `{{issue}}` - Issue number
- `{{year}}` - Publication year
- `{{publication_date}}` - Full publication date
- `{{doi}}` - Digital Object Identifier (if available)
- `{{identifier}}` - Article identifier/code

## Template Structure

Each template JSON file contains:

```json
{
  "name": "Template Display Name",
  "description": "Brief description of the template",
  "category": "certificate|diploma|award",
  "orientation": "landscape|portrait",
  "author": "GoValid OJS",
  "version": "1.0",
  "thumbnail": "preview_image.png",
  "data": {
    "version": "5.1.0",
    "objects": [...]
  }
}
```

### Fields Explained

- **name**: Display name shown in the template gallery
- **description**: Help text describing the template's style and use case
- **category**: Template category (certificate, diploma, award, etc.)
- **orientation**: Page orientation (landscape or portrait)
- **author**: Template creator/source
- **version**: Template version number
- **thumbnail**: Preview image filename (optional)
- **data**: Fabric.js canvas JSON containing all design elements

## How Templates Are Loaded

1. **Backend**: PHP reads JSON files from this directory
2. **AJAX endpoint**: `/ajax?action=listDefaultTemplates` returns all templates
3. **Frontend**: JavaScript displays templates in the Template Gallery
4. **User action**: Clicking "Use Template" loads the design onto the canvas

## Adding New Templates

To add new default templates:

1. Create a certificate design in the Designer
2. Click "Save Template" to save it
3. Export the template JSON from the database:
   ```sql
   SELECT setting_value FROM plugin_settings
   WHERE plugin_name='govalidojs' AND setting_name='savedTemplates';
   ```
4. Extract your template from the JSON
5. Wrap it in the template structure (see above)
6. Save as a new `.json` file in this directory
7. Restart Apache or clear OJS cache

## Template Guidelines

When creating new templates:

- **Use template variables** instead of hard-coded text
- **Test with long text** to ensure fields don't overflow
- **Keep it printable**: Use standard paper sizes (A4 landscape = 1123x794px)
- **Use web-safe fonts**: Arial, Georgia, Times New Roman, Verdana, etc.
- **Provide contrast**: Ensure text is readable
- **Leave margins**: Minimum 40px from edges
- **Include signature lines**: For editor/authority signatures
- **Add date fields**: For publication or issue dates

## Maintenance

- **Location**: `/var/www/pub/plugins/generic/goValidOJS/default_templates/`
- **Permissions**: Read-only for web server
- **Version control**: Track changes in Git
- **Updates**: Distributed with plugin updates

## Support

For template customization or issues:
1. Check the OJS Integration Guide
2. Review Fabric.js documentation for object properties
3. Contact plugin maintainer

---

**Last Updated**: November 2, 2025
**Template Format Version**: 1.0
**Fabric.js Version**: 5.1.0
