    const A4_WIDTH_MM = 210;
    const A4_HEIGHT_MM = 297;
    const MM_TO_PX = 3.7795275591; // 96 DPI
    
    const A4_WIDTH_PX = Math.round(A4_WIDTH_MM * MM_TO_PX); // 794px
    const A4_HEIGHT_PX = Math.round(A4_HEIGHT_MM * MM_TO_PX); // 1123px
    
    // Helper function to get clean URL without HTML entities
    function getCleanURL() {
        const decodedHref = window.location.href.replace(/&amp;/g, '&');
        return decodedHref;
    }
    
    // Helper function to build clean AJAX URL
    function getAjaxURL() {
        // Use direct AJAX endpoint instead of going through grid handler
        const pluginPath = window.pluginAjaxUrl;
        console.log('AJAX Base URL:', pluginPath);
        return pluginPath;
    }

    function buildActionURL(action) {
        let baseURL = getAjaxURL();
        // Add action as a parameter
        const actionURL = baseURL + '?action=' + action;
        console.log('Action URL for ' + action + ':', actionURL);
        return actionURL;
    }
    
    // Create a QR code placeholder image
    function createQRPlaceholder() {
        // Create a simple QR code-like pattern as base64 data URL
        const canvas = document.createElement('canvas');
        canvas.width = 100;
        canvas.height = 100;
        const ctx = canvas.getContext('2d');
        
        // Fill with white background
        ctx.fillStyle = '#ffffff';
        ctx.fillRect(0, 0, 100, 100);
        
        // Draw QR-like pattern
        ctx.fillStyle = '#000000';
        
        // Corner squares
        ctx.fillRect(0, 0, 20, 20);
        ctx.fillRect(80, 0, 20, 20);
        ctx.fillRect(0, 80, 20, 20);
        
        // Random pattern to look like QR
        for (let i = 0; i < 100; i += 5) {
            for (let j = 0; j < 100; j += 5) {
                if (Math.random() > 0.6) {
                    ctx.fillRect(i, j, 4, 4);
                }
            }
        }
        
        // Add text overlay
        ctx.fillStyle = 'rgba(255, 255, 255, 0.8)';
        ctx.fillRect(25, 40, 50, 20);
        ctx.fillStyle = '#000000';
        ctx.font = '10px Arial';
        ctx.textAlign = 'center';
        ctx.fillText('QR CODE', 50, 52);
        
        return canvas.toDataURL();
    }
    
    // Generate final certificate with real QR code
    async function generateFinalCertificate() {
        if (!goValidAuth.isAuthenticated) {
            alert('Please authenticate with GoValid first to generate certificates.');
            return;
        }
        
        // Get current content selections
        const issueSelect = document.getElementById('content_issue_select');
        const articleSelect = document.getElementById('content_article_select');
        const reviewerSelect = document.getElementById('content_reviewer_name');

        if (!issueSelect.value || !articleSelect.value || !reviewerSelect.value) {
            alert('Please select an issue, article, and reviewer before generating the certificate.');
            return;
        }

        // Show loading
        const originalText = document.getElementById('generateCertificate').innerHTML;
        document.getElementById('generateCertificate').innerHTML = '<i class="fa fa-spinner fa-spin"></i> Generating...';
        document.getElementById('generateCertificate').disabled = true;

        try {
            // Get all replacement data (same as preview but will generate real QR)
            const issueData = JSON.parse(issueSelect.options[issueSelect.selectedIndex].dataset.issue || '{}');
            const articleData = JSON.parse(articleSelect.options[articleSelect.selectedIndex].dataset.article || '{}');

            // Get reviewer data - content_reviewer_name is a select with options that have dataset
            const reviewerOption = reviewerSelect.options[reviewerSelect.selectedIndex];
            const reviewerData = reviewerOption ? {
                name: reviewerOption.text,
                email: reviewerOption.dataset.email || '',
                id: reviewerOption.dataset.reviewerId || ''
            } : {};
            
            // Get QR settings values
            const qrIdentifierValue = document.getElementById('qr_identifier_code')?.value;
            const qrIdentifier = qrIdentifierValue && qrIdentifierValue.trim() !== '' ? qrIdentifierValue.trim() : '{QR_IDENTIFIER}';

            // Check if date toggles are enabled before getting values
            const qrStartDateToggle = document.getElementById('qr_start_date_toggle')?.checked;
            const qrEndDateToggle = document.getElementById('qr_end_date_toggle')?.checked;
            const qrStartDate = qrStartDateToggle ? document.getElementById('qr_start_date')?.value : null;
            const qrEndDate = qrEndDateToggle ? document.getElementById('qr_end_date')?.value : null;

            const replacements = {
                '{ISSUE_TITLE}': issueData.title || 'Issue Title',
                '{ISSUE_VOLUME}': issueData.volume || 'Volume',
                '{ISSUE_NUMBER}': issueData.number || 'Number',
                '{ISSUE_YEAR}': issueData.year || new Date().getFullYear(),
                '{ARTICLE_TITLE}': articleData.title || 'Article Title',
                '{ARTICLE_DOI}': articleData.doi || 'DOI not available',
                '{ARTICLE_PAGES}': articleData.pages || 'Pages not specified',
                '{REVIEWER_NAME}': reviewerData.name || reviewerSelect.value || 'Reviewer Name',
                '{REVIEWER_EMAIL}': reviewerData.email || 'Email not available',
                '{CURRENT_DATE}': new Date().toLocaleDateString(),
                '{SUBMISSION_ID}': articleData.id || 'No ID',
                '{ISSN_ONLINE}': (window.goValidJournalInfo && window.goValidJournalInfo.onlineIssn) ? window.goValidJournalInfo.onlineIssn : '',
                '{ISSN_PRINT}': (window.goValidJournalInfo && window.goValidJournalInfo.printIssn) ? window.goValidJournalInfo.printIssn : '',
                '{QR_ID}': (typeof getQRSettings === 'function' && getQRSettings().formatted_uuid) ? getQRSettings().formatted_uuid : '{QR_ID}',
                '{QR_IDENTIFIER}': qrIdentifier,
                '{QR_ISSUE_DATE}': qrStartDate ? new Date(qrStartDate).toLocaleDateString('en-US', { year: 'numeric', month: 'short', day: 'numeric' }) : new Date().toLocaleDateString('en-US', { year: 'numeric', month: 'short', day: 'numeric' }),
                '{QR_EXPIRE_DATE}': qrEndDate ? new Date(qrEndDate).toLocaleDateString('en-US', { year: 'numeric', month: 'short', day: 'numeric' }) : new Date(new Date().setFullYear(new Date().getFullYear() + 1)).toLocaleDateString('en-US', { year: 'numeric', month: 'short', day: 'numeric' })
            };

            // Generate real QR code
            console.log('Generating real QR code for final certificate...');
            const qrResult = await generateCertificateQR(replacements);

            // Store formatted_uuid (QR ID) if available
            if (qrResult.formatted_uuid) {
                if (typeof getQRSettings === 'function') {
                    getQRSettings().formatted_uuid = qrResult.formatted_uuid;
                }
                replacements['{QR_ID}'] = qrResult.formatted_uuid;
                console.log('Stored QR ID (formatted_uuid):', qrResult.formatted_uuid);
            }

            if (qrResult.success && qrResult.qr_code) {
                replacements['{QR_CODE}'] = 'data:image/png;base64,' + qrResult.qr_code;
            } else if (qrResult.success && qrResult.data && qrResult.data.qr_code) {
                replacements['{QR_CODE}'] = 'data:image/png;base64,' + qrResult.data.qr_code;
            } else {
                throw new Error('Failed to generate QR code');
            }
            
            // Generate final PDF with real QR code
            const canvasJson = canvas.toJSON();
            const response = await fetch(getAjaxURL(), {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'action=preview&' + Object.keys(replacements).map(key => 
                    'replacements[' + encodeURIComponent(key) + ']=' + encodeURIComponent(replacements[key])
                ).join('&') + '&canvasData=' + encodeURIComponent(JSON.stringify(canvasJson)) + 
                '&orientation=' + encodeURIComponent(currentOrientation)
            });

            if (response.ok) {
                const blob = await response.blob();
                const url = window.URL.createObjectURL(blob);
                const a = document.createElement('a');
                a.style.display = 'none';
                a.href = url;
                a.download = `certificate_${replacements['{REVIEWER_NAME}'].replace(/[^a-zA-Z0-9]/g, '_')}_${Date.now()}.pdf`;
                document.body.appendChild(a);
                a.click();
                window.URL.revokeObjectURL(url);
                document.body.removeChild(a);
                
                alert('Certificate generated and downloaded successfully!');
            } else {
                throw new Error('Failed to generate certificate PDF');
            }
            
        } catch (error) {
            console.error('Error generating final certificate:', error);
            alert('Error generating certificate: ' + error.message);
        } finally {
            // Restore button
            document.getElementById('generateCertificate').innerHTML = originalText;
            document.getElementById('generateCertificate').disabled = false;
        }
    }

    // Setup properties panel toggle
    function setupPropertiesToggle() {
        const toggleBtn = document.getElementById('toggleProperties');
        const propertiesContent = document.getElementById('objectProperties');
        const toggleIcon = toggleBtn.querySelector('i');
        
        // Check if properties panel state is saved in localStorage
        // Default to collapsed if not set
        const isPanelExpanded = localStorage.getItem('propertiesPanelExpanded') === 'true';
        
        // Set initial state based on localStorage or default to collapsed
        if (isPanelExpanded) {
            propertiesContent.classList.remove('collapsed');
            propertiesContent.classList.add('expanded');
            toggleIcon.classList.remove('fa-chevron-down');
            toggleIcon.classList.add('fa-chevron-up');
        } else {
            // Ensure it's collapsed by default
            propertiesContent.classList.remove('expanded');
            propertiesContent.classList.add('collapsed');
            toggleIcon.classList.remove('fa-chevron-up');
            toggleIcon.classList.add('fa-chevron-down');
            localStorage.setItem('propertiesPanelExpanded', 'false');
        }
        
        toggleBtn.addEventListener('click', function() {
            const isExpanded = propertiesContent.classList.contains('expanded');
            
            if (isExpanded) {
                // Collapse panel
                propertiesContent.classList.remove('expanded');
                propertiesContent.classList.add('collapsed');
                toggleIcon.classList.remove('fa-chevron-up');
                toggleIcon.classList.add('fa-chevron-down');
                localStorage.setItem('propertiesPanelExpanded', 'false');
            } else {
                // Expand panel
                propertiesContent.classList.remove('collapsed');
                propertiesContent.classList.add('expanded');
                toggleIcon.classList.remove('fa-chevron-down');
                toggleIcon.classList.add('fa-chevron-up');
                localStorage.setItem('propertiesPanelExpanded', 'true');
                
                // If an object is selected, update the properties panel content
                if (selectedObject) {
                    updateProperties(selectedObject);
                }
            }
        });
    }
    
    // Initialize properties panel toggle
    setupPropertiesToggle();
    
    // Setup layer controls toggle
    function setupLayerControlsToggle() {
        const toggleBtn = document.getElementById('toggleLayers');
        const layerContent = document.getElementById('layerControlsContent');
        const toggleIcon = toggleBtn.querySelector('i');
        
        // Check if layer panel state is saved in localStorage
        // Default to expanded if not set
        const isLayerPanelExpanded = localStorage.getItem('layerPanelExpanded') !== 'false';
        
        // Set initial state based on localStorage or default to expanded
        if (isLayerPanelExpanded) {
            layerContent.classList.remove('collapsed');
            layerContent.classList.add('expanded');
            toggleIcon.classList.remove('fa-chevron-down');
            toggleIcon.classList.add('fa-chevron-up');
            localStorage.setItem('layerPanelExpanded', 'true');
        } else {
            // Collapse if saved as collapsed
            layerContent.classList.remove('expanded');
            layerContent.classList.add('collapsed');
            toggleIcon.classList.remove('fa-chevron-up');
            toggleIcon.classList.add('fa-chevron-down');
            localStorage.setItem('layerPanelExpanded', 'false');
        }
        
        toggleBtn.addEventListener('click', function() {
            const isExpanded = layerContent.classList.contains('expanded');
            
            if (isExpanded) {
                // Collapse panel
                layerContent.classList.remove('expanded');
                layerContent.classList.add('collapsed');
                toggleIcon.classList.remove('fa-chevron-up');
                toggleIcon.classList.add('fa-chevron-down');
                localStorage.setItem('layerPanelExpanded', 'false');
            } else {
                // Expand panel
                layerContent.classList.remove('collapsed');
                layerContent.classList.add('expanded');
                toggleIcon.classList.remove('fa-chevron-down');
                toggleIcon.classList.add('fa-chevron-up');
                localStorage.setItem('layerPanelExpanded', 'true');
            }
        });
    }
    
    // Initialize layer controls toggle
    setupLayerControlsToggle();

    // Initialize Fabric.js canvas with proper A4 dimensions based on orientation
    const initialWidth = currentOrientation === 'portrait' ? A4_WIDTH_PX : A4_HEIGHT_PX;
    const initialHeight = currentOrientation === 'portrait' ? A4_HEIGHT_PX : A4_WIDTH_PX;
    
    // Override fabric.Text to fix textBaseline issue
    var originalTextInit = fabric.Text.prototype.initialize;
    fabric.Text.prototype.initialize = function(text, options) {
        options = options || {};
        // Always set textBaseline to 'alphabetic' if not specified or if set to invalid value
        if (!options.textBaseline || options.textBaseline === 'alphabetical') {
            options.textBaseline = 'alphabetic';
        }
        return originalTextInit.call(this, text, options);
    };
    
    var canvas = new fabric.Canvas('certificateCanvas', {
        width: initialWidth,
        height: initialHeight,
        backgroundColor: 'white'
    });

    // Add fieldType to custom properties that will be serialized
    fabric.Object.prototype.toObject = (function(toObject) {
        return function(propertiesToInclude) {
            propertiesToInclude = (propertiesToInclude || []).concat(['fieldType']);
            return toObject.apply(this, [propertiesToInclude]);
        };
    })(fabric.Object.prototype.toObject);

    // Fix for invalid textBaseline values
    function fixTextBaseline(obj) {
        if (obj && obj.type === 'text') {
            const validBaselines = ['top', 'middle', 'bottom', 'alphabetic', 'hanging'];
            // Fix common typo: 'alphabetical' should be 'alphabetic'
            if (obj.textBaseline === 'alphabetical') {
                obj.set('textBaseline', 'alphabetic');
            } else if (obj.textBaseline && !validBaselines.includes(obj.textBaseline)) {
                obj.set('textBaseline', 'alphabetic');
            }
        }
    }
    
    // Clean template data before loading to fix textBaseline issues and reset placeholders
    function cleanTemplateData(templateData) {
        try {
            let data = typeof templateData === 'string' ? JSON.parse(templateData) : templateData;

            // Define content placeholders with their default styles
            const contentPlaceholders = {
                '{REVIEWER_NAME}': { text: '{REVIEWER_NAME}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{ARTICLE_TITLE}': { text: '{ARTICLE_TITLE}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{ARTICLE_DOI}': { text: '{ARTICLE_DOI}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{ARTICLE_PAGES}': { text: '{ARTICLE_PAGES}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{ISSUE_TITLE}': { text: '{ISSUE_TITLE}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{ISSUE_VOLUME}': { text: '{ISSUE_VOLUME}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{ISSUE_NUMBER}': { text: '{ISSUE_NUMBER}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{ISSUE_YEAR}': { text: '{ISSUE_YEAR}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{REVIEWER_EMAIL}': { text: '{REVIEWER_EMAIL}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{CURRENT_DATE}': { text: '{CURRENT_DATE}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{SUBMISSION_ID}': { text: '{SUBMISSION_ID}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{ISSN_ONLINE}': { text: '{ISSN_ONLINE}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 },
                '{ISSN_PRINT}': { text: '{ISSN_PRINT}', fill: '#000000', backgroundColor: '', fontWeight: 'normal', padding: 0 }
            };

            // Define QR-related placeholders with their special styles
            const qrPlaceholders = {
                '{QR_CODE}': { text: '{QR_CODE}', fill: '#333', backgroundColor: '#f0f0f0', fontWeight: 'normal', padding: 10 },
                '{QR_ID}': { text: '{QR_ID}', fill: '#d97706', backgroundColor: '#fffbea', fontWeight: 'bold', padding: 8 },
                '{QR_IDENTIFIER}': { text: '{QR_IDENTIFIER}', fill: '#d97706', backgroundColor: '#fffbea', fontWeight: 'bold', padding: 8 },
                '{QR_ISSUE_DATE}': { text: '{QR_ISSUE_DATE}', fill: '#d97706', backgroundColor: '#fffbea', fontWeight: 'bold', padding: 8 },
                '{QR_EXPIRE_DATE}': { text: '{QR_EXPIRE_DATE}', fill: '#d97706', backgroundColor: '#fffbea', fontWeight: 'bold', padding: 8 }
            };

            // Merge all placeholders
            const allPlaceholders = { ...contentPlaceholders, ...qrPlaceholders };

            // Fix textBaseline and reset placeholders in objects
            if (data.objects && Array.isArray(data.objects)) {
                data.objects.forEach(obj => {
                    // Fix textBaseline
                    if (obj.type === 'text' && obj.textBaseline === 'alphabetical') {
                        obj.textBaseline = 'alphabetic';
                    }

                    // Reset placeholder text and styles based on fieldType
                    if (obj.fieldType && typeof obj.fieldType === 'string') {
                        const placeholder = allPlaceholders[obj.fieldType];

                        if (placeholder) {
                            // Reset text for text-based objects
                            if (obj.type === 'text' || obj.type === 'textbox' || obj.type === 'i-text') {
                                // Only reset if text doesn't match placeholder (meaning it was replaced with real data)
                                if (obj.text !== placeholder.text) {
                                    console.log('cleanTemplateData: Resetting', obj.fieldType, 'from', obj.text, 'to placeholder');
                                    obj.text = placeholder.text;
                                    obj.fill = placeholder.fill;
                                    obj.backgroundColor = placeholder.backgroundColor;
                                    obj.fontWeight = placeholder.fontWeight;
                                    obj.padding = placeholder.padding;
                                }
                            }
                        }
                    }
                });
            }

            return data;
        } catch (e) {
            console.error('Error cleaning template data:', e);
            return templateData;
        }
    }
    
    // Apply fix when objects are added
    canvas.on('object:added', function(e) {
        updateLayerUI();
        fixTextBaseline(e.target);
    });
    
    // Apply fix when canvas is loaded
    canvas.on('canvas:loaded', function() {
        canvas.getObjects().forEach(fixTextBaseline);
    });

    // Global variables
    var selectedObject = null;
    var currentOrientation = 'landscape';
    var currentZoom = 1.0;
    var currentLoadedTemplate = null; // Track currently loaded template
    var goValidAuth = {
        isAuthenticated: false,
        token: null,
        expiry: null,
        sessionDuration: 3600000, // 1 hour in milliseconds
        userInfo: null,
        subscription: null,
        sessionStart: null,
        lastCheck: null,
        accessToken: null,
        initializing: false // Changed to false to show login overlay immediately
    };

    /**
     * Check if user has Ultimate or Business subscription (Premium plans)
     * Also treats credit-based users with sufficient balance as premium
     */
    function isPremiumPlan() {
        if (!goValidAuth.isAuthenticated || !goValidAuth.subscription) {
            return false;
        }

        // Credit-based users with balance are treated as premium (paid users)
        if (goValidAuth.subscription.business_model === 'credit') {
            // Use can_generate_qr from API if available (new multi-currency API)
            if (goValidAuth.subscription.can_generate_qr !== undefined) {
                return goValidAuth.subscription.can_generate_qr;
            }
            // Fallback to legacy check
            const balanceIdr = goValidAuth.subscription.balance_idr || 0;
            const bonusQr = goValidAuth.subscription.bonus_qr_quota || 0;
            // Credit users who have paid (have balance or bonus QRs) are premium
            return balanceIdr >= 890 || bonusQr > 0;
        }

        const planTier = (goValidAuth.subscription.plan_tier || '').toUpperCase();
        const planName = (goValidAuth.subscription.plan_name || '').toLowerCase();

        // Check plan_tier for ULTI (Ultimate) or BUSI (Business)
        if (planTier === 'ULTI' || planTier === 'ULTIMATE' || planTier === 'BUSI' || planTier === 'BUSINESS') {
            return true;
        }

        // Check plan_name contains "ultimate" or "business"
        if (planName.includes('ultimate') || planName.includes('business')) {
            return true;
        }

        return false;
    }

    /**
     * Update header branding based on subscription level
     */
    function updateDesignerHeaderBranding() {
        const govalidSection = document.getElementById('designerGoValidSection');
        const journalSection = document.getElementById('designerJournalSection');
        const topHeader = document.getElementById('designerTopHeader');
        const journalInfo = document.getElementById('designerJournalInfo');

        if (!govalidSection || !journalSection) return;

        if (isPremiumPlan()) {
            // Hide GoValid branding
            govalidSection.style.display = 'none';

            // Stretch journal section to full width
            if (journalSection) {
                journalSection.style.flex = '1';
            }

            // Adjust journal info styling for left-right layout
            if (journalInfo) {
                journalInfo.style.display = 'flex';
                journalInfo.style.alignItems = 'center';
                journalInfo.style.justifyContent = 'space-between';
                journalInfo.style.width = '100%';
                journalInfo.style.textAlign = 'left';
            }

            // Make journal name larger
            const journalNameEl = document.getElementById('journalName');
            if (journalNameEl) {
                journalNameEl.style.fontSize = '20px';
            }

            console.log('Certificate Designer: Premium plan detected - GoValid branding hidden');
        } else {
            // Show GoValid branding (default)
            govalidSection.style.display = 'block';

            // Reset journal section
            if (journalSection) {
                journalSection.style.flex = '';
            }

            // Reset journal info styling
            if (journalInfo) {
                journalInfo.style.display = '';
                journalInfo.style.alignItems = '';
                journalInfo.style.justifyContent = '';
                journalInfo.style.width = '';
                journalInfo.style.textAlign = 'right';
            }

            // Reset journal name size
            const journalNameEl = document.getElementById('journalName');
            if (journalNameEl) {
                journalNameEl.style.fontSize = '16px';
            }

            console.log('Certificate Designer: Standard plan - GoValid branding visible');
        }
    }

    // Make function available globally
    window.updateDesignerHeaderBranding = updateDesignerHeaderBranding;
    window.isPremiumPlan = isPremiumPlan;

    // Security wrapper for all actions
