{**
 * plugins/generic/goValidOJS/templates/emailTemplateManager_modern.tpl
 *
 * Copyright (c) 2025 Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * Modern Email template manager interface
 *}

<div id="emailTemplateManager" class="govalidojs-email-manager">
    <!-- Header Section -->
    <div class="etm-header">
        <div class="etm-header-content">
            <div class="etm-title-section">
                <h1 class="etm-title">
                    <svg class="etm-icon" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="2" y="5" width="20" height="14" rx="2"></rect>
                        <polyline points="2,10 12,15 22,10"></polyline>
                    </svg>
                    Email Templates
                </h1>
                <p class="etm-subtitle">Manage and customize email templates for reviewer certificates</p>
            </div>
            <button class="etm-btn etm-btn-primary etm-btn-create" onclick="window.location.href='{url op="emailTemplateDesigner"}'">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M12 19l7-7 3 3-7 7-3-3z"></path>
                    <path d="M18 13l-1.5-7.5L2 2l3.5 14.5L13 18l5-5z"></path>
                    <path d="M2 2l7.586 7.586"></path>
                    <circle cx="11" cy="11" r="2"></circle>
                </svg>
                Email Template Designer
            </button>
        </div>
    </div>

    <!-- Active Template Banner -->
    <div class="etm-active-banner">
        <div class="etm-active-content">
            <span class="etm-active-label">Active Template:</span>
            <span class="etm-active-name">
                {foreach from=$emailTemplates item=template key=templateId}
                    {if $selectedTemplate == $templateId}{$template.name|escape}{/if}
                {/foreach}
            </span>
        </div>
    </div>

    <!-- Templates Grid -->
    <div class="etm-templates-section">
        <div class="etm-templates-grid">
            {foreach from=$emailTemplates item=template key=templateId}
                <div class="etm-card {if $selectedTemplate == $templateId}etm-card-active{/if}" data-template-id="{$templateId}">
                    <div class="etm-card-header">
                        <h3 class="etm-card-title">{$template.name|escape}</h3>
                        {if $selectedTemplate == $templateId}
                            <span class="etm-badge etm-badge-active">Active</span>
                        {elseif $template.custom}
                            <span class="etm-badge etm-badge-custom">Custom</span>
                        {else}
                            <span class="etm-badge etm-badge-default">Default</span>
                        {/if}
                    </div>
                    
                    <div class="etm-card-body">
                        <div class="etm-subject">
                            <svg class="etm-subject-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                                <polyline points="22,6 12,13 2,6"></polyline>
                            </svg>
                            <span class="etm-subject-text">{$template.subject|escape|truncate:50}</span>
                        </div>
                    </div>
                    
                    <div class="etm-card-actions">
                        <button class="etm-btn etm-btn-ghost etm-btn-icon preview-btn" 
                                data-template-id="{$templateId}"
                                title="Preview">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                <circle cx="12" cy="12" r="3"></circle>
                            </svg>
                        </button>
                        
                        <button class="etm-btn etm-btn-ghost etm-btn-icon test-btn" 
                                data-template-id="{$templateId}"
                                title="Send Test Email">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <line x1="22" y1="2" x2="11" y2="13"></line>
                                <polygon points="22 2 15 22 11 13 2 9 22 2"></polygon>
                            </svg>
                        </button>
                        
                        {if $template.custom}
                            <button class="etm-btn etm-btn-ghost etm-btn-icon edit-btn" 
                                    data-template-id="{$templateId}"
                                    title="Edit">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path>
                                    <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                                </svg>
                            </button>
                            
                            <button class="etm-btn etm-btn-ghost etm-btn-icon etm-btn-danger delete-btn" 
                                    data-template-id="{$templateId}"
                                    title="Delete">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <polyline points="3 6 5 6 21 6"></polyline>
                                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                </svg>
                            </button>
                        {else}
                            <button class="etm-btn etm-btn-ghost etm-btn-icon copy-btn" 
                                    data-template-id="{$templateId}"
                                    title="Create Copy">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect>
                                    <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path>
                                </svg>
                            </button>
                        {/if}
                        
                        {if $selectedTemplate != $templateId}
                            <button class="etm-btn etm-btn-secondary activate-btn" 
                                    data-template-id="{$templateId}">
                                Activate
                            </button>
                        {/if}
                    </div>
                </div>
            {/foreach}
        </div>
    </div>

    <!-- Placeholder Reference -->
    <div class="etm-reference">
        <h2 class="etm-reference-title">Template Variables</h2>
        <p class="etm-reference-subtitle">Use these placeholders in your email templates</p>
        
        <div class="etm-reference-grid">
            <div class="etm-reference-card">
                <h3 class="etm-reference-card-title">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                    Reviewer
                </h3>
                <div class="etm-variables">
                    <div class="etm-variable">
                        <code>{literal}{{reviewer_name}}{/literal}</code>
                        <span>Full name of the reviewer</span>
                    </div>
                    <div class="etm-variable">
                        <code>{literal}{{reviewer_email}}{/literal}</code>
                        <span>Email address of the reviewer</span>
                    </div>
                </div>
            </div>
            
            <div class="etm-reference-card">
                <h3 class="etm-reference-card-title">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                        <polyline points="14 2 14 8 20 8"></polyline>
                        <line x1="16" y1="13" x2="8" y2="13"></line>
                        <line x1="16" y1="17" x2="8" y2="17"></line>
                        <polyline points="10 9 9 9 8 9"></polyline>
                    </svg>
                    Article
                </h3>
                <div class="etm-variables">
                    <div class="etm-variable">
                        <code>{literal}{{article_title}}{/literal}</code>
                        <span>Title of the reviewed article</span>
                    </div>
                    <div class="etm-variable">
                        <code>{literal}{{article_authors}}{/literal}</code>
                        <span>Authors of the article</span>
                    </div>
                    <div class="etm-variable">
                        <code>{literal}{{issue_title}}{/literal}</code>
                        <span>Issue title/number</span>
                    </div>
                </div>
            </div>
            
            <div class="etm-reference-card">
                <h3 class="etm-reference-card-title">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                        <polyline points="9 22 9 12 15 12 15 22"></polyline>
                    </svg>
                    Journal
                </h3>
                <div class="etm-variables">
                    <div class="etm-variable">
                        <code>{literal}{{journal_name}}{/literal}</code>
                        <span>Name of the journal</span>
                    </div>
                    <div class="etm-variable">
                        <code>{literal}{{journal_url}}{/literal}</code>
                        <span>Journal website URL</span>
                    </div>
                    <div class="etm-variable">
                        <code>{literal}{{contact_email}}{/literal}</code>
                        <span>Journal contact email</span>
                    </div>
                    <div class="etm-variable">
                        <code>{literal}{{journal_logo_url}}{/literal}</code>
                        <span>Journal logo URL</span>
                    </div>
                </div>
            </div>
            
            <div class="etm-reference-card">
                <h3 class="etm-reference-card-title">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                        <line x1="16" y1="2" x2="16" y2="6"></line>
                        <line x1="8" y1="2" x2="8" y2="6"></line>
                        <line x1="3" y1="10" x2="21" y2="10"></line>
                    </svg>
                    Other
                </h3>
                <div class="etm-variables">
                    <div class="etm-variable">
                        <code>{literal}{{review_date}}{/literal}</code>
                        <span>Date of the review</span>
                    </div>
                    <div class="etm-variable">
                        <code>{literal}{{custom_message}}{/literal}</code>
                        <span>Custom message from settings</span>
                    </div>
                    <div class="etm-variable">
                        <code>{literal}{{#if variable}}...{{/if}}{/literal}</code>
                        <span>Conditional content</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Preview Modal -->
<div id="emailPreviewModal" class="etm-modal">
    <div class="etm-modal-content">
        <div class="etm-modal-header">
            <h2 class="etm-modal-title">Email Preview</h2>
            <button class="etm-modal-close" onclick="closePreviewModal()">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="18" y1="6" x2="6" y2="18"></line>
                    <line x1="6" y1="6" x2="18" y2="18"></line>
                </svg>
            </button>
        </div>
        <div class="etm-modal-body">
            <div id="previewContent" class="etm-preview-content">
                <!-- Preview content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<style>
/* Modern Email Template Manager Styles */
.govalidojs-email-manager {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
    color: #1a202c;
    line-height: 1.5;
}

/* Header */
.etm-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 2rem 0;
    margin: -2rem -2rem 2rem -2rem;
}

.etm-header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1.5rem;
}

.etm-title {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.etm-icon {
    width: 32px;
    height: 32px;
}

.etm-subtitle {
    margin: 0.5rem 0 0 0;
    opacity: 0.9;
    font-size: 1.1rem;
}

/* Active Banner */
.etm-active-banner {
    background: #f7fafc;
    border: 1px solid #e2e8f0;
    border-radius: 0.75rem;
    padding: 1.25rem 2rem;
    margin-bottom: 2rem;
}

.etm-active-content {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.etm-active-label {
    font-weight: 600;
    color: #4a5568;
}

.etm-active-name {
    color: #667eea;
    font-weight: 600;
    font-size: 1.1rem;
}

/* Buttons */
.etm-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.625rem 1.25rem;
    border-radius: 0.5rem;
    font-weight: 500;
    font-size: 0.875rem;
    border: none;
    cursor: pointer;
    transition: all 0.2s ease;
    text-decoration: none;
}

.etm-btn-primary {
    background: white;
    color: #667eea;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.etm-btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.etm-btn-secondary {
    background: #667eea;
    color: white;
}

.etm-btn-secondary:hover {
    background: #5a67d8;
}

.etm-btn-ghost {
    background: transparent;
    color: #4a5568;
    padding: 0.5rem;
}

.etm-btn-ghost:hover {
    background: #f7fafc;
    color: #2d3748;
}

.etm-btn-icon {
    width: 36px;
    height: 36px;
    padding: 0;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.etm-btn-danger:hover {
    color: #e53e3e;
    background: #fff5f5;
}

/* Templates Grid */
.etm-templates-section {
    margin-bottom: 3rem;
}

.etm-templates-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
    gap: 1.5rem;
}

/* Cards */
.etm-card {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 0.75rem;
    padding: 1.5rem;
    transition: all 0.2s ease;
    position: relative;
}

.etm-card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}

.etm-card-active {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.etm-card-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 1rem;
}

.etm-card-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin: 0;
    color: #2d3748;
}

/* Badges */
.etm-badge {
    font-size: 0.75rem;
    padding: 0.25rem 0.75rem;
    border-radius: 9999px;
    font-weight: 600;
    text-transform: uppercase;
}

.etm-badge-active {
    background: #48bb78;
    color: white;
}

.etm-badge-custom {
    background: #ed8936;
    color: white;
}

.etm-badge-default {
    background: #e2e8f0;
    color: #4a5568;
}

/* Card Body */
.etm-card-body {
    margin-bottom: 1.25rem;
}

.etm-subject {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #718096;
}

.etm-subject-icon {
    flex-shrink: 0;
}

.etm-subject-text {
    font-size: 0.875rem;
}

/* Card Actions */
.etm-card-actions {
    display: flex;
    gap: 0.5rem;
    align-items: center;
    flex-wrap: wrap;
}

/* Reference Section */
.etm-reference {
    background: #f7fafc;
    border-radius: 0.75rem;
    padding: 2.5rem;
    margin: 0 -2rem -2rem -2rem;
}

.etm-reference-title {
    font-size: 1.5rem;
    font-weight: 600;
    margin: 0 0 0.5rem 0;
    color: #2d3748;
}

.etm-reference-subtitle {
    color: #718096;
    margin-bottom: 2rem;
}

.etm-reference-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
}

.etm-reference-card {
    background: white;
    border-radius: 0.5rem;
    padding: 1.5rem;
    border: 1px solid #e2e8f0;
}

.etm-reference-card-title {
    font-size: 1.125rem;
    font-weight: 600;
    margin: 0 0 1rem 0;
    color: #2d3748;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.etm-variables {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.etm-variable {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.etm-variable code {
    background: #edf2f7;
    padding: 0.25rem 0.5rem;
    border-radius: 0.25rem;
    font-size: 0.875rem;
    color: #667eea;
    font-family: "SF Mono", Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
    align-self: flex-start;
}

.etm-variable span {
    font-size: 0.875rem;
    color: #718096;
}

/* Modal */
.etm-modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.5);
    z-index: 9999;
    padding: 2rem;
    overflow-y: auto;
}

.etm-modal-content {
    background: white;
    max-width: 800px;
    margin: 0 auto;
    border-radius: 0.75rem;
    box-shadow: 0 20px 25px -5px rgba(0,0,0,0.1);
}

.etm-modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.5rem;
    border-bottom: 1px solid #e2e8f0;
}

.etm-modal-title {
    font-size: 1.5rem;
    font-weight: 600;
    margin: 0;
    color: #2d3748;
}

.etm-modal-close {
    background: none;
    border: none;
    cursor: pointer;
    color: #718096;
    padding: 0.5rem;
    border-radius: 0.25rem;
    transition: all 0.2s ease;
}

.etm-modal-close:hover {
    background: #f7fafc;
    color: #2d3748;
}

.etm-modal-body {
    padding: 1.5rem;
}

.etm-preview-content {
    min-height: 300px;
}

/* Responsive */
@media (max-width: 768px) {
    .etm-header-content {
        padding: 0 1rem;
    }
    
    .etm-title {
        font-size: 1.5rem;
    }
    
    .etm-icon {
        width: 24px;
        height: 24px;
    }
    
    .etm-templates-grid {
        grid-template-columns: 1fr;
    }
    
    .etm-reference {
        padding: 1.5rem;
        margin: 0 -1rem -1rem -1rem;
    }
    
    .etm-reference-grid {
        grid-template-columns: 1fr;
    }
}

/* Loading state */
.etm-loading {
    text-align: center;
    padding: 3rem;
    color: #718096;
}

.etm-loading::after {
    content: '';
    display: inline-block;
    width: 20px;
    height: 20px;
    border: 2px solid #e2e8f0;
    border-top-color: #667eea;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
    margin-left: 0.5rem;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}
</style>

<script>
function previewTemplate(templateId) {
    // Show loading
    document.getElementById('previewContent').innerHTML = '<div class="etm-loading">Loading preview...</div>';
    document.getElementById('emailPreviewModal').style.display = 'block';
    
    // Load preview content
    fetch('{url op="previewTemplate"}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'templateId=' + encodeURIComponent(templateId) + '&{$smarty.const.SESSION_CSRF_TOKEN}={$csrfToken}'
    })
    .then(response => response.text())
    .then(html => {
        document.getElementById('previewContent').innerHTML = html;
    })
    .catch(error => {
        document.getElementById('previewContent').innerHTML = '<div class="error">Error loading preview</div>';
    });
}

function closePreviewModal() {
    document.getElementById('emailPreviewModal').style.display = 'none';
}

function testEmailTemplate(templateId) {
    if (!templateId) {
        alert('No template selected');
        return;
    }
    
    const testEmail = prompt('Enter email address to send test email:', 'naufal.unismuh@gmail.com');
    if (!testEmail) {
        return;
    }
    
    // Show loading message
    alert('Sending test email to ' + testEmail + '...');
    
    fetch('{url op="testEmail"}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'templateId=' + encodeURIComponent(templateId) + '&testEmail=' + encodeURIComponent(testEmail) + '&{$smarty.const.SESSION_CSRF_TOKEN}={$csrfToken}'
    })
    .then(response => response.json())
    .then(data => {
        if (data.content && data.content.success) {
            alert(data.content.message);
        } else {
            alert(data.content ? data.content.error : 'Failed to send test email');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error sending test email: ' + error.message);
    });
}

function activateTemplate(templateId) {
    if (!confirm('Are you sure you want to activate this template?')) {
        return;
    }
    
    fetch('{url op="activateTemplate"}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'templateId=' + encodeURIComponent(templateId) + '&{$smarty.const.SESSION_CSRF_TOKEN}={$csrfToken}'
    })
    .then(response => response.json())
    .then(data => {
        if (data.content && data.content.success) {
            location.reload();
        } else {
            alert(data.content ? data.content.error : 'Failed to activate template');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error activating template');
    });
}

function deleteTemplate(templateId) {
    if (!confirm('Are you sure you want to delete this template? This action cannot be undone.')) {
        return;
    }
    
    fetch('{url op="deleteTemplate"}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'templateId=' + encodeURIComponent(templateId) + '&{$smarty.const.SESSION_CSRF_TOKEN}={$csrfToken}'
    })
    .then(response => response.json())
    .then(data => {
        if (data.content && data.content.success) {
            location.reload();
        } else {
            alert(data.content ? data.content.error : 'Failed to delete template');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error deleting template');
    });
}

// Event listeners
document.addEventListener('DOMContentLoaded', function() {
    // Preview buttons
    document.querySelectorAll('.preview-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            previewTemplate(this.dataset.templateId);
        });
    });
    
    // Test email buttons
    document.querySelectorAll('.test-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            testEmailTemplate(this.dataset.templateId);
        });
    });
    
    // Edit buttons - redirect to email designer
    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            window.location.href = '{url op="emailTemplateDesigner"}';
        });
    });

    // Copy buttons (for default templates) - redirect to email designer
    document.querySelectorAll('.copy-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            window.location.href = '{url op="emailTemplateDesigner"}';
        });
    });
    
    // Delete buttons
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            deleteTemplate(this.dataset.templateId);
        });
    });
    
    // Activate buttons
    document.querySelectorAll('.activate-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            activateTemplate(this.dataset.templateId);
        });
    });
    
    // Close modal on click outside
    document.getElementById('emailPreviewModal').addEventListener('click', function(e) {
        if (e.target === this) {
            closePreviewModal();
        }
    });
});
</script>