# GoValidOJS Plugin Documentation

## Overview

GoValidOJS is a plugin for Open Journal Systems (OJS) 3.4 that integrates with the GoValid certification service to automatically generate and distribute reviewer certificates.

## Documentation Index

### 1. [Auto-Population Feature](AUTO_POPULATION.md)
Learn how the plugin automatically pulls issue and article data from OJS to populate certificate fields.

### 2. [Installation Guide](INSTALLATION.md)
Step-by-step instructions for installing and configuring the plugin.

### 3. [API Reference](API_REFERENCE.md)
Complete reference for all plugin API endpoints and methods.

### 4. [Developer Guide](DEVELOPER_GUIDE.md)
Technical details for developers extending or modifying the plugin.

## Quick Links

- **Plugin Version**: 1.0.0
- **OJS Compatibility**: 3.4.x
- **PHP Requirements**: 8.0+
- **License**: GPL v3

## Tested On

| Component | Version |
|-----------|---------|
| PHP | 8.3.6 |
| OJS | 3.4.x |

## Features

- ✅ Automatic certificate generation for reviewers
- ✅ Integration with GoValid QR code service
- ✅ Auto-population of journal/article data
- ✅ Custom certificate designer
- ✅ Batch certificate generation
- ✅ Email notifications

## Support

For issues or questions:
1. Check the documentation
2. Review the [troubleshooting guide](AUTO_POPULATION.md#troubleshooting)
3. Contact plugin maintainers

## Contributing

Contributions are welcome! Please read our contributing guidelines before submitting pull requests.