# GoValidOJS API Reference

## Table of Contents
1. [Plugin API Endpoints](#plugin-api-endpoints)
2. [Request/Response Format](#requestresponse-format)
3. [Authentication](#authentication)
4. [Error Handling](#error-handling)
5. [Complete Endpoint Reference](#complete-endpoint-reference)

## Plugin API Endpoints

All endpoints follow this base pattern:
```
/index.php/{journal}/$$call$$/grid/settings/plugins/settings-plugin-grid/manage
```

### Required Parameters
- `verb`: Always `designer` for designer-related actions
- `plugin`: Always `goValidOJS`
- `category`: Always `generic`
- `action`: Specific action to perform

## Request/Response Format

### Standard Response Structure
```json
{
  "status": true|false,
  "content": {
    // Response data
  },
  "elementId": "0",
  "events": null
}
```

### Error Response Structure
```json
{
  "status": false,
  "content": {
    "error": "Error message",
    "message": "Detailed error description"
  }
}
```

## Authentication

### Session-Based Auth
All requests must include session cookies:
```javascript
fetch(url, {
    credentials: 'same-origin'
})
```

### GoValid Authentication
For GoValid API operations:
```javascript
// Login
POST ?action=login
Body: username=xxx&password=xxx&remember=1

// Check auth status
GET ?action=checkAuth

// Logout
POST ?action=logout
```

## Error Handling

### HTTP Status Codes
- `200`: Success
- `401`: Unauthorized
- `403`: Forbidden
- `500`: Server Error

### Common Error Messages
```json
{
  "success": false,
  "message": "Authentication required",
  "error": "NOT_AUTHENTICATED"
}
```

## Complete Endpoint Reference

### 1. Get Issues
Retrieve all published issues for the current journal.

**Endpoint:**
```
GET ?verb=designer&plugin=goValidOJS&category=generic&action=getIssues
```

**Response:**
```json
{
  "status": true,
  "content": {
    "issues": [
      {
        "id": 1,
        "title": "Volume 1, Issue 2",
        "volume": 1,
        "number": "02",
        "year": 2024,
        "datePublished": "2024-11-01 00:00:00",
        "description": "Issue description",
        "published": true
      }
    ]
  }
}
```

### 2. Get Submissions
Retrieve all published articles for a specific issue.

**Endpoint:**
```
GET ?verb=designer&plugin=goValidOJS&category=generic&action=getSubmissions&issueId={id}
```

**Parameters:**
- `issueId` (required): Issue ID to filter by

**Response:**
```json
{
  "status": true,
  "content": {
    "submissions": [
      {
        "id": 123,
        "title": "Article Title",
        "doi": "10.1234/example.2024.001",
        "pages": "1-15",
        "dateSubmitted": "2024-01-01",
        "datePublished": "2024-02-01",
        "abstract": "Article abstract text...",
        "issueId": 1,
        "sectionId": 5,
        "authors": "John Doe, Jane Smith"
      }
    ]
  }
}
```

### 3. Get Reviewers
Retrieve reviewers for the current journal.

**Endpoint:**
```
GET ?verb=designer&plugin=goValidOJS&category=generic&action=getReviewers&search={query}
```

**Parameters:**
- `search` (optional): Search term for filtering reviewers

**Response:**
```json
{
  "status": true,
  "content": {
    "reviewers": [
      {
        "id": 456,
        "name": "Dr. John Smith",
        "email": "john.smith@example.com",
        "affiliation": "University of Example"
      }
    ]
  }
}
```

### 4. Save Template
Save a certificate template design.

**Endpoint:**
```
POST ?verb=designer&plugin=goValidOJS&category=generic&action=save
```

**Request Body:**
```
templateData={
  "name": "Template Name",
  "data": {...canvas data...},
  "orientation": "landscape",
  "timestamp": "2024-01-01T00:00:00Z"
}
```

**Response:**
```json
{
  "status": true,
  "content": {
    "status": true,
    "message": "Template saved successfully!"
  }
}
```

### 5. Load Template
Load a saved certificate template.

**Endpoint:**
```
GET ?verb=designer&plugin=goValidOJS&category=generic&action=load&templateName={name}
```

**Parameters:**
- `templateName` (required): Name of template to load

**Response:**
```json
{
  "status": true,
  "content": {
    "status": true,
    "templateData": {...canvas data...},
    "orientation": "landscape"
  }
}
```

### 6. Delete Template
Delete a saved certificate template.

**Endpoint:**
```
POST ?verb=designer&plugin=goValidOJS&category=generic&action=delete
```

**Request Body:**
```
templateName=Template Name
```

**Response:**
```json
{
  "status": true,
  "content": {
    "status": true,
    "message": "Template deleted successfully!"
  }
}
```

### 7. List Templates
Get list of all saved templates.

**Endpoint:**
```
GET ?verb=designer&plugin=goValidOJS&category=generic&action=list
```

**Response:**
```json
{
  "status": true,
  "content": {
    "templates": [
      {
        "name": "Default Certificate",
        "timestamp": "2024-01-01T00:00:00Z"
      }
    ]
  }
}
```

### 8. GoValid Login
Authenticate with GoValid service.

**Endpoint:**
```
POST ?verb=designer&plugin=goValidOJS&category=generic&action=login
```

**Request Body:**
```
username=user@example.com&password=password&remember=1
```

**Response:**
```json
{
  "status": true,
  "content": {
    "success": true,
    "access": "eyJhbGciOiJIUzI1...",
    "refresh": "eyJhbGciOiJIUzI1...",
    "user": {
      "id": 21,
      "username": "user@example.com",
      "email": "user@example.com",
      "first_name": "John",
      "last_name": "Doe",
      "is_staff": false
    }
  }
}
```

### 9. Check Authentication
Check current GoValid authentication status.

**Endpoint:**
```
GET ?verb=designer&plugin=goValidOJS&category=generic&action=checkAuth
```

**Response:**
```json
{
  "status": true,
  "content": {
    "authenticated": true,
    "user": {...user data...},
    "subscription": {
      "success": true,
      "business_model": "plan",
      "plan_name": "Ultimate",
      "plan_tier": "ULTI",
      "monthly_qr_limit": 1500,
      "qr_codes_used": 19,
      "remaining_qr_codes": 1481,
      "can_generate_qr": true
    }
  }
}
```

### 10. Get Subscription Info
Get detailed GoValid subscription information.

**Endpoint:**
```
GET ?verb=designer&plugin=goValidOJS&category=generic&action=getSubscription
```

**Response:**
```json
{
  "status": true,
  "content": {
    "success": true,
    "business_model": "plan",
    "plan_name": "Ultimate",
    "plan_tier": "ULTI",
    "monthly_qr_limit": 1500,
    "qr_codes_used": 19,
    "remaining_qr_codes": 1481,
    "can_generate_qr": true,
    "is_active": true,
    "subscription_source": "institution",
    "institution_name": "ACENA ERASSA"
  }
}
```

### 11. Generate Certificate QR
Generate a certificate with QR code.

**Endpoint:**
```
POST ?verb=designer&plugin=goValidOJS&category=generic&action=generateCertificateQR
```

**Request Body (JSON):**
```json
{
  "qr_type": "url",
  "quantity": 1,
  "document_type": "certificate",
  "pattern_id": 123,
  "certificate_data": {
    "reviewer_name": "Dr. John Smith",
    "journal_name": "Example Journal",
    "article_title": "Research Article",
    "review_date": "2024-01-01"
  }
}
```

**Response:**
```json
{
  "status": true,
  "content": {
    "success": true,
    "data": {
      "qr_code_url": "https://my.govalid.org/qr/ABC123",
      "certificate_id": "CERT-2024-001"
    }
  }
}
```

### 12. Preview Certificate
Generate a preview of the certificate.

**Endpoint:**
```
GET ?verb=designer&plugin=goValidOJS&category=generic&action=preview
```

**Parameters:**
- Includes all template data as query parameters

**Response:**
- Returns PDF file stream
- Content-Type: application/pdf

## JavaScript Helper Functions

### getAjaxURL()
Returns the base URL for AJAX requests with HTML entities decoded:
```javascript
function getAjaxURL() {
    return window.location.href.replace(/&amp;/g, '&');
}
```

### Making Authenticated Requests
```javascript
fetch(getAjaxURL() + '&action=getIssues', {
    method: 'GET',
    headers: {
        'Accept': 'application/json',
    },
    credentials: 'same-origin'
})
.then(response => response.json())
.then(data => {
    if (data.status && data.content) {
        // Handle success
    }
});
```

## Rate Limiting

- No specific rate limits on plugin endpoints
- GoValid API has its own rate limits
- Implement client-side throttling for better UX

## Versioning

Current API Version: 1.0.0
- All endpoints are stable
- Backwards compatibility maintained
- New features added via new endpoints