<?php
/**
 * @file plugins/generic/goValidOJS/ajax.php
 *
 * AJAX endpoint for GoValidOJS plugin
 */

// Enable error reporting
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Log to file
$logFile = __DIR__ . '/ajax_debug.log';
file_put_contents($logFile, "\n\n=== NEW REQUEST ===\n", FILE_APPEND);
file_put_contents($logFile, date('Y-m-d H:i:s') . "\n", FILE_APPEND);
file_put_contents($logFile, "REQUEST: " . json_encode($_REQUEST) . "\n", FILE_APPEND);

try {
    // Initialize OJS
    define('INDEX_FILE_LOCATION', dirname(__FILE__, 4) . '/index.php');
    file_put_contents($logFile, "INDEX_FILE_LOCATION: " . INDEX_FILE_LOCATION . "\n", FILE_APPEND);

    chdir(dirname(INDEX_FILE_LOCATION));
    file_put_contents($logFile, "CWD: " . getcwd() . "\n", FILE_APPEND);

    require_once('./lib/pkp/includes/bootstrap.php');
    file_put_contents($logFile, "Bootstrap loaded\n", FILE_APPEND);
} catch (\Exception $e) {
    file_put_contents($logFile, "Bootstrap ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
    header('Content-Type: application/json');
    echo json_encode(['status' => false, 'error' => 'Bootstrap error: ' . $e->getMessage()]);
    exit;
}

// Get the application and request
$application = \APP\core\Application::get();
$request = $application->getRequest();

if (!$request) {
    header('Content-Type: application/json');
    echo json_encode(['status' => false, 'error' => 'Could not initialize request']);
    exit;
}

// Load the plugin
\PKP\plugins\PluginRegistry::loadCategory('generic');
file_put_contents($logFile, "Plugin category loaded\n", FILE_APPEND);

$plugin = \PKP\plugins\PluginRegistry::getPlugin('generic', 'govalidojsplugin');
file_put_contents($logFile, "Plugin object: " . var_export($plugin, true) . "\n", FILE_APPEND);

if (!$plugin) {
    file_put_contents($logFile, "ERROR: Plugin not found\n", FILE_APPEND);
    header('Content-Type: application/json');
    echo json_encode(['status' => false, 'error' => 'Plugin not found']);
    exit;
}

file_put_contents($logFile, "Plugin found successfully\n", FILE_APPEND);

// Check authentication (must be logged in to OJS as manager)
$user = $request->getUser();
file_put_contents($logFile, "User object: " . var_export($user, true) . "\n", FILE_APPEND);

if (!$user) {
    file_put_contents($logFile, "ERROR: Not authenticated\n", FILE_APPEND);
    header('Content-Type: application/json');
    echo json_encode(['status' => false, 'error' => 'Not authenticated']);
    exit;
}

file_put_contents($logFile, "User authenticated: " . $user->getUsername() . "\n", FILE_APPEND);

$context = $request->getContext();
$contextId = $context ? $context->getId() : \PKP\core\PKPApplication::CONTEXT_SITE;
file_put_contents($logFile, "Context ID: " . $contextId . "\n", FILE_APPEND);

if (!$user->hasRole([\PKP\security\Role::ROLE_ID_SITE_ADMIN, \PKP\security\Role::ROLE_ID_MANAGER], $contextId)) {
    file_put_contents($logFile, "ERROR: Permission denied for user " . $user->getUsername() . "\n", FILE_APPEND);
    header('Content-Type: application/json');
    echo json_encode(['status' => false, 'error' => 'Permission denied']);
    exit;
}

file_put_contents($logFile, "Permission check passed\n", FILE_APPEND);

// Get the action
$action = $_REQUEST['action'] ?? $_POST['action'] ?? $_GET['action'] ?? null;
file_put_contents($logFile, "Action: " . var_export($action, true) . "\n", FILE_APPEND);

if (!$action) {
    file_put_contents($logFile, "ERROR: No action specified\n", FILE_APPEND);
    header('Content-Type: application/json');
    echo json_encode(['status' => false, 'error' => 'No action specified']);
    exit;
}

file_put_contents($logFile, "Calling plugin method for action: " . $action . "\n", FILE_APPEND);

// Call the plugin's AJAX handler using reflection
try {
    $reflectionClass = new \ReflectionClass($plugin);
    file_put_contents($logFile, "Reflection class created\n", FILE_APPEND);

    $method = $reflectionClass->getMethod('_handleDesignerAjax');
    file_put_contents($logFile, "Method _handleDesignerAjax found\n", FILE_APPEND);

    $method->setAccessible(true);
    file_put_contents($logFile, "Method set accessible\n", FILE_APPEND);

    $result = $method->invoke($plugin, $request);
    file_put_contents($logFile, "Method invoked, result type: " . gettype($result) . "\n", FILE_APPEND);

    // The method returns JSONMessage, but we want raw JSON
    // So we'll just call the method directly and let it output JSON with headers
    if ($result && is_a($result, 'PKP\\core\\JSONMessage')) {
        file_put_contents($logFile, "Returning JSONMessage\n", FILE_APPEND);
        header('Content-Type: application/json');
        echo $result->getString();
        exit;
    } else {
        file_put_contents($logFile, "Result is not JSONMessage, type: " . (is_object($result) ? get_class($result) : gettype($result)) . "\n", FILE_APPEND);
        file_put_contents($logFile, "Result content: " . var_export($result, true) . "\n", FILE_APPEND);
    }
} catch (\Exception $e) {
    file_put_contents($logFile, "EXCEPTION: " . $e->getMessage() . "\n", FILE_APPEND);
    file_put_contents($logFile, "Stack trace: " . $e->getTraceAsString() . "\n", FILE_APPEND);
    header('Content-Type: application/json');
    echo json_encode(['status' => false, 'error' => 'Error: ' . $e->getMessage()]);
    exit;
}
