<?php

/**
 * @file plugins/generic/goValidOJS/classes/EmailDesignTemplateLibrary.php
 *
 * Copyright (c) 2025 Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * @class EmailDesignTemplateLibrary
 * @ingroup plugins_generic_goValidOJS
 *
 * @brief Provides starter design templates for email customization
 */

namespace APP\plugins\generic\goValidOJS\classes;

class EmailDesignTemplateLibrary {

    /**
     * Get all available starter design templates
     * @return array List of design templates
     */
    public static function getDesignTemplates() {
        return [
            'professional' => self::getProfessionalDesign(),
            'modern' => self::getModernDesign(),
            'minimal' => self::getMinimalDesign(),
            'elegant' => self::getElegantDesign(),
            'academic' => self::getAcademicDesign()
        ];
    }

    /**
     * Get a specific design template by key
     * @param string $key Template key
     * @return array|null Design template or null
     */
    public static function getDesignTemplate($key) {
        $templates = self::getDesignTemplates();
        return $templates[$key] ?? null;
    }

    /**
     * Professional design template
     */
    private static function getProfessionalDesign() {
        return [
            'name' => 'Professional',
            'description' => 'Clean professional design with subtle colors',
            'preview' => 'professional-preview.png',
            'config' => [
                'settings' => [
                    'fontFamily' => 'Arial, sans-serif',
                    'fontSize' => 16,
                    'lineHeight' => '1.6',
                    'emailWidth' => 600,
                    'outerBgColor' => '#ffffff'
                ],
                'header' => [
                    'bgType' => 'solid',
                    'bgColor' => '#2c3e50',
                    'gradientStart' => '#2c3e50',
                    'gradientEnd' => '#34495e',
                    'textColor' => '#ffffff',
                    'padding' => 30,
                    'title' => '{$contextName}',
                    'subtitle' => '',
                    'showLogo' => true,
                    'logoPosition' => 'center',
                    'logoMaxWidth' => 200,
                    'showNameBesideLogo' => false
                ],
                'content' => [
                    'bgColor' => '#ffffff',
                    'textColor' => '#333333',
                    'padding' => 40,
                    'greeting' => 'Dear {$recipientName},',
                    'message' => '',
                    'closing' => 'Best regards,',
                    'showDetailsBox' => false,
                    'detailsBgColor' => '#f8f9fa'
                ],
                'footer' => [
                    'bgColor' => '#ecf0f1',
                    'textColor' => '#2c3e50',
                    'linkColor' => '#3498db',
                    'padding' => 25,
                    'borderWidth' => 3,
                    'borderColor' => '#2c3e50',
                    'signature' => 'Best regards,',
                    'signatureName' => '{$contextName} Editorial Team',
                    'showUrl' => true
                ]
            ]
        ];
    }

    /**
     * Modern design template
     */
    private static function getModernDesign() {
        return [
            'name' => 'Modern',
            'description' => 'Modern gradient design with vibrant colors',
            'preview' => 'modern-preview.png',
            'config' => [
                'settings' => [
                    'fontFamily' => '\'Segoe UI\', Tahoma, Geneva, Verdana, sans-serif',
                    'fontSize' => 16,
                    'lineHeight' => '1.6',
                    'emailWidth' => 600,
                    'outerBgColor' => '#f8f9fa'
                ],
                'header' => [
                    'bgType' => 'gradient',
                    'bgColor' => '#667eea',
                    'gradientStart' => '#667eea',
                    'gradientEnd' => '#764ba2',
                    'textColor' => '#ffffff',
                    'padding' => 40,
                    'title' => '{$contextName}',
                    'subtitle' => '',
                    'showLogo' => true,
                    'logoPosition' => 'center',
                    'logoMaxWidth' => 180,
                    'showNameBesideLogo' => false
                ],
                'content' => [
                    'bgColor' => '#ffffff',
                    'textColor' => '#2c3e50',
                    'padding' => 40,
                    'greeting' => 'Dear {$recipientName},',
                    'message' => '',
                    'closing' => 'Best regards,',
                    'showDetailsBox' => false,
                    'detailsBgColor' => '#f8f9fa'
                ],
                'footer' => [
                    'bgColor' => '#2c3e50',
                    'textColor' => '#ffffff',
                    'linkColor' => '#3498db',
                    'padding' => 25,
                    'borderWidth' => 0,
                    'borderColor' => '#2c3e50',
                    'signature' => 'Best regards,',
                    'signatureName' => '{$contextName} Editorial Team',
                    'showUrl' => true
                ]
            ]
        ];
    }

    /**
     * Minimal design template
     */
    private static function getMinimalDesign() {
        return [
            'name' => 'Minimal',
            'description' => 'Clean and simple minimal design',
            'preview' => 'minimal-preview.png',
            'config' => [
                'settings' => [
                    'fontFamily' => 'Georgia, serif',
                    'fontSize' => 16,
                    'lineHeight' => '1.8',
                    'emailWidth' => 600,
                    'outerBgColor' => '#ffffff'
                ],
                'header' => [
                    'bgType' => 'solid',
                    'bgColor' => '#ffffff',
                    'gradientStart' => '#ffffff',
                    'gradientEnd' => '#f8f9fa',
                    'textColor' => '#333333',
                    'padding' => 40,
                    'title' => '{$contextName}',
                    'subtitle' => '',
                    'showLogo' => true,
                    'logoPosition' => 'center',
                    'logoMaxWidth' => 150,
                    'showNameBesideLogo' => false
                ],
                'content' => [
                    'bgColor' => '#ffffff',
                    'textColor' => '#333333',
                    'padding' => 40,
                    'greeting' => 'Dear {$recipientName},',
                    'message' => '',
                    'closing' => 'Sincerely,',
                    'showDetailsBox' => false,
                    'detailsBgColor' => '#f9f9f9'
                ],
                'footer' => [
                    'bgColor' => '#f9f9f9',
                    'textColor' => '#666666',
                    'linkColor' => '#333333',
                    'padding' => 25,
                    'borderWidth' => 2,
                    'borderColor' => '#e0e0e0',
                    'signature' => 'Sincerely,',
                    'signatureName' => '{$contextName} Editorial Team',
                    'showUrl' => true
                ]
            ]
        ];
    }

    /**
     * Elegant design template
     */
    private static function getElegantDesign() {
        return [
            'name' => 'Elegant',
            'description' => 'Sophisticated elegant design with refined styling',
            'preview' => 'elegant-preview.png',
            'config' => [
                'settings' => [
                    'fontFamily' => '\'Times New Roman\', Times, serif',
                    'fontSize' => 16,
                    'lineHeight' => '1.7',
                    'emailWidth' => 600,
                    'outerBgColor' => '#f5f5f5'
                ],
                'header' => [
                    'bgType' => 'solid',
                    'bgColor' => '#1a1a1a',
                    'gradientStart' => '#1a1a1a',
                    'gradientEnd' => '#2d2d2d',
                    'textColor' => '#d4af37',
                    'padding' => 40,
                    'title' => '{$contextName}',
                    'subtitle' => '',
                    'showLogo' => true,
                    'logoPosition' => 'center',
                    'logoMaxWidth' => 180,
                    'showNameBesideLogo' => false
                ],
                'content' => [
                    'bgColor' => '#ffffff',
                    'textColor' => '#333333',
                    'padding' => 45,
                    'greeting' => 'Dear {$recipientName},',
                    'message' => '',
                    'closing' => 'With warm regards,',
                    'showDetailsBox' => false,
                    'detailsBgColor' => '#fafafa'
                ],
                'footer' => [
                    'bgColor' => '#1a1a1a',
                    'textColor' => '#d4af37',
                    'linkColor' => '#d4af37',
                    'padding' => 30,
                    'borderWidth' => 3,
                    'borderColor' => '#d4af37',
                    'signature' => 'With warm regards,',
                    'signatureName' => '{$contextName}',
                    'showUrl' => true
                ]
            ]
        ];
    }

    /**
     * Academic design template
     */
    private static function getAcademicDesign() {
        return [
            'name' => 'Academic',
            'description' => 'Traditional academic design for scholarly communications',
            'preview' => 'academic-preview.png',
            'config' => [
                'settings' => [
                    'fontFamily' => '\'Palatino Linotype\', \'Book Antiqua\', Palatino, serif',
                    'fontSize' => 15,
                    'lineHeight' => '1.8',
                    'emailWidth' => 650,
                    'outerBgColor' => '#fafafa'
                ],
                'header' => [
                    'bgType' => 'solid',
                    'bgColor' => '#003366',
                    'gradientStart' => '#003366',
                    'gradientEnd' => '#004080',
                    'textColor' => '#ffffff',
                    'padding' => 35,
                    'title' => '{$contextName}',
                    'subtitle' => 'Scholarly Communication',
                    'showLogo' => true,
                    'logoPosition' => 'center',
                    'logoMaxWidth' => 200,
                    'showNameBesideLogo' => false
                ],
                'content' => [
                    'bgColor' => '#ffffff',
                    'textColor' => '#2d2d2d',
                    'padding' => 40,
                    'greeting' => 'Dear {$recipientName},',
                    'message' => '',
                    'closing' => 'Yours sincerely,',
                    'showDetailsBox' => false,
                    'detailsBgColor' => '#f0f4f8'
                ],
                'footer' => [
                    'bgColor' => '#f0f4f8',
                    'textColor' => '#003366',
                    'linkColor' => '#003366',
                    'padding' => 30,
                    'borderWidth' => 2,
                    'borderColor' => '#003366',
                    'signature' => 'Yours sincerely,',
                    'signatureName' => '{$contextName} Editorial Office',
                    'showUrl' => true
                ]
            ]
        ];
    }
}
