# GoValid OJS Plugin - Information

## Plugin Information

**Plugin Name**: GoValid OJS
**Version**: 1.2.0
**Release Date**: December 10, 2025
**Type**: Generic Plugin
**Author**: Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia
**License**: GNU GPL v3

## System Requirements

### Compatible OJS Version
- **OJS Version**: 3.4.0.x (tested and verified on 3.4.0.4)
- **OJS Type**: ojs2

### Server Requirements
- **PHP Version**: 8.3.6 or higher
- **Web Server**: Apache 2.4.58 or higher (Ubuntu)
- **Database**: MySQL 8.0.43 or higher
- **Operating System**: Linux (Ubuntu) - Kernel 6.8.0-85-generic
- **Required PHP Extensions**:
  - GD (for image processing)
  - JSON
  - MySQL/MySQLi
  - cURL
  - mbstring

### Browser Requirements
- Modern browsers with JavaScript enabled
- HTML5 Canvas support
- Support for:
  - Fabric.js (canvas manipulation)
  - Base64 encoding/decoding
  - Blob API
  - FormData API
  - Camera/MediaDevices API (for QR scanning)

## Features

### Smart Verify Widget (NEW in v1.1.0)
- **Floating Action Button (FAB)**: Expandable verification widget on article pages
- **Three Verification Methods**:
  1. **QR ID Search**: Enter formatted UUID (e.g., 1ACE-DO-aebc7591)
  2. **Camera Scan**: Real-time QR code scanning using device camera
  3. **Image Upload**: Upload QR code image for verification
- **Rich Verification Results**:
  - QR Code name and ID
  - Template type
  - Generated by (creator name with verified badge)
  - Institution name
  - Scan count
- **Anti-Counterfeit Detection**:
  - Warning display for suspicious activity
  - Block display for potentially counterfeit QR codes
  - Violation details and messages
- **Supports All Security Levels**:
  - SMART (ultra-compact)
  - VERIFIED
  - SECURE
  - ENTERPRISE (Ed25519 signed)

### Certificate Designer
- **Visual Canvas Editor**: Drag-and-drop interface for designing certificates
- **High Resolution Export**: 3x resolution multiplier (300 DPI quality)
- **Flexible Layouts**: Support for both Portrait and Landscape orientations
- **Template System**: Save and load custom certificate templates
- **Background Support**: Upload and manage background images

### Design Elements
- **Text Fields**: Dynamic text fields with center alignment by default
  - Reviewer Name
  - Author Name
  - Editor Name
  - Article Title
  - Journal Name
  - Submission ID
  - Review Date
  - Issue information
  - And many more...
- **Journal Logo**: Auto-scaled to 150px width with aspect ratio preservation
- **QR Codes**: Support for QR code generation and placement
- **Shapes**: Basic shapes (rectangle, circle, line)
- **Custom Images**: Upload and place custom images

### Email Integration
- **Direct Email Sending**: Send certificates directly via email
- **Email Templates**: Customizable email templates
- **Multi-recipient Support**: To, CC, and BCC fields
- **Attachment Management**: Attach certificates as JPG (up to 5MB)
- **Additional Attachments**: Support for multiple file attachments (total 10MB max)

### Export Options
- **JPG Export**: High-quality JPEG download (3x resolution)
- **Direct Download**: One-click download functionality
- **Email Delivery**: Send certificates via email with attachments

### Authentication & Security
- **GoValid Integration**: Integrated with GoValid authentication system
- **Login Protection**: Requires login for:
  - Saving templates
  - Loading templates
  - Downloading certificates
  - Sending emails
- **Subscription Verification**: Checks user subscription status before operations
- **Template Limits**: Maximum 5 templates per user (configurable)

### User Interface
- **Icon-only Buttons**: Clean, minimal interface for Save/Load/Download buttons
- **Confirmation Dialogs**:
  - Save confirmation with template details
  - Overwrite warning for existing templates
- **Live Preview**: Real-time canvas preview (no separate preview button needed)
- **Responsive Design**: Works on various screen sizes

## Installation

1. Extract the plugin to: `/path/to/ojs/plugins/generic/goValidOJS`
2. Clear OJS cache: `php tools/runScheduledTasks.php`
3. Login to OJS as Administrator
4. Navigate to: Settings > Website > Plugins
5. Find "GoValid OJS Plugin" and click "Enable"

## Configuration

### Initial Setup
1. Enable the plugin in OJS settings
2. Configure journal logo in Journal Settings
3. Set up GoValid authentication credentials
4. Configure SMTP settings for email functionality

### Template Management
- Maximum 5 templates per user
- Templates are saved to database
- Templates include canvas data, orientation, and timestamp

### Email Settings
- Configure sender email in Journal Settings
- Set up SMTP server for email delivery
- File size limits:
  - Certificate: 5MB max
  - Total attachments: 10MB max

## Usage

### Smart Verify Widget
1. Navigate to any article page
2. Click the floating GoValid badge button (bottom-right)
3. Choose verification method:
   - **Search**: Enter QR ID like `1ACE-DO-aebc7591`
   - **Camera**: Allow camera access and point at QR code
   - **Upload**: Click or drag-drop a QR code image
4. View verification results including:
   - QR Code details
   - Creator information
   - Institution
   - Anti-counterfeit warnings (if applicable)

### Creating a Certificate
1. Login to GoValid
2. Navigate to the Certificate Designer
3. Design your certificate using the canvas tools
4. Save as a template (optional)
5. Download or send via email

### Designer Interface
**Main Toolbar**:
- **Download**: Export certificate as high-quality JPG
- **Send Email**: Send certificate via email to recipients

**Canvas Controls**:
- **Save** (icon): Save current design as template
- **Load** (icon): Load saved template
- **Gallery**: Browse template gallery
- **Clear All**: Clear entire canvas

**Properties Panel**:
- Drag and drop fields onto canvas
- Configure text properties (font, size, color, alignment)
- Manage background images
- Add shapes and elements

### Keyboard Shortcuts
- **Delete**: Remove selected object
- **Ctrl+C**: Copy selected object
- **Ctrl+V**: Paste copied object
- **Ctrl+Z**: Undo (browser native)

## Technical Specifications

### Canvas Specifications
- **Default DPI**: 96 DPI (screen display)
- **Export DPI**: 300 DPI (3x multiplier)
- **A4 Dimensions**:
  - Landscape: 1123px × 794px (screen) / 3369px × 2382px (export)
  - Portrait: 794px × 1123px (screen) / 2382px × 3369px (export)

### File Format Support
- **Export**: JPEG (high quality, 92% initial quality)
- **Backgrounds**: PNG, JPG, GIF
- **Attachments**: PDF, PNG, JPG, GIF

### Performance
- **Maximum Template Size**: Limited by browser memory
- **Export Time**: ~2-5 seconds for 3x resolution
- **File Size Optimization**: Automatic quality reduction if file exceeds 5MB

### Smart Verify API Integration
- **QR Lookup API**: `/qr_codes/api/v1/qr/lookup/`
- **Verify Signed API**: `/api/v1/ojs/verify-signed/`
- **Decode QR Image API**: `/api/v1/ojs/decode-qr-image/`
- **Scan Verify API**: `/api/v1/scan/verify/`

## Changelog

### Version 1.2.0 (2025-12-10)
**New Features:**
- Added {QR_ID} placeholder as default element on canvas (below QR code)
- Added Email Template Designer button (green rounded icon) next to Send Email button
- QR ID displays formatted UUID (e.g., 6ACE-CE-477e51db) after QR generation

**Improvements:**
- Fixed {QR_IDENTIFIER} placeholder to use field value if filled, not auto-generate
- Improved "Refresh/Load to Canvas" button to properly update QR-related placeholders
- Stored QR Identifier and QR ID globally for use after QR generation
- All QR placeholders ({QR_CODE}, {QR_ID}, {QR_IDENTIFIER}) now reset properly when loading templates

**Technical Changes:**
- Added `currentQRIdentifierCode` global variable in designer-ui.js
- Added `window.getCurrentQRIdentifierCode()` accessor function
- Updated designer-content.js to prioritize field value over auto-generated identifiers
- Added QR ID default placement in designer-init.js

### Version 1.1.0 (2025-12-10)
**New Features:**
- Added Smart Verify Widget with FAB interface
- Three verification methods: QR ID search, Camera scan, Image upload
- Display creator information (name, verified badge)
- Display institution name for institutional QR codes
- Anti-counterfeit warning and block display
- Support for all QR security levels (SMART, VERIFIED, SECURE, ENTERPRISE)

**Technical Improvements:**
- Added `smart-verify-widget-loader.js` for self-contained widget
- Added `smart-verify-widget.css` for widget styling
- Integrated jsQR library for client-side QR decoding
- Added support for both API response formats (lookup vs verify-signed)
- Enhanced error handling for camera and file upload

**API Enhancements:**
- Added `creator` object to verify-signed API response
- Added `anti_counterfeit` object to verify-signed API response
- Support for VERIFIED/SMART token verification
- Normalized anti-counterfeit data format across APIs

### Version 1.0.1 (2025-12-09)
- Minor bug fixes
- Updated template handling

### Version 1.0.0 (2025-07-10)
- Initial release
- Basic certificate designer
- Template management
- Email integration
- GoValid authentication

## Troubleshooting

### Common Issues

**Issue**: Certificate attachment corrupted in email
**Solution**: Ensure you're using version 5.11.0 or higher with Blob upload fix

**Issue**: Login button not updating after login
**Solution**: Check browser console for errors, clear cache, reload page

**Issue**: Smart Verify camera not working
**Solution**: Ensure HTTPS is enabled (camera requires secure context), check browser permissions

**Issue**: QR code not found during verification
**Solution**: Verify the QR code exists in the GoValid system, check the formatted UUID format

**Issue**: Anti-counterfeit warning not showing
**Solution**: Ensure the QR code has an anti-counterfeit profile assigned

### Cache Issues
If changes don't appear, clear OJS cache:
```bash
/var/www/ojs-dev/FIX_CACHE.sh
```

Or manually:
```bash
rm -rf /path/to/ojs/cache/*
sudo systemctl restart apache2
```

## Support

For issues, questions, or feature requests:
- **Institution**: University Of Muhammadiyah Makassar, Indonesia
- **Contact**: System Administrator
- **Documentation**: See plugin files and inline comments

## License

Copyright (c) 2025 Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

## Credits

- **Development**: Naufal Naufal
- **Institution**: University Of Muhammadiyah Makassar, Indonesia
- **Framework**: Open Journal Systems (OJS) 3.4
- **Libraries Used**:
  - Fabric.js (Canvas manipulation)
  - QRCode.js (QR code generation)
  - jsQR (QR code decoding)
  - Laravel Mail (Email functionality)
  - Font Awesome (Icons)

---

**Last Updated**: December 10, 2025
**Plugin Version**: 1.2.0
**OJS Compatibility**: 3.4.0.x
