{**
 * templates/smartVerifyWidget.tpl
 *
 * Copyright (c) 2025 GoValid
 * Distributed under the GNU GPL v3.
 *
 * Smart Verify floating widget for public pages
 *}

{* Smart Verify Widget Container *}
<div id="govalid-smart-verify-widget" class="govalid-sv-widget govalid-sv-{$widgetPosition}" style="display: none;">
    {* Floating Button *}
    <button id="govalid-sv-toggle" class="govalid-sv-toggle" title="Verify QR Code">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
            <polyline points="22 4 12 14.01 9 11.01"></polyline>
        </svg>
    </button>

    {* Widget Panel *}
    <div id="govalid-sv-panel" class="govalid-sv-panel">
        <div class="govalid-sv-header">
            <div class="govalid-sv-title">
                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
                    <polyline points="22 4 12 14.01 9 11.01"></polyline>
                </svg>
                Smart Verify
            </div>
            <button id="govalid-sv-close" class="govalid-sv-close">&times;</button>
        </div>

        <div class="govalid-sv-body">
            {* Tab Navigation *}
            <div class="govalid-sv-tabs">
                <button class="govalid-sv-tab active" data-tab="qr-id">QR ID</button>
                <button class="govalid-sv-tab" data-tab="camera">Camera</button>
                <button class="govalid-sv-tab" data-tab="upload">Upload</button>
            </div>

            {* QR ID Search Tab *}
            <div id="govalid-sv-tab-qr-id" class="govalid-sv-tab-content active">
                <div class="govalid-sv-input-group">
                    <input type="text" id="govalid-sv-qr-input" class="govalid-sv-input" placeholder="Enter QR ID (e.g., 1ACE-DO-abc123)" />
                    <button id="govalid-sv-search-btn" class="govalid-sv-btn-primary">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="11" cy="11" r="8"></circle>
                            <path d="m21 21-4.35-4.35"></path>
                        </svg>
                    </button>
                </div>
                <div class="govalid-sv-hint">Format: XXXX-XX-xxxxxxxx or XXXXXXxxxxxxxx</div>
            </div>

            {* Camera Tab *}
            <div id="govalid-sv-tab-camera" class="govalid-sv-tab-content">
                <div class="govalid-sv-camera-container">
                    <video id="govalid-sv-video" class="govalid-sv-camera-video" playsinline muted></video>
                    <div class="govalid-sv-camera-overlay">
                        <div class="govalid-sv-scan-region"></div>
                    </div>
                </div>
                <div class="govalid-sv-camera-controls">
                    <button id="govalid-sv-camera-toggle" class="govalid-sv-btn-secondary">Start Camera</button>
                    <button id="govalid-sv-camera-switch" class="govalid-sv-btn-secondary" style="display: none;">Switch Cam</button>
                </div>
                <div id="govalid-sv-camera-status" class="govalid-sv-camera-status">Camera permission required</div>
            </div>

            {* Upload Tab *}
            <div id="govalid-sv-tab-upload" class="govalid-sv-tab-content">
                <div id="govalid-sv-dropzone" class="govalid-sv-dropzone">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="17 8 12 3 7 8"></polyline>
                        <line x1="12" y1="3" x2="12" y2="15"></line>
                    </svg>
                    <span>Drop image here or click to upload</span>
                    <input type="file" id="govalid-sv-file-input" accept="image/*" style="display: none;" />
                </div>
                <div id="govalid-sv-preview" class="govalid-sv-preview" style="display: none;">
                    <img id="govalid-sv-preview-img" src="" alt="Preview" />
                    <button id="govalid-sv-clear-preview" class="govalid-sv-btn-secondary">Clear</button>
                </div>
            </div>

            {* Results Area *}
            <div id="govalid-sv-results" class="govalid-sv-results" style="display: none;">
                <div id="govalid-sv-loading" class="govalid-sv-loading" style="display: none;">
                    <div class="govalid-sv-spinner"></div>
                    <span>Verifying...</span>
                </div>
                <div id="govalid-sv-result-content"></div>
            </div>
        </div>

        <div class="govalid-sv-footer">
            <a href="https://govalid.org" target="_blank" class="govalid-sv-powered">
                Powered by <strong>GoValid</strong>
            </a>
        </div>
    </div>
</div>

{* Load CSS *}
<link rel="stylesheet" href="{$baseUrl}/plugins/generic/goValidOJS/css/smart-verify-widget.css?v=20251210b" />

{* Load jsQR library for QR code scanning *}
<script src="https://cdn.jsdelivr.net/npm/jsqr@1.4.0/dist/jsQR.min.js"></script>

{* Load Widget JavaScript *}
<script src="{$baseUrl}/plugins/generic/goValidOJS/js/smart-verify-widget.js?v=20251210b"></script>
