{**
 * plugins/generic/goValidOJS/templates/emailTemplateManager.tpl
 *
 * Copyright (c) 2025 Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * Email template manager interface
 *}

<div id="emailTemplateManager" class="pkp_page_content">
    <h2>{translate key="plugins.generic.goValidOJS.emailTemplates.title"}</h2>
    
    <div class="pkp_controllers_grid">
        <div class="header">
            <h3>{translate key="plugins.generic.goValidOJS.emailTemplates.available"}</h3>
            <div class="actions">
                <a href="{url op="emailTemplateForm"}" class="pkp_button pkp_button_primary">
                    {translate key="plugins.generic.goValidOJS.emailTemplates.create"}
                </a>
            </div>
        </div>
        
        <div class="template-grid">
            {foreach from=$emailTemplates item=template key=templateId}
                <div class="template-card" data-template-id="{$templateId}">
                    <div class="template-header">
                        <h4>{$template.name|escape}</h4>
                        <div class="template-actions">
                            <button class="pkp_button pkp_button_offset preview-btn" 
                                    data-template-id="{$templateId}">
                                {translate key="plugins.generic.goValidOJS.emailTemplates.preview"}
                            </button>
                            <button class="pkp_button pkp_button_primary test-btn" 
                                    data-template-id="{$templateId}">
                                Test Email
                            </button>
                            {if $template.custom}
                                <button class="pkp_button edit-btn" 
                                        data-template-id="{$templateId}">
                                    {translate key="plugins.generic.goValidOJS.emailTemplates.edit"}
                                </button>
                                <button class="pkp_button pkp_button_offset delete-btn" 
                                        data-template-id="{$templateId}">
                                    {translate key="plugins.generic.goValidOJS.emailTemplates.delete"}
                                </button>
                            {/if}
                        </div>
                    </div>
                    
                    <div class="template-info">
                        <p><strong>{translate key="plugins.generic.goValidOJS.emailTemplates.subject"}:</strong> 
                           {$template.subject|escape|truncate:60}</p>
                        
                        <div class="template-status">
                            {if $selectedTemplate == $templateId}
                                <span class="status-badge active">
                                    {translate key="plugins.generic.goValidOJS.emailTemplates.active"}
                                </span>
                            {else}
                                <button class="pkp_button pkp_button_offset activate-btn" 
                                        data-template-id="{$templateId}">
                                    {translate key="plugins.generic.goValidOJS.emailTemplates.activate"}
                                </button>
                            {/if}
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
    
    {* Placeholder Reference *}
    <div class="placeholder-reference">
        <h3>{translate key="plugins.generic.goValidOJS.emailTemplates.placeholders"}</h3>
        <div class="placeholder-grid">
            <div class="placeholder-group">
                <h4>{translate key="plugins.generic.goValidOJS.emailTemplates.placeholders.reviewer"}</h4>
                <ul>
                    <li><code>{literal}{{reviewer_name}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.reviewer_name"}</li>
                    <li><code>{literal}{{reviewer_email}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.reviewer_email"}</li>
                </ul>
            </div>
            
            <div class="placeholder-group">
                <h4>{translate key="plugins.generic.goValidOJS.emailTemplates.placeholders.article"}</h4>
                <ul>
                    <li><code>{literal}{{article_title}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.article_title"}</li>
                    <li><code>{literal}{{article_authors}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.article_authors"}</li>
                    <li><code>{literal}{{issue_title}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.issue_title"}</li>
                </ul>
            </div>
            
            <div class="placeholder-group">
                <h4>{translate key="plugins.generic.goValidOJS.emailTemplates.placeholders.journal"}</h4>
                <ul>
                    <li><code>{literal}{{journal_name}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.journal_name"}</li>
                    <li><code>{literal}{{journal_url}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.journal_url"}</li>
                    <li><code>{literal}{{contact_email}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.contact_email"}</li>
                </ul>
            </div>
            
            <div class="placeholder-group">
                <h4>{translate key="plugins.generic.goValidOJS.emailTemplates.placeholders.logo"}</h4>
                <ul>
                    <li><code>{literal}{{journal_logo_url}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.journal_logo_url"}</li>
                    <li><code>{literal}{{journal_logo_alt}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.journal_logo_alt"}</li>
                    <li><code>{literal}{{journal_logo_width}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.journal_logo_width"}</li>
                    <li><code>{literal}{{journal_logo_height}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.journal_logo_height"}</li>
                </ul>
            </div>
            
            <div class="placeholder-group">
                <h4>{translate key="plugins.generic.goValidOJS.emailTemplates.placeholders.conditional"}</h4>
                <ul>
                    <li><code>{literal}{{#if journal_logo_url}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.conditional_start"}</li>
                    <li><code>{literal}{{/if}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.conditional_end"}</li>
                </ul>
            </div>
            
            <div class="placeholder-group">
                <h4>{translate key="plugins.generic.goValidOJS.emailTemplates.placeholders.other"}</h4>
                <ul>
                    <li><code>{literal}{{review_date}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.review_date"}</li>
                    <li><code>{literal}{{custom_message}}{/literal}</code> - {translate key="plugins.generic.goValidOJS.emailTemplates.placeholder.custom_message"}</li>
                </ul>
            </div>
        </div>
    </div>
</div>

{* Preview Modal *}
<div id="emailPreviewModal" class="pkp_modal pkp_modal_panel" style="display: none;">
    <div class="pkp_modal_content">
        <div class="pkp_modal_header">
            <h3>{translate key="plugins.generic.goValidOJS.emailTemplates.preview"}</h3>
            <button class="pkp_modal_close" onclick="closePreviewModal()">&times;</button>
        </div>
        <div class="pkp_modal_body">
            <div class="preview-controls">
                <button class="pkp_button pkp_button_offset" onclick="togglePreviewMode()">
                    {translate key="plugins.generic.goValidOJS.emailTemplates.preview.toggle"}
                </button>
                <button class="pkp_button pkp_button_offset" onclick="sendTestEmail()">
                    {translate key="plugins.generic.goValidOJS.emailTemplates.preview.sendTest"}
                </button>
            </div>
            <div id="previewContent" class="preview-content"></div>
        </div>
    </div>
</div>

<style>
.template-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.template-card {
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 20px;
    background: white;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.template-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}

.template-header h4 {
    margin: 0;
    color: #333;
}

.template-actions {
    display: flex;
    gap: 8px;
}

.template-actions button {
    padding: 6px 12px;
    font-size: 12px;
}

.template-info {
    margin-top: 15px;
}

.template-status {
    margin-top: 10px;
}

.status-badge {
    display: inline-block;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 12px;
    font-weight: bold;
}

.status-badge.active {
    background: #28a745;
    color: white;
}

.placeholder-reference {
    margin-top: 40px;
    padding: 20px;
    background: #f8f9fa;
    border-radius: 8px;
}

.placeholder-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.placeholder-group {
    background: white;
    padding: 15px;
    border-radius: 6px;
    border: 1px solid #e9ecef;
}

.placeholder-group h4 {
    margin: 0 0 10px 0;
    color: #495057;
    font-size: 14px;
}

.placeholder-group ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.placeholder-group li {
    padding: 4px 0;
    font-size: 13px;
    border-bottom: 1px solid #f1f3f4;
}

.placeholder-group li:last-child {
    border-bottom: none;
}

.placeholder-group code {
    background: #f1f3f4;
    padding: 2px 4px;
    border-radius: 3px;
    font-size: 12px;
    font-family: monospace;
    color: #d63384;
}

.pkp_modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.5);
    z-index: 1000;
}

.pkp_modal_content {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: white;
    border-radius: 8px;
    max-width: 90%;
    max-height: 90%;
    overflow: auto;
    min-width: 600px;
}

.pkp_modal_header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px;
    border-bottom: 1px solid #ddd;
}

.pkp_modal_header h3 {
    margin: 0;
}

.pkp_modal_close {
    background: none;
    border: none;
    font-size: 24px;
    cursor: pointer;
    color: #666;
}

.pkp_modal_body {
    padding: 20px;
}

.preview-controls {
    margin-bottom: 20px;
    display: flex;
    gap: 10px;
}

.preview-content {
    border: 1px solid #ddd;
    border-radius: 6px;
    padding: 20px;
    background: #f8f9fa;
    min-height: 400px;
}

.preview-content iframe {
    width: 100%;
    height: 500px;
    border: none;
    border-radius: 4px;
}
</style>

<script>
function previewTemplate(templateId) {
    // Show loading
    document.getElementById('previewContent').innerHTML = '<div class="loading">Loading preview...</div>';
    document.getElementById('emailPreviewModal').style.display = 'block';
    
    // Load preview content
    fetch('{url op="previewTemplate"}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'templateId=' + encodeURIComponent(templateId) + '&{$smarty.const.SESSION_CSRF_TOKEN}={$csrfToken}'
    })
    .then(response => response.text())
    .then(html => {
        document.getElementById('previewContent').innerHTML = html;
    })
    .catch(error => {
        document.getElementById('previewContent').innerHTML = '<div class="error">Error loading preview</div>';
    });
}

function closePreviewModal() {
    document.getElementById('emailPreviewModal').style.display = 'none';
}

function testEmailTemplate(templateId) {
    if (!templateId) {
        alert('No template selected');
        return;
    }
    
    const testEmail = prompt('Enter email address to send test email:', 'naufal.unismuh@gmail.com');
    if (!testEmail) {
        return;
    }
    
    // Show loading message
    alert('Sending test email to ' + testEmail + '...');
    
    fetch('{url op="testEmail"}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'templateId=' + encodeURIComponent(templateId) + '&testEmail=' + encodeURIComponent(testEmail) + '&{$smarty.const.SESSION_CSRF_TOKEN}={$csrfToken}'
    })
    .then(response => response.json())
    .then(data => {
        if (data.content && data.content.success) {
            alert(data.content.message);
        } else {
            alert(data.content ? data.content.error : 'Failed to send test email');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error sending test email: ' + error.message);
    });
}

function togglePreviewMode() {
    const content = document.getElementById('previewContent');
    const isHtml = content.innerHTML.includes('<iframe');
    
    if (isHtml) {
        // Switch to HTML source view
        const iframe = content.querySelector('iframe');
        const htmlContent = iframe.contentDocument.documentElement.outerHTML;
        content.innerHTML = '<pre style="white-space: pre-wrap; font-family: monospace; font-size: 12px;">' + 
                           htmlContent.replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</pre>';
    } else {
        // Switch back to rendered view
        location.reload(); // Simple reload for now
    }
}

function activateTemplate(templateId) {
    fetch('{url op="activateTemplate"}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'templateId=' + encodeURIComponent(templateId) + '&{$smarty.const.SESSION_CSRF_TOKEN}={$csrfToken}'
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert('Error activating template');
        }
    });
}

function deleteTemplate(templateId) {
    if (confirm('{translate key="plugins.generic.goValidOJS.emailTemplates.delete.confirm"}')) {
        fetch('{url op="deleteTemplate"}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: 'templateId=' + encodeURIComponent(templateId) + '&{$smarty.const.SESSION_CSRF_TOKEN}={$csrfToken}'
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error deleting template');
            }
        });
    }
}

// Event listeners
document.addEventListener('DOMContentLoaded', function() {
    // Preview buttons
    document.querySelectorAll('.preview-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            previewTemplate(this.dataset.templateId);
        });
    });
    
    // Test email buttons
    document.querySelectorAll('.test-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            testEmailTemplate(this.dataset.templateId);
        });
    });
    
    // Edit buttons
    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            window.location.href = '{url op="emailTemplateForm"}&templateId=' + this.dataset.templateId;
        });
    });
    
    // Delete buttons
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            deleteTemplate(this.dataset.templateId);
        });
    });
    
    // Activate buttons
    document.querySelectorAll('.activate-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            activateTemplate(this.dataset.templateId);
        });
    });
    
    // Close modal on outside click
    document.getElementById('emailPreviewModal').addEventListener('click', function(e) {
        if (e.target === this) {
            closePreviewModal();
        }
    });
});
</script>