# GoValid OJS Plugin - Information

## Plugin Information

**Plugin Name**: GoValid OJS
**Version**: 1.0.0
**Release Date**: December 9, 2025
**Type**: Generic Plugin
**Author**: Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia
**License**: GNU GPL v3

## System Requirements

### Compatible OJS Version
- **OJS Version**: 3.3.0.17 (tested and verified)
- **OJS Type**: ojs2
- **Compatibility**: OJS 3.3.x series

### Server Requirements
- **PHP Version**: 8.2.x or higher (tested on 8.2.29)
- **Web Server**: Apache 2.4.x or higher
- **Database**: MySQL 8.0.x or MariaDB 10.x
- **Operating System**: Linux (Ubuntu/Debian recommended)
- **Required PHP Extensions**:
  - GD (for image processing)
  - JSON
  - MySQL/MySQLi
  - cURL
  - mbstring
  - OpenSSL

### Browser Requirements
- Modern browsers with JavaScript enabled
- HTML5 Canvas support
- Support for:
  - Fabric.js (canvas manipulation)
  - Base64 encoding/decoding
  - Blob API
  - FormData API

## Features

### Certificate Designer
- **Visual Canvas Editor**: Drag-and-drop interface for designing certificates
- **High Resolution Export**: 3x resolution multiplier (300 DPI quality)
- **Flexible Layouts**: Support for both Portrait and Landscape orientations
- **Template System**: Save and load custom certificate templates
- **Background Support**: Upload and manage background images

### Design Elements
- **Text Fields**: Dynamic text fields with center alignment by default
  - Reviewer Name
  - Author Name
  - Editor Name
  - Article Title
  - Journal Name
  - Submission ID
  - Review Date
  - Issue information (Volume, Number, Year)
  - DOI
  - And many more...
- **Journal Logo**: Auto-scaled to 150px width with aspect ratio preservation
- **QR Codes**: Support for QR code generation and placement with GoValid integration
- **Shapes**: Basic shapes (rectangle, circle, line)
- **Custom Images**: Upload and place custom images

### Email Designer
- **Visual Email Template Designer**: Design custom email templates with header, content, and footer sections
- **OJS Native Integration**: Templates saved to OJS email template system
- **Design Settings**:
  - Header: Logo, title, subtitle, background color/gradient, text color, padding
  - Content: Greeting, message body, article details box, closing
  - Footer: Signature, signature name, journal URL, colors, border
  - General: Font family, font size, line height, email width, outer background
- **Logo Position Options**: Center, Left, Right, with option to show name beside logo
- **Gradient Support**: Header backgrounds support gradient colors
- **Variable Placeholders**: Support for OJS template variables

### Email Integration
- **Direct Email Sending**: Send certificates directly via email
- **Email Templates**: Use templates created in Email Designer
- **Multi-recipient Support**: To, CC, and BCC fields
- **User Autocomplete**: Search OJS users when composing emails
- **Attachment Management**: Attach certificates as JPG (up to 5MB)
- **Additional Attachments**: Support for multiple file attachments (total 10MB max)

### QR Code Generation
- **GoValid Integration**: Generate QR codes through GoValid API
- **Signed Certificates**: Support for digitally signed certificates with PIN verification
- **Security Levels**: Standard, Secure, and Enterprise security options
- **Password Protection**: Optional password protection for QR codes
- **Certificate Metadata**: Include identifier, recipient, issuer, dates, description

### Signed Certificate Flow (PIN Verification)
1. User enables "Signed By" toggle
2. System checks PIN status via GoValid API
3. User enters 6-digit PIN for verification
4. Upon successful verification, receives `qr_session_token`
5. Token is used for signed QR code generation
6. Token expires after 5 minutes for security

### Export Options
- **JPG Export**: High-quality JPEG download (3x resolution)
- **Direct Download**: One-click download functionality
- **Email Delivery**: Send certificates via email with attachments

### Authentication & Security
- **GoValid Integration**: Integrated with GoValid authentication system
- **Login Protection**: Requires login for:
  - Saving templates
  - Loading templates
  - Downloading certificates
  - Sending emails
  - Generating QR codes
- **Subscription Verification**: Checks user subscription status before operations
- **PIN Verification**: Required for signed certificates
- **Session Token Security**: Short-lived tokens for signed operations

### User Interface
- **Icon-only Buttons**: Clean, minimal interface for Save/Load/Download buttons
- **Confirmation Dialogs**:
  - Save confirmation with template details
  - Overwrite warning for existing templates
- **Live Preview**: Real-time canvas preview (no separate preview button needed)
- **Responsive Design**: Works on various screen sizes

## Installation

1. Extract the plugin to: `/path/to/ojs/plugins/generic/goValidOJS`
2. Clear OJS cache: `rm -rf cache/*`
3. Login to OJS as Administrator
4. Navigate to: Settings > Website > Plugins
5. Find "GoValid OJS Plugin" and click "Enable"

## Configuration

### Initial Setup
1. Enable the plugin in OJS settings
2. Configure journal logo in Journal Settings
3. Set up GoValid authentication credentials
4. Configure SMTP settings for email functionality

### Template Management
- Templates are saved to OJS database
- Email templates saved with `CUSTOM_` prefix are available in Certificate Designer
- Templates include canvas data, orientation, and timestamp

### Email Settings
- Configure sender email in Journal Settings
- Set up SMTP server for email delivery
- File size limits:
  - Certificate: 5MB max
  - Total attachments: 10MB max

## Usage

### Creating a Certificate
1. Login to GoValid
2. Navigate to the Certificate Designer
3. Select Issue and Article from dropdowns
4. Design your certificate using the canvas tools
5. Configure QR Settings (optional: enable signing)
6. Save as a template (optional)
7. Download or send via email

### Creating an Email Template
1. Navigate to Email Designer
2. Configure header settings (logo, title, colors)
3. Set content (greeting, message, closing)
4. Configure footer (signature, URL)
5. Click "Save" to save as custom template
6. Template will be available in Certificate Designer's "Send Email" modal

### Designer Interface
**Main Toolbar**:
- **Download**: Export certificate as high-quality JPG
- **Send Email**: Send certificate via email to recipients

**Canvas Controls**:
- **Save** (icon): Save current design as template
- **Load** (icon): Load saved template
- **Gallery**: Browse template gallery
- **Clear All**: Clear entire canvas

**Properties Panel**:
- Drag and drop fields onto canvas
- Configure text properties (font, size, color, alignment)
- Manage background images
- Add shapes and elements

**QR Settings Tab**:
- QR Name and Identifier
- Awarded To and Generated By
- Purpose and Description
- Start/End Dates
- Signed By (requires PIN verification)
- Security Level and Password Protection

### Keyboard Shortcuts
- **Delete**: Remove selected object
- **Ctrl+C**: Copy selected object
- **Ctrl+V**: Paste copied object
- **Ctrl+Z**: Undo (browser native)

## Technical Specifications

### Canvas Specifications
- **Default DPI**: 96 DPI (screen display)
- **Export DPI**: 300 DPI (3x multiplier)
- **A4 Dimensions**:
  - Landscape: 1123px x 794px (screen) / 3369px x 2382px (export)
  - Portrait: 794px x 1123px (screen) / 2382px x 3369px (export)

### File Format Support
- **Export**: JPEG (high quality, 92% initial quality)
- **Backgrounds**: PNG, JPG, GIF
- **Attachments**: PDF, PNG, JPG, GIF

### OJS 3.3.x Compatibility
This plugin is specifically designed for OJS 3.3.x and uses:
- `Services::get('emailTemplate')` for email template management
- `DAORegistry::getDAO()` pattern for database access
- `SubmissionDAO` for article retrieval (not `PublishedArticleDAO`)
- `RoleDAO->getUsersByRoleId()` for user search
- OJS 3.3 session management

### API Endpoints (GoValid Backend)
| Action | Endpoint | Method |
|--------|----------|--------|
| Check PIN status | `/api/v1/ojs/pin-status/` | GET |
| Verify PIN | `/api/v1/ojs/verify-pin/` | POST |
| Generate QR | `/api/v1/ojs/generate-qr/` | POST |
| Check Auth | `/api/v1/ojs/check-auth/` | GET |
| Check Subscription | `/api/v1/ojs/check-subscription/` | GET |

## Troubleshooting

### Common Issues

**Issue**: Certificate attachment corrupted in email
**Solution**: Ensure you're using the latest version with Blob upload fix

**Issue**: Login button not updating after login
**Solution**: Check browser console for errors, clear cache, reload page

**Issue**: Email templates not showing header/footer
**Solution**: Re-save templates in Email Designer (templates must have `CUSTOM_` prefix)

**Issue**: "Unrecognized DAO PublishedArticleDAO" error
**Solution**: This is an OJS version mismatch. Ensure you're using the OJS 3.3.x compatible version

**Issue**: User search not working in email modal
**Solution**: The plugin uses `RoleDAO->getUsersByRoleId()` - ensure OJS 3.3.x compatibility

**Issue**: Signed QR code fails with "Invalid or expired session token"
**Solution**:
1. Verify PIN again (tokens expire after 5 minutes)
2. Check that backend returns `qr_session_token` in PIN verification response
3. Ensure token is properly passed to QR generation request

### Cache Issues
If changes don't appear, clear OJS cache:
```bash
rm -rf /path/to/ojs/cache/*
sudo systemctl restart apache2
```

## Support

For issues, questions, or feature requests:
- **Institution**: University Of Muhammadiyah Makassar, Indonesia
- **Contact**: System Administrator
- **Documentation**: See plugin files and inline comments

## Changelog

### Version 1.0.0 (2025-12-09)
- **OJS 3.3.x Compatibility**: Full compatibility with OJS 3.3.0.17
- **Email Designer**: New visual email template designer
- **Email Template Integration**: Save designed templates to OJS native system
- **Certificate Designer Email Modal**: Load saved email templates
- **Signed Certificates**: PIN verification flow for signed QR codes
- **User Search**: Autocomplete for OJS users in email fields
- **Fixed**: DAO compatibility (SubmissionDAO instead of PublishedArticleDAO)
- **Fixed**: Email template service (Services::get pattern for OJS 3.3)
- **Fixed**: User search (RoleDAO->getUsersByRoleId)
- **Enhanced**: Full header/footer support in saved email templates
- **Enhanced**: All Email Designer settings preserved (logo position, colors, gradients, etc.)

## License

Copyright (c) 2025 Naufal Naufal, University Of Muhammadiyah Makassar, Indonesia

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

## Credits

- **Development**: Naufal Naufal
- **Institution**: University Of Muhammadiyah Makassar, Indonesia
- **Framework**: Open Journal Systems (OJS) 3.3.x
- **Libraries Used**:
  - Fabric.js (Canvas manipulation)
  - GoValid API (QR code generation and verification)
  - Font Awesome (Icons)

---

**Last Updated**: December 9, 2025
**Plugin Version**: 1.0.0
**OJS Compatibility**: 3.3.x (tested on 3.3.0.17)
**PHP Compatibility**: 8.2.x (tested on 8.2.29)
