# GoValid OJS Plugin - Changelog

## Version 1.3.5.1-ojs33 (2025-12-17)

### OJS 3.3.x Compatibility Release

This version is specifically built for **OJS 3.3.x** with **PHP 7.4.x - 8.2.x** support.

### Features
- Certificate Designer with QR code integration
- Email Designer with visual template editor
- GoValid authentication integration
- Smart Verify Widget for article verification
- Email template management with OJS integration
- Certificate email sending with attachments
- Anti-counterfeit tag generation

### OJS 3.3 Specific Implementations

#### Handler System
- Uses namespaced `APP\core\Request`
- Handler class with modern OJS 3.3 patterns
- Page handler registration via `LoadHandler` hook

#### Email Templates
- Uses `PKP\mail\EmailTemplate` or `LocaleEmailTemplate`
- Modern DAO patterns with Eloquent-style queries
- `EmailTemplateDAO` with updated method signatures

#### File Management
- `PublicFileManager` with single-argument context path method
- `getContextFilesPath($contextId)` - single argument

#### Context/Journal
- Uses `$context->getLocalizedData('setting')` for localized settings
- Uses `$context->getLocalizedName()` for journal name
- Modern context handling

#### DAO Registry
- Standard `DAORegistry::getDAO('DAOName')` pattern
- Some DAOs may use namespaced class names

#### Plugin Settings
- `$plugin->getSetting($contextId, 'settingName')`
- `$plugin->updateSetting($contextId, 'settingName', $value)`

### PHP Compatibility Notes
- Supports typed properties (PHP 7.4+)
- Uses modern PHP 7.4+ syntax
- Compatible with PHP 8.0, 8.1, 8.2
- Uses `??` null coalescing operator
- Uses arrow functions where applicable

### Requirements
- OJS 3.3.x (3.3.0 - 3.3.0-17)
- PHP 7.4.x - 8.2.x
- MySQL 5.7+ or PostgreSQL 9.5+

### Installation
1. Download and extract to `plugins/generic/goValidOJS/`
2. Enable plugin in Website Settings > Plugins
3. Configure GoValid API credentials in plugin settings

### Migration from OJS 3.1
If upgrading from OJS 3.1:
1. Backup your existing plugin settings
2. Remove old plugin directory
3. Install this OJS 3.3 version
4. Re-configure plugin settings
5. Test all functionality
