# GoValidOJS Installation Guide

## Requirements

- **OJS Version**: 3.4.x
- **PHP Version**: 8.0+
- **PHP Extensions**:
  - curl (for API communication)
  - json
  - mbstring
- **GoValid Account**: Active subscription at [my.govalid.org](https://my.govalid.org)

## Tested On

| Component | Version |
|-----------|---------|
| PHP | 8.3.6 |
| OJS | 3.4.x |

*You can add more tested versions here after testing.*

## Installation Steps

### 1. Download the Plugin

Download the latest release from the plugin repository or clone via Git:

```bash
cd /path/to/ojs/plugins/generic/
git clone https://github.com/yourusername/goValidOJS.git
```

### 2. Set Permissions

Ensure the web server can read the plugin files:

```bash
chmod -R 755 goValidOJS/
chown -R www-data:www-data goValidOJS/  # Adjust user as needed
```

### 3. Install via OJS Admin

1. Log in as Administrator
2. Navigate to Settings → Website → Plugins
3. Click "Upload a New Plugin"
4. Select the goValidOJS.tar.gz file
5. Click "Install"

**OR** if manually installed:

1. Navigate to Settings → Website → Plugins
2. Find "GoValid OJS Plugin" under Generic Plugins
3. Click "Enable"

### 4. Configure the Plugin

1. Click the arrow next to the plugin name
2. Click "Settings"
3. Configure the following options:
   - **Email Notifications**: Enable/disable automatic certificate emails
   - **Certificate Designer**: Click to open the designer interface

## Initial Setup

### 1. GoValid Authentication

When you first open the Certificate Designer:

1. You'll be prompted to log in with your GoValid credentials
2. Enter your GoValid username and password
3. Check "Remember me" to stay logged in
4. Click "Sign In"

### 2. Verify Subscription

After login, the system will verify your GoValid subscription:
- Plan type and limits will be displayed
- Institution membership (if applicable)
- Available QR code quota

### 3. Design Your First Certificate

1. Use the design tools to create your certificate template
2. Add text fields with placeholders:
   - `{reviewer_name}` - Reviewer's full name
   - `{journal_name}` - Journal title
   - `{article_title}` - Article being reviewed
   - `{review_date}` - Completion date
   - `{issue_info}` - Issue details
3. Save the template with a descriptive name

## Database Changes

The plugin creates the following database entries:

### Plugin Settings Table
```sql
-- Stored in plugin_settings table
plugin_name: goValidOJS
setting_name: emailEnabled | savedTemplates | certificateTemplate
```

No additional database tables are created.

## File Structure After Installation

```
ojs/
└── plugins/
    └── generic/
        └── goValidOJS/
            ├── GoValidOJSPlugin.php
            ├── version.xml
            ├── classes/
            ├── templates/
            ├── locale/
            ├── docs/
            └── README.md
```

## Troubleshooting Installation

### Plugin Not Appearing

1. Clear OJS cache:
```bash
rm -rf cache/t_compile/*
rm -rf cache/*.php
```

2. Check file permissions
3. Verify PHP version compatibility

### Enable Debug Mode

In `config.inc.php`:
```ini
[debug]
show_stacktrace = On
display_errors = On
deprecation_warnings = On
```

### Check Error Logs

```bash
tail -f /var/log/apache2/error.log  # Apache
tail -f /var/log/nginx/error.log    # Nginx
tail -f files/logs/ojs.log          # OJS logs
```

### Common Issues

1. **"Class not found" errors**
   - Run: `composer dump-autoload` in OJS root
   - Clear cache directories

2. **Permission denied errors**
   - Fix: `chown -R www-data:www-data plugins/generic/goValidOJS/`

3. **500 errors on designer page**
   - Check PHP error logs
   - Ensure all required PHP extensions are installed

## Upgrading

### From Previous Versions

1. Backup your settings:
   - Export saved templates from the designer
   - Note your configuration settings

2. Disable the old version:
   - Settings → Website → Plugins
   - Uncheck "Enable" for GoValidOJS

3. Replace plugin files:
```bash
cd plugins/generic/
mv goValidOJS goValidOJS_backup
git clone https://github.com/yourusername/goValidOJS.git
```

4. Re-enable the plugin
5. Restore your settings and templates

### Keeping Settings

Settings are preserved in the database when upgrading. To ensure compatibility:

1. Export templates before upgrading
2. Test in a staging environment first
3. Keep the backup until confirmed working

## Uninstallation

### Complete Removal

1. Disable the plugin in OJS admin
2. Remove plugin files:
```bash
rm -rf plugins/generic/goValidOJS/
```

3. Clean database (optional):
```sql
DELETE FROM plugin_settings WHERE plugin_name = 'goValidOJS';
```

### Preserve Settings

To temporarily disable without losing settings:
1. Just uncheck "Enable" in the plugins page
2. Settings remain in database
3. Re-enable when needed

## Security Considerations

### File Permissions
- Plugin files: 755 (directories) / 644 (files)
- No files should be writable by web server

### API Keys
- GoValid credentials are stored in session only
- Never stored in database or files
- Use HTTPS for production

### Access Control
- Only Journal Managers and Administrators can access designer
- Certificate generation requires valid GoValid subscription

## Getting Help

### Support Channels
1. Plugin documentation in `/docs` folder
2. OJS Forum: [forum.pkp.sfu.ca](https://forum.pkp.sfu.ca)
3. GoValid Support: [my.govalid.org/support](https://my.govalid.org/support)

### Diagnostic Information
When reporting issues, include:
- OJS version
- PHP version
- Plugin version
- Error messages from logs
- Browser console errors